/* This file is part of Cinaest.
 *
 * Copyright (C) 2009 Philipp Zabel
 *
 * Cinaest is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Cinaest is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Cinaest. If not, see <http://www.gnu.org/licenses/>.
 */

using Gtk;
using Hildon;

class GooglePlugin : Plugin {
	List<MovieSource> sources;

	public override void hello (Gtk.Window window, Osso.Context context) {
		stdout.printf ("Google Plugin Loaded.\n");

		var source = new GoogleSource ();

		sources = new List<MovieSource> ();
		sources.append (source);

		// FIXME - this forces the inclusion of config.h
		(void) Config.GETTEXT_PACKAGE;
	}

	public override unowned List<MovieSource> get_sources () {
		return sources;
	}

	public override List<MovieAction> get_actions (Movie movie) {
		List<MovieAction> list = null;

		return list;
	}

	public override void settings_dialog (Gtk.Window window) {
		GoogleSource source = (GoogleSource) sources.data;
		var dialog = new Gtk.Dialog ();
		dialog.set_transient_for (window);
		dialog.set_title (_("Google plugin settings"));

		var selector = new TouchSelectorEntry.text ();
		selector.append_text ("Berlin");

		var button = new PickerButton (SizeType.FINGER_HEIGHT, ButtonArrangement.HORIZONTAL);
		button.set_title (_("Location"));
		button.set_selector (selector);
		button.set_value (source.location);

		var content = (VBox) dialog.get_content_area ();
		content.pack_start (button, true, true, 0);

		dialog.add_button ("Done", ResponseType.ACCEPT);

		dialog.show_all ();
		int res = dialog.run ();
		if (res == ResponseType.ACCEPT) {
			source.location = button.get_value ();
		}
		dialog.destroy ();
	}

	public override unowned string get_name () {
		return "Google";
	}
}

class GoogleSource : MovieSource {
	public string location;
	public string description;

	public override async void get_movies (MovieFilter filter, MovieSource.ReceiveMovieFunction callback, int limit, Cancellable? cancellable) {
		var parser = new GoogleParser ();

		yield parser.query (filter, location, callback, cancellable);
	}

	public override void add_movie (Movie movie) {
	}

	public override unowned string get_name () {
		return _("Google");
	}

	public override unowned string get_description () {
		if (location != null && location != "") {
			description = _("Movie Showtimes near %s").printf (location);
		} else {
			description =  _("Movie Showtimes");
		}
		return description;
	}
}

[ModuleInit]
public Type register_plugin () {
	// types are registered automatically
	return typeof (GooglePlugin);
}
