/* This file is part of Cinaest.
 *
 * Copyright (C) 2009 Philipp Zabel
 *
 * Cinaest is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Cinaest is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Cinaest. If not, see <http://www.gnu.org/licenses/>.
 */

using Hildon;
using Osso;

public class MovieMenu : AppMenu {
	private Movie movie;
	private List<MovieAction> actions;

	public MovieMenu (Movie _movie) {
		movie = _movie;

		foreach (Plugin plugin in CinaestProgram.plugins) {
			foreach (MovieAction action in plugin.get_actions (movie)) {
				var button = new Gtk.Button.with_label (action.name);
				button.clicked.connect (action.execute);
				append (button);
				actions.append (action);
			}
		}

		show_all ();
	}
}

