/* This file is part of Cinaest.
 *
 * Copyright (C) 2009 Philipp Zabel
 *
 * Cinaest is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Cinaest is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Cinaest. If not, see <http://www.gnu.org/licenses/>.
 */

#include <CEvent.h>
#include <CMulticalendar.h>
#include <CalendarErrors.h>
#include <ctime>

using namespace std;

extern "C" {

	int calendar_backend_add_event (char* summary,
	                                char* description,
	                                char* location,
	                                time_t start,
	                                time_t end)
	{
		CMulticalendar* MC = CMulticalendar::MCInstance ();
		CCalendar* C = MC->getDefaultCalendar ();
		int id = C->getCalendarId ();
		int error = 0;

		CEvent* E = new CEvent (summary, description, location, start, end);

		MC->addEvent (E, id, error);

		delete E;

		if (error != CALENDAR_OPERATION_SUCCESSFUL) {
			return error;
		} else {
			return 0;
		}
	}

}
