/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Array;
import java.util.Calendar;
import java.util.Date;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.Timer;
import org.jdesktop.swingx.calendar.CalendarUtils;
import org.jdesktop.swingx.calendar.DateSelectionModel;
import org.jdesktop.swingx.calendar.DefaultDateSelectionModel;
import org.jdesktop.swingx.event.EventListenerMap;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.MonthViewAddon;
import org.jdesktop.swingx.plaf.MonthViewUI;
import org.jdesktop.swingx.util.Contract;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXMonthView
extends JComponent {
    private static final Logger LOG = Logger.getLogger(JXMonthView.class.getName());
    public static final String COMMIT_KEY = "monthViewCommit";
    public static final String CANCEL_KEY = "monthViewCancel";
    public static final String BOX_PADDING_X = "boxPaddingX";
    public static final String BOX_PADDING_Y = "boxPaddingY";
    public static final String DAYS_OF_THE_WEEK = "daysOfTheWeek";
    public static final String FIRST_DISPLAYED_DATE = "firstDisplayedDate";
    public static final String SELECTION_MODEL = "selectionModel";
    public static final String SHOW_LEADING_DATES = "showLeadingDates";
    public static final String SHOW_TRAILING_DATES = "showTrailingDates";
    public static final String TRAVERSABLE = "traversable";
    public static final String WEEK_NUMBER = "weekNumber";
    public static final String FLAGGED_DATES = "flaggedDates";
    public static final int MONTH_DOWN = 1;
    public static final int MONTH_UP = 2;
    private static final int MONTH_TRAVERSABLE = 1;
    private static final int YEAR_TRAVERSABLE = 2;
    public static final String uiClassID = "MonthViewUI";
    public static final int DAYS_IN_WEEK = 7;
    public static final int MONTHS_IN_YEAR = 12;
    private long firstDisplayedDate;
    private Calendar cal;
    private Calendar anchor;
    private int firstDayOfWeek;
    private long today;
    private Timer todayTimer = null;
    private TreeSet<Long> flaggedDates;
    private DateSelectionModel model;
    private SelectionMode selectionMode;
    private EventListenerMap listenerMap;
    private Date modifiedStartDate;
    private Date modifiedEndDate;
    private String[] _daysOfTheWeek;
    protected Insets _monthStringInsets = new Insets(0, 0, 0, 0);
    private int boxPaddingX;
    private int boxPaddingY;
    private int minCalCols = 1;
    private int minCalRows = 1;
    private boolean antiAlias = false;
    private boolean traversable = false;
    private boolean leadingDates;
    private boolean trailingDates;
    private Color todayBackgroundColor;
    private Color monthStringBackground;
    private Color monthStringForeground;
    private Color daysOfTheWeekForeground;
    private Color selectedBackground;
    private String actionCommand = "selectionChanged";
    private Hashtable<Integer, Color> dayToColorTable = new Hashtable();
    private Color flaggedDayForeground;
    private boolean showWeekNumber;
    private boolean componentInputMapEnabled;

    public JXMonthView() {
        this(System.currentTimeMillis(), null, null);
    }

    public JXMonthView(Locale locale) {
        this(System.currentTimeMillis(), null, locale);
    }

    public JXMonthView(long firstDisplayedDate) {
        this(firstDisplayedDate, null, null);
    }

    public JXMonthView(long firstDisplayedDate, DateSelectionModel model) {
        this(firstDisplayedDate, model, null);
    }

    public JXMonthView(long firstDisplayedDate, DateSelectionModel model, Locale locale) {
        this.listenerMap = new EventListenerMap();
        this.selectionMode = SelectionMode.SINGLE_SELECTION;
        this.model = model;
        if (this.model == null) {
            this.model = new DefaultDateSelectionModel();
        }
        this.setLocale(locale);
        this.setFirstDisplayedDate(firstDisplayedDate);
        this.updateTodayFromCurrentTime();
        this.updateUI();
        this.setFocusable(true);
        this.todayBackgroundColor = this.getForeground();
    }

    @Override
    public void setLocale(Locale locale) {
        this.installCalendar(locale);
        if (locale != null) {
            super.setLocale(locale);
            this.repaint();
        }
    }

    public Calendar getCalendar() {
        if (this.cal == null) {
            throw new IllegalStateException("must not be called before instantiation is complete");
        }
        Calendar calendar = (Calendar)this.cal.clone();
        calendar.setTimeInMillis(this.firstDisplayedDate);
        return calendar;
    }

    private void installCalendar(Locale locale) {
        if (locale == null) {
            locale = JComponent.getDefaultLocale();
        }
        this.cal = Calendar.getInstance(locale);
        this.firstDayOfWeek = this.cal.getFirstDayOfWeek();
        this.cal.setMinimalDaysInFirstWeek(1);
        this.anchor = (Calendar)this.cal.clone();
    }

    public TimeZone getTimeZone() {
        return this.cal.getTimeZone();
    }

    public void setTimeZone(TimeZone tz) {
        TimeZone old = this.getTimeZone();
        this.cal.setTimeZone(tz);
        this.anchor.setTimeZone(tz);
        this.setFirstDisplayedDate(this.anchor.getTimeInMillis());
        this.updateTodayFromCurrentTime();
        this.updateDatesAfterTimeZoneChange(old);
        this.firePropertyChange("timeZone", old, this.getTimeZone());
    }

    protected void updateDatesAfterTimeZoneChange(TimeZone oldTimeZone) {
        this.clearSelection();
        this.setLowerBound(null);
        this.setUpperBound(null);
        this.setFlaggedDates(null);
        this.setUnselectableDates(new Date[0]);
    }

    public long getFirstDisplayedDate() {
        return this.firstDisplayedDate;
    }

    public void setFirstDisplayedDate(long date) {
        this.anchor.setTimeInMillis(date);
        long oldFirstDisplayedDate = this.firstDisplayedDate;
        this.cal.setTimeInMillis(this.anchor.getTimeInMillis());
        CalendarUtils.startOfMonth(this.cal);
        this.firstDisplayedDate = this.cal.getTimeInMillis();
        this.firePropertyChange(FIRST_DISPLAYED_DATE, oldFirstDisplayedDate, this.firstDisplayedDate);
        this.repaint();
    }

    protected Date getAnchorDate() {
        return this.anchor.getTime();
    }

    public long getLastDisplayedDate() {
        return this.getUI().getLastDisplayedDate();
    }

    public void ensureDateVisible(Date date) {
        this.ensureDateVisible(date.getTime());
    }

    public void ensureDateVisible(long date) {
        if (date < this.firstDisplayedDate) {
            this.setFirstDisplayedDate(date);
        } else {
            long lastDisplayedDate = this.getLastDisplayedDate();
            if (date > lastDisplayedDate) {
                this.cal.setTimeInMillis(date);
                int month = this.cal.get(2);
                int year = this.cal.get(1);
                this.cal.setTimeInMillis(lastDisplayedDate);
                int lastMonth = this.cal.get(2);
                int lastYear = this.cal.get(1);
                int diffMonths = month - lastMonth + (year - lastYear) * 12;
                this.cal.setTimeInMillis(this.firstDisplayedDate);
                this.cal.add(2, diffMonths);
                this.setFirstDisplayedDate(this.cal.getTimeInMillis());
            }
        }
    }

    protected void updateTodayFromCurrentTime() {
        this.setTodayInMillis(System.currentTimeMillis());
    }

    protected void incrementToday() {
        this.cal.setTimeInMillis(this.getTodayInMillis());
        this.cal.add(5, 1);
        this.setTodayInMillis(this.cal.getTimeInMillis());
    }

    protected void setTodayInMillis(long millis) {
        long oldToday = this.getTodayInMillis();
        this.today = this.startOfDay(millis);
        this.firePropertyChange("todayInMillis", oldToday, this.getTodayInMillis());
        this.repaint();
    }

    public long getTodayInMillis() {
        return this.today;
    }

    private void cleanupWeekSelectionDates(Date startDate, Date endDate) {
        int count = 1;
        this.cal.setTime(startDate);
        while (this.cal.getTimeInMillis() < endDate.getTime()) {
            this.cal.add(5, 1);
            ++count;
        }
        if (count > 7) {
            int daysTillEnd;
            this.cal.setTime(startDate);
            int dayOfWeek = this.cal.get(7);
            int firstDayOfWeek = this.getFirstDayOfWeek();
            int daysFromStart = dayOfWeek - firstDayOfWeek;
            if (daysFromStart < 0) {
                daysFromStart += 7;
            }
            this.cal.add(5, -daysFromStart);
            this.modifiedStartDate = this.cal.getTime();
            this.cal.setTime(endDate);
            dayOfWeek = this.cal.get(7);
            int lastDayOfWeek = firstDayOfWeek - 1;
            if (lastDayOfWeek == 0) {
                lastDayOfWeek = 7;
            }
            if ((daysTillEnd = lastDayOfWeek - dayOfWeek) < 0) {
                daysTillEnd += 7;
            }
            this.cal.add(5, daysTillEnd);
            this.modifiedEndDate = this.cal.getTime();
        }
    }

    private Date startOfDay(Date date) {
        this.cal.setTime(date);
        CalendarUtils.startOfDay(this.cal);
        return this.cal.getTime();
    }

    private long startOfDay(long millis) {
        this.cal.setTimeInMillis(millis);
        CalendarUtils.startOfDay(this.cal);
        return this.cal.getTimeInMillis();
    }

    @Override
    public MonthViewUI getUI() {
        return (MonthViewUI)this.ui;
    }

    public void setUI(MonthViewUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        this.setUI((MonthViewUI)LookAndFeelAddons.getUI(this, MonthViewUI.class));
        this.invalidate();
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public DateSelectionModel getSelectionModel() {
        return this.model;
    }

    public void setSelectionModel(DateSelectionModel model) {
        Contract.asNotNull(model, "date selection model must not be null");
        DateSelectionModel oldModel = this.model;
        this.model = model;
        this.firePropertyChange(SELECTION_MODEL, oldModel, model);
    }

    public void clearSelection() {
        this.getSelectionModel().clearSelection();
    }

    public boolean isSelectionEmpty() {
        return this.getSelectionModel().isSelectionEmpty();
    }

    public SortedSet<Date> getSelection() {
        return this.getSelectionModel().getSelection();
    }

    public void addSelectionInterval(Date startDate, Date endDate) {
        if (this.selectionMode != SelectionMode.NO_SELECTION) {
            this.modifiedStartDate = startDate;
            this.modifiedEndDate = endDate;
            if (this.selectionMode == SelectionMode.WEEK_INTERVAL_SELECTION) {
                this.cleanupWeekSelectionDates(startDate, endDate);
            }
            this.getSelectionModel().addSelectionInterval(this.startOfDay(this.modifiedStartDate), this.startOfDay(this.modifiedEndDate));
        }
    }

    public void setSelectionInterval(Date startDate, Date endDate) {
        if (this.selectionMode != SelectionMode.NO_SELECTION) {
            this.modifiedStartDate = startDate;
            this.modifiedEndDate = endDate;
            if (this.selectionMode == SelectionMode.WEEK_INTERVAL_SELECTION) {
                this.cleanupWeekSelectionDates(startDate, endDate);
            }
            this.getSelectionModel().setSelectionInterval(this.startOfDay(this.modifiedStartDate), this.startOfDay(this.modifiedEndDate));
        }
    }

    public void removeSelectionInterval(Date startDate, Date endDate) {
        this.getSelectionModel().removeSelectionInterval(this.startOfDay(startDate), this.startOfDay(endDate));
    }

    public SelectionMode getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionMode(SelectionMode selectionMode) {
        SelectionMode oldSelectionMode = this.selectionMode;
        this.selectionMode = selectionMode;
        if (selectionMode == SelectionMode.NO_SELECTION || selectionMode == SelectionMode.SINGLE_SELECTION) {
            this.getSelectionModel().setSelectionMode(DateSelectionModel.SelectionMode.SINGLE_SELECTION);
        } else if (selectionMode == SelectionMode.SINGLE_INTERVAL_SELECTION || selectionMode == SelectionMode.WEEK_INTERVAL_SELECTION) {
            this.getSelectionModel().setSelectionMode(DateSelectionModel.SelectionMode.SINGLE_INTERVAL_SELECTION);
        } else {
            this.getSelectionModel().setSelectionMode(DateSelectionModel.SelectionMode.MULTIPLE_INTERVAL_SELECTION);
        }
        this.firePropertyChange("selectionMode", (Object)oldSelectionMode, (Object)this.selectionMode);
    }

    public Date getSelectedDate() {
        return this.isSelectionEmpty() ? null : this.getSelection().first();
    }

    public void setSelectedDate(Date newDate) {
        if (newDate == null) {
            this.clearSelection();
        } else {
            this.setSelectionInterval(newDate, newDate);
        }
    }

    public boolean isSelectedDate(Date date) {
        return this.getSelectionModel().isSelected(this.startOfDay(date));
    }

    public void setLowerBound(Date lowerBound) {
        Date lower = lowerBound != null ? this.startOfDay(lowerBound) : null;
        this.getSelectionModel().setLowerBound(lower);
    }

    public void setUpperBound(Date upperBound) {
        Date upper = upperBound != null ? this.startOfDay(upperBound) : null;
        this.getSelectionModel().setUpperBound(upper);
    }

    public Date getLowerBound() {
        return this.getSelectionModel().getLowerBound();
    }

    public Date getUpperBound() {
        return this.getSelectionModel().getUpperBound();
    }

    public boolean isUnselectableDate(Date date) {
        return this.getSelectionModel().isUnselectableDate(this.startOfDay(date));
    }

    public void setUnselectableDates(Date ... unselectableDates) {
        Contract.asNotNull(unselectableDates, "unselectable dates must not be null");
        TreeSet<Date> unselectableSet = new TreeSet<Date>();
        for (Date unselectableDate : unselectableDates) {
            unselectableSet.add(this.startOfDay(unselectableDate));
        }
        this.getSelectionModel().setUnselectableDates(unselectableSet);
        this.repaint();
    }

    public boolean isSelectedDate(long date) {
        return this.getSelectionModel().isSelected(new Date(this.startOfDay(date)));
    }

    public boolean isUnselectableDate(long date) {
        return this.getSelectionModel().isUnselectableDate(new Date(this.startOfDay(date)));
    }

    public void setUnselectableDates(long[] unselectableDates) {
        TreeSet<Date> unselectableSet = new TreeSet<Date>();
        if (unselectableDates != null) {
            for (long unselectableDate : unselectableDates) {
                unselectableSet.add(new Date(this.startOfDay(unselectableDate)));
            }
        }
        this.getSelectionModel().setUnselectableDates(unselectableSet);
        this.repaint();
    }

    public boolean isFlaggedDate(long date) {
        boolean result = false;
        if (this.flaggedDates != null) {
            result = this.flaggedDates.contains(this.startOfDay(date));
        }
        return result;
    }

    public void setFlaggedDates(long[] flaggedDates) {
        if (flaggedDates == null) {
            this.flaggedDates = null;
        } else {
            this.flaggedDates = new TreeSet();
            for (long flaggedDate : flaggedDates) {
                this.flaggedDates.add(this.startOfDay(flaggedDate));
            }
        }
        this.firePropertyChange(FLAGGED_DATES, null, this.flaggedDates);
        this.repaint();
    }

    protected boolean hasFlaggedDates() {
        return this.flaggedDates != null && this.flaggedDates.size() > 0;
    }

    public void setShowLeadingDates(boolean value) {
        if (this.leadingDates == value) {
            return;
        }
        this.leadingDates = value;
        this.firePropertyChange(SHOW_LEADING_DATES, !this.leadingDates, this.leadingDates);
    }

    public boolean isShowingLeadingDates() {
        return this.leadingDates;
    }

    public void setShowTrailingDates(boolean value) {
        if (this.trailingDates == value) {
            return;
        }
        this.trailingDates = value;
        this.firePropertyChange(SHOW_TRAILING_DATES, !this.trailingDates, this.trailingDates);
    }

    public boolean isShowingTrailingDates() {
        return this.trailingDates;
    }

    public int getBoxPaddingX() {
        return this.boxPaddingX;
    }

    public void setBoxPaddingX(int boxPaddingX) {
        int oldBoxPadding = this.boxPaddingX;
        this.boxPaddingX = boxPaddingX;
        this.firePropertyChange(BOX_PADDING_X, oldBoxPadding, this.boxPaddingX);
    }

    public int getBoxPaddingY() {
        return this.boxPaddingY;
    }

    public void setBoxPaddingY(int boxPaddingY) {
        int oldBoxPadding = this.boxPaddingY;
        this.boxPaddingY = boxPaddingY;
        this.firePropertyChange(BOX_PADDING_Y, oldBoxPadding, this.boxPaddingY);
    }

    public boolean isTraversable() {
        return this.traversable;
    }

    public void setTraversable(boolean traversable) {
        if (traversable != this.traversable) {
            this.traversable = traversable;
            this.firePropertyChange(TRAVERSABLE, !this.traversable, this.traversable);
            this.repaint();
        }
    }

    public boolean isShowingWeekNumber() {
        return this.showWeekNumber;
    }

    public void setShowingWeekNumber(boolean showWeekNumber) {
        if (this.showWeekNumber != showWeekNumber) {
            this.showWeekNumber = showWeekNumber;
            this.firePropertyChange(WEEK_NUMBER, !this.showWeekNumber, showWeekNumber);
            this.repaint();
        }
    }

    public void setDaysOfTheWeek(String[] days) throws IllegalArgumentException, NullPointerException {
        if (days == null) {
            throw new NullPointerException("Array of days is null.");
        }
        if (days.length != 7) {
            throw new IllegalArgumentException("Array of days is not of length 7 as expected.");
        }
        String[] oldValue = this._daysOfTheWeek;
        this._daysOfTheWeek = days;
        this.firePropertyChange(DAYS_OF_THE_WEEK, oldValue, this._daysOfTheWeek);
        this.repaint();
    }

    public String[] getDaysOfTheWeek() {
        String[] days = new String[7];
        System.arraycopy(this._daysOfTheWeek, 0, days, 0, 7);
        return days;
    }

    public int getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    public void setFirstDayOfWeek(int firstDayOfWeek) {
        if (firstDayOfWeek == this.firstDayOfWeek) {
            return;
        }
        int oldFirstDayOfWeek = this.firstDayOfWeek;
        this.firstDayOfWeek = firstDayOfWeek;
        this.cal.setFirstDayOfWeek(this.firstDayOfWeek);
        this.model.setFirstDayOfWeek(this.firstDayOfWeek);
        this.firePropertyChange("firstDayOfWeek", oldFirstDayOfWeek, this.firstDayOfWeek);
        this.repaint();
    }

    public boolean isAntialiased() {
        return this.antiAlias;
    }

    public void setAntialiased(boolean antiAlias) {
        if (this.antiAlias == antiAlias) {
            return;
        }
        this.antiAlias = antiAlias;
        this.firePropertyChange("antialiased", !this.antiAlias, this.antiAlias);
        this.repaint();
    }

    public Color getSelectedBackground() {
        return this.selectedBackground;
    }

    public void setSelectedBackground(Color c) {
        this.selectedBackground = c;
    }

    public Color getTodayBackground() {
        return this.todayBackgroundColor;
    }

    public void setTodayBackground(Color c) {
        this.todayBackgroundColor = c;
        this.repaint();
    }

    public Color getMonthStringBackground() {
        return this.monthStringBackground;
    }

    public void setMonthStringBackground(Color c) {
        this.monthStringBackground = c;
        this.repaint();
    }

    public Color getMonthStringForeground() {
        return this.monthStringForeground;
    }

    public void setMonthStringForeground(Color c) {
        this.monthStringForeground = c;
        this.repaint();
    }

    public void setDaysOfTheWeekForeground(Color c) {
        this.daysOfTheWeekForeground = c;
        this.repaint();
    }

    public Color getDaysOfTheWeekForeground() {
        return this.daysOfTheWeekForeground;
    }

    public void setDayForeground(int dayOfWeek, Color c) {
        this.dayToColorTable.put(dayOfWeek, c);
    }

    public Color getDayForeground(int dayOfWeek) {
        Color c = this.dayToColorTable.get(dayOfWeek);
        if (c == null) {
            c = this.getForeground();
        }
        return c;
    }

    public void setFlaggedDayForeground(Color c) {
        this.flaggedDayForeground = c;
    }

    public Color getFlaggedDayForeground() {
        return this.flaggedDayForeground;
    }

    public Insets getMonthStringInsets() {
        return (Insets)this._monthStringInsets.clone();
    }

    public void setMonthStringInsets(Insets insets) {
        if (insets == null) {
            this._monthStringInsets.top = 0;
            this._monthStringInsets.left = 0;
            this._monthStringInsets.bottom = 0;
            this._monthStringInsets.right = 0;
        } else {
            this._monthStringInsets.top = insets.top;
            this._monthStringInsets.left = insets.left;
            this._monthStringInsets.bottom = insets.bottom;
            this._monthStringInsets.right = insets.right;
        }
        this.repaint();
    }

    public int getPreferredCols() {
        return this.minCalCols;
    }

    public void setPreferredCols(int cols) {
        if (cols <= 0) {
            return;
        }
        this.minCalCols = cols;
        this.revalidate();
        this.repaint();
    }

    public int getPreferredRows() {
        return this.minCalRows;
    }

    public void setPreferredRows(int rows) {
        if (rows <= 0) {
            return;
        }
        this.minCalRows = rows;
        this.revalidate();
        this.repaint();
    }

    @Override
    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    @Override
    public void setFont(Font font) {
        Font old = this.getFont();
        super.setFont(font);
        this.firePropertyChange("font", old, font);
    }

    @Override
    public void removeNotify() {
        this.todayTimer.stop();
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        int secondsTillTomorrow = 86400;
        if (this.todayTimer == null) {
            this.todayTimer = new Timer(secondsTillTomorrow * 1000, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JXMonthView.this.incrementToday();
                }
            });
        }
        this.cal.setTimeInMillis(System.currentTimeMillis());
        secondsTillTomorrow = secondsTillTomorrow - this.cal.get(11) * 3600 - this.cal.get(12) * 60 - this.cal.get(13);
        this.todayTimer.setInitialDelay(secondsTillTomorrow * 1000);
        this.todayTimer.start();
    }

    public long getDayAt(int x, int y) {
        return this.getUI().getDayAt(x, y);
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void setActionCommand(String actionCommand) {
        this.actionCommand = actionCommand;
    }

    public void addActionListener(ActionListener l) {
        this.listenerMap.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerMap.remove(ActionListener.class, l);
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        EventListener[] result;
        List<EventListener> listeners = this.listenerMap.getListeners(listenerType);
        if (!listeners.isEmpty()) {
            result = (EventListener[])Array.newInstance(listenerType, listeners.size());
            result = listeners.toArray(result);
        } else {
            result = super.getListeners(listenerType);
        }
        return result;
    }

    protected void fireActionPerformed(String actionCommand) {
        ActionListener[] listeners = (ActionListener[])this.getListeners(ActionListener.class);
        ActionEvent e = null;
        for (ActionListener listener : listeners) {
            if (e == null) {
                e = new ActionEvent(this, 1001, actionCommand);
            }
            listener.actionPerformed(e);
        }
    }

    public void postActionEvent() {
        this.fireActionPerformed(this.getActionCommand());
    }

    public void commitSelection() {
        this.getSelectionModel().setAdjusting(false);
        this.fireActionPerformed(COMMIT_KEY);
    }

    public void cancelSelection() {
        this.getSelectionModel().setAdjusting(false);
        this.fireActionPerformed(CANCEL_KEY);
    }

    public void setComponentInputMapEnabled(boolean enabled) {
        if (this.isComponentInputMapEnabled() == enabled) {
            return;
        }
        this.componentInputMapEnabled = enabled;
        this.firePropertyChange("componentInputMapEnabled", !enabled, this.isComponentInputMapEnabled());
    }

    public boolean isComponentInputMapEnabled() {
        return this.componentInputMapEnabled;
    }

    static {
        LookAndFeelAddons.contribute(new MonthViewAddon());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SelectionMode {
        NO_SELECTION,
        SINGLE_SELECTION,
        SINGLE_INTERVAL_SELECTION,
        MULTIPLE_INTERVAL_SELECTION,
        WEEK_INTERVAL_SELECTION;

    }
}

