#ifndef CHARMAP_H
#define CHARMAP_H

#include <QMainWindow>
#include <QResizeEvent>

#include "ui_charmap.h"

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow();

private:
    void resizeEvent(QResizeEvent *event);
    void addCharacters();
    void removeCharacters();

private slots:
    void on_actionAbout_triggered();
    void on_chart_currentItemChanged(QListWidgetItem *item, QListWidgetItem *prev);
    void on_chart_itemActivated(QListWidgetItem *item);
    void buttonCopy_clicked();
    void buttonClear_clicked();

private:
    Ui::MainWindow ui;
    QLabel *labelCharacter;
    QLabel *labelUnicode;
    QLabel *labelDescription;
    QLineEdit *edit;
};

#endif // CHARMAP_H
