#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

"""
Implements L{ChangeGraph}.

@todo: Document this module.
"""

from main.listctrl import ListView
from models.tripsmodel import SPEED, RPM, ALTITUDE

class ChangeGraph(ListView):
    """
    @todo: Document this class.
    """
    def __init__(self, parent):
        self._parent = parent
        ListView.__init__(self, "list-normal", "list-item-checkbox",
                "SELECT GRAPHIC")

        graph = parent._parent.get_graph_type()
        self.add_item("Speed", self.__select_speed, check=graph==SPEED)
        self.add_item("RPM", self.__select_rpm, check=graph==RPM)
        self.add_item("Altitude", self.__select_altitude,
            check=graph==ALTITUDE)

    def __select_speed(self, obj, item, param):
        self.hide()
        self._parent.hide(True)
        self._parent._parent.change_graph_speed()

    def __select_rpm(self, obj, item, param):
        self.hide()
        self._parent.hide(True)
        self._parent._parent.change_graph_rpm()

    def __select_altitude(self, obj, item, param):
        self.hide()
        self._parent.hide(True)
        self._parent._parent.change_graph_altitude()
