#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

"""
Implements L{ConnectAccountController}.
"""

from main.messagedlgctrl import MessageDlgController
from maps.connectaccountview import LoginAccountView
from maps.setupaccountctrl import SetupAccountController
from models.infosharingmodel import InfoSharingModel
from models.kbmodel import KeyBoardModel


class ConnectAccountController(object):
    """
    Implements account connection features (controls L{LoginAccountView} in
    union with L{SetupAccountController}).

    @type   parent: L{ManageAccounts}
    @param  parent: Parent window.
    """
    def __init__(self, parent=None):
        self._parent = parent
        self.is_model = InfoSharingModel()
        self.is_service = self.is_model.service

    def exist_account(self):
        """
        Verifies if account exists. Calls L{SetupAccountController} if
        InfoShare account is not set.

        @rtype: boolean
        @return: C{True} if account exists, C{False} otherwise.
        """
        def setup_account():
            setup = SetupAccountController("SETUP ACCOUNT",
                    self._parent, self.connect_account)
            setup.show()

        if not self.is_service.account_exists():
            msg = MessageDlgController(confirm_cb=setup_account)
            msg.show_message("You do not have any account to share.<br>" \
                "Do you want to setup now?", buttons=2, \
                title="CONNECT ACCOUNT")
            return False
        return True

    def connect_account(self):
        """
        Connects to InfoShare default account, if any.
        """
        def connect():
            self.is_model.account_status = self.is_model.CONNECTING
            self.is_service.account_connect()
            KeyBoardModel().set_focus()

        def set_password_cb(*data):
            self.is_service.set_account_password( \
                login_view.password_entry.text, login_view.remember)
            login_view.hide(True)
            connect()

        if self._parent:
            self._parent.hide(True)

        if not self.is_service.get_account_password():
            login_view = LoginAccountView("LOGIN ACCOUNT", set_password_cb)
            login_view.show()
        else:
            connect()
