#
#  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
#
#  This file is part of carman-python.
#
#  carman-python is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  carman-python is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

"""
Implements L{MessageDlgView}.
"""

from main.basedlgview import BaseDlgView

class MessageDlgView(BaseDlgView):
    """
    Handles the message dialog view.
    """

    def __init__(self):
        BaseDlgView.__init__(self, "message", 30)

    def cancel_connect_cb(self, cancel_cb):
        """
        Adds a callback to be called when the user clicks on the C{Cancel}
        button.

        @type   cancel_cb: callback
        @param  cancel_cb: Callback to be called.
        """
        self.signal_callback_add("cancel_bt_clicked", "", cancel_cb)

    def confirm_connect_cb(self, confirm_cb):
        """
        Adds a callback to be called when the user clicks on the C{Confirm}
        or C{OK} button.

        @type   confirm_cb: callback
        @param  confirm_cb: Callback to be called.
        """
        self.signal_callback_add("confirm_bt_clicked", "", confirm_cb)

    def set_buttons(self, two=True):
        """
        Emits the C{two-buttons} signal, according to the given argument.

        @type   two: boolean
        @param  two: C{True} if view has two buttons, C{False} if only one.
        """
        if two:
            self.signal_emit("two-buttons", "")

    def set_title(self, title):
        """
        Sets the given title into the dialog view.

        @type   title: string
        @param  title: Title to be displayed on the dialog view.
        """
        self.part_text_set("title", title)

    def show_message(self, msg, confirm_label, cancel_label):
        """
        Shows the message to be displayed inside the dialog view.

        @type   msg: string
        @param  msg: Message to be displayed to user.
        @type   confirm_label: string
        @param  confirm_label: Label to be applied on the C{Confirm} or C{OK}
                               button, if any.
        @type   cancel_label: string
        @param  cancel_label: Label to be applied on the C{Cancel} button, if
                              any.
        """
        self.part_text_set("msg_label", msg)
        if confirm_label:
            self.part_text_set("confirm_bt_label", confirm_label)
        if cancel_label:
            self.part_text_set("cancel_bt_label", cancel_label)
        self.show()
