#! /bin/sh
#
# skeleton	example file to build /etc/init.d/ scripts.
#		This file should be used to construct scripts for /etc/init.d.
#
#		Written by Miquel van Smoorenburg <miquels@cistron.nl>.
#		Modified for Debian 
#		by Ian Murdock <imurdock@gnu.ai.mit.edu>.
#
# Version:	@(#)skeleton  1.9  26-Feb-2001  miquels@cistron.nl
# Modified for camkeyd by Heikki Holstila

PATH=/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin
DAEMON=/usr/sbin/camkeyd
NAME=camkeyd
DESC=camkeyd

test -x $DAEMON || exit 0

# Include camkeyd defaults if available
if [ -f /etc/default/camkeyd ] ; then
	. /etc/default/camkeyd
fi

set -e


# get dbus session bus address
pids=`pgrep dbus-daemon`
for pid in $pids; do
        FILE=`cat /proc/$pid/environ | perl -pe 's/\x0/\n/g'|grep SESSION_BUS_ADDRESS_FILE \
                |sed -e 's/SESSION_BUS_ADDRESS_FILE=//g'`
done
eval `cat $FILE`


case "$1" in
  start)
	echo -n "Starting $DESC: "
	start-stop-daemon --start --quiet \
		--chuid user --exec $DAEMON -- $DAEMON_OPTS
	echo "$NAME."
	;;
  stop)
	echo -n "Stopping $DESC: "
	start-stop-daemon --stop --quiet \
		--exec $DAEMON
	echo "$NAME."
	;;
  #reload)
	# nothing
  #;;
  force-reload)
	#
	#	If the "reload" option is implemented, move the "force-reload"
	#	option to the "reload" entry above. If not, "force-reload" is
	#	just the same as "restart" except that it does nothing if the
	#   daemon isn't already running.
	# check wether $DAEMON is running. If so, restart
	start-stop-daemon --stop --test --quiet \
		--exec $DAEMON \
	&& $0 restart \
	|| exit 0
	;;
  restart)
    echo -n "Restarting $DESC: "
	start-stop-daemon --stop --quiet \
		--exec $DAEMON
	sleep 1
	start-stop-daemon --start --quiet \
		--chuid user --exec $DAEMON -- $DAEMON_OPTS
	echo "$NAME."
	;;
  *)
	N=/etc/init.d/$NAME
	# echo "Usage: $N {start|stop|restart|reload|force-reload}" >&2
	echo "Usage: $N {start|stop|restart|force-reload}" >&2
	exit 1
	;;
esac

exit 0
