#ifndef EDITLISTWIDGET_H
#define EDITLISTWIDGET_H

#include <QtGui>
#include <QMainWindow>
#include <QMaemo5InformationBox>
#include <QContactManager>
#include <QContactDetailFilter>
#include <QContactPhoneNumber>
#include <QContact>
#include "editlistwindow.h"
#include "importlistwindow.h"
#include "importfilewindow.h"

QTM_USE_NAMESPACE

class EditListWidget : public QMainWindow
{
    Q_OBJECT
public:
    EditListWidget(const QString &fileName, QWidget *parent = 0);
    virtual ~EditListWidget();

private slots:
    void loadList();
    void addNewNumber();
    void editNumber();
    void delNumber();
    void delNumbers();
    void importContactNumbers();
    void importList();
    void clearList();
    void updateList(const QStringList&);
    void addToList(const QStringList&);
    void writeToFile();
    void updateStatus();
    QString cleanString(const QString&, bool);
    QMap<QString, QString> fetchContacts();

private:
    QListWidget *listWidget;
    QString filePath;
    QLabel *statusLabel;
};

#endif // EDITLISTWIDGET_H
