#include "settingdialog.h"

SettingDialog::SettingDialog(QWidget *parent) :
    QDialog(parent)
{
    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
    readSettings();
    QMaemo5ValueButton *currentList = new QMaemo5ValueButton("Active List");
    currentListSelector = new QMaemo5ListPickSelector;
    QStandardItemModel *listModel = new QStandardItemModel(0, 1);
    for (int i = 0; i < customlistspath.size(); ++i){
        QStandardItem *item = new QStandardItem(customlistspath.at(i));
        item->setEditable(false);
        listModel->appendRow(item);
    }
    currentListSelector->setModel(listModel);
    currentListSelector->setCurrentIndex(0);
    currentList->setPickSelector(currentListSelector);

    autostartCheckBox = new QCheckBox("Auto-start at boot");
    autostartCheckBox->setChecked(daemonautostart);
    modeCheckBox = new QCheckBox("WhiteList Mode");
    modeCheckBox->setChecked(whitelistmode);
    blockUnknown = new QCheckBox("Block Unknown");
    blockUnknown->setChecked(blockunknown);

    saveButtonP = new QDialogButtonBox(QDialogButtonBox::Save);
    connect(saveButtonP, SIGNAL(accepted()), this, SLOT(saveSettings()));
    saveButtonL = new QDialogButtonBox(QDialogButtonBox::Save);
    connect(saveButtonL, SIGNAL(accepted()), this, SLOT(saveSettings()));
    QGridLayout *mainLayout = new QGridLayout;
    mainLayout->setColumnStretch(0,1);
    mainLayout->addWidget(currentList, 0, 0);
    mainLayout->addWidget(modeCheckBox, 1, 0);
    mainLayout->addWidget(autostartCheckBox, 2, 0);
    mainLayout->addWidget(blockUnknown, 3, 0);
    mainLayout->addWidget(saveButtonL, 3, 1);
    mainLayout->addWidget(saveButtonP, 4, 0);
    setLayout(mainLayout);
    setWindowTitle("Settings");
    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));
    orientationChanged();
}

/* Parsing the stored settings */
void SettingDialog::readSettings()
{
    QSettings settings("callerx", "callerx");
    daemonautostart = settings.value("auto-start", true).toBool();
    whitelistmode = settings.value("whitelistmode", false).toBool();
    blockunknown = settings.value("blockunknown", false).toBool();
    whitelistpath = settings.value("whitelistpath", DEFAULT_WHITELIST).toString();
    blacklistpath = settings.value("blacklistpath", DEFAULT_BLACKLIST).toString();
    customlistspath = settings.value("customlistspath", QStringList()).toStringList();
    if (whitelistmode) {
        listPath = whitelistpath;
    }
    else {
        listPath = blacklistpath;
    }
    customlistspath.prepend(whitelistmode?blacklistpath:whitelistpath);
    customlistspath.prepend(listPath);
    for (int i = 0; i < customlistspath.size(); ++i){
        if (!QFile::exists(customlistspath.at(i))){
            customlistspath.removeAt(i);
        }
    }
}

/* Save settings and exit */
void SettingDialog::saveSettings()
{
    QSettings settings("callerx", "callerx");
    settings.setValue("auto-start", autostartCheckBox->isChecked());
    settings.setValue("whitelistmode", modeCheckBox->isChecked());
    settings.setValue("blockunknown", blockUnknown->isChecked());
    settings.setValue("whitelistpath", modeCheckBox->isChecked()?currentListSelector->currentValueText():whitelistpath);
    settings.setValue("blacklistpath", modeCheckBox->isChecked()?blacklistpath:currentListSelector->currentValueText());
    /* This will let the QSettings finished writing to file, otherwise it will crash */
    QTimer::singleShot(0, this, SLOT(accept()));
}

void SettingDialog::orientationChanged()
{
    QRect screenGeometry = QApplication::desktop()->screenGeometry();
    if (screenGeometry.width() > screenGeometry.height()){
        saveButtonP->hide();
        saveButtonL->show();
    }
    else {
        saveButtonP->show();
        saveButtonL->hide();
    }
}
