#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QObject>
#include <QDBusConnection>
#include <QDBusInterface>
#include <QDBusMessage>
#include <QFile>
#include <QFileSystemWatcher>
#include <QSettings>
#include <QList>
#include <QString>
#include <QTextStream>

#define BUS_NAME "com.nokia.csd.Call"
#define BUS_PATH "/com/nokia/csd/call"
#define BUS_PATH_1 "/com/nokia/csd/call/1"
#define BUS_PATH_2 "/com/nokia/csd/call"
#define INSTANCE_INTERFACE "com.nokia.csd.Call.Instance"

#define DEFAULT_WHITELIST "/home/user/MyDocs/whitelist.txt"
#define DEFAULT_BLACKLIST "/home/user/MyDocs/blacklist.txt"


class CallerXDaemon : public QObject
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.callerx.ifdbus")

public:

    explicit CallerXDaemon(QObject *parent = 0);
    ~CallerXDaemon();

    void Start();


signals:
    void quit();

public slots:
    Q_SCRIPTABLE void reload();
    Q_SCRIPTABLE void stop();
    Q_SCRIPTABLE void loadwhitelist();
    Q_SCRIPTABLE void loadblacklist();

private slots:
    void callScreen(const QDBusMessage&);
    void callOn(const QDBusMessage&);
    void callOff(const QDBusMessage&);
    void callRelease();
    void loadlist();
    void setloadlist(const QString& f, bool m);

private:
    QFileSystemWatcher* fileWatcher;
    QList<QString> nlist;
    QString dbusPath, listPath, whitelistpath, blacklistpath;
    bool whitelistmode;
    QSettings settings;
};
#endif // MAINWINDOW_H
