#include "mainwindow.h"

CallerXDaemon::CallerXDaemon(QObject *parent) :
    QObject(parent)
{
    dbusPath = BUS_PATH_1;
    whitelistmode = settings.value("whitelistmode", false).toBool();
    whitelistpath = settings.value("whitelistpath", DEFAULT_WHITELIST).toString();
    blacklistpath = settings.value("blacklistpath", DEFAULT_BLACKLIST).toString();
    if (whitelistmode) {
        listPath = whitelistpath;
    }
    else {
        listPath = blacklistpath;
    }
    settings.setValue("whitelistmode", whitelistmode);
    settings.setValue("whitelistpath", whitelistpath);
    settings.setValue("blacklistpath", blacklistpath);
}

CallerXDaemon::~CallerXDaemon()
{
    QDBusConnection::systemBus().disconnect(BUS_NAME, BUS_PATH, BUS_NAME, "Coming", this, SLOT(callScreen(const QDBusMessage&)));
    QDBusConnection::systemBus().disconnect(BUS_NAME, BUS_PATH_1, INSTANCE_INTERFACE, "Terminated", this, SLOT(callOff(const QDBusMessage&)));
    QDBusConnection::systemBus().disconnect(BUS_NAME, BUS_PATH, BUS_NAME, "UserConnection", this, SLOT(callOn(const QDBusMessage&)));
    delete fileWatcher;
}

void CallerXDaemon::Start()
{
    if (!QDBusConnection::systemBus().connect(BUS_NAME, BUS_PATH, BUS_NAME, "Coming", this, SLOT(callScreen(const QDBusMessage&)))){
        emit quit();
        return;
    }

    if (!QDBusConnection::systemBus().connect(BUS_NAME, BUS_PATH, BUS_NAME, "UserConnection", this, SLOT(callOn(const QDBusMessage&)))){
        emit quit();
        return;
    }

    if (!QDBusConnection::systemBus().connect(BUS_NAME, BUS_PATH_1, INSTANCE_INTERFACE, "Terminated", this, SLOT(callOff(const QDBusMessage&)))){
        emit quit();
        return;
    }

    if (!QDBusConnection::sessionBus().isConnected()) {
        emit quit();
        return;
    }
    if (!QDBusConnection::sessionBus().registerService("org.callerx.ifdbus")) {
        emit quit();
        return;
    }
    if (!QDBusConnection::sessionBus().registerObject("/org/callerx/ifdbus", this, QDBusConnection::ExportScriptableSlots)) {
        emit quit();
        return;
    }

    QFile blocklist(listPath);
    if (!blocklist.exists()) {
        if (!blocklist.open(QIODevice::WriteOnly | QIODevice::Text)){
            return;
        }
        blocklist.close();
    }

    fileWatcher = new QFileSystemWatcher();
    fileWatcher->addPath(listPath);
    QObject::connect(fileWatcher, SIGNAL(fileChanged(const QString&)), this, SLOT(loadlist()));

    if (whitelistmode) {
        loadwhitelist();
    }
    else {
        loadblacklist();
    }
}

void CallerXDaemon::callScreen(const QDBusMessage &msg)
{
    QString n;
    n = msg.arguments()[1].toString();
    if (n.isEmpty()){
        n = "unknown";
    }
    if (whitelistmode) {
        bool match = false;
        for (int i = 0; i < nlist.size(); ++i){
            if (n.startsWith(nlist.at(i))){
                match = true;
                break;
            }
        }
        if(!match){
            callRelease();
        }
    }
    else {
        for (int i = 0; i < nlist.size(); ++i){
            if (n.startsWith(nlist.at(i))){
                callRelease();
                break;
            }
        }
    }

}

void CallerXDaemon::callOn(const QDBusMessage&)
{
    dbusPath = BUS_PATH_2;
}

void CallerXDaemon::callOff(const QDBusMessage&)
{
    dbusPath = BUS_PATH_1;
}

void CallerXDaemon::stop()
{
    emit quit();
    return;
}

void CallerXDaemon::reload()
{
    loadlist();
}

void CallerXDaemon::loadblacklist()
{
    setloadlist(blacklistpath, false);
}

void CallerXDaemon::loadwhitelist()
{
    setloadlist(whitelistpath, true);
}
void CallerXDaemon::setloadlist(const QString &f, bool m)
{
    if (QFile::exists(f)) {
        whitelistmode = m;
        settings.setValue("whitelistmode", m);
        fileWatcher->removePath(listPath);
        listPath = f;
        fileWatcher->addPath(listPath);
        loadlist();
    }
}

void CallerXDaemon::callRelease()
{
     QDBusInterface iface(BUS_NAME, dbusPath, INSTANCE_INTERFACE, QDBusConnection::systemBus(), this);
     iface.call("Release");
}

void CallerXDaemon::loadlist()
{
    nlist.clear();
    QFile blocklist(listPath);
    if (blocklist.exists()) {
        if (!blocklist.open(QIODevice::ReadOnly | QIODevice::Text)){
            return;
        }
        QTextStream in(&blocklist);
        QString line = in.readLine();
        while (!line.isNull()) {
            if (!nlist.contains(line)) {
               nlist.append(line);
            }
            line = in.readLine();
        }
        blocklist.close();
    }
}
