/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the Qt Assistant.
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
**
**
**
**
**
**
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include <QApplication>
#include <QList>
#include <QMap>
#include <QPushButton>
#include <QString>

#include <iostream>

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);
    QList<int> intList;
    intList << 2 << 3 << 5 << 7;
    QMap<double, QString> map;
    map.insert(1.5, QLatin1String("String 1"));
    map.insert(2.6, QLatin1String("String 2"));
    map.insert(23.7, QLatin1String("String 3"));
    const QString buttonText
        = QString::fromLocal8Bit(argc >= 2 ? argv[1] : "Click here to exit");
    std::cout << "This goes to stdout." << std::endl;
    qDebug("This goes to stderr.");
    QPushButton button(buttonText, 0);
    QObject::connect(&button, SIGNAL(clicked()), &app, SLOT(quit()));
    button.showFullScreen();
//    for (unsigned int i = 1; i != 0; ++i) {
//        std::cout << i << std::endl;
//        //sleep(1);
//    }
    const int retVal = app.exec();
    std::cout << "Final output." /* << std::endl */;
    return retVal;
}
