#include <QPushButton>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QGridLayout>
#include <QLCDNumber>
#include <QFrame>
#include <QWidget>
#include <QApplication>
#include <QMainWindow>
#include <QKeyEvent>
#include <QDebug>
#include "game.h"
#include "gamefield.h"

/* class constructor */
Game::Game(QWidget *parent) : QWidget(parent)
{
    /* create buttons */
    QPushButton* newGame = new QPushButton(tr("Новая Игра"));
    QPushButton* quit = new QPushButton(tr("Выход"));
    quit->setFont(QFont("Arial",10,1,0));
    newGame->setMaximumHeight(35);
    quit->setMaximumHeight(35);
    newGame->setFont(QFont("Arial",10,1,0));  
    /* create layouts */
    QHBoxLayout* layout = new QHBoxLayout;
    QGridLayout* grid = new QGridLayout;
    QHBoxLayout* hlayout = new QHBoxLayout;
    QVBoxLayout* gameLayout = new QVBoxLayout;

    /* create LCDs */
    score = new QLCDNumber(3);
    score->setSegmentStyle(QLCDNumber::Filled);
    score->setMaximumHeight(50); 
    lifesLeft = new QLCDNumber(3);
    lifesLeft->setSegmentStyle(QLCDNumber::Filled);
    lifesLeft->display(5);
    lifesLeft->setMaximumHeight(50);  

    /* create labels */
    QLabel *hitsLabel = new QLabel(tr("Очки"));
    QLabel *lifesLeftLabel = new QLabel(tr("Жизни"));

    /* add widgets to horizontal layout */
    hlayout->addWidget(score);
    hlayout->addWidget(hitsLabel);
    hlayout->addWidget(lifesLeft);
    hlayout->addWidget(lifesLeftLabel);

    /* create frame for gamefield widget */
    QFrame *gameBox = new QFrame;
    gameBox->setFrameStyle(QFrame::WinPanel | QFrame::Sunken);

    /* create widget gamefield, where game process is drawing */
    GameField* gameField = new GameField;
    gameLayout->addWidget(gameField);
    gameBox->setLayout(gameLayout);

     /* exit program on clicking quit button */
    connect(quit, SIGNAL(clicked()), qApp, SLOT(quit()));
    /* connect signals and slots to make game works */
    connect(gameField, SIGNAL(hit()), this, SLOT(addHit()));
    connect(gameField, SIGNAL(counters()), this, SLOT(beginCount()));
    connect(gameField, SIGNAL(fail()), this, SLOT(addFail()));
    connect(this, SIGNAL(gameOver()), gameField, SLOT(epicFail()));
    connect(this, SIGNAL(newLevel()), gameField, SLOT(addLevel()));
    connect(newGame, SIGNAL(clicked()),gameField, SLOT(restart()));
    connect(gameField, SIGNAL(firstaid()), this, SLOT(addLife()));

    /* add buttons to layout */
    layout->addWidget(newGame);
    layout->addWidget(quit);
    
    /* add elements to main layout */
    grid->addLayout(layout, 0, 0);
    grid->addLayout(hlayout, 0, 1);
    grid->addWidget(gameBox, 1, 0, 2, 2);
    grid->setColumnStretch(0, 1);
    grid->setColumnStretch(1, 10);
    

    setLayout(grid); // set main layout
    setFocusPolicy(Qt::NoFocus); // experiments with focus
}



/* function adds +1 hit to score when killing a bug */
void Game::addHit()
{
    score->display(score->intValue() + 1); // change lcd display value
    if (score->intValue()%50 == 0)
        emit newLevel();
}


/* function takes of 1 life when passing a bug */
void Game::addFail()
{
    lifesLeft->display(lifesLeft->intValue() - 1); // change lcd display value
    if (lifesLeft->intValue() == 0)
        emit gameOver(); // cause signal
}

void Game::addLife()
{
    lifesLeft->display(lifesLeft->intValue() + 1); // change lcd display value

}

/* set default values of lcd displays */
void Game::beginCount()
{
    lifesLeft->display(5);
    score->display(0);
}
