#include <QPainter>
#include <QTimerEvent>
#include "enemy.h"
#include <stdlib.h>
#include <QDebug>
#include <QTime>
#include <QImage>

/* class constructor */
Enemy::Enemy(int width)
{
    /* setting random start coordinate */
    QTime time;
    //x = rand()%width+time.msec();
    x = (rand()+time.msec()) % (width - 90);
    y = 0 - time.msec();
    image.load("images/enemy.png");
    pos.setRect(x,y,50,50);
    deviation = 0;
}


/* updating of position of object (bug) */
void Enemy::update(QPainter* painter)
{
    /* set parameters of drawing */
    painter->setPen(Qt::NoPen);
    painter->setBrush(Qt::white);
    painter->drawImage(pos,image);
   
    /* set deviation of object on axis X */
    if (deviation < 8)
    {
        x += 5;
        deviation++;
    }
    else if (deviation < 16)
    {
        x -= 5;
        deviation++;
    }
    else
        deviation = 0;

    y += 5; // move object on axis Y
    pos.setRect(x,y,50,50); // set changed coordinates

}


/* check if the object is out of borders */
bool Enemy::isOut(int height)
{
	if (y >= height)
		return true;
	else
		return false;
}


/* get current object coordinates */
QRect Enemy::getRect()
{
    /* create and return QRect object */
    QRect temp(x,y,50,50);
    return temp;
}
