#include <QPainter>
#include <QTimerEvent>
#include "bomb.h"
#include <stdlib.h>
#include <QDebug>
#include <QTime>
#include <QImage>

/* class constructor */
Bomb::Bomb(int width)
{
    /* setting random start coordinate */
    QTime time;
    x = (rand()+time.msec())%(width-50);
    y = 0 - time.msec();
    image.load("images/bomb.png");
    pos.setRect(x,y,25,25);

}


/* updating of position of object (bomb) */
void Bomb::update(QPainter* painter)
{
    /* set parameters of drawing */
    painter->setPen(Qt::NoPen);
    painter->setBrush(Qt::white);
    painter->drawImage(pos,image);

    y += 10; // move object on axis Y
    pos.setRect(x,y,50,50); // set changed coordinates

}


/* check if the object is out of borders */
bool Bomb::isOut(int height)
{
    if (y >= height)
        return true;
    else
        return false;
}


/* get current object coordinates */
QRect Bomb::getRect()
{
    /* create and return QRect object */
    QRect temp(x,y,50,50);
    return temp;
}
