//  (C) Copyright John Maddock 2006-7.
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#define SC_(x) static_cast<T>(BOOST_JOIN(x, L))
   static const boost::array<boost::array<T, 6>, 1000> spherical_harmonic = {
      SC_(0.2e1), SC_(0), SC_(-0.6223074436187744140625e1), SC_(-0.983176708221435546875e0), SC_(0.62736841735769885881246893757736785347239567286304e0), SC_(0), 
      SC_(0.2e1), SC_(0), SC_(-0.5057456493377685546875e1), SC_(0.59339153766632080078125e0), SC_(-0.20713028443163886820218719974386053923059852163073e0), SC_(0), 
      SC_(0.2e1), SC_(0), SC_(-0.4687422275543212890625e1), SC_(0.5891966342926025390625e1), SC_(-0.31480190270523966739513025513763623833894947272512e0), SC_(0), 
      SC_(0.2e1), SC_(0), SC_(-0.28032686710357666015625e1), SC_(0.46800785064697265625e1), SC_(0.52655067270403872306721376357891919506022788695237e0), SC_(0), 
      SC_(0.2e1), SC_(0), SC_(-0.1743031024932861328125e1), SC_(0.4387288570404052734375e1), SC_(-0.28759993950019252230305986773209798109581312882458e0), SC_(0), 
      SC_(0.2e1), SC_(0), SC_(0.30552928447723388671875e1), SC_(-0.317191779613494873046875e0), SC_(0.62375382255600227118437993629928966318732328906381e0), SC_(0), 
      SC_(0.2e1), SC_(0), SC_(0.3735729694366455078125e1), SC_(-0.5883162021636962890625e1), SC_(0.33428112636668248892477814957401134243912590455598e0), SC_(0), 
      SC_(0.2e1), SC_(0), SC_(0.37734358310699462890625e1), SC_(-0.25506031513214111328125e1), SC_(0.30071249849279422035163175145138750883542632972971e0), SC_(0), 
      SC_(0.2e1), SC_(0), SC_(0.54537200927734375e1), SC_(0.2279031276702880859375e1), SC_(0.1160546117367807407152783138997786541874144507988e0), SC_(0), 
      SC_(0.2e1), SC_(0.1e1), SC_(-0.458073139190673828125e1), SC_(0.509933185577392578125e1), SC_(0.37939894994349071850195546472417494785116097463318e-1), SC_(-0.93107300900343613424961589916279630747721170081866e-1), 
      SC_(0.2e1), SC_(0.1e1), SC_(-0.97907507419586181640625e0), SC_(0.195379292964935302734375e1), SC_(-0.13365658387823648349917293511332555081805906708217e0), SC_(0.33174333022099396014687314581478847312444020861066e0), 
      SC_(0.2e1), SC_(0.1e1), SC_(0.475549983978271484375e1), SC_(0.5774152278900146484375e1), SC_(0.29046640079014036022889946316442406419301954589267e-1), SC_(-0.16210635922809696460530259867846941769692426758954e-1), 
      SC_(0.2e1), SC_(0.1e1), SC_(0.52242870330810546875e1), SC_(0.175631821155548095703125e1), SC_(-0.60855473088463839496314678179027675166851871018551e-1), SC_(0.32425114600308867975046215949339819893698567878093e0), 
      SC_(0.2e1), SC_(0.1e1), SC_(0.5877228260040283203125e1), SC_(-0.4302561283111572265625e1), SC_(-0.11167901750699566664933060087163004380052822920546e0), SC_(0.25707237315223816631488907449414263457063550537321e0), 
      SC_(0.2e1), SC_(0.2e1), SC_(-0.4902621746063232421875e1), SC_(-0.18377502262592315673828125e0), SC_(0.34758668332269754124667464441534904092678544008633e0), SC_(-0.13383731780379523410231053175504807605617305066684e0), 
      SC_(0.2e1), SC_(0.2e1), SC_(-0.4131989955902099609375e1), SC_(-0.24892330169677734375e1), SC_(0.71028469303627438443505218504789723476775735703371e-1), SC_(0.26061737572960702576362821401262553454136075924086e0), 
      SC_(0.2e1), SC_(0.2e1), SC_(-0.39159076213836669921875e1), SC_(0.589130580425262451171875e0), SC_(0.72243575677708396654934991200786489958595832424973e-1), SC_(0.17449231348731311339771539907208960289022209309613e0), 
      SC_(0.2e1), SC_(0.2e1), SC_(-0.35055897235870361328125e1), SC_(0.16632754802703857421875e1), SC_(-0.48123182288009319551515814304893416646752842717278e-1), SC_(-0.90036880226735999457627735549531053450913137683366e-2), 
      SC_(0.2e1), SC_(0.2e1), SC_(-0.12724893093109130859375e1), SC_(0.32388579845428466796875e1), SC_(0.34625198570942398650986171441955620010816501680557e0), SC_(0.6821932943579386165556674909693473588513398324536e-1), 
      SC_(0.2e1), SC_(0.2e1), SC_(0.19570953845977783203125e1), SC_(0.37438814640045166015625e1), SC_(0.11868540133295449383018733211573720238248966454746e0), SC_(0.30946390521414868955137848944282844227519588015905e0), 
      SC_(0.2e1), SC_(0.2e1), SC_(0.5749200344085693359375e1), SC_(0.623871707916259765625e1), SC_(0.9966808034179761849929083987599231751430505405574e-1), SC_(-0.88875708639419834563244802526935291667296729862762e-2), 
      SC_(0.2e1), SC_(0.2e1), SC_(0.5913643360137939453125e1), SC_(0.6045803070068359375e1), SC_(0.44818825447699183791615026234271299189304152367279e-1), SC_(-0.23035725896903097839072699428746139571750062847173e-1), 
      SC_(0.3e1), SC_(0), SC_(-0.440936374664306640625e1), SC_(-0.5062591552734375e1), SC_(0.2844959862964824854388237165468357597848603400639e0), SC_(0), 
      SC_(0.3e1), SC_(0), SC_(-0.3934875011444091796875e1), SC_(-0.11469180583953857421875e1), SC_(0.14121291094740439000611232468259189623852053498783e0), SC_(0), 
      SC_(0.3e1), SC_(0), SC_(-0.552507817745208740234375e0), SC_(-0.2055795304477214813232421875e-1), SC_(0.19783391750498753000939983604310666040001705067569e0), SC_(0), 
      SC_(0.3e1), SC_(0), SC_(0.2055927753448486328125e1), SC_(-0.76976108551025390625e0), SC_(0.33285173555020716750381297236585266229434503862998e0), SC_(0), 
      SC_(0.3e1), SC_(0.1e1), SC_(-0.6247767925262451171875e1), SC_(0.194901907444000244140625e1), SC_(0.16876892664773021474708993031012643521641026445293e-1), SC_(-0.42473255665367397599231902837920937763489895056333e-1), 
      SC_(0.3e1), SC_(0.1e1), SC_(-0.47100925445556640625e1), SC_(-0.22983958721160888671875e1), SC_(-0.21493410580929797924752259751422347054230070438068e0), SC_(-0.24133524984657105208106822870162658732975114112697e0), 
      SC_(0.3e1), SC_(0.1e1), SC_(-0.423974609375e1), SC_(0.18090667724609375e1), SC_(0.2460020537420461905141929611988448892491267501235e-2), SC_(-0.10128361841653616652755617311405848132460463121178e-1), 
      SC_(0.3e1), SC_(0.1e1), SC_(-0.148838031291961669921875e1), SC_(-0.3641620159149169921875e1), SC_(0.27307271430136733126056860410690628785894268952483e0), SC_(-0.14919005653183612118737489713533290688614488819696e0), 
      SC_(0.3e1), SC_(0.1e1), SC_(0.528886890411376953125e1), SC_(0.32004873752593994140625e1), SC_(-0.13132892216208786526729131339765405257419451394884e0), SC_(-0.77435354342006197456232571693201218623653117535312e-2), 
      SC_(0.3e1), SC_(0.2e1), SC_(-0.563958072662353515625e1), SC_(0.3709591388702392578125e1), SC_(0.12400538306523070140083527916246828402942458169912e0), SC_(0.26699858682144904684388476504336635512136556796993e0), 
      SC_(0.3e1), SC_(0.2e1), SC_(-0.28145520687103271484375e1), SC_(0.25858356952667236328125e1), SC_(-0.4427518193860363815453664754812317897095435941741e-1), SC_(0.89525230913027456917186909094786496675085768579997e-1), 
      SC_(0.3e1), SC_(0.2e1), SC_(0.5657657146453857421875e1), SC_(-0.11826162040233612060546875e0), SC_(0.27612706743908622809999597264410624935441554778235e0), SC_(-0.66556246601320034007511476245916059803884974109287e-1), 
      SC_(0.3e1), SC_(0.2e1), SC_(0.5777313232421875e1), SC_(0.92682850360870361328125e0), SC_(-0.58588098669530777703405917826904778693250781231732e-1), SC_(0.20157326960446402040769133558058970326764280176092e0), 
      SC_(0.3e1), SC_(0.3e1), SC_(-0.527923882007598876953125e0), SC_(-0.683784008026123046875e0), SC_(-0.24654062825223548093087660191000851588872270901477e-1), SC_(-0.47291850857448633744932273700908288294545006619689e-1), 
      SC_(0.3e1), SC_(0.3e1), SC_(0.1838623523712158203125e1), SC_(0.36941986083984375e1), SC_(-0.3251989759113359602179775532073865855506456807785e-1), SC_(0.37275562661891880526110138370423344373839148188933e0), 
      SC_(0.3e1), SC_(0.3e1), SC_(0.4064691066741943359375e1), SC_(0.4045156002044677734375e1), SC_(0.19225943415968710973448026931813683101145483967527e0), SC_(-0.88384340622034426527979275575844466979738642942222e-1), 
      SC_(0.4e1), SC_(0), SC_(-0.440710163116455078125e1), SC_(-0.33909590244293212890625e1), SC_(0.60872192197795412389189648659338955746589054925866e-1), SC_(0), 
      SC_(0.4e1), SC_(0), SC_(-0.429697513580322265625e1), SC_(-0.4541179180145263671875e1), SC_(-0.10130272828064344799880549551171672634167040868427e0), SC_(0), 
      SC_(0.4e1), SC_(0), SC_(-0.18641016483306884765625e1), SC_(-0.543375682830810546875e1), SC_(0.77950672871982581371063052627417982915168633930729e-1), SC_(0), 
      SC_(0.4e1), SC_(0), SC_(0.7485844194889068603515625e-1), SC_(0.5530133724212646484375e1), SC_(0.82273248411762862558841087329680483291796232837127e0), SC_(0), 
      SC_(0.4e1), SC_(0), SC_(0.35047321319580078125e1), SC_(-0.335662305355072021484375e0), SC_(0.37133004542041317082392079068126598136623939939308e0), SC_(0), 
      SC_(0.4e1), SC_(0.1e1), SC_(-0.30877811908721923828125e1), SC_(-0.21055171489715576171875e1), SC_(0.51530379745010133318309937545431717391992159587507e-1), SC_(0.87003979532462364316044078325872969424339205057574e-1), 
      SC_(0.4e1), SC_(0.1e1), SC_(-0.2515388965606689453125e1), SC_(-0.322296047210693359375e1), SC_(0.35728040642895721804296646233781584207546649366613e0), SC_(-0.29135454916493737137065666660072086321415216443954e-1), 
      SC_(0.4e1), SC_(0.1e1), SC_(0.38922393321990966796875e1), SC_(0.4281579494476318359375e1), SC_(0.73224312308144597581776422776064913903291741167661e-1), SC_(0.15932143480326534106072259313508337288462063133883e0), 
      SC_(0.4e1), SC_(0.1e1), SC_(0.539428615570068359375e1), SC_(-0.355329418182373046875e1), SC_(0.46533898855307088507984825351331498092468310453766e-1), SC_(-0.20319290220199811762971093203847032309702077858032e-1), 
      SC_(0.4e1), SC_(0.1e1), SC_(0.577162647247314453125e1), SC_(0.1017331600189208984375e1), SC_(0.24653136285647999037266860579180968024317536393039e0), SC_(0.39899392923702488934009644431361230633591531405502e0), 
      SC_(0.4e1), SC_(0.2e1), SC_(-0.109746491909027099609375e1), SC_(0.4912235260009765625e1), SC_(-0.11098204562790300318279208564336530955042958737283e0), SC_(-0.46882241953600592630431606043540984795775718139569e-1), 
      SC_(0.4e1), SC_(0.3e1), SC_(-0.3470681667327880859375e1), SC_(-0.6059832096099853515625e1), SC_(0.31337958445241324767620450698180315330245557945883e-1), SC_(0.24830670306818716181091950369779498234247337466209e-1), 
      SC_(0.4e1), SC_(0.4e1), SC_(-0.312797260284423828125e1), SC_(0.5717919826507568359375e1), SC_(-0.96954964101799260839348807502986770292227228575254e-8), SC_(-0.11740977624668344825904309478314389528362476219229e-7), 
      SC_(0.4e1), SC_(0.4e1), SC_(0.4036896228790283203125e1), SC_(-0.3077565670013427734375e1), SC_(0.15878540892930306515344411249534442262277798236826e0), SC_(0.41579282626431184123743601642889070990303304799171e-1), 
      SC_(0.4e1), SC_(0.4e1), SC_(0.473447322845458984375e1), SC_(0.107150614261627197265625e1), SC_(-0.18283689147350112716914859883900530125561571604351e0), SC_(-0.40252223561364165551747117833207254896015413001567e0), 
      SC_(0.4e1), SC_(0.4e1), SC_(0.5119096279144287109375e1), SC_(-0.38126966953277587890625e1), SC_(-0.28253048985912201601336039243135828403941707239604e0), SC_(-0.13898722210008351680968086768165980849714173551268e0), 
      SC_(0.5e1), SC_(0), SC_(-0.6133619785308837890625e1), SC_(0.28519971370697021484375e1), SC_(0.78495683565043724315160369014308547334238000668841e0), SC_(0), 
      SC_(0.5e1), SC_(0), SC_(-0.132062244415283203125e1), SC_(-0.3846485912799835205078125e0), SC_(0.31693347535795755694751876346186174674215495248026e0), SC_(0), 
      SC_(0.5e1), SC_(0), SC_(0.193621504306793212890625e1), SC_(0.3750054836273193359375e0), SC_(-0.29624781700952612310404787297827585402918731693093e0), SC_(0), 
      SC_(0.5e1), SC_(0), SC_(0.32320735454559326171875e1), SC_(-0.135314095020294189453125e1), SC_(-0.8790123246629224792127618910569050934884656058578e0), SC_(0), 
      SC_(0.5e1), SC_(0), SC_(0.455754852294921875e1), SC_(0.3585579693317413330078125e0), SC_(-0.24115920970937134101170155815017359735279175844133e0), SC_(0), 
      SC_(0.5e1), SC_(0.1e1), SC_(0.387013494968414306640625e0), SC_(0.11664593219757080078125e1), SC_(-0.21103277179368909749392113640951296749695200975509e0), SC_(-0.49316527556044503500327911477758500378219060039796e0), 
      SC_(0.5e1), SC_(0.1e1), SC_(0.369808864593505859375e1), SC_(-0.8027703762054443359375e0), SC_(0.21419837825943510697987352828754457359028432984086e0), SC_(-0.22177292654383587982333487011338866121140808680977e0), 
      SC_(0.5e1), SC_(0.2e1), SC_(0.6248452663421630859375e0), SC_(0.292543506622314453125e1), SC_(0.41573590536157272547449027947361423003543786240211e0), SC_(-0.19183141402020165103358558903368617865081892865933e0), 
      SC_(0.5e1), SC_(0.3e1), SC_(-0.14002730846405029296875e1), SC_(-0.4245142459869384765625e1), SC_(-0.24179587072105227507534954893340732889531316289458e0), SC_(0.41271158120487694865505940795712844055500009419391e-1), 
      SC_(0.5e1), SC_(0.3e1), SC_(0.773553669452667236328125e0), SC_(-0.150236189365386962890625e1), SC_(0.86752460384204523734238237483181189266881715764871e-1), SC_(-0.41660395066952655044211855258764940392838274877353e0), 
      SC_(0.5e1), SC_(0.3e1), SC_(0.85227191448211669921875e0), SC_(0.3439598977565765380859375e0), SC_(-0.2196268910459300563562462210856877243970361932779e0), SC_(-0.36729488140701770922993890678969810345467122358823e0), 
      SC_(0.5e1), SC_(0.3e1), SC_(0.24533689022064208984375e1), SC_(-0.26912262439727783203125e1), SC_(0.84407718049714982177819663764778352740974157106147e-1), SC_(0.37799906426529471223627861284161774428328546798949e0), 
      SC_(0.5e1), SC_(0.3e1), SC_(0.27156016826629638671875e1), SC_(0.31183650493621826171875e1), SC_(0.15738150174204471823641953702231269343028123924248e0), SC_(-0.10984570703089041779572343816480593380078028706438e-1), 
      SC_(0.5e1), SC_(0.4e1), SC_(-0.46507358551025390625e1), SC_(-0.43424549102783203125e1), SC_(-0.81610388990130490457172097141225859717686441857729e-2), SC_(-0.89374756741490952643612742660035362791080713876533e-1), 
      SC_(0.5e1), SC_(0.4e1), SC_(-0.621512591838836669921875e0), SC_(0.27708027362823486328125e1), SC_(0.12004544884393419000142424854735638715599322929316e-1), SC_(-0.13663000278677616631515950276497097659521716705081e0), 
      SC_(0.5e1), SC_(0.4e1), SC_(-0.3524012267589569091796875e0), SC_(-0.29785907268524169921875e1), SC_(0.15539463517620091160584166121979812487332568999928e-1), SC_(0.11862472589638443152295111650527149252307457439108e-1), 
      SC_(0.5e1), SC_(0.4e1), SC_(0.36894562244415283203125e1), SC_(0.1071460247039794921875e1), SC_(0.38153406983899025097770719403625882271965074571694e-1), SC_(0.83955212528015340355210834835918623348871882361705e-1), 
      SC_(0.5e1), SC_(0.5e1), SC_(-0.42015819549560546875e1), SC_(-0.478091144561767578125e1), SC_(-0.78771509147710774911525721791906161990439181276561e-1), SC_(-0.22084717987914999243192976716629891839889973092779e0), 
      SC_(0.5e1), SC_(0.5e1), SC_(-0.180522000789642333984375e1), SC_(0.5453938961029052734375e1), SC_(-0.21672250347594585950911058254553519147793823945815e0), SC_(0.34099438042314355745269066747118572610691093362052e0), 
      SC_(0.5e1), SC_(0.5e1), SC_(-0.12037513256072998046875e1), SC_(-0.5605228424072265625e1), SC_(-0.31874692735033257564857484066099467165425801736272e0), SC_(-0.80775786107272377968028522827249220178768442687974e-1), 
      SC_(0.6e1), SC_(0), SC_(0.20121209621429443359375e1), SC_(-0.861879289150238037109375e0), SC_(0.32257795431442290461841251687529714907368163562707e0), SC_(0), 
      SC_(0.6e1), SC_(0), SC_(0.4633154392242431640625e1), SC_(0.22559111118316650390625e1), SC_(-0.27681099511914428364563582745448972945131911762108e0), SC_(0), 
      SC_(0.6e1), SC_(0.1e1), SC_(-0.3017557621002197265625e1), SC_(-0.571695041656494140625e1), SC_(-0.3182765780247527650661898994294506316455643091238e0), SC_(-0.20231866414632311555370052856158411199370305440248e0), 
      SC_(0.6e1), SC_(0.1e1), SC_(0.518460178375244140625e1), SC_(-0.340577602386474609375e1), SC_(-0.33139977324999822170079691728884438394414052512003e-1), SC_(0.89645618853660614566673715437819413174948890145033e-2), 
      SC_(0.6e1), SC_(0.2e1), SC_(-0.6224950313568115234375e1), SC_(-0.5851941585540771484375e1), SC_(0.11367466843852340301572859185434206855654509197407e-1), SC_(0.13270566470379113215836086478491562374358240623435e-1), 
      SC_(0.6e1), SC_(0.2e1), SC_(-0.193228816986083984375e1), SC_(-0.1259368419647216796875e1), SC_(0.17015439455703996120010725881479695757433339645918e0), SC_(0.12220984654978791100511873145119907611258061014597e0), 
      SC_(0.6e1), SC_(0.2e1), SC_(0.400869883596897125244140625e-1), SC_(0.4094336986541748046875e1), SC_(-0.27360081358504041462622421950891651651395215185102e-2), SC_(0.78671516012011607353617487800753368671969089199501e-2), 
      SC_(0.6e1), SC_(0.2e1), SC_(0.100159740447998046875e1), SC_(0.16007587909698486328125e1), SC_(0.33312817952136891151402845107667869437393042975291e0), SC_(0.19986611973298386574420459205971926548352851571804e-1), 
      SC_(0.6e1), SC_(0.2e1), SC_(0.59941844940185546875e1), SC_(0.3987349987030029296875e1), SC_(-0.39244591286024440252746771258278487487912400705915e-1), SC_(0.3235114873781273794432242397162162922003339463124e0), 
      SC_(0.6e1), SC_(0.3e1), SC_(-0.6181474208831787109375e1), SC_(-0.44616298675537109375e1), SC_(-0.36555439626733798836250150331159658612721704105969e-2), SC_(0.39060829015610718780646476145797070893363169410104e-2), 
      SC_(0.6e1), SC_(0.4e1), SC_(-0.182942934334278106689453125e-1), SC_(0.5804382801055908203125e1), SC_(-0.13485527897342181133863650635688529036517094942302e-6), SC_(-0.37594444368148394959570303805408930607416900185595e-6), 
      SC_(0.6e1), SC_(0.4e1), SC_(0.48182523250579833984375e0), SC_(0.5854918956756591796875e0), SC_(-0.87580495795744127191094582263757800051970023004008e-1), SC_(0.90108633166851281571381334701278548340039592769718e-1), 
      SC_(0.6e1), SC_(0.4e1), SC_(0.516034984588623046875e1), SC_(-0.4611907958984375e1), SC_(0.23049173553295922558222462993834501197132512377121e0), SC_(0.97973529754174577721376294184893822193214608457915e-1), 
      SC_(0.6e1), SC_(0.4e1), SC_(0.6061522006988525390625e1), SC_(-0.2968140125274658203125e1), SC_(0.60676772977524853207600487824157980668392948601337e-2), SC_(0.50468623600570621193161410606406246749591675232384e-2), 
      SC_(0.6e1), SC_(0.5e1), SC_(-0.658673822879791259765625e0), SC_(-0.5300802707672119140625e1), SC_(0.22531653116574577761994224114760107123286633342113e-1), SC_(-0.11142449466127886599912340334619246275444923640014e0), 
      SC_(0.6e1), SC_(0.6e1), SC_(-0.4454288482666015625e1), SC_(-0.2731008052825927734375e1), SC_(-0.30736978236431376889708302043761105936105814540522e0), SC_(0.24758607297910007253493353507550428937688092735856e0), 
      SC_(0.6e1), SC_(0.6e1), SC_(-0.720326125621795654296875e0), SC_(0.130981147289276123046875e1), SC_(-0.19448366204955640275137920739967557970612435458044e-3), SC_(0.3979415187870059203520574469327740770369547693405e-1), 
      SC_(0.6e1), SC_(0.6e1), SC_(0.379644489288330078125e1), SC_(0.4640662670135498046875e1), SC_(-0.22406945511909215157279556250051059356005015977709e-1), SC_(0.10286003034965999858111224927885582369599679113793e-1), 
      SC_(0.6e1), SC_(0.6e1), SC_(0.5194150447845458984375e1), SC_(0.732226788997650146484375e0), SC_(-0.73382380652652099372339025816919837662648600488596e-1), SC_(-0.22216129075117957646125779178470970035532853520059e0), 
      SC_(0.7e1), SC_(0), SC_(-0.32678530216217041015625e1), SC_(0.4053973674774169921875e1), SC_(-0.86183169184536587464416234029228370869690020761501e0), SC_(0), 
      SC_(0.7e1), SC_(0.1e1), SC_(-0.423647403717041015625e1), SC_(0.352175140380859375e1), SC_(0.28971190067302116998255296195312688178773200365056e0), SC_(0.11576795099517211802712504788243112442428479807958e0), 
      SC_(0.7e1), SC_(0.1e1), SC_(-0.3104446887969970703125e1), SC_(-0.39721319675445556640625e1), SC_(-0.10144486795624163442415177132378036941755821378977e0), SC_(0.11104335122050038919312235174417766930212553647874e0), 
      SC_(0.7e1), SC_(0.1e1), SC_(-0.770735323429107666015625e0), SC_(-0.187298762798309326171875e1), SC_(0.10796679809902591652952779708058539166627723305903e0), SC_(0.34633730248395313462818797598306208281520945109715e0), 
      SC_(0.7e1), SC_(0.1e1), SC_(0.3235886096954345703125e1), SC_(-0.5531973361968994140625e1), SC_(0.2647447592114984951727181900888993559516065796256e0), SC_(0.24723527637960256115016859269425703021555156408855e0), 
      SC_(0.7e1), SC_(0.2e1), SC_(-0.121874995529651641845703125e0), SC_(0.55549716949462890625e1), SC_(0.11900042243877052113869899113467893796769866876714e-1), SC_(-0.1035953886187316715238895150714839838539413397102e0), 
      SC_(0.7e1), SC_(0.2e1), SC_(0.4436319828033447265625e1), SC_(0.4264160096645355224609375e0), SC_(-0.19781155808981186300021469893781883955717273850325e0), SC_(-0.22646565273170192925993184213147443225034207539808e0), 
      SC_(0.7e1), SC_(0.3e1), SC_(-0.28556697368621826171875e1), SC_(-0.12074756622314453125e1), SC_(-0.13953471732730374449487481768780304853329504970975e0), SC_(0.72791323297513745960194444547598419337475994993572e-1), 
      SC_(0.7e1), SC_(0.3e1), SC_(-0.1350553333759307861328125e0), SC_(0.5536253452301025390625e0), SC_(-0.18477573924981138952526910254111509848926179035747e-2), SC_(0.20456958882102401716479094215516956245585045931766e-1), 
      SC_(0.7e1), SC_(0.3e1), SC_(0.16649867594242095947265625e0), SC_(-0.4549009799957275390625e1), SC_(-0.17558790784346864546478646833203194317506624782308e-1), SC_(0.32908448493169620892988807775917255086560729792027e-1), 
      SC_(0.7e1), SC_(0.4e1), SC_(-0.3268310070037841796875e1), SC_(-0.57746105194091796875e1), SC_(0.81299195576456833588327428455403529747561860368437e-3), SC_(-0.16265726260462819996568637533684952218178511474723e-2), 
      SC_(0.7e1), SC_(0.5e1), SC_(-0.164309346675872802734375e1), SC_(-0.5865120410919189453125e1), SC_(0.16760613338897665747453711293098866723837357795454e0), SC_(-0.29305077603622682379949116975213923906974325154042e0), 
      SC_(0.7e1), SC_(0.5e1), SC_(0.4872310638427734375e1), SC_(0.5027225017547607421875e1), SC_(-0.23067172423896537332892129244592185137175678545074e0), SC_(-0.78056357393757193768619937772666474522840598082238e-3), 
      SC_(0.7e1), SC_(0.5e1), SC_(0.5060679912567138671875e1), SC_(-0.249031162261962890625e1), SC_(0.13753748478903756341484295477107659377958738581289e0), SC_(0.15860775742632141101079305954903492997755336496804e-1), 
      SC_(0.7e1), SC_(0.6e1), SC_(-0.33328540325164794921875e1), SC_(0.664524853229522705078125e0), SC_(0.57498062904194064879021232307453500913997423402099e-4), SC_(0.64868309297670987911598603982158050715895820930619e-4), 
      SC_(0.7e1), SC_(0.6e1), SC_(-0.14786479473114013671875e1), SC_(-0.532855987548828125e1), SC_(0.14259814483048013620331775979350773297786516807031e0), SC_(-0.88497140569694600622038688983909594547952891990795e-1), 
      SC_(0.7e1), SC_(0.6e1), SC_(-0.138558256626129150390625e1), SC_(-0.364045429229736328125e1), SC_(-0.30725737032055778236658671224207261187058449089194e0), SC_(-0.4594185845226742406411289649702915642149815332278e-1), 
      SC_(0.7e1), SC_(0.6e1), SC_(0.605351161956787109375e1), SC_(-0.5659209728240966796875e1), SC_(-0.20901957458912927465118670434052080186284236708559e-3), SC_(-0.14369279257657720071703187408655266795825046057259e-3), 
      SC_(0.7e1), SC_(0.7e1), SC_(-0.5680699825286865234375e1), SC_(-0.11480517685413360595703125e0), SC_(-0.65140704275190863672046807976534224495201358472486e-2), SC_(0.6756119988059887486626728364131012876289737261477e-2), 
      SC_(0.7e1), SC_(0.7e1), SC_(-0.5071102142333984375e1), SC_(-0.34756076335906982421875e1), SC_(-0.21905578908423564859803694144259024487569003475884e0), SC_(-0.22712796877731922586505713804395568309402460574174e0), 
      SC_(0.7e1), SC_(0.7e1), SC_(0.5731956005096435546875e1), SC_(0.1909694671630859375e1), SC_(0.37598146043488924163894875530133800955439742466261e-2), SC_(0.38828252880283876450833465635333140864124811461276e-2), 
      SC_(0.8e1), SC_(0), SC_(-0.174847590923309326171875e1), SC_(0.370496082305908203125e1), SC_(0.18550045831415641967666054709281586733390994411325e-1), SC_(0), 
      SC_(0.8e1), SC_(0.1e1), SC_(-0.452208614349365234375e1), SC_(0.3915435791015625e1), SC_(0.23019679038581067528534161237276798496352885814285e0), SC_(0.22493746813347214617465466191330729868341816644437e0), 
      SC_(0.8e1), SC_(0.1e1), SC_(-0.39771163463592529296875e1), SC_(-0.143620395660400390625e1), SC_(0.36301297025341664566666346498271968009720726028362e-2), SC_(-0.26808229305944791926567877056916990487727464113202e-1), 
      SC_(0.8e1), SC_(0.1e1), SC_(-0.66873514652252197265625e0), SC_(0.321435070037841796875e1), SC_(0.39406873706161791889852906292118603474593888516999e0), SC_(0.28722372365231764992320867288998773612706625034375e-1), 
      SC_(0.8e1), SC_(0.1e1), SC_(0.187384045124053955078125e1), SC_(-0.3037343502044677734375e1), SC_(0.17794210537795242523013483763026225704890887387774e0), SC_(0.18617807828216999141187248645194382373616915625708e-1), 
      SC_(0.8e1), SC_(0.2e1), SC_(-0.6167109012603759765625e0), SC_(-0.152680873870849609375e1), SC_(0.24000422949980477957700542249685566058368783514604e-1), SC_(0.21169056137944002734434184984307952573952684330955e-2), 
      SC_(0.8e1), SC_(0.3e1), SC_(-0.6089620113372802734375e1), SC_(-0.119403922557830810546875e1), SC_(0.77971609467743901980621443154610976052966610640442e-1), SC_(-0.36757537707475739042245470420250110410146728318915e-1), 
      SC_(0.8e1), SC_(0.3e1), SC_(-0.561525058746337890625e1), SC_(0.4036243438720703125e1), SC_(-0.26183123847934094904688640386937655890466224942618e0), SC_(0.12895535657804239089002419149650357189645019033082e0), 
      SC_(0.8e1), SC_(0.3e1), SC_(0.3464707851409912109375e1), SC_(-0.2467859745025634765625e1), SC_(-0.12874451667460064623738273537411974899357470290627e0), SC_(0.26624781009709669895450895027368185835791099860145e0), 
      SC_(0.8e1), SC_(0.4e1), SC_(-0.4651485919952392578125e1), SC_(0.18566305637359619140625e1), SC_(0.12592104641289906870037909199085550396014647571113e0), SC_(0.27641566816857971887002213784137211036509739661967e0), 
      SC_(0.8e1), SC_(0.4e1), SC_(-0.15152676105499267578125e1), SC_(0.539582347869873046875e1), SC_(-0.28410552168554428566740914478730904671011806202094e0), SC_(0.12275715851863546355879733351914244258278412105518e0), 
      SC_(0.8e1), SC_(0.4e1), SC_(0.412498533725738525390625e0), SC_(0.56413593292236328125e1), SC_(-0.18315159629088794253245676084584973421892658420177e0), SC_(-0.11850567614428816582904899494364499303201721466813e0), 
      SC_(0.8e1), SC_(0.4e1), SC_(0.27453744411468505859375e1), SC_(-0.255950832366943359375e1), SC_(-0.13382799462106048953408703301736152134247938249842e0), SC_(0.14149983348273597884779254948404738493440847796772e0), 
      SC_(0.8e1), SC_(0.4e1), SC_(0.307490062713623046875e1), SC_(0.15511372089385986328125e1), SC_(0.26301753680061811559461671151416773389006755344484e-3), SC_(-0.20725508710879576631848833533657282088636707797968e-4), 
      SC_(0.8e1), SC_(0.5e1), SC_(0.13535942137241363525390625e0), SC_(0.465190410614013671875e1), SC_(0.12593474577729879328996704229091917560383813171573e-3), SC_(0.40364398522353527224874983148986924630931717284382e-3), 
      SC_(0.8e1), SC_(0.5e1), SC_(0.3521441936492919921875e1), SC_(0.2127299785614013671875e1), SC_(0.18481832785609232621926986722656522919851307483837e-1), SC_(0.49239249095384773481901232724712132742579607851099e-1), 
      SC_(0.8e1), SC_(0.5e1), SC_(0.4724236965179443359375e1), SC_(-0.607558155059814453125e1), SC_(-0.14664656434647655165083588276743153778075028708042e-1), SC_(-0.24869927235806125654143309114941607335170358669862e-1), 
      SC_(0.8e1), SC_(0.6e1), SC_(-0.492523956298828125e1), SC_(0.106922961771488189697265625e0), SC_(-0.86945560388086951661546157470260103502189237664923e-1), SC_(-0.64942837847887454311657325200003786253026431700206e-1), 
      SC_(0.8e1), SC_(0.6e1), SC_(0.1813555240631103515625e1), SC_(0.55047619342803955078125e0), SC_(0.41411216054779798884986712778874671922915303809168e-1), SC_(0.6736659235066683728553731957200706826935054228731e-2), 
      SC_(0.8e1), SC_(0.6e1), SC_(0.5159311771392822265625e1), SC_(-0.8060247898101806640625e0), SC_(0.45026286310132596550436782290422648920648265915341e-1), SC_(0.36196070851562878952293191729504618347474427155142e0), 
      SC_(0.8e1), SC_(0.7e1), SC_(-0.196123659610748291015625e1), SC_(0.15785694122314453125e1), SC_(-0.24678141820863093225455026307807683165941073499112e-1), SC_(0.45309793641314105891246007305737410993278743999935e0), 
      SC_(0.8e1), SC_(0.7e1), SC_(0.51325283050537109375e1), SC_(-0.4159594058990478515625e1), SC_(-0.29595552905540753070716640268170720910650719148172e0), SC_(0.332059868793872731248540033047341795029884302294e0), 
      SC_(0.8e1), SC_(0.7e1), SC_(0.6158903598785400390625e1), SC_(0.5516656398773193359375e1), SC_(0.55932218009792233791741442620119426385453938864187e-6), SC_(0.73071425007288902657965660261024096743078980708518e-6), 
      SC_(0.8e1), SC_(0.8e1), SC_(0.3919124126434326171875e1), SC_(0.23470895290374755859375e1), SC_(0.30154206479106513660501752336796138467374971454367e-1), SC_(-0.22003157529443788047854320046205885770317105778624e-2), 
      SC_(0.9e1), SC_(0), SC_(-0.34222714900970458984375e1), SC_(0.3765552997589111328125e1), SC_(0.15845610051932134984594945072416514086975939314958e0), SC_(0), 
      SC_(0.9e1), SC_(0.1e1), SC_(0.167212736606597900390625e1), SC_(-0.39607150554656982421875e1), SC_(0.12548687918987719566500624237591738197416459977741e0), SC_(-0.13424961700581831121800270629853882371441525150884e0), 
      SC_(0.9e1), SC_(0.2e1), SC_(-0.442551136016845703125e1), SC_(-0.4138004779815673828125e1), SC_(-0.61559188340701767062192232749512812567487416761928e-1), SC_(-0.13710070039767483485760934931022607461523727139633e0), 
      SC_(0.9e1), SC_(0.2e1), SC_(-0.38390843868255615234375e1), SC_(0.4326712131500244140625e1), SC_(-0.28596046954990044261524611305912535465955673398397e0), SC_(0.2780388792377936953846777097220344386815445164775e0), 
      SC_(0.9e1), SC_(0.2e1), SC_(-0.3391027748584747314453125e0), SC_(-0.2373758792877197265625e1), SC_(0.21086756314119105658973195323688928631392541514675e-1), SC_(0.60002614848805544763372948640351979856652862384932e0), 
      SC_(0.9e1), SC_(0.3e1), SC_(-0.4886820316314697265625e1), SC_(0.26052792072296142578125e1), SC_(-0.44986374918179076447614636378810028326092753759167e-4), SC_(-0.11788103094083536288159887351496473520842442297489e-2), 
      SC_(0.9e1), SC_(0.3e1), SC_(0.119249927997589111328125e1), SC_(-0.633897125720977783203125e0), SC_(0.10661275313759439400343892862074793516663373619121e0), SC_(0.31034911628908485056915422615024906439125319874928e0), 
      SC_(0.9e1), SC_(0.3e1), SC_(0.265421581268310546875e1), SC_(-0.417761707305908203125e1), SC_(-0.52792186292690383321489339244409914836965808925751e0), SC_(-0.17702251832755797804528673092324193932848132328461e-1), 
      SC_(0.9e1), SC_(0.3e1), SC_(0.532034587860107421875e1), SC_(0.18164756298065185546875e1), SC_(-0.16474506897438148135756520978224076604140320053414e0), SC_(0.18150276831881486654600903725513285328232281719402e0), 
      SC_(0.9e1), SC_(0.4e1), SC_(-0.38357050418853759765625e1), SC_(-0.73860776424407958984375e0), SC_(0.37396761117160979118298120310613477596871276736389e0), SC_(0.70821256345155194300947696382447947385433787950901e-1), 
      SC_(0.9e1), SC_(0.5e1), SC_(0.5043890476226806640625e0), SC_(-0.24976122379302978515625e1), SC_(-0.25304174899252507368917512263852276234451408260751e0), SC_(-0.19856158804896335655269484851897538505219009378056e-1), 
      SC_(0.9e1), SC_(0.6e1), SC_(-0.1826671123504638671875e1), SC_(-0.768182575702667236328125e0), SC_(-0.36383809511987945745895919711901473701172819344979e-1), SC_(0.35098344557326952520730458181065622337882187260986e0), 
      SC_(0.9e1), SC_(0.6e1), SC_(-0.139970302581787109375e1), SC_(0.153906738758087158203125e1), SC_(0.34147705076854453980469468519559651082110599266184e0), SC_(-0.65805127404205744152996799319195368187412181730244e-1), 
      SC_(0.9e1), SC_(0.6e1), SC_(0.10938360691070556640625e1), SC_(-0.2935746610164642333984375e0), SC_(-0.22181162847756730867661777963978478080275815169277e-1), SC_(-0.11493088711446092397691481681882585856690108355921e0), 
      SC_(0.9e1), SC_(0.6e1), SC_(0.5087884426116943359375e1), SC_(0.28482229709625244140625e1), SC_(0.28428796947170113299347168443705272270194557587573e-1), SC_(0.14828267534273498167890755818225549744798727305814e0), 
      SC_(0.9e1), SC_(0.7e1), SC_(-0.575471782684326171875e1), SC_(0.12923643589019775390625e1), SC_(0.34643980992172731245838832711437012052613884009057e-1), SC_(-0.13766092300502511712443494068789878311802203272284e-1), 
      SC_(0.9e1), SC_(0.7e1), SC_(-0.3653880655765533447265625e0), SC_(0.5028850555419921875e1), SC_(-0.31676125282099863384881749068344425268674370699455e-2), SC_(-0.23803333387406967903717335010291243889712301455789e-2), 
      SC_(0.9e1), SC_(0.8e1), SC_(-0.4243305206298828125e1), SC_(-0.114706027507781982421875e1), SC_(0.39452587206961377866353414029879314567221771636441e0), SC_(0.10002310029803144917098970699288393793970757619897e0), 
      SC_(0.1e2), SC_(0), SC_(-0.38967626094818115234375e1), SC_(-0.33728845119476318359375e1), SC_(0.25397561084627033281792768375990482785160991577662e0), SC_(0), 
      SC_(0.1e2), SC_(0), SC_(-0.206896686553955078125e1), SC_(-0.466129207611083984375e1), SC_(-0.17004857598164473358157223354788449341439521048683e0), SC_(0), 
      SC_(0.1e2), SC_(0.2e1), SC_(-0.58089447021484375e1), SC_(0.4825091838836669921875e1), SC_(-0.81764622822692569335099636423687269158521635212749e-1), SC_(-0.18748822599524126477502240060490200332300445042612e-1), 
      SC_(0.1e2), SC_(0.2e1), SC_(-0.4144989013671875e1), SC_(0.22510836124420166015625e1), SC_(-0.66251791528537186731323271459989865007095311125344e-1), SC_(-0.31049566955895992317247181720333016387603754364513e0), 
      SC_(0.1e2), SC_(0.3e1), SC_(-0.100292265415191650390625e1), SC_(-0.95294868946075439453125e0), SC_(-0.19090681261369404030390046317793709401105686711272e0), SC_(-0.55464228266018352876474257954927232151173030835511e-1), 
      SC_(0.1e2), SC_(0.3e1), SC_(0.37219564914703369140625e1), SC_(0.104107844829559326171875e1), SC_(0.14868402502193691747656109708940395828879257400089e0), SC_(-0.27297451864124138213789366405864236947137289061913e-2), 
      SC_(0.1e2), SC_(0.3e1), SC_(0.416216182708740234375e1), SC_(-0.480767154693603515625e1), SC_(0.69316556229416063637666344422670728417878305798677e-1), SC_(0.23585379523282713007758467411403656944567532728201e0), 
      SC_(0.1e2), SC_(0.4e1), SC_(-0.4378448486328125e1), SC_(0.613216304779052734375e1), SC_(0.2801493800592263622049970216336394334792975107886e0), SC_(-0.19334693399544345309856028961389471442888274103706e0), 
      SC_(0.1e2), SC_(0.4e1), SC_(-0.35968379974365234375e1), SC_(0.581934261322021484375e1), SC_(-0.13505400665232269491060441393347748931385091310871e0), SC_(-0.4617016601251649511569365921476204505165166138494e0), 
      SC_(0.1e2), SC_(0.4e1), SC_(-0.3301392078399658203125e1), SC_(0.58891086578369140625e1), SC_(-0.11647259959227514254116535946415063214349551191508e-3), SC_(-0.21137150919448156841397051719737116792353054579864e-1), 
      SC_(0.1e2), SC_(0.4e1), SC_(-0.2941527843475341796875e1), SC_(0.538914012908935546875e1), SC_(-0.43607617827909263080825806984058862183798525320633e-1), SC_(0.20242039234574190109616561742085628057906253739101e-1), 
      SC_(0.1e2), SC_(0.4e1), SC_(0.28944232463836669921875e1), SC_(-0.501726818084716796875e1), SC_(0.34384588313734143552028174599316937644561255196057e-1), SC_(-0.93824122358359981632816513781695963287234934841715e-1), 
      SC_(0.1e2), SC_(0.4e1), SC_(0.3353387355804443359375e1), SC_(-0.2992414951324462890625e1), SC_(0.48667999312969118120870840093825300985241507897186e-1), SC_(0.33061094584439697488692020968433054728408665356903e-1), 
      SC_(0.1e2), SC_(0.5e1), SC_(-0.25550463199615478515625e1), SC_(0.19575879573822021484375e1), SC_(0.4440492882641083750896286684210995764190314340535e0), SC_(0.16874625872887779280553690534836426831021084434415e0), 
      SC_(0.1e2), SC_(0.6e1), SC_(-0.26142978668212890625e1), SC_(-0.456720829010009765625e1), SC_(-0.1307676306147224499152182081273115968473099419014e0), SC_(-0.1553435200285519991033942206669201586469328427245e0), 
      SC_(0.1e2), SC_(0.6e1), SC_(0.98750121891498565673828125e-1), SC_(-0.4860765933990478515625e1), SC_(-0.14779726279784082645802605529748674744478999953899e-4), SC_(0.18256809409868681128556729969838452968770523146843e-4), 
      SC_(0.1e2), SC_(0.7e1), SC_(-0.131299459934234619140625e1), SC_(0.171491467952728271484375e1), SC_(-0.29021189228283220973714594098738075209108277464972e0), SC_(0.18274476855155299681174672929292375748860634571959e0), 
      SC_(0.1e2), SC_(0.7e1), SC_(0.2780026912689208984375e1), SC_(-0.3383314609527587890625e1), SC_(0.10300460186719276988913693344211453985439973649751e-2), SC_(0.84530345018324844186868559472272777442232566914713e-2), 
      SC_(0.1e2), SC_(0.8e1), SC_(-0.13951508700847625732421875e0), SC_(-0.108962213993072509765625e1), SC_(-0.73761442162782360964819122485850601716829499806569e-6), SC_(-0.63118551152102010374365089745222581133607205586406e-6), 
      SC_(0.1e2), SC_(0.8e1), SC_(0.58817803859710693359375e0), SC_(-0.34362576007843017578125e1), SC_(-0.30414784302921429385835433932877643425670372460333e-1), SC_(-0.30346422607976833489631395643876073469922378993145e-1), 
      SC_(0.1e2), SC_(0.8e1), SC_(0.378266143798828125e1), SC_(0.3304093837738037109375e1), SC_(0.19307856171928346319503741216981369476742908521414e-1), SC_(0.69551432219218254885581740459845931814275000080444e-1), 
      SC_(0.1e2), SC_(0.8e1), SC_(0.577074909210205078125e1), SC_(0.5193515777587890625e1), SC_(-0.13422362143882942810949980813096787499685801783101e-1), SC_(-0.11476864427514824480795686384997274821094499951914e-1), 
      SC_(0.1e2), SC_(0.9e1), SC_(0.248108617961406707763671875e-1), SC_(0.193217194080352783203125e1), SC_(-0.95469448087216063409584068294127665888913376089584e-15), SC_(0.85820343091699707961713468711815827174778483009996e-14), 
      SC_(0.1e2), SC_(0.1e2), SC_(-0.195623314380645751953125e1), SC_(0.98677504062652587890625e0), SC_(-0.2288268745971460517545031273592742457943882851384e0), SC_(-0.10855932915107980719527996101987432101305010062513e0), 
      SC_(0.1e2), SC_(0.1e2), SC_(0.62019405364990234375e1), SC_(-0.29847362041473388671875e1), SC_(0.15008614784049322626679231171406496436787886041602e-13), SC_(0.67247836637415337848152407553391668101165304165406e-11), 
      SC_(0.11e2), SC_(0), SC_(0.50858898162841796875e1), SC_(-0.29596750736236572265625e1), SC_(0.30199931918324987696234641080804235519683690284391e0), SC_(0), 
      SC_(0.11e2), SC_(0.1e1), SC_(-0.181774199008941650390625e1), SC_(-0.2083968639373779296875e1), SC_(-0.15136503627385948092688916598878219694864088397496e0), SC_(-0.26860107909943525947658981544625828617978092341723e0), 
      SC_(0.11e2), SC_(0.1e1), SC_(-0.363314151763916015625e0), SC_(-0.22841622829437255859375e1), SC_(0.11608929172234139785702184879507592681711245077449e0), SC_(0.13414549563434164090078869895357599380287635097597e0), 
      SC_(0.11e2), SC_(0.2e1), SC_(-0.2385650157928466796875e1), SC_(-0.417295074462890625e1), SC_(0.41511833951573476195093302994573699935690411217707e-1), SC_(0.77468157183164794692443358393861683034263657319542e-1), 
      SC_(0.11e2), SC_(0.2e1), SC_(0.545695400238037109375e1), SC_(0.147863948345184326171875e1), SC_(-0.31369257775360208217352876119549972744472479393349e0), SC_(0.58481576482503044570210690850526915411369983763124e-1), 
      SC_(0.11e2), SC_(0.3e1), SC_(0.31026897430419921875e1), SC_(0.5926645360887050628662109375e-2), SC_(-0.24103193108338051924806338526787355619567057748937e-2), SC_(-0.42859839752331066587382031209311495788228810115997e-4), 
      SC_(0.11e2), SC_(0.3e1), SC_(0.4516885280609130859375e1), SC_(0.13938140869140625e1), SC_(0.93690135287640016346569046209807087632148425822931e-1), SC_(0.15955691286546242954911672068823567681963401079772e0), 
      SC_(0.11e2), SC_(0.4e1), SC_(0.54613780975341796875e1), SC_(0.2720598876476287841796875e0), SC_(-0.18258411224119625616970440833647362449446999419253e0), SC_(-0.34853279830762133182915266185991436290956193113148e0), 
      SC_(0.11e2), SC_(0.4e1), SC_(0.568593120574951171875e1), SC_(0.2286726474761962890625e1), SC_(-0.30248666813093794758574540439378052841488441350582e0), SC_(0.86284878357101113033915596368803469610227643045572e-1), 
      SC_(0.11e2), SC_(0.5e1), SC_(-0.5922855377197265625e1), SC_(0.12070996761322021484375e1), SC_(-0.17638227406466341219059028104519725988893419300857e0), SC_(0.4460345889241772826092729274366547429190845588879e-1), 
      SC_(0.11e2), SC_(0.6e1), SC_(-0.574997997283935546875e1), SC_(0.4672241687774658203125e1), SC_(-0.30447452858056984637575033236091241320890110194517e0), SC_(0.74795259810782796857210054118574990110366877791338e-1), 
      SC_(0.11e2), SC_(0.6e1), SC_(-0.73212467133998870849609375e-1), SC_(-0.6125618457794189453125e1), SC_(0.44549426931423894859711314306916660652909536827046e-5), SC_(0.61695494834648701116593208264470826187561709999518e-5), 
      SC_(0.11e2), SC_(0.6e1), SC_(0.1741596758365631103515625e0), SC_(-0.58993968963623046875e1), SC_(-0.82867717953783911792238962900865754909037927199117e-3), SC_(0.92238533215406727398131240953233599564714594627181e-3), 
      SC_(0.11e2), SC_(0.7e1), SC_(-0.3984513759613037109375e1), SC_(-0.320418262481689453125e1), SC_(0.4275691382648662145105399116986093625097881364174e0), SC_(-0.20031521440355624779302843250595691400364553626486e0), 
      SC_(0.11e2), SC_(0.8e1), SC_(-0.30920422077178955078125e1), SC_(-0.2523058354854583740234375e0), SC_(0.29139811688416707180257820251113316682920221426938e-9), SC_(0.60687657183385711609479195150100891202946032032604e-9), 
      SC_(0.11e2), SC_(0.8e1), SC_(0.3067127704620361328125e1), SC_(0.23851130008697509765625e1), SC_(-0.16889931796373325241352339447581773490900512276788e-7), SC_(-0.39786903607550816936065433126367518895881744497777e-8), 
      SC_(0.11e2), SC_(0.8e1), SC_(0.507330226898193359375e1), SC_(-0.144820880889892578125e1), SC_(-0.45597938670697162299938319265917567222687225170266e-1), SC_(-0.68087624277326404793729826794071862013254579710128e-1), 
      SC_(0.11e2), SC_(0.8e1), SC_(0.601527881622314453125e1), SC_(-0.33627564907073974609375e1), SC_(-0.78576926079844285204506622051641761208000102021087e-4), SC_(-0.39061161529214507409533138734634515556906985749577e-3), 
      SC_(0.11e2), SC_(0.9e1), SC_(0.249751377105712890625e1), SC_(-0.5460778713226318359375e1), SC_(-0.22134201705446754152863233101198039571985809810129e-1), SC_(-0.4555089208746421807790913757655871467648286174498e-1), 
      SC_(0.11e2), SC_(0.1e2), SC_(-0.268183231353759765625e1), SC_(0.2702235698699951171875e1), SC_(0.21633956434426947384266278340292328636278670428762e-3), SC_(-0.65541614504317866144229677749864128209698071659402e-3), 
      SC_(0.11e2), SC_(0.1e2), SC_(-0.20985181331634521484375e1), SC_(0.4857052326202392578125e1), SC_(0.37602689229505437473899554225689581073183849929999e-1), SC_(0.30129182606903602867385598948220183090290637361066e0), 
      SC_(0.11e2), SC_(0.11e2), SC_(-0.1457462012767791748046875e0), SC_(0.964111030101776123046875e0), SC_(-0.12798908237746641367836110706040011147073516511458e-9), SC_(-0.31105509149776030556238819766596695493231811157094e-9), 
      SC_(0.12e2), SC_(0), SC_(-0.27939560413360595703125e1), SC_(-0.12659642696380615234375e1), SC_(-0.50245999093202167540131219035072728442143157445386e0), SC_(0), 
      SC_(0.12e2), SC_(0), SC_(0.2336709201335906982421875e0), SC_(0.54796295166015625e1), SC_(-0.32923865655076526139901756362696025903136327987856e0), SC_(0), 
      SC_(0.12e2), SC_(0), SC_(0.279525852203369140625e1), SC_(0.2572634220123291015625e1), SC_(-0.50669261011677931032139673183938654989374120383111e0), SC_(0), 
      SC_(0.12e2), SC_(0.1e1), SC_(-0.4104320049285888671875e1), SC_(0.268799591064453125e1), SC_(0.30458750654711342869502533364737000405804708595095e0), SC_(-0.1484860501237992171651972432543966440056062459275e0), 
      SC_(0.12e2), SC_(0.2e1), SC_(-0.608856868743896484375e1), SC_(0.39724438190460205078125e1), SC_(-0.5582675526510436143785033474870655984990793661167e-1), SC_(0.61242256488549371093840283162281354130703419721366e0), 
      SC_(0.12e2), SC_(0.2e1), SC_(-0.5067639827728271484375e1), SC_(-0.2642840862274169921875e1), SC_(0.57762273922813702670312547143053613135865478522471e-1), SC_(0.89467368103216250903593726167898427392831760912897e-1), 
      SC_(0.12e2), SC_(0.2e1), SC_(-0.38313934803009033203125e1), SC_(0.20056588649749755859375e1), SC_(-0.42941619080976773240453866876589396988871610508178e-1), SC_(-0.50871385318399433042987283750516259893676730642254e-1), 
      SC_(0.12e2), SC_(0.2e1), SC_(0.147284042835235595703125e1), SC_(0.416424083709716796875e1), SC_(0.51825648699074333055892028815964550270904059000355e-1), SC_(-0.10089876131468112387439420732079791193884641188359e0), 
      SC_(0.12e2), SC_(0.3e1), SC_(0.511381053924560546875e1), SC_(-0.4609709262847900390625e1), SC_(-0.10108519880868427744711583188043968871668100666509e0), SC_(0.31771132500505811167610709603346358006973657133146e0), 
      SC_(0.12e2), SC_(0.4e1), SC_(0.3377315998077392578125e0), SC_(0.5138848781585693359375e1), SC_(-0.58059105198654907735263811769382076272563524851227e-1), SC_(0.4273142209763739783364463020811786791881948792003e0), 
      SC_(0.12e2), SC_(0.4e1), SC_(0.1473772525787353515625e1), SC_(0.197115957736968994140625e1), SC_(-0.41024515101737243101027456944692878467702298766989e-2), SC_(0.13377726571616940795122092559016241346466072755257e0), 
      SC_(0.12e2), SC_(0.7e1), SC_(-0.4496031284332275390625e1), SC_(0.187228238582611083984375e1), SC_(0.23956898754783719573830896853758404683165423623079e0), SC_(0.14347650027527815184814112865809198181859490012352e0), 
      SC_(0.12e2), SC_(0.7e1), SC_(0.3812189579010009765625e1), SC_(-0.129456484317779541015625e1), SC_(0.43140621585108485125047585557723609228214759065268e0), SC_(0.16377494005439894573031547195052139380844415778324e0), 
      SC_(0.12e2), SC_(0.8e1), SC_(0.3774065494537353515625e1), SC_(-0.34265804290771484375e0), SC_(-0.20819421645773526254571842292855254794810423642849e0), SC_(-0.88103684654905422827754298968080254320021941554714e-1), 
      SC_(0.12e2), SC_(0.1e2), SC_(-0.545978069305419921875e1), SC_(0.399041461944580078125e1), SC_(-0.10513558814776065919585933800421061721589695158219e0), SC_(0.14291991461924719081404104193932101701739439145562e0), 
      SC_(0.12e2), SC_(0.12e2), SC_(-0.79252445697784423828125e0), SC_(-0.8495934009552001953125e0), SC_(-0.69126171305047711263782984151979985436482121577315e-2), SC_(0.67075458239189379387343801459016374816130690142161e-2), 
      SC_(0.12e2), SC_(0.12e2), SC_(0.16081607341766357421875e1), SC_(0.1887936294078826904296875e0), SC_(-0.35948565770119602215153199277620253218324995255481e0), SC_(0.43139248190735410966910261223233082565752671715714e0), 
      SC_(0.12e2), SC_(0.12e2), SC_(0.4079442501068115234375e1), SC_(-0.858896732330322265625e0), SC_(-0.27170815984256964729436100669503499326191901059043e-1), SC_(0.33000590173998374023736042025291527311242708218748e-1), 
      SC_(0.12e2), SC_(0.12e2), SC_(0.408801364898681640625e1), SC_(0.7438556849956512451171875e-1), SC_(0.28900428087373455615234833868945900490227729042124e-1), SC_(0.35872707414660024986387224869462672443051259361367e-1), 
      SC_(0.13e2), SC_(0), SC_(0.5563597202301025390625e1), SC_(-0.46342029571533203125e1), SC_(-0.34264387142407785677612584851183910340829977463927e0), SC_(0), 
      SC_(0.13e2), SC_(0.1e1), SC_(-0.4767066478729248046875e1), SC_(0.209027576446533203125e1), SC_(0.11725833641453014526935161836139872664101869100451e0), SC_(-0.20504339867590444892040571712285801263671980128967e0), 
      SC_(0.13e2), SC_(0.2e1), SC_(-0.2494990825653076171875e1), SC_(-0.238145351409912109375e1), SC_(-0.56805075141397946060790510451429282557823473149221e-2), SC_(-0.11234943907190646514087058717349791721653688611845e0), 
      SC_(0.13e2), SC_(0.3e1), SC_(-0.4132814884185791015625e1), SC_(0.30071017742156982421875e1), SC_(-0.78678273483682131621120611026667211062977284162186e-1), SC_(0.33587175914642908695953518344789438884198624921631e-1), 
      SC_(0.13e2), SC_(0.3e1), SC_(-0.4044706821441650390625e1), SC_(-0.2353971004486083984375e1), SC_(-0.20461244355883492358700355876613584393321436233666e0), SC_(0.20190077435185182644255057733199514569936535316107e0), 
      SC_(0.13e2), SC_(0.3e1), SC_(0.839149534702301025390625e0), SC_(0.6070216655731201171875e1), SC_(-0.29914795433974747119414384477659869789133427926834e0), SC_(0.2222204666116811334853936680078677685742460998117e0), 
      SC_(0.13e2), SC_(0.3e1), SC_(0.405716800689697265625e1), SC_(0.20926516056060791015625e1), SC_(0.24581531905440887337165576963344258487806198376217e0), SC_(-0.12857463821698924356568802633629993019344540913099e-2), 
      SC_(0.13e2), SC_(0.4e1), SC_(-0.4948431491851806640625e1), SC_(-0.90608723461627960205078125e-1), SC_(0.30276993176530380699005482861261503860275299009006e-1), SC_(-0.11480589973698922737358901687378217339935362771337e-1), 
      SC_(0.13e2), SC_(0.4e1), SC_(-0.3106113433837890625e1), SC_(0.181916487216949462890625e1), SC_(-0.10221553802209164674261963778374548598949137453384e-3), SC_(-0.15692926767151212980219810515941756427410625117683e-3), 
      SC_(0.13e2), SC_(0.4e1), SC_(0.146112060546875e1), SC_(0.56753559112548828125e1), SC_(-0.24465562841781141867870193998394410152545968273016e0), SC_(-0.21040556941653282743961137825203246852631284540021e0), 
      SC_(0.13e2), SC_(0.5e1), SC_(-0.15548093318939208984375e1), SC_(-0.4107154369354248046875e1), SC_(-0.37255101991341841703811428303932083505129447414448e-1), SC_(-0.32134509062151516471517305200954289919761799538696e0), 
      SC_(0.13e2), SC_(0.5e1), SC_(0.561185550689697265625e1), SC_(0.2989013195037841796875e1), SC_(0.19733982733535325402119142359121490906842909229201e-1), SC_(-0.18865318251931835434720296167311384244576051091309e-1), 
      SC_(0.13e2), SC_(0.6e1), SC_(0.4796903133392333984375e1), SC_(0.627162933349609375e1), SC_(-0.28687709935217613721878535434909230712657517310563e0), SC_(0.19922801517103053174413461992162351353974706470946e-1), 
      SC_(0.13e2), SC_(0.6e1), SC_(0.4798676013946533203125e1), SC_(-0.5152803897857666015625e1), SC_(-0.25575742997096556614451479209924309013467489147284e0), SC_(-0.13942323363719836584183212564167403336038326505597e0), 
      SC_(0.13e2), SC_(0.7e1), SC_(-0.54972438812255859375e1), SC_(0.769059360027313232421875e0), SC_(-0.19497959434631629776047031260437326259623602366459e0), SC_(0.24558900467488126934419855593624532012024041831269e0), 
      SC_(0.13e2), SC_(0.7e1), SC_(-0.16472432613372802734375e1), SC_(0.168770539760589599609375e1), SC_(-0.15961207820522390617719231580189065049751553167995e0), SC_(0.1494210079764469029096489460298243256687558286567e0), 
      SC_(0.13e2), SC_(0.9e1), SC_(-0.4317742824554443359375e1), SC_(-0.2063424587249755859375e1), SC_(0.27767009520380653405301845519378686016174244934479e0), SC_(0.79464968952704258217721617229068668325054035038998e-1), 
      SC_(0.13e2), SC_(0.9e1), SC_(-0.22591744363307952880859375e0), SC_(0.474472332000732421875e1), SC_(0.19528996438178665835152785567309001202860316287507e-4), SC_(-0.65202711083197955861140784494464054690607618696963e-4), 
      SC_(0.13e2), SC_(0.9e1), SC_(0.803806602954864501953125e0), SC_(0.60156345367431640625e0), SC_(-0.28791627397051741658879106612769276285076875577257e0), SC_(0.34066161617452077696332090173091377733679139336719e0), 
      SC_(0.13e2), SC_(0.1e2), SC_(-0.617870330810546875e1), SC_(-0.3890130519866943359375e1), SC_(0.13950798854909310812169404991015897627109838918204e-8), SC_(-0.36117933836913461210782558965236230028535432831023e-8), 
      SC_(0.13e2), SC_(0.1e2), SC_(-0.29013309478759765625e1), SC_(0.592978668212890625e1), SC_(0.12655980741670840410151717053619078308123885093993e-4), SC_(-0.52377498950728135706136984568134532260431944986259e-5), 
      SC_(0.13e2), SC_(0.11e2), SC_(0.3740127980709075927734375e0), SC_(0.6052441120147705078125e1), SC_(0.10961588479261529529127520530621341879177901522438e-3), SC_(0.7554173665231828914804603050166484427373092841182e-4), 
      SC_(0.13e2), SC_(0.11e2), SC_(0.4916776716709136962890625e0), SC_(-0.32330300807952880859375e1), SC_(0.10661153208677010392189273964845139154131288955771e-2), SC_(-0.1681794653942100270783933643690313988236651463244e-2), 
      SC_(0.13e2), SC_(0.12e2), SC_(-0.25963599681854248046875e1), SC_(-0.4182485103607177734375e1), SC_(-0.94970691121801412930841933904618901184068118727506e-3), SC_(-0.71993408734104821082349156105458451553393279007511e-4), 
      SC_(0.13e2), SC_(0.12e2), SC_(-0.129588901996612548828125e0), SC_(-0.37171680927276611328125e1), SC_(0.5136493499212248769207481677103474845446436001796e-10), SC_(-0.36959119559845479635087164033205085393460725001906e-10), 
      SC_(0.13e2), SC_(0.12e2), SC_(0.120613324642181396484375e1), SC_(-0.90159952640533447265625e0), SC_(-0.81403870943419410638037846203390530815018392887066e-1), SC_(0.45672963534868625466751655372653078387114323756823e0), 
      SC_(0.13e2), SC_(0.12e2), SC_(0.528204822540283203125e1), SC_(-0.13512732982635498046875e1), SC_(-0.17635048049194146385471497773079906569327805971894e0), SC_(0.98022760626077965936319139846056567882437982131607e-1), 
      SC_(0.13e2), SC_(0.13e2), SC_(-0.382866191864013671875e1), SC_(-0.379355621337890625e1), SC_(-0.90356158188859353887191344949547031520799246540727e-3), SC_(-0.12615285292913765846474681096464572473295060090888e-2), 
      SC_(0.14e2), SC_(0), SC_(-0.605432987213134765625e1), SC_(0.1042837619781494140625e1), SC_(-0.53162534399387447027692326131316024132962317781277e0), SC_(0), 
      SC_(0.14e2), SC_(0.1e1), SC_(-0.537614154815673828125e1), SC_(0.174082887172698974609375e1), SC_(-0.10848528406558257115804504364086818687161873730321e-1), SC_(0.63186602546835839608859029804237595073253494882396e-1), 
      SC_(0.14e2), SC_(0.1e1), SC_(-0.34408271312713623046875e1), SC_(-0.2765136063098907470703125e0), SC_(-0.27002888552257593138356500763655412827499887947742e0), SC_(0.76629719571216132086270428583471175739673403937352e-1), 
      SC_(0.14e2), SC_(0.1e1), SC_(-0.3118896484375e1), SC_(0.194431388378143310546875e1), SC_(0.89934094093341326638148545329522648298868109755739e-1), SC_(-0.22947321144850006584851277354241806981606008208288e0), 
      SC_(0.14e2), SC_(0.1e1), SC_(-0.2949567317962646484375e1), SC_(0.62388896942138671875e1), SC_(-0.63237490091956870193598093066106674126229975855541e0), SC_(0.28029768674266792593951083152901991107258776104463e-1), 
      SC_(0.14e2), SC_(0.1e1), SC_(0.4033493697643280029296875e0), SC_(0.6065327167510986328125e1), SC_(0.4573951416969808691931508760300540935371964966692e0), SC_(-0.10125426200955844588815691470737971426284651982084e0), 
      SC_(0.14e2), SC_(0.1e1), SC_(0.33924887180328369140625e1), SC_(-0.23534438610076904296875e1), SC_(0.86691689490004927585189564352166575859444713082536e-1), SC_(0.87169919511907068594509246590566143789107267948305e-1), 
      SC_(0.14e2), SC_(0.2e1), SC_(-0.3197202205657958984375e1), SC_(0.588922119140625e1), SC_(0.82014157452808707859573396194563930255163921453933e-1), SC_(-0.82430213806611347159021848897870338501372153592935e-1), 
      SC_(0.14e2), SC_(0.2e1), SC_(0.20006997585296630859375e1), SC_(0.118571555614471435546875e1), SC_(-0.23952154883733628281755344437063840237263810047363e0), SC_(0.23233154515265614436348187402577410941478067094446e0), 
      SC_(0.14e2), SC_(0.3e1), SC_(-0.6000283718109130859375e1), SC_(-0.5667644500732421875e1), SC_(0.18021395527378150426232309306068544203547826253891e0), SC_(-0.63670690576591548821464981089617880479460201997529e0), 
      SC_(0.14e2), SC_(0.3e1), SC_(0.39930970668792724609375e1), SC_(-0.2177291393280029296875e1), SC_(-0.24399250396111894343639334246644744209799671515606e0), SC_(0.6196086567082813754036315172685218051490343857915e-1), 
      SC_(0.14e2), SC_(0.4e1), SC_(-0.5302167415618896484375e1), SC_(0.147140753269195556640625e1), SC_(0.10658705850230735274734268117564694714233863191793e0), SC_(-0.44757434635156715744783889188897231215482547543134e-1), 
      SC_(0.14e2), SC_(0.4e1), SC_(-0.42539081573486328125e1), SC_(-0.148484051227569580078125e0), SC_(-0.28422830628095944295459326574389573647564559141563e0), SC_(0.19193129287656205865255733746274441443577886014689e0), 
      SC_(0.14e2), SC_(0.5e1), SC_(0.2462371826171875e1), SC_(0.169020211696624755859375e1), SC_(0.16562000518224774073491407468699530347488061468426e0), SC_(-0.24363621623597510111511828584662398848400921953322e0), 
      SC_(0.14e2), SC_(0.6e1), SC_(0.596593952178955078125e1), SC_(-0.3653766214847564697265625e0), SC_(-0.72542687539052897269167348320491933495115726450976e-1), SC_(-0.10129954487608121490196649695777331785175066413949e0), 
      SC_(0.14e2), SC_(0.7e1), SC_(0.437421417236328125e1), SC_(0.4770869731903076171875e1), SC_(0.12731277348239547383554151042385446443359378302837e0), SC_(-0.29343072225138207174781580688193718890655766003548e0), 
      SC_(0.14e2), SC_(0.9e1), SC_(0.289339160919189453125e1), SC_(0.3429374217987060546875e1), SC_(0.27595075078722537272590756953488182184571556803982e-3), SC_(-0.16977916992400196699914297443137032285403371433635e-3), 
      SC_(0.14e2), SC_(0.1e2), SC_(-0.4928920269012451171875e1), SC_(-0.15731518268585205078125e1), SC_(0.24424583501847388522395295761698136987535965546016e0), SC_(-0.57542750688882947339626227969189510771613493903897e-2), 
      SC_(0.14e2), SC_(0.1e2), SC_(0.6214138507843017578125e1), SC_(-0.116089141368865966796875e1), SC_(0.91447854943543293048351438782054774574950471237155e-10), SC_(0.12991563620838806281523576753838105927721720095285e-9), 
      SC_(0.14e2), SC_(0.11e2), SC_(-0.509906482696533203125e1), SC_(0.347402095794677734375e1), SC_(-0.14756776585094385087678895196884784502531056426028e0), SC_(-0.83537863415678598720706795355100272107195903565931e-1), 
      SC_(0.14e2), SC_(0.11e2), SC_(-0.256143283843994140625e1), SC_(-0.22669765949249267578125e1), SC_(-0.21784869237271308964355278847759537812709716201558e-1), SC_(-0.432533469035583393536894966419522308691924530118e-2), 
      SC_(0.14e2), SC_(0.12e2), SC_(-0.89062178134918212890625e0), SC_(-0.969047009944915771484375e0), SC_(0.11809795123617035206090481553484603584988326258895e0), SC_(0.16096130252118992835925668541986981197633977939608e0), 
      SC_(0.14e2), SC_(0.12e2), SC_(0.3878519833087921142578125e0), SC_(0.164770162105560302734375e1), SC_(0.48387432126182871389329297745502308805988985367078e-4), SC_(0.63924410383286939916905509206921411782482866255201e-4), 
      SC_(0.14e2), SC_(0.13e2), SC_(-0.37226655483245849609375e1), SC_(0.10564463138580322265625e1), SC_(0.41883347138134890365878132735363491389848183423895e-3), SC_(0.98141423835953734540878304437127773575620065033463e-3), 
      SC_(0.14e2), SC_(0.13e2), SC_(0.402100276947021484375e1), SC_(0.28205711841583251953125e1), SC_(-0.34232569502159297025407727081038115846088687879469e-1), SC_(0.57224017444548626285559711037085885821986750440056e-1), 
      SC_(0.14e2), SC_(0.14e2), SC_(-0.5860907077789306640625e1), SC_(0.3634274005889892578125e0), SC_(0.81262686210318332276779678061498258042023106564922e-6), SC_(-0.20608649398078812059496161767390735108124275129723e-5), 
      SC_(0.14e2), SC_(0.14e2), SC_(0.26032459735870361328125e1), SC_(0.11247842311859130859375e1), SC_(-0.5090919578401763872943627405251108300050320467391e-4), SC_(-0.19872800654992029295789122786508292812037246742391e-5), 
      SC_(0.15e2), SC_(0), SC_(-0.27519686222076416015625e1), SC_(-0.29901831150054931640625e1), SC_(-0.25708545830932844896853916631333141878349345602876e0), SC_(0), 
      SC_(0.15e2), SC_(0.1e1), SC_(0.215900516510009765625e1), SC_(0.14293510913848876953125e1), SC_(-0.46695952478768205589420954677461302675216532160778e-1), SC_(-0.32792992077882673644944047367062987620554377664143e0), 
      SC_(0.15e2), SC_(0.4e1), SC_(-0.29131815433502197265625e1), SC_(0.575155162811279296875e1), SC_(0.17024866807197617775726906905664710247654348681983e0), SC_(0.27413981237727290345063225044275099845880880653994e0), 
      SC_(0.15e2), SC_(0.4e1), SC_(-0.53502118587493896484375e0), SC_(-0.509640789031982421875e1), SC_(-0.84056968062822180714048706007567969170569817688051e-2), SC_(0.24199748004145114967632816140713630319996031889192e0), 
      SC_(0.15e2), SC_(0.5e1), SC_(-0.317697942256927490234375e0), SC_(-0.265069293975830078125e1), SC_(0.29354431375467376526517694856564381884468360870824e0), SC_(-0.24084207633151509397103182168944164433195720701915e0), 
      SC_(0.15e2), SC_(0.5e1), SC_(0.1394347667694091796875e1), SC_(-0.5292422771453857421875e1), SC_(-0.67142280202753317283722758667918502833513106600653e-1), SC_(0.27268537431854373339572487400824925119701082782333e0), 
      SC_(0.15e2), SC_(0.6e1), SC_(-0.5141866207122802734375e1), SC_(-0.543011951446533203125e1), SC_(-0.24197890596762349278147213876072311401045090261133e-1), SC_(0.56288477303783856035693899003576348218561691838042e-1), 
      SC_(0.15e2), SC_(0.6e1), SC_(-0.11788280308246612548828125e0), SC_(-0.542876338958740234375e1), SC_(0.3900829586916176748287216017560510253170003872618e-3), SC_(-0.88742915605236003751861924541813557385596019823595e-3), 
      SC_(0.15e2), SC_(0.7e1), SC_(-0.32583715915679931640625e1), SC_(-0.105855953693389892578125e1), SC_(-0.47044040992895423959634221127256788015728764837077e-4), SC_(0.98882734291256908175285355352723487015959174592621e-4), 
      SC_(0.15e2), SC_(0.8e1), SC_(-0.541434574127197265625e1), SC_(-0.4352278232574462890625e1), SC_(0.17534973054182809313653905568510341139328038022501e0), SC_(-0.46779514339106151835563711199742107055703636375295e-1), 
      SC_(0.15e2), SC_(0.8e1), SC_(-0.51602184772491455078125e0), SC_(-0.961919009685516357421875e0), SC_(0.47135735718280777699368441235706685255524650443233e-1), SC_(-0.29464689804367936189424779906231671261817541609781e0), 
      SC_(0.15e2), SC_(0.1e2), SC_(0.3937534987926483154296875e0), SC_(0.31241142749786376953125e1), SC_(0.64055376103458070014615702857086874456338385652311e-2), SC_(-0.11311260394061828516088489353442931784539655425181e-2), 
      SC_(0.15e2), SC_(0.1e2), SC_(0.22992246150970458984375e1), SC_(-0.495580959320068359375e1), SC_(-0.3829624113951033603430519179464179050315240089847e0), SC_(-0.32743077762482792704706805489374685454947467156427e0), 
      SC_(0.15e2), SC_(0.12e2), SC_(-0.477042484283447265625e1), SC_(0.22684945166110992431640625e0), SC_(0.19764424242827293160211165750613723210460278878257e0), SC_(-0.88120113202544520811451099225540002694751129456273e-1), 
      SC_(0.15e2), SC_(0.12e2), SC_(-0.30813977718353271484375e1), SC_(0.546906375885009765625e1), SC_(0.71695558996220562641365813788165662410313453979638e-13), SC_(-0.25739562769518467006074240596495565975169345508308e-13), 
      SC_(0.15e2), SC_(0.14e2), SC_(-0.20891387760639190673828125e0), SC_(0.34108579158782958984375e0), SC_(0.54698737617913189595892579722915474423241472104915e-10), SC_(-0.86968564463251914571365038933400073976678383852869e-9), 
      SC_(0.15e2), SC_(0.15e2), SC_(0.5574726581573486328125e1), SC_(0.32205302715301513671875e1), SC_(-0.357140970001297258623419278009446813076660545654e-3), SC_(-0.87697929196496430306823545734687921239220086339943e-3), 
      SC_(0.16e2), SC_(0), SC_(-0.21114356517791748046875e1), SC_(0.524550914764404296875e1), SC_(-0.30164010413733437677023132010424343345736624656443e0), SC_(0), 
      SC_(0.16e2), SC_(0), SC_(-0.142287528514862060546875e1), SC_(0.6087810993194580078125e1), SC_(-0.24478745633908751894176257996158654839601881007758e0), SC_(0), 
      SC_(0.16e2), SC_(0.2e1), SC_(-0.3573507785797119140625e1), SC_(-0.4364034175872802734375e1), SC_(0.36723587092285428471934531836579931088413461017845e0), SC_(0.30725859561826850111385807315484660068640154247347e0), 
      SC_(0.16e2), SC_(0.2e1), SC_(0.33949272632598876953125e1), SC_(0.5918058872222900390625e1), SC_(0.38713988102908705646921615016623099572054061775614e0), SC_(-0.34663460445500759434174600673548629382828652016821e0), 
      SC_(0.16e2), SC_(0.3e1), SC_(0.38509771823883056640625e1), SC_(-0.4073082447052001953125e1), SC_(-0.36778109352194463975248522385157654761928856079281e0), SC_(-0.13305285285962638753856672704410573200059677433374e0), 
      SC_(0.16e2), SC_(0.4e1), SC_(-0.3384979248046875e1), SC_(0.1283912181854248046875e1), SC_(0.18570709498706729902813091746931106263786734655324e0), SC_(-0.41223530567641324423179101335768666111796283838888e0), 
      SC_(0.16e2), SC_(0.5e1), SC_(-0.1996487140655517578125e1), SC_(0.28026053905487060546875e1), SC_(0.16274117936700606410723300178074518257205264645725e-1), SC_(0.13042077266364163349627709325169572680431448178276e0), 
      SC_(0.16e2), SC_(0.5e1), SC_(0.22032878398895263671875e1), SC_(0.12703235447406768798828125e0), SC_(0.12827484160659902689100193844808704749479550073073e0), SC_(0.94545033508102171475362719074623330640400067123789e-1), 
      SC_(0.16e2), SC_(0.6e1), SC_(-0.29020578861236572265625e1), SC_(0.44871044158935546875e1), SC_(-0.14690737711863346300016730571106598295308155192611e-1), SC_(0.65977454075241443355602407060131957342756667792814e-1), 
      SC_(0.16e2), SC_(0.6e1), SC_(-0.245467090606689453125e1), SC_(0.35781395435333251953125e1), SC_(0.30752201097773163184960254043123193606669534519961e0), SC_(-0.17702041056258671883165959934037359004898382059187e0), 
      SC_(0.16e2), SC_(0.6e1), SC_(-0.4718778133392333984375e0), SC_(-0.389361917972564697265625e0), SC_(-0.4044058400342541826500656935196683793204225701439e0), SC_(-0.42093381014426182845265895843452201374875064903161e0), 
      SC_(0.16e2), SC_(0.6e1), SC_(0.195046722888946533203125e1), SC_(-0.6268721103668212890625e1), SC_(-0.30633168788996373215448357011147037745745784175948e0), SC_(-0.26652008292786385470946722315414301352261877546944e-1), 
      SC_(0.16e2), SC_(0.6e1), SC_(0.27866938114166259765625e1), SC_(-0.11623651981353759765625e1), SC_(0.26901154779721852128856462691599978142662361317583e0), SC_(-0.22248023802407371024099152345059398016094415775155e0), 
      SC_(0.16e2), SC_(0.6e1), SC_(0.432775974273681640625e1), SC_(0.36455266475677490234375e1), SC_(0.31640980020674094175782144672412490150931285166082e0), SC_(-0.37506988555329824607521146066632953380244625793576e-1), 
      SC_(0.16e2), SC_(0.7e1), SC_(-0.267037677764892578125e1), SC_(0.1169764995574951171875e1), SC_(0.1549257272150274130650482871901051339677942625486e0), SC_(-0.44593381323087072616151350368035146251490576526064e0), 
      SC_(0.16e2), SC_(0.8e1), SC_(-0.624547100067138671875e1), SC_(-0.49113941192626953125e0), SC_(-0.17613107326374166956267033885056787871716661380931e-8), SC_(0.1768810410118516264122556522767812122676486162452e-8), 
      SC_(0.16e2), SC_(0.1e2), SC_(0.2996160030364990234375e1), SC_(0.321604442596435546875e1), SC_(0.90683117425697861931620687517507958528138889720094e-6), SC_(0.83556168172954829950264365891660988999746104561437e-6), 
      SC_(0.16e2), SC_(0.11e2), SC_(-0.271818256378173828125e1), SC_(-0.3873643398284912109375e1), SC_(-0.12112084363554166073714127892182840730677993762206e-2), SC_(-0.60190691920327979427421713360733198430453024564436e-2), 
      SC_(0.16e2), SC_(0.11e2), SC_(-0.3599366247653961181640625e0), SC_(-0.31719396114349365234375e1), SC_(-0.12482187327234307976708842155900018324196564045428e-2), SC_(0.43287573457406611999239316695512907826168224216788e-3), 
      SC_(0.16e2), SC_(0.14e2), SC_(-0.6096050739288330078125e1), SC_(-0.39123890399932861328125e1), SC_(-0.15221364414761734465052486192029704906822047294341e-9), SC_(0.73419342446747059329557630271550082627570760570294e-9), 
      SC_(0.16e2), SC_(0.15e2), SC_(-0.5199747562408447265625e1), SC_(0.95767533779144287109375e0), SC_(0.56684456816817302627291609727302835441050046059808e-1), SC_(-0.24433393482033903664944617767154331497287859235478e0), 
      SC_(0.16e2), SC_(0.16e2), SC_(-0.34403278827667236328125e1), SC_(0.35251140594482421875e1), SC_(0.19004626196368253820245382444888355684005799383552e-8), SC_(-0.28109257030144620003916850670254255840130425975144e-9), 
      SC_(0.16e2), SC_(0.16e2), SC_(0.5256219387054443359375e1), SC_(0.2109048366546630859375e1), SC_(-0.34461059578475670777955384794247790817516942263014e-1), SC_(0.36399374527736499137866403239210798833169682291803e-1), 
      SC_(0.17e2), SC_(0.1e1), SC_(-0.2955873966217041015625e1), SC_(-0.181444680690765380859375e1), SC_(-0.97564273624825329574548143955020698822287563480684e-1), SC_(-0.39247177640032355606218617165019499553352359679161e0), 
      SC_(0.17e2), SC_(0.1e1), SC_(-0.29020233154296875e1), SC_(0.464881610870361328125e1), SC_(0.14430994669294093778639058620178920061780676326958e-1), SC_(0.22669336849140254616918915768514234432764722809716e0), 
      SC_(0.17e2), SC_(0.1e1), SC_(0.103357350826263427734375e1), SC_(0.6191986560821533203125e1), SC_(0.34204836113388779701085638221116835266801839934059e0), SC_(-0.31281153843271759834152781794460561375581104704408e-1), 
      SC_(0.17e2), SC_(0.1e1), SC_(0.4183556079864501953125e1), SC_(-0.5412806987762451171875e1), SC_(-0.21730005987468077163421102493427700013644250153143e0), SC_(-0.25776896365563929520656090933849499205300231225488e0), 
      SC_(0.17e2), SC_(0.2e1), SC_(-0.5956976413726806640625e1), SC_(-0.36576316356658935546875e1), SC_(-0.14930931820863650916175002869357807864967820277616e0), SC_(0.24981113217001939838830337252416848919161679654162e0), 
      SC_(0.17e2), SC_(0.5e1), SC_(0.20358726978302001953125e1), SC_(-0.369507122039794921875e1), SC_(-0.24844841018528621188257490831458920935003576630695e-1), SC_(-0.97566362684719232241660033646251248646442211940867e-2), 
      SC_(0.17e2), SC_(0.7e1), SC_(-0.836547374725341796875e0), SC_(0.4296808719635009765625e1), SC_(-0.46910932254297333811038538563424423092614844495962e-1), SC_(0.19809144657372382547097207431267057795142209042387e0), 
      SC_(0.17e2), SC_(0.9e1), SC_(-0.215844440460205078125e1), SC_(-0.4782807826995849609375e1), SC_(-0.16050610786716661727972736656042909291139330469833e0), SC_(-0.21840410906109625287558013106077099200913645142654e0), 
      SC_(0.17e2), SC_(0.9e1), SC_(0.13484210968017578125e1), SC_(-0.47215290069580078125e1), SC_(0.28202060318943414326653760815046818650570592901644e-1), SC_(0.34206586101440189881672233691319484207471602990613e0), 
      SC_(0.17e2), SC_(0.9e1), SC_(0.26299114227294921875e1), SC_(0.1882200717926025390625e1), SC_(0.97619561959928325849652756826390506319931833455586e-1), SC_(0.27688822741859913651081214803381984093943467380885e0), 
      SC_(0.17e2), SC_(0.9e1), SC_(0.552706050872802734375e1), SC_(-0.3554541110992431640625e1), SC_(0.2084887873521145402352802891490946959488051473673e0), SC_(-0.13509348236780155984031744104667642176243969268266e0), 
      SC_(0.17e2), SC_(0.1e2), SC_(0.181512153148651123046875e1), SC_(0.565128040313720703125e1), SC_(-0.12453300389782714226258312007808473489777645903901e0), SC_(0.44681342452270240144436989420903828246680804499614e-2), 
      SC_(0.17e2), SC_(0.1e2), SC_(0.26170427799224853515625e1), SC_(-0.1882215976715087890625e1), SC_(-0.16748158922146434393009935420874310154252050789084e0), SC_(-0.45894997481323039109359289761400908120013314795618e-2), 
      SC_(0.17e2), SC_(0.12e2), SC_(-0.197214353084564208984375e1), SC_(0.142578971385955810546875e1), SC_(-0.65566491253312408736913042187457221449481044788811e-1), SC_(-0.38361189939459540594299963129740768991259982446014e0), 
      SC_(0.17e2), SC_(0.12e2), SC_(0.20350577831268310546875e1), SC_(0.2039525508880615234375e1), SC_(0.17693200230281199543285251350964408758389654777225e0), SC_(-0.13687468330591658206315912099113365173602354914054e0), 
      SC_(0.17e2), SC_(0.13e2), SC_(0.310098171234130859375e1), SC_(-0.4785091400146484375e1), SC_(-0.71531449574228331988258016649483569913383503398036e-16), SC_(-0.51681178141076842487307687269357155394350483409232e-16), 
      SC_(0.17e2), SC_(0.13e2), SC_(0.5460363864898681640625e1), SC_(0.224959087371826171875e1), SC_(-0.17551352441781166016265666377530605324397529676416e0), SC_(-0.25630047343058630760684371123247223927449683785414e0), 
      SC_(0.17e2), SC_(0.13e2), SC_(0.6041368007659912109375e1), SC_(-0.93331897258758544921875e0), SC_(0.73723047429671398827326370004157728823967225213225e-6), SC_(0.34099039594775504707388653975253319173365956971267e-6), 
      SC_(0.17e2), SC_(0.14e2), SC_(0.170634615421295166015625e1), SC_(0.349086284637451171875e1), SC_(0.72451439142438771873066544500037006510143091924304e-1), SC_(-0.40412851380067314418759185148649412853811774732759e0), 
      SC_(0.17e2), SC_(0.14e2), SC_(0.5842761516571044921875e1), SC_(-0.25807273387908935546875e0), SC_(-0.18272117743683244344280559231817977644966582988605e-3), SC_(0.9314406997671886086788135796199050624924582067747e-4), 
      SC_(0.17e2), SC_(0.15e2), SC_(0.5955392360687255859375e1), SC_(-0.518670737743377685546875e0), SC_(0.38568805465044296160643576413239450556303487861639e-7), SC_(-0.52080944620264301722864207859762330406951175168727e-6), 
      SC_(0.17e2), SC_(0.16e2), SC_(0.23042104244232177734375e1), SC_(0.51989536285400390625e1), SC_(-0.14235099754120138302712090299948011524376912627516e-2), SC_(-0.20613633231116752504086778986228284468071093005142e-1), 
      SC_(0.18e2), SC_(0.1e1), SC_(0.175070858001708984375e1), SC_(0.6065383434295654296875e1), SC_(-0.57082986727100799966376197708815116896791451159807e-1), SC_(0.12633178835218266651846860030378252709546049656524e-1), 
      SC_(0.18e2), SC_(0.3e1), SC_(0.24663555622100830078125e1), SC_(0.43499965667724609375e1), SC_(0.19340263325020317319565521400561335969501527162468e0), SC_(0.10157884110096902348568665156163132454702318149545e0), 
      SC_(0.18e2), SC_(0.5e1), SC_(-0.13388669490814208984375e1), SC_(0.46427764892578125e1), SC_(0.93746689283724154186989587930018969983913010151864e-1), SC_(0.25837326172328637892598825027944681409145618209144e0), 
      SC_(0.18e2), SC_(0.5e1), SC_(0.33598711490631103515625e1), SC_(-0.4953685283660888671875e1), SC_(-0.21049292002975820094429719053689367442422250561918e0), SC_(-0.80268743862826196805505040424097720925062995929297e-1), 
      SC_(0.18e2), SC_(0.5e1), SC_(0.5976083278656005859375e1), SC_(-0.1903387010097503662109375e0), SC_(0.33336395845935480748654008907899166877070224813372e0), SC_(-0.46784284098456010515273796366274068955703656780187e0), 
      SC_(0.18e2), SC_(0.6e1), SC_(0.38131678104400634765625e0), SC_(-0.56470012664794921875e1), SC_(-0.45389121887510714251786875069325082259187660495763e0), SC_(-0.3636869855806322491131800646488995912875017245459e0), 
      SC_(0.18e2), SC_(0.6e1), SC_(0.551486909389495849609375e0), SC_(-0.18524148464202880859375e1), SC_(-0.38158719637616225658322334946950316168812672155382e-2), SC_(-0.31937730810263509553985832555443741111210057264651e-1), 
      SC_(0.18e2), SC_(0.7e1), SC_(-0.21025569438934326171875e1), SC_(-0.119908320903778076171875e1), SC_(-0.71269543331932737981023645852349941730664012233064e-1), SC_(-0.11900329281349591873069118865528905048588445719022e0), 
      SC_(0.18e2), SC_(0.7e1), SC_(0.1081864833831787109375e1), SC_(0.20436699390411376953125e1), SC_(-0.53477180599598900950199584293983555920649774869178e-1), SC_(0.31431962802835368220006289448379452054044238375947e0), 
      SC_(0.18e2), SC_(0.8e1), SC_(-0.64876520633697509765625e0), SC_(0.682464420795440673828125e0), SC_(0.14895032902715554125555227723295425237885293833755e0), SC_(-0.16074674721142079010011541247203459710967790591566e0), 
      SC_(0.18e2), SC_(0.8e1), SC_(0.4204979419708251953125e1), SC_(0.31924116611480712890625e0), SC_(-0.15168132209206535607331102606659155073722499238054e0), SC_(0.10104656381360884077413004489913001820737352390456e0), 
      SC_(0.18e2), SC_(0.8e1), SC_(0.5940637111663818359375e1), SC_(-0.179618394374847412109375e1), SC_(-0.25492833684734865003009618398125599858871105894793e-1), SC_(-0.1077576472069137991373822880503137086226339682438e0), 
      SC_(0.18e2), SC_(0.9e1), SC_(-0.53344440460205078125e1), SC_(0.3031736850738525390625e1), SC_(-0.83947836359991750619658189371056576334422062672375e-1), SC_(0.12754820780109011736320875520892865264583769317998e0), 
      SC_(0.18e2), SC_(0.9e1), SC_(0.160719335079193115234375e1), SC_(-0.110090769827365875244140625e0), SC_(0.1036323358714537260906275603417508860240301593312e0), SC_(-0.15818373686402031529796566835321555859423360074547e0), 
      SC_(0.18e2), SC_(0.12e2), SC_(-0.4904686450958251953125e1), SC_(-0.557145893573760986328125e0), SC_(0.30813603446843837650613490096272411252239179283899e0), SC_(-0.13121064124841743212527971509082703248974655954301e0), 
      SC_(0.18e2), SC_(0.13e2), SC_(-0.4764343738555908203125e1), SC_(0.33112971782684326171875e1), SC_(-0.14172877770700810254702956823985113551409039200517e0), SC_(0.19221102638370231884553477762342092005479877076477e0), 
      SC_(0.18e2), SC_(0.14e2), SC_(0.6204075336456298828125e1), SC_(0.5687473773956298828125e1), SC_(-0.21475363535678211921353784261963668166865908223984e-13), SC_(-0.40654923253521176415572968274979130931676486109898e-13), 
      SC_(0.18e2), SC_(0.15e2), SC_(0.34153645038604736328125e1), SC_(-0.4538040637969970703125e1), SC_(-0.64630690507726265702207930730288864426209264030233e-7), SC_(-0.11123127133210209567433481768405237677577325499377e-6), 
      SC_(0.18e2), SC_(0.16e2), SC_(-0.38164026737213134765625e1), SC_(0.282684326171875e0), SC_(-0.92252043870808798754167677507739202196175310946425e-3), SC_(-0.48113358591534906292868512997536750138755773474584e-2), 
      SC_(0.18e2), SC_(0.16e2), SC_(-0.11353113651275634765625e1), SC_(0.543939876556396484375e1), SC_(0.28982298981783941149793123109343170759287834327903e0), SC_(-0.39205270969821898686779859494721409809720696544287e0), 
      SC_(0.18e2), SC_(0.16e2), SC_(0.3265987396240234375e1), SC_(0.185117065906524658203125e1), SC_(-0.10594682689944096333889579066944593920060325794684e-13), SC_(-0.45994081326825694445180471752044919412938884659682e-13), 
      SC_(0.18e2), SC_(0.17e2), SC_(0.29616458415985107421875e1), SC_(-0.4398264408111572265625e1), SC_(0.59111318036142449142132583269351950447175230015975e-12), SC_(0.42893643601237808320443506527189231338043450164471e-12), 
      SC_(0.18e2), SC_(0.18e2), SC_(0.2519867718219757080078125e0), SC_(0.143170928955078125e1), SC_(0.69444795446057866403253169724435897525729117164794e-11), SC_(0.51491928114950666353533976551747807660320598510408e-11), 
      SC_(0.19e2), SC_(0), SC_(-0.4360961437225341796875e1), SC_(-0.212550258636474609375e1), SC_(0.17779208620920819242893021316966842617196832027202e0), SC_(0), 
      SC_(0.19e2), SC_(0.1e1), SC_(0.3593729496002197265625e1), SC_(0.4872873783111572265625e1), SC_(0.753471226678863467837734232028748689414287271732e-1), SC_(-0.46545930577990764663280377756781252535757029650398e0), 
      SC_(0.19e2), SC_(0.2e1), SC_(-0.3347132205963134765625e1), SC_(0.29699370861053466796875e1), SC_(-0.6056010975298908675661440068943333305151595611906e0), SC_(0.21648223607036281723163736488593602681085437906058e0), 
      SC_(0.19e2), SC_(0.4e1), SC_(0.2359915256500244140625e1), SC_(0.4676140308380126953125e1), SC_(0.25619103669659706784223773631846360391309063340523e0), SC_(-0.37408862169435468863314190941076967597276790174712e-1), 
      SC_(0.19e2), SC_(0.6e1), SC_(-0.7250115871429443359375e0), SC_(0.2091255664825439453125e1), SC_(0.11580958008221846542244366097307849008493876182808e0), SC_(-0.21817197227426580088998672141507994766626450745348e-2), 
      SC_(0.19e2), SC_(0.7e1), SC_(0.40428676605224609375e1), SC_(-0.63148774206638336181640625e-1), SC_(0.29555915435281645012312596416260749423021427021104e0), SC_(-0.13988129014403976755932941334904969150532455975467e0), 
      SC_(0.19e2), SC_(0.7e1), SC_(0.567075634002685546875e1), SC_(-0.572455883026123046875e1), SC_(0.15292041322774157775387390779521217071940021479753e0), SC_(0.14792428383855150980193546255474025673576709746613e0), 
      SC_(0.19e2), SC_(0.8e1), SC_(-0.4795370578765869140625e1), SC_(-0.723793923854827880859375e0), SC_(-0.29286335684820725456858496420178789171430571423756e0), SC_(-0.15727753340072474629727086052270231791006602679315e0), 
      SC_(0.19e2), SC_(0.12e2), SC_(-0.9511549472808837890625e0), SC_(0.168096458911895751953125e1), SC_(-0.35555560035325925301417211691800377905954964720633e-1), SC_(-0.13996060070687245184438677824430489349072710733457e0), 
      SC_(0.19e2), SC_(0.14e2), SC_(-0.40382061004638671875e1), SC_(-0.3806934356689453125e1), SC_(0.5090350797897085551466266086416085625730950576293e0), SC_(0.56217768140307330616639654576932558161554190530096e-1), 
      SC_(0.19e2), SC_(0.18e2), SC_(0.32035858631134033203125e1), SC_(0.5270156383514404296875e1), SC_(-0.57392737050886297399737898576446602274735173065534e-21), SC_(-0.40544546449371808546162865184481960023877754648794e-21), 
      SC_(0.19e2), SC_(0.18e2), SC_(0.557434558868408203125e1), SC_(0.25641357898712158203125e1), SC_(-0.73663467219069562020616141034192393204230840468033e-3), SC_(0.1073621182829047870755874410520251950547777079213e-2), 
      SC_(0.19e2), SC_(0.19e2), SC_(-0.13231449127197265625e1), SC_(0.710399150848388671875e0), SC_(0.20927935611855942229397269033871938782391309847475e0), SC_(0.28132879105730784934790684797797225042100948740933e0), 
      SC_(0.2e2), SC_(0), SC_(0.18518922328948974609375e1), SC_(-0.129695618152618408203125e1), SC_(0.28194337062594057783652774564224670370329371043616e0), SC_(0), 
      SC_(0.2e2), SC_(0), SC_(0.419089221954345703125e1), SC_(-0.34356572628021240234375e1), SC_(-0.10145533702848632311620637882340902397620946671081e0), SC_(0), 
      SC_(0.2e2), SC_(0.1e1), SC_(0.2973771572113037109375e1), SC_(-0.4879449367523193359375e1), SC_(0.49015146062890046370876514328844321347761082545908e-1), SC_(0.29066318761749610083362526171043527981340016444775e0), 
      SC_(0.2e2), SC_(0.3e1), SC_(-0.523828029632568359375e1), SC_(-0.22804915904998779296875e1), SC_(0.2756969730616984461702317334375385552861411106595e0), SC_(-0.17219183703488598027550250093292873812108836273016e0), 
      SC_(0.2e2), SC_(0.3e1), SC_(-0.4570482730865478515625e1), SC_(-0.29929668903350830078125e1), SC_(-0.75480479938248850980634649558184299375968804101343e-1), SC_(-0.36078192294036965836559847702790905450976716111303e-1), 
      SC_(0.2e2), SC_(0.3e1), SC_(-0.3658396303653717041015625e0), SC_(0.18125046789646148681640625e0), SC_(-0.39798644754682595723691868152136138944520636879261e0), SC_(-0.24059891903689602820634046188990162914500745527235e0), 
      SC_(0.2e2), SC_(0.5e1), SC_(-0.3568611621856689453125e1), SC_(-0.4959176540374755859375e1), SC_(0.451312815641806818347744396231646703911408874332e-1), SC_(0.15805255740746552946631957352094906770895015755439e-1), 
      SC_(0.2e2), SC_(0.5e1), SC_(-0.136743485927581787109375e1), SC_(0.4813317775726318359375e1), SC_(0.12386579484933731481979934899486697855270982047988e0), SC_(-0.22425324980956281609546272536777057329042318313411e0), 
      SC_(0.2e2), SC_(0.5e1), SC_(0.482901763916015625e1), SC_(0.424260044097900390625e1), SC_(0.16927660442615163242782649766084369287619326605903e0), SC_(-0.16683911998554189054065839864447833053233424456092e0), 
      SC_(0.2e2), SC_(0.7e1), SC_(-0.37716350555419921875e1), SC_(0.6227814197540283203125e1), SC_(-0.40543184616494956730083894131234778144262741323614e0), SC_(0.16551736932863612649466801839541361240219820437037e0), 
      SC_(0.2e2), SC_(0.7e1), SC_(0.387690258026123046875e1), SC_(-0.6208118915557861328125e1), SC_(0.18518536161985634576342383710393551398022844389437e-1), SC_(0.10737804853089673114536849109410293454449619908027e-1), 
      SC_(0.2e2), SC_(0.7e1), SC_(0.616154193878173828125e1), SC_(0.5646119594573974609375e1), SC_(-0.30270484781340871320070838726969163920444803164192e-3), SC_(0.11711672914631801275038710657303566077082801915522e-2), 
      SC_(0.2e2), SC_(0.8e1), SC_(-0.44194812774658203125e1), SC_(-0.4338510036468505859375e1), SC_(-0.24235394721786425158529197457244252442536508656378e0), SC_(0.36767319975997567222193184230305680282114868661045e-1), 
      SC_(0.2e2), SC_(0.9e1), SC_(-0.38992140293121337890625e1), SC_(0.218198871612548828125e1), SC_(-0.29409966858298028413394092272393217271957407558631e0), SC_(-0.2958366586408468808998636067732372594425246844194e0), 
      SC_(0.2e2), SC_(0.9e1), SC_(0.409140682220458984375e1), SC_(-0.59264469146728515625e1), SC_(0.37249404279670709750857124998962380341713845895572e0), SC_(0.25762747247426359773776798889833414947687083260956e-1), 
      SC_(0.2e2), SC_(0.11e2), SC_(0.24323694705963134765625e1), SC_(-0.15406930446624755859375e1), SC_(-0.15775255386587670558656979781807228019536699947149e0), SC_(0.45885677606086551458789472192765150386791784141844e0), 
      SC_(0.2e2), SC_(0.15e2), SC_(-0.216687679290771484375e1), SC_(-0.20997421741485595703125e1), SC_(-0.49075409386099536413736323942155063351143351351404e0), SC_(0.3944608235231354840778581241629003947116781434442e-1), 
      SC_(0.2e2), SC_(0.15e2), SC_(-0.60010993480682373046875e0), SC_(-0.606073625385761260986328125e-1), SC_(0.14938657008780013797821963104178228468214335389752e-1), SC_(-0.19181392727674065857204834312185128679617024004068e-1), 
      SC_(0.2e2), SC_(0.15e2), SC_(0.1751677989959716796875e1), SC_(0.31253283023834228515625e1), SC_(-0.22249585765031965180759735401621044286673729213685e0), SC_(0.55384456550691248501344848757321867003528867146345e-1), 
      SC_(0.2e2), SC_(0.17e2), SC_(0.237985515594482421875e1), SC_(-0.771009981632232666015625e0), SC_(0.32234319570125277099141265404163644943271984942533e-1), SC_(-0.19357235515813378491180157998528573224330370335815e-1), 
      SC_(0.2e2), SC_(0.17e2), SC_(0.4548780918121337890625e1), SC_(-0.85772359371185302734375e0), SC_(-0.1783970883650208810410072590462495815007860958342e0), SC_(-0.37490916784736454216512163770274075175656338804509e0), 
      SC_(0.2e2), SC_(0.18e2), SC_(0.42806243896484375e0), SC_(0.35437357425689697265625e1), SC_(0.1107745945729121116713583816882859044761290337035e-5), SC_(0.15668342095662384710699751278424405761920723488877e-5), 
      SC_(0.2e2), SC_(0.19e2), SC_(0.53311748504638671875e1), SC_(-0.4181415557861328125e1), SC_(-0.29360794196564600824227400804180898934317317747906e-1), SC_(0.37542019709332888370517420902071583914255531491941e-1), 
      SC_(0.21e2), SC_(0.1e1), SC_(0.2091248035430908203125e1), SC_(0.11432034969329833984375e1), SC_(-0.25963017651416901147198375980087596910425766928618e-1), SC_(-0.56972580737889016141484409524661404467483855145306e-1), 
      SC_(0.21e2), SC_(0.1e1), SC_(0.503726100921630859375e1), SC_(-0.2841108798980712890625e1), SC_(-0.23985252385210358060293628717719948192576495559588e0), SC_(-0.74322258039467863284983693119267119368017523730504e-1), 
      SC_(0.21e2), SC_(0.3e1), SC_(0.3963398456573486328125e1), SC_(-0.4498321056365966796875e1), SC_(0.22006067233932770638896047704540393996949523075752e0), SC_(-0.29420863992868461444357609649345685257656133295347e0), 
      SC_(0.21e2), SC_(0.4e1), SC_(0.108176577091217041015625e1), SC_(-0.31826279163360595703125e1), SC_(-0.2632490324365952976879815921304838598928832765999e0), SC_(0.43602259499698616405568042617580701992346901358396e-1), 
      SC_(0.21e2), SC_(0.5e1), SC_(-0.11399033069610595703125e1), SC_(0.14145519733428955078125e1), SC_(-0.21747105977965965241859571794632919518205331764646e0), SC_(-0.21929517921879405113114020208486299609589713184999e0), 
      SC_(0.21e2), SC_(0.6e1), SC_(-0.4329843997955322265625e1), SC_(0.61438446044921875e1), SC_(0.22672114607729768595001877142570520134894679655183e0), SC_(-0.25093315603979020161824781035135951819403020477159e0), 
      SC_(0.21e2), SC_(0.7e1), SC_(-0.405952739715576171875e1), SC_(-0.44282855987548828125e1), SC_(0.28652008447116177899729718330459333095986272198613e0), SC_(0.12724037272559207174447563458563368279483069712349e0), 
      SC_(0.21e2), SC_(0.9e1), SC_(0.29988424777984619140625e1), SC_(0.3780962467193603515625e1), SC_(0.12606348219904991672194680013653501371982248223556e-3), SC_(-0.73669309093900007054190553243420220117566327142135e-4), 
      SC_(0.21e2), SC_(0.9e1), SC_(0.3786845684051513671875e1), SC_(0.56724185943603515625e1), SC_(-0.21864817542582421898765060615033373502842562210329e-1), SC_(-0.21903628277081672424734648065555529452791268577459e-1), 
      SC_(0.21e2), SC_(0.9e1), SC_(0.415498256683349609375e1), SC_(0.104038202762603759765625e1), SC_(0.89166773768408964055452856441084024827126403166979e-1), SC_(-0.54763343044065758750492136756936698655811814743282e-2), 
      SC_(0.21e2), SC_(0.9e1), SC_(0.5398624420166015625e1), SC_(-0.5972367763519287109375e1), SC_(-0.31419017800991304201118277878357577310520238711979e0), SC_(0.11263991542426107089340605492500003436408819070406e0), 
      SC_(0.21e2), SC_(0.1e2), SC_(-0.606342220306396484375e1), SC_(-0.257316768169403076171875e0), SC_(-0.98253658631138563168501273585109552463770688396671e-3), SC_(-0.62759394481390143466799842307726950844955331405024e-3), 
      SC_(0.21e2), SC_(0.13e2), SC_(0.6156896114349365234375e1), SC_(-0.711609542369842529296875e0), SC_(-0.56639571886557959943860298176175097113833266366701e-8), SC_(-0.99474345674215221804166120947316863363222641794754e-9), 
      SC_(0.21e2), SC_(0.17e2), SC_(-0.22132570743560791015625e1), SC_(0.761013507843017578125e0), SC_(0.36016513692907497120392229690314423630318469450932e0), SC_(0.14005083989377274745869795086473687644063954713393e0), 
      SC_(0.21e2), SC_(0.18e2), SC_(-0.6276621341705322265625e1), SC_(-0.58613033294677734375e1), SC_(0.84550282971129976905599275434919725304369160575276e-38), SC_(0.3176968692832264083031364160120367789320540857439e-37), 
      SC_(0.21e2), SC_(0.18e2), SC_(-0.4130377292633056640625e1), SC_(-0.239477641880512237548828125e-1), SC_(-0.3111642862017626910241947909958727382793224765965e0), SC_(0.14310579473858952646955833043043819547786827389279e0), 
      SC_(0.21e2), SC_(0.2e2), SC_(-0.5592360019683837890625e1), SC_(-0.5070696353912353515625e1), SC_(0.24966134993550706521238616963659099689738357208731e-3), SC_(-0.30383462766490890468925648144173816339846173906576e-3), 
      SC_(0.21e2), SC_(0.21e2), SC_(-0.37527716159820556640625e1), SC_(0.43376369476318359375e1), SC_(0.55647096592322960477723912751970863413896880651839e-5), SC_(-0.87991256417453787543623721805846240273574893580383e-7), 
      SC_(0.22e2), SC_(0), SC_(-0.3864028453826904296875e1), SC_(0.5979479312896728515625e1), SC_(-0.37967087388707100427707805986698540905039508773099e0), SC_(0), 
      SC_(0.22e2), SC_(0.3e1), SC_(0.1368967533111572265625e1), SC_(0.657112419605255126953125e0), SC_(0.12316586097730232533091966369452462083717607753128e0), SC_(-0.29087587762911481194130758056326898414738577412776e0), 
      SC_(0.22e2), SC_(0.5e1), SC_(-0.366358280181884765625e1), SC_(0.5622122287750244140625e1), SC_(0.27684985110692077499994676227242274323871191478822e0), SC_(-0.45735917259284501414245695270719512179943835826404e-1), 
      SC_(0.22e2), SC_(0.5e1), SC_(0.5363164424896240234375e1), SC_(-0.606977176666259765625e1), SC_(0.1751648901204294697662582874027059296018256422649e0), SC_(0.31781489303802521190182350791767799341550554001581e0), 
      SC_(0.22e2), SC_(0.5e1), SC_(0.5382340908050537109375e1), SC_(-0.5070119380950927734375e1), SC_(0.31531046343577100904411895404894921248865376196666e0), SC_(-0.69799944617085695682901813700291853442171437489007e-1), 
      SC_(0.22e2), SC_(0.6e1), SC_(-0.35059435367584228515625e1), SC_(-0.1310674250125885009765625e0), SC_(0.44639975824520930084449831684677570674949731217019e0), SC_(-0.44729916523966538839145122680956329063569465778055e0), 
      SC_(0.22e2), SC_(0.6e1), SC_(0.2452491283416748046875e1), SC_(0.3063588619232177734375e1), SC_(0.37363116123718612440182893979763211580427209283854e0), SC_(-0.18886411785123971976060766470720030727601684914718e0), 
      SC_(0.22e2), SC_(0.6e1), SC_(0.28284170627593994140625e1), SC_(-0.12117390334606170654296875e0), SC_(0.48033735493406664646476932994601229333457762192755e0), SC_(-0.42731153413226458312247849334100993822438760302695e0), 
      SC_(0.22e2), SC_(0.7e1), SC_(0.6060801029205322265625e1), SC_(0.35501916408538818359375e1), SC_(0.89577224329346208760967333144783186514831997543763e-1), SC_(-0.25894125941642603358561760365605456962732368436741e-1), 
      SC_(0.22e2), SC_(0.8e1), SC_(0.4333584308624267578125e1), SC_(-0.4655420780181884765625e1), SC_(0.26496603088702572603348436578206876243960666028432e-1), SC_(0.12987605687137328945405726858680858630887621325785e-1), 
      SC_(0.22e2), SC_(0.1e2), SC_(0.864459812641143798828125e0), SC_(0.15828573703765869140625e1), SC_(-0.10458848750001873164197618676069904037212486649258e0), SC_(-0.12675988097635033852593118386581421544177367424329e-1), 
      SC_(0.22e2), SC_(0.1e2), SC_(0.163216269016265869140625e1), SC_(0.43768138885498046875e1), SC_(0.10769205475460309308794914608940701214263678218339e0), SC_(-0.23422321835273454290188132545221469210350416953425e-1), 
      SC_(0.22e2), SC_(0.11e2), SC_(-0.172898852825164794921875e1), SC_(-0.54356231689453125e1), SC_(-0.1335025996960849715903265813094436678810094072623e-1), SC_(0.13609978948258916265734724944928256251378221992011e-2), 
      SC_(0.22e2), SC_(0.12e2), SC_(-0.20351169109344482421875e1), SC_(0.449889361858367919921875e0), SC_(0.17878540679188264322965944893065283062887151054005e0), SC_(-0.21826872425506224986912933422675902924012236473512e0), 
      SC_(0.22e2), SC_(0.12e2), SC_(-0.6888487339019775390625e0), SC_(0.615605449676513671875e1), SC_(0.23262385022211008475718553997388761318363343547997e-1), SC_(-0.51400108068513679387034561994627323588391398264502e0), 
      SC_(0.22e2), SC_(0.12e2), SC_(0.106960904598236083984375e1), SC_(-0.19733583927154541015625e0), SC_(-0.27226521758545893036254882915860201713026965820198e0), SC_(-0.26589547564475006733069948339763008440828985949816e0), 
      SC_(0.22e2), SC_(0.12e2), SC_(0.4419538974761962890625e1), SC_(-0.2886566638946533203125e1), SC_(0.26296625742818967930147276101793374934473773909799e0), SC_(-0.21421217062421925493761715263871847391566452667958e-1), 
      SC_(0.22e2), SC_(0.13e2), SC_(0.4435905933380126953125e1), SC_(-0.12813246250152587890625e1), SC_(-0.1994502603548058170882961020550149081586085253674e0), SC_(0.27847016580640654910845435722469110183802493530924e0), 
      SC_(0.22e2), SC_(0.14e2), SC_(-0.4442024707794189453125e1), SC_(-0.9945828914642333984375e0), SC_(0.1296973807142630520602561405069367183406751677746e-2), SC_(-0.59965265315985629106575527349406388681327592445741e-2), 
      SC_(0.22e2), SC_(0.15e2), SC_(0.23340003490447998046875e1), SC_(-0.5747199535369873046875e1), SC_(-0.97047210369236124504262026747372680536197441525978e-1), SC_(0.5162824383605399312832886588640438267957441255626e0), 
      SC_(0.22e2), SC_(0.15e2), SC_(0.5646602630615234375e1), SC_(-0.370086956024169921875e1), SC_(0.70099047237989581963419105029008064056241505095465e-1), SC_(0.11823366414397759576235377840074880901538627773909e0), 
      SC_(0.22e2), SC_(0.18e2), SC_(-0.4764419078826904296875e1), SC_(-0.5781750202178955078125e1), SC_(-0.28873734553361943376146504742715192480189630599691e0), SC_(0.12171764615416719961400687145073205519603805335772e0), 
      SC_(0.22e2), SC_(0.18e2), SC_(-0.602382600307464599609375e0), SC_(0.14415314197540283203125e1), SC_(0.22051079783421255041075442087441577571651558309987e-2), SC_(0.23388580730357922522617564497036978348138194251512e-2), 
      SC_(0.22e2), SC_(0.18e2), SC_(0.125289380550384521484375e1), SC_(0.10234868526458740234375e1), SC_(-0.20756108656065894795840187247351381826303166188039e0), SC_(0.94387295297523600294518324872047767477120423407304e-1), 
      SC_(0.22e2), SC_(0.18e2), SC_(0.16989471912384033203125e1), SC_(-0.33770077228546142578125e1), SC_(0.29529482620380182728114893943939945095007932514389e-1), SC_(-0.57431573411124672998794190039206379458054603532143e-1), 
      SC_(0.22e2), SC_(0.18e2), SC_(0.6217523097991943359375e1), SC_(0.485020160675048828125e0), SC_(-0.80437198826822501659130070303795091568128825681545e-19), SC_(0.66986958864633541550450146264372252429299951916435e-19), 
      SC_(0.22e2), SC_(0.19e2), SC_(-0.597578525543212890625e1), SC_(0.4910336017608642578125e1), SC_(-0.47804997793402321085743862795705266459809548387236e-8), SC_(0.67047195254824818560749900273886729950395336143326e-8), 
      SC_(0.22e2), SC_(0.19e2), SC_(0.2022489070892333984375e1), SC_(0.504736614227294921875e1), SC_(-0.43326159139679386743853520940223863748311016118727e-1), SC_(0.53121235298576042278559416566379389495615270017184e0), 
      SC_(0.23e2), SC_(0), SC_(0.29888064861297607421875e1), SC_(-0.13009319305419921875e1), SC_(0.75738929893098462495350827800799399695345377677096e0), SC_(0), 
      SC_(0.23e2), SC_(0), SC_(0.5227834224700927734375e1), SC_(0.451055812835693359375e1), SC_(0.14853191605883646545449022181751805416325866263486e0), SC_(0), 
      SC_(0.23e2), SC_(0.3e1), SC_(-0.547917079925537109375e1), SC_(-0.4498243808746337890625e1), SC_(-0.12042433185638232158601425798187407633114484812021e0), SC_(0.16092273708577621342840733394234829666884093892974e0), 
      SC_(0.23e2), SC_(0.3e1), SC_(0.55184173583984375e1), SC_(-0.554555797576904296875e1), SC_(-0.2298035983414593549064673463692369917410884946655e0), SC_(0.30731004437158444478476636152634839325606939416505e0), 
      SC_(0.23e2), SC_(0.5e1), SC_(-0.20993845462799072265625e1), SC_(-0.23019187450408935546875e1), SC_(-0.15359745242107965786972893853988106488191265982488e0), SC_(-0.27202352359407390030331662263002014519028242316274e0), 
      SC_(0.23e2), SC_(0.5e1), SC_(0.545889568328857421875e1), SC_(-0.5044847965240478515625e1), SC_(0.85936753192554254706707642050916866586380300897297e-1), SC_(-0.78851093751912218787076363157244016360880050881498e-2), 
      SC_(0.23e2), SC_(0.6e1), SC_(-0.593177318572998046875e1), SC_(0.4529429912567138671875e1), SC_(-0.2888004383617216913479816051906518888250307796671e0), SC_(0.56428526154976709721188366384981988147403713306907e0), 
      SC_(0.23e2), SC_(0.8e1), SC_(0.35884401798248291015625e1), SC_(0.313064479827880859375e1), SC_(-0.59220553861944572728526349267733022699870221067449e0), SC_(0.52000072378830935460116346633206117875833953638951e-1), 
      SC_(0.23e2), SC_(0.1e2), SC_(-0.35713214874267578125e1), SC_(-0.5895015716552734375e1), SC_(0.27363047177334956393785621839935733927906007921567e0), SC_(0.24990093323567845231465167088461804945796877368968e0), 
      SC_(0.23e2), SC_(0.11e2), SC_(0.288183689117431640625e1), SC_(-0.4051367282867431640625e1), SC_(-0.27008054438566323442041866091056043346991294041611e-2), SC_(0.17800897467223742426745667205709769443293791401656e-2), 
      SC_(0.23e2), SC_(0.14e2), SC_(0.27440736293792724609375e1), SC_(0.562889385223388671875e1), SC_(0.52694336150630886094788925618445248259468774455507e-2), SC_(0.14283216133931614223523268257433533500731213592224e-2), 
      SC_(0.23e2), SC_(0.15e2), SC_(-0.52518482208251953125e1), SC_(0.5665853023529052734375e1), SC_(-0.4135549711402433437559090469608862668469973827373e0), SC_(-0.68774959471297104657173238804389143814112152294236e-1), 
      SC_(0.23e2), SC_(0.15e2), SC_(-0.4191381931304931640625e1), SC_(-0.4067589282989501953125e1), SC_(-0.96095750532255311845519979802764966717867886737734e-1), SC_(0.38075803261362252763692306470964765229435596293148e0), 
      SC_(0.23e2), SC_(0.15e2), SC_(-0.127436196804046630859375e1), SC_(0.19672439098358154296875e1), SC_(-0.70178323950894872942146252508886888414269316658327e-1), SC_(-0.20064028045811801960473157780116871915372597167299e0), 
      SC_(0.23e2), SC_(0.16e2), SC_(-0.4365890979766845703125e1), SC_(0.2873447418212890625e1), SC_(0.66070268152301147670501629421559548165547966030298e-1), SC_(-0.14713280719714581028087523063695627699901661190266e0), 
      SC_(0.23e2), SC_(0.16e2), SC_(-0.187368810176849365234375e1), SC_(0.176321041584014892578125e1), SC_(0.35181149451317022322548874207766609890359266123822e0), SC_(-0.22181918800123060405270886651387612747002266548699e-1), 
      SC_(0.23e2), SC_(0.16e2), SC_(-0.987631022930145263671875e0), SC_(-0.25693976879119873046875e1), SC_(-0.14752625223614687995978414827009163508111393964289e-1), SC_(0.40774858170144985725470132137656579592284515508229e-2), 
      SC_(0.23e2), SC_(0.17e2), SC_(-0.1042644977569580078125e1), SC_(-0.126002967357635498046875e1), SC_(-0.84372836036506907579365776174497016920482554258603e-1), SC_(-0.54157040587253602532939767236091668933755307060758e-1), 
      SC_(0.23e2), SC_(0.21e2), SC_(-0.162158882617950439453125e1), SC_(0.926264286041259765625e0), SC_(-0.33537009884370457257819832085729754220752139566095e0), SC_(-0.23042213507030152112399657499329678284736738115171e0), 
      SC_(0.23e2), SC_(0.23e2), SC_(-0.5628755092620849609375e1), SC_(-0.486063861846923828125e1), SC_(-0.19279642809569265771501043324890995674328606788309e-5), SC_(-0.70167395917250045539062331026766596596685495030774e-5), 
      SC_(0.24e2), SC_(0), SC_(-0.1324918270111083984375e1), SC_(-0.2062782764434814453125e1), SC_(0.31248414740470870068648813349183676826199752058627e0), SC_(0), 
      SC_(0.24e2), SC_(0), SC_(-0.862500965595245361328125e0), SC_(0.517900943756103515625e1), SC_(0.28761642824529274677889314069723145139439610730308e-1), SC_(0), 
      SC_(0.24e2), SC_(0), SC_(0.613764095306396484375e1), SC_(0.27141590118408203125e1), SC_(-0.76809865030741529572652412857730476800278075901627e0), SC_(0), 
      SC_(0.24e2), SC_(0.1e1), SC_(0.37304210662841796875e1), SC_(0.2045906543731689453125e1), SC_(0.17406937330198662132259168765838417087776489150157e0), SC_(-0.33838547049587917953685331170358244820079493271777e0), 
      SC_(0.24e2), SC_(0.2e1), SC_(-0.596615886688232421875e1), SC_(-0.3750219821929931640625e1), SC_(-0.11972345578499665450698852003835809000878029811576e0), SC_(0.32441191438142413805004166984248260147019477460334e0), 
      SC_(0.24e2), SC_(0.2e1), SC_(0.482663822174072265625e1), SC_(0.1862316131591796875e1), SC_(-0.25071109310625056452049278178434541704578780231427e0), SC_(-0.16534935117017818943877902117408306235938246945429e0), 
      SC_(0.24e2), SC_(0.4e1), SC_(0.6276796817779541015625e1), SC_(-0.11994216442108154296875e1), SC_(0.25801612399963249102879730758376329625555131739219e-6), SC_(0.30175536401800446418804784440865574636608737328616e-5), 
      SC_(0.24e2), SC_(0.1e2), SC_(-0.5570613384246826171875e1), SC_(0.4233923256397247314453125e0), SC_(0.19337378251150843320954417807274626913542733729733e0), SC_(0.37283178307258688225228263568186108488537147181342e0), 
      SC_(0.24e2), SC_(0.1e2), SC_(0.22040307521820068359375e1), SC_(-0.20946109294891357421875e1), SC_(0.37302897301258406546836692868470724457316471444728e-1), SC_(0.64289673233253501568434095072478328874481417023666e-1), 
      SC_(0.24e2), SC_(0.11e2), SC_(-0.502376461029052734375e1), SC_(-0.983952462673187255859375e0), SC_(0.28894185384748941092528428359045290042488287748567e-1), SC_(-0.16623375357848744142183060777069550816278314788802e0), 
      SC_(0.24e2), SC_(0.13e2), SC_(0.4449751377105712890625e1), SC_(0.2216667652130126953125e1), SC_(0.22824011402197158751112985203705119383513476952859e0), SC_(0.13754263343801919733700269665463551158773894003828e0), 
      SC_(0.24e2), SC_(0.15e2), SC_(-0.4976137638092041015625e1), SC_(-0.310904216766357421875e1), SC_(-0.30389330120851375593946370604183523851559183134456e0), SC_(-0.16141344530020327810859705205819937069987356435226e0), 
      SC_(0.24e2), SC_(0.15e2), SC_(-0.462989044189453125e1), SC_(0.29690244197845458984375e1), SC_(0.30521077389098319232149363723210282664192767320181e0), SC_(0.18841760449959212347690394670808241696462446304094e0), 
      SC_(0.24e2), SC_(0.16e2), SC_(-0.54365100860595703125e1), SC_(-0.107414150238037109375e1), SC_(-0.45557665116940822672642712669212000516440479824573e-1), SC_(0.49113352922974654869881563350776976504670140793946e0), 
      SC_(0.24e2), SC_(0.16e2), SC_(-0.2125865459442138671875e1), SC_(-0.511815166473388671875e1), SC_(-0.38416093886724238216340790326420228393001869248409e0), SC_(0.81486556178465805625708210814255943217651558678561e-1), 
      SC_(0.24e2), SC_(0.16e2), SC_(-0.17001283168792724609375e1), SC_(0.3998670101165771484375e1), SC_(-0.11138605277601010251188258498857458647912106126701e0), SC_(-0.24681596187119985954323447452100423319448346948214e0), 
      SC_(0.24e2), SC_(0.18e2), SC_(-0.4075663089752197265625e1), SC_(-0.5742432117462158203125e1), SC_(-0.51266655456634025309426203584175543452638425990346e0), SC_(-0.16353152833753100258373409708197422697689089790348e0), 
      SC_(0.24e2), SC_(0.18e2), SC_(0.46365203857421875e1), SC_(-0.17638797760009765625e1), SC_(-0.11140821918938605951834868980133015433047714242108e0), SC_(0.38647382721754031499693021268538390526610003867236e-1), 
      SC_(0.24e2), SC_(0.19e2), SC_(-0.4418343603610992431640625e0), SC_(0.4380367755889892578125e1), SC_(0.97528994148526769438004673063110012855421277572828e-6), SC_(0.38666222714376615580697269201641358307069107285711e-4), 
      SC_(0.24e2), SC_(0.2e2), SC_(-0.553404712677001953125e1), SC_(-0.4798403263092041015625e1), SC_(-0.44568002302399882798139251940752779565308668211966e-2), SC_(-0.2959108821243276465092713314859992630431731645777e-1), 
      SC_(0.24e2), SC_(0.22e2), SC_(-0.560159206390380859375e1), SC_(-0.1638908863067626953125e1), SC_(-0.36373486522680725254518973028655936524769190667545e-4), SC_(0.50207113740532464470510299951942942143415384668508e-3), 
      SC_(0.24e2), SC_(0.22e2), SC_(-0.8115555346012115478515625e-1), SC_(0.2600201129913330078125e1), SC_(0.17079228237050294369757430672219409902092550934305e-22), SC_(0.1313953895770315858484471886621780802232058082472e-22), 
      SC_(0.24e2), SC_(0.23e2), SC_(-0.5962747097015380859375e1), SC_(0.741824924945831298828125e0), SC_(0.27300200137470974720018871768085999995459732753643e-11), SC_(0.12395239937794373196827378246837635273642840395193e-10), 
      SC_(0.24e2), SC_(0.23e2), SC_(0.4480103969573974609375e1), SC_(0.5091310024261474609375e1), SC_(0.371317369895599348651474612156066319502066288817e0), SC_(0.4323561691929297334793362661141953034455816226565e0), 
      SC_(0.24e2), SC_(0.24e2), SC_(-0.5264360904693603515625e1), SC_(-0.6782491207122802734375e0), SC_(-0.11874473221763931033108524336407512892608017319905e-1), SC_(0.76114257408314561038166809303894864473872661846102e-2), 
      SC_(0.25e2), SC_(0), SC_(-0.3876895427703857421875e1), SC_(-0.32360093593597412109375e1), SC_(-0.24452080451562791198246313501234401060101215892473e0), SC_(0), 
      SC_(0.25e2), SC_(0.1e1), SC_(-0.27703266143798828125e1), SC_(0.12215938568115234375e1), SC_(0.11746962748701579924923836574918003019510282873987e0), SC_(0.3226080064489771651711357824503959554332405674128e0), 
      SC_(0.25e2), SC_(0.1e1), SC_(0.7773735523223876953125e0), SC_(0.5681798458099365234375e1), SC_(-0.63218002691708143536080430464529613751050271653976e-1), SC_(0.43378593874156819995284851343146234941137966666292e-1), 
      SC_(0.25e2), SC_(0.1e1), SC_(0.2005723476409912109375e1), SC_(-0.25890109539031982421875e1), SC_(0.25080805178160619245804883981811723733876125233566e-1), SC_(0.15466404766801889477712656081299736079787792239148e-1), 
      SC_(0.25e2), SC_(0.3e1), SC_(0.499125385284423828125e1), SC_(0.2625409603118896484375e1), SC_(0.51599564991025433641751334953777473303522774308688e-2), SC_(-0.23189933545442436138439500369133402123625001488003e0), 
      SC_(0.25e2), SC_(0.5e1), SC_(-0.5153573513031005859375e1), SC_(-0.46076297760009765625e1), SC_(0.39473234214683783091619172393326231275476524627325e-2), SC_(-0.68338514034057717266443350723340867185848364943051e-2), 
      SC_(0.25e2), SC_(0.6e1), SC_(0.622525119781494140625e1), SC_(0.27696933746337890625e1), SC_(-0.24425625229479477233188544139092463122182434092512e-3), SC_(-0.3143315256687476516940017361078913592775166275262e-3), 
      SC_(0.25e2), SC_(0.7e1), SC_(0.114450514316558837890625e1), SC_(-0.2546615123748779296875e1), SC_(-0.95637014511567344221264544790152606871926989097047e-1), SC_(-0.15685033719678696999611509536131244333363029683236e0), 
      SC_(0.25e2), SC_(0.7e1), SC_(0.2645304203033447265625e1), SC_(0.3280132710933685302734375e0), SC_(-0.30647436470681925568674763213354695641056755300071e0), SC_(0.34571952107274179166660249962996491344682011604635e0), 
      SC_(0.25e2), SC_(0.8e1), SC_(-0.25140659809112548828125e1), SC_(-0.18471310138702392578125e1), SC_(-0.71554921015350386695845601481135992925247309694169e-1), SC_(-0.961295665140334103486942390331186792374042041282e-1), 
      SC_(0.25e2), SC_(0.9e1), SC_(-0.242069911956787109375e1), SC_(0.5341898441314697265625e1), SC_(-0.1460083067839701489438706250450869484090920317533e0), SC_(-0.20556089324545968654377047800812990995396349780646e0), 
      SC_(0.25e2), SC_(0.9e1), SC_(0.1712700366973876953125e1), SC_(-0.491151332855224609375e1), SC_(0.31334256426873953231492357029337302275793319860016e0), SC_(-0.70504830560979637998854802373395690866160076937206e-1), 
      SC_(0.25e2), SC_(0.9e1), SC_(0.511040782928466796875e1), SC_(-0.6116263866424560546875e1), SC_(-0.23590505400258263693433013328826839179698865946289e-1), SC_(-0.3438312035300497706121783539581422771445398525173e0), 
      SC_(0.25e2), SC_(0.1e2), SC_(0.3095265865325927734375e1), SC_(0.178794467449188232421875e1), SC_(-0.12036667074182603651749819750773626281025819046829e-8), SC_(0.17568031065028703357843791528647300227723575332801e-8), 
      SC_(0.25e2), SC_(0.1e2), SC_(0.4784619808197021484375e1), SC_(-0.5005569934844970703125e1), SC_(-0.32256570201324250889979735987131248551167770129767e0), SC_(-0.68679305644396201505491801595415389963761424260392e-1), 
      SC_(0.25e2), SC_(0.12e2), SC_(0.4094234943389892578125e1), SC_(0.205652904510498046875e1), SC_(-0.30330180676691994676055164310923196173641860577758e0), SC_(0.1481581731020885911545974981858342825516482597711e0), 
      SC_(0.25e2), SC_(0.12e2), SC_(0.4962983608245849609375e1), SC_(-0.163137233257293701171875e1), SC_(-0.15839134993623850489777357359933744313103301843138e0), SC_(0.14086880827905948850990015097149018548509954501518e0), 
      SC_(0.25e2), SC_(0.13e2), SC_(-0.2300118923187255859375e1), SC_(-0.36115558147430419921875e1), SC_(0.39791804119535103665755545319108981142922247032052e0), SC_(0.69807317190331413170669851171882753950629031686466e-1), 
      SC_(0.25e2), SC_(0.13e2), SC_(-0.889023125171661376953125e0), SC_(-0.567437839508056640625e1), SC_(0.77488995646546077377528426598426223660068364128541e-2), SC_(-0.12790724893854634917857667665072335967097237791168e0), 
      SC_(0.25e2), SC_(0.13e2), SC_(0.21100962162017822265625e1), SC_(-0.21088435649871826171875e1), SC_(0.14328387126713818148236022542510962859678723697469e0), SC_(0.16621948669419806269290232665997400106837593517422e0), 
      SC_(0.25e2), SC_(0.15e2), SC_(-0.5503502368927001953125e1), SC_(0.17439391613006591796875e1), SC_(-0.20612272315235832711064550794393208299382361965088e0), SC_(-0.34042019972211732597646951568375363155696917414732e0), 
      SC_(0.25e2), SC_(0.19e2), SC_(0.68212032318115234375e-1), SC_(0.5628895282745361328125e1), SC_(-0.12862315073404389959698914161686961550654093238902e-18), SC_(-0.17452067685713628457026780573925765370864488540548e-19), 
      SC_(0.25e2), SC_(0.21e2), SC_(0.652602493762969970703125e0), SC_(0.1647074222564697265625e1), SC_(0.29482344436261443152558299688997978191119148500104e-2), SC_(0.91541077227606152736369539747397509508686307427872e-4), 
      SC_(0.25e2), SC_(0.24e2), SC_(-0.560768795013427734375e1), SC_(-0.135371887683868408203125e1), SC_(0.22683331887985147446081280672359733123330908887175e-4), SC_(-0.41772421541307706758709900467145772598020182643899e-4), 
      SC_(0.25e2), SC_(0.24e2), SC_(-0.25576140880584716796875e1), SC_(-0.5700718402862548828125e1), SC_(-0.39000450874718532083419260533487240120088234728687e-6), SC_(-0.24484192497289751823128107116472159586524030098795e-5), 
      SC_(0.25e2), SC_(0.24e2), SC_(0.1733565807342529296875e1), SC_(-0.5109857082366943359375e1), SC_(0.55836962543957325906629790288435638719057752040688e0), SC_(-0.64189571383798894090504849164065298725709687409556e-1), 
      SC_(0.25e2), SC_(0.24e2), SC_(0.267821216583251953125e1), SC_(0.34839074611663818359375e1), SC_(0.61079010931332695678531003634103207962775055239385e-8), SC_(-0.16149896531717650240134485219262264117712269354817e-7), 
      SC_(0.25e2), SC_(0.24e2), SC_(0.5091073513031005859375e1), SC_(0.507114410400390625e1), SC_(-0.20755548134105865087692788918483802129799964515379e0), SC_(0.2200700189867651973658928910254355227812118256831e0), 
      SC_(0.26e2), SC_(0), SC_(0.28866140842437744140625e1), SC_(-0.32590219974517822265625e1), SC_(0.59888796023273285414978283053050390085918627286007e0), SC_(0), 
      SC_(0.26e2), SC_(0.4e1), SC_(-0.4675228118896484375e1), SC_(-0.536728191375732421875e1), SC_(0.15607741424248587444670750100843521079692964025284e0), SC_(0.89783278899561852524446346954599790348748627919629e-1), 
      SC_(0.26e2), SC_(0.4e1), SC_(-0.3475870609283447265625e1), SC_(0.2798839092254638671875e1), SC_(-0.10330755317046573919679713513393069909634998522503e0), SC_(0.51020315387182095575971247206672588326249150135501e0), 
      SC_(0.26e2), SC_(0.4e1), SC_(0.52667827606201171875e1), SC_(0.35358884334564208984375e1), SC_(-0.80208715950742831164609891241196492786571490304276e-3), SC_(0.12558357452735600082861913195525690993598139649899e0), 
      SC_(0.26e2), SC_(0.5e1), SC_(-0.4896442890167236328125e1), SC_(-0.644553959369659423828125e0), SC_(-0.3219917446704770830987636285023782624906334020492e0), SC_(0.2619593665072280598925333284807917974759103914616e-1), 
      SC_(0.26e2), SC_(0.5e1), SC_(-0.1856127679347991943359375e0), SC_(0.3506732940673828125e1), SC_(0.12808777056376183866778340276701209822128124445917e0), SC_(-0.4915611242976698789268648567893977457275119249108e0), 
      SC_(0.26e2), SC_(0.6e1), SC_(0.35201609134674072265625e1), SC_(0.712134182453155517578125e0), SC_(0.18167473263617165549862218444646925788793996157123e-2), SC_(0.38631817684229255023504922858120822379142056189224e-2), 
      SC_(0.26e2), SC_(0.8e1), SC_(0.21621563434600830078125e1), SC_(0.176831352710723876953125e1), SC_(-0.21902677451976515855664026438380708818940415564342e-2), SC_(0.23446519587828903308091387090129442535840190548951e0), 
      SC_(0.26e2), SC_(0.8e1), SC_(0.29448168277740478515625e1), SC_(0.4156087398529052734375e1), SC_(-0.11648026682090861893404700256346285395509902344719e-1), SC_(0.4344028102678889398661550429910420496309969253894e-1), 
      SC_(0.26e2), SC_(0.9e1), SC_(-0.7637768052518367767333984375e-2), SC_(0.37568457126617431640625e1), SC_(-0.38666063076948367819941181610041792269034885343045e-14), SC_(0.3572673453413943137086464572968282399473008855551e-14), 
      SC_(0.26e2), SC_(0.1e2), SC_(-0.130035817623138427734375e1), SC_(0.4838814258575439453125e1), SC_(-0.96096634776053518451225224737094628216737181029099e-1), SC_(-0.30360311349635329844708524547980680440375114974486e0), 
      SC_(0.26e2), SC_(0.1e2), SC_(-0.1281925678253173828125e1), SC_(0.3520789623260498046875e1), SC_(-0.18971976240579681665607152009114929782194828818254e0), SC_(-0.14433870229808105443741875831309708824618109723486e0), 
      SC_(0.26e2), SC_(0.11e2), SC_(-0.266436004638671875e1), SC_(-0.146718060970306396484375e1), SC_(0.53754978773168219938186239125756949628605830326527e0), SC_(-0.24719781072866265067668253668334010720688282062476e0), 
      SC_(0.26e2), SC_(0.12e2), SC_(-0.46720333099365234375e1), SC_(0.5567004680633544921875e1), SC_(0.13159723065828215725901237808308445798477821140514e0), SC_(0.14406923933879002089309396120649556453547842223706e0), 
      SC_(0.26e2), SC_(0.13e2), SC_(-0.5170716762542724609375e1), SC_(0.396167524158954620361328125e-1), SC_(0.2747066992606051124718983862369076127794027582961e0), SC_(0.15547439604601166462304161698796568643095823328666e0), 
      SC_(0.26e2), SC_(0.16e2), SC_(0.34189922809600830078125e1), SC_(0.62253940105438232421875e0), SC_(-0.15388447791508385488961606039859778005711466301889e-4), SC_(-0.91377487900087822487029398478309708641358364344333e-5), 
      SC_(0.26e2), SC_(0.17e2), SC_(-0.2040981292724609375e1), SC_(-0.32355091571807861328125e1), SC_(-0.13937408586961078471459718438769272177699951388526e-2), SC_(-0.5404201520948196392514367169061015489092824027921e-1), 
      SC_(0.26e2), SC_(0.18e2), SC_(-0.496606349945068359375e1), SC_(-0.3744811534881591796875e1), SC_(-0.93692939929955839702525083671902479242015507776566e-2), SC_(0.67643379276993047968633668940119476977778481029538e-1), 
      SC_(0.26e2), SC_(0.22e2), SC_(-0.215118408203125e1), SC_(0.4257010936737060546875e1), SC_(0.3233570363068339030724037307349679834283059153667e0), SC_(-0.21816685536363050909681486114218107795833718573678e0), 
      SC_(0.26e2), SC_(0.23e2), SC_(-0.626444530487060546875e1), SC_(0.30316879749298095703125e1), SC_(-0.14610937060772995527984594628448830882806388111318e-37), SC_(-0.10294396143474871982249659742078628066491723977817e-37), 
      SC_(0.26e2), SC_(0.23e2), SC_(0.2308638095855712890625e1), SC_(0.2850924015045166015625e1), SC_(-0.24198577688656307591232455670025615741027047043071e-1), SC_(0.10293617054536935634549002148603933883299843345613e-1), 
      SC_(0.27e2), SC_(0), SC_(0.262725543975830078125e1), SC_(-0.3332263469696044921875e1), SC_(-0.32108559549890749301698421358412842563756110855673e0), SC_(0), 
      SC_(0.27e2), SC_(0), SC_(0.29525635242462158203125e1), SC_(-0.96874904632568359375e0), SC_(0.23244104762422620766564658428336431139783727577812e0), SC_(0), 
      SC_(0.27e2), SC_(0.1e1), SC_(-0.3790359020233154296875e1), SC_(-0.33002679347991943359375e1), SC_(-0.39615090450102674096082556731023459539923878348912e0), SC_(0.63392278322470359061713469877762348658777297223449e-1), 
      SC_(0.27e2), SC_(0.3e1), SC_(0.23251364231109619140625e1), SC_(-0.35694611072540283203125e1), SC_(-0.18399232475186213478532994671392506573104355525209e-1), SC_(0.62295069046281653710453200709810763951905891143402e-1), 
      SC_(0.27e2), SC_(0.5e1), SC_(0.3879522383213043212890625e0), SC_(-0.38136348724365234375e1), SC_(0.53834161615875287293754381907669271323628694858384e0), SC_(-0.11960293884052284795748049244054999405373272041818e0), 
      SC_(0.27e2), SC_(0.5e1), SC_(0.650668203830718994140625e0), SC_(0.5258705615997314453125e1), SC_(0.15188383394406850166122344762357200180219134166819e0), SC_(0.34944545086668248072247019650278666496638639469351e0), 
      SC_(0.27e2), SC_(0.6e1), SC_(-0.166312253475189208984375e1), SC_(-0.119002068042755126953125e1), SC_(-0.13021055843854354343691965096561463265667602208609e0), SC_(0.15031374707675568834777976554388900651625644602142e0), 
      SC_(0.27e2), SC_(0.7e1), SC_(-0.4965648651123046875e1), SC_(-0.5313018798828125e1), SC_(-0.25930244722780854914235196015039329670614742450185e0), SC_(-0.14435626860269623414202165396442933086661458033335e0), 
      SC_(0.27e2), SC_(0.9e1), SC_(0.601284885406494140625e1), SC_(-0.14040200710296630859375e1), SC_(0.15932380943538052638751643294167291738338727406529e0), SC_(-0.11140502509579299328368147700939877600963528039524e-1), 
      SC_(0.27e2), SC_(0.11e2), SC_(-0.5047023773193359375e1), SC_(-0.1643696308135986328125e1), SC_(0.12949376863247812700191578038411775026897240843971e0), SC_(0.12528905474545626016745194874120375569465438710282e0), 
      SC_(0.27e2), SC_(0.14e2), SC_(-0.5018929004669189453125e1), SC_(-0.61585292816162109375e1), SC_(-0.49444593829854721265248350137908864074848505124683e-1), SC_(0.28065201196709096764215836614007991340683316011596e0), 
      SC_(0.27e2), SC_(0.14e2), SC_(0.10453426837921142578125e1), SC_(0.4748726367950439453125e1), SC_(0.11447223007891547356823550767384702707901639572594e0), SC_(0.63839321920711976674672958851492878428150855280256e-1), 
      SC_(0.27e2), SC_(0.15e2), SC_(-0.3675783634185791015625e1), SC_(-0.51941013336181640625e1), SC_(0.19284283285718520917320611396827335529838436413153e0), SC_(0.14010197984265520557426785450181784982418943123654e0), 
      SC_(0.27e2), SC_(0.15e2), SC_(0.42129802703857421875e1), SC_(-0.11898415088653564453125e1), SC_(0.59606553371851112994505044969982752502609379088643e-1), SC_(0.93227644665587411267658810181860604476389275218165e-1), 
      SC_(0.27e2), SC_(0.16e2), SC_(-0.519953060150146484375e1), SC_(0.21793434619903564453125e1), SC_(-0.34978662217298386043133441212835046085830245918824e0), SC_(-0.11280893779488382017129004140946079702770950468579e0), 
      SC_(0.27e2), SC_(0.16e2), SC_(-0.36205046176910400390625e1), SC_(0.31306784152984619140625e1), SC_(-0.40300698085023514517994827194108195059010110782911e-1), SC_(0.71100434044382319252965214747550316204001925413246e-2), 
      SC_(0.27e2), SC_(0.21e2), SC_(0.3417222499847412109375e1), SC_(0.24105484783649444580078125e0), SC_(0.9175821801343779257885854530260509654111962970602e-9), SC_(-0.25155796556906881651758357739199584186008363674147e-8), 
      SC_(0.27e2), SC_(0.23e2), SC_(-0.140652561187744140625e1), SC_(0.35428617000579833984375e1), SC_(-0.33402552979090232528742889524607488583682153563735e0), SC_(0.6617806699528517719147513542523733796765945708277e-1), 
      SC_(0.27e2), SC_(0.24e2), SC_(0.34913151264190673828125e1), SC_(0.3636254787445068359375e1), SC_(-0.44276015746085093586636394741641137465608780422309e-9), SC_(0.36877262381006324108255678772315066310533711139797e-9), 
      SC_(0.27e2), SC_(0.25e2), SC_(-0.19502545893192291259765625e0), SC_(0.43212947845458984375e1), SC_(0.1293084909882853957297819284583450662042489589536e-16), SC_(0.35142803536333876246035524741838830925177608638617e-16), 
      SC_(0.27e2), SC_(0.26e2), SC_(0.42383403778076171875e1), SC_(0.4610982418060302734375e1), SC_(-0.96792963912541844209040359834406140802021879909123e-1), SC_(-0.53511150454597223921638356713277351605960241025587e-1), 
      SC_(0.27e2), SC_(0.27e2), SC_(-0.24535601139068603515625e1), SC_(0.1783678531646728515625e1), SC_(-0.16610346397007784290967506143688737284156397994818e-5), SC_(-0.28003729361654600046367368297838432192011606961365e-5), 
      SC_(0.28e2), SC_(0.2e1), SC_(0.2177688121795654296875e1), SC_(0.18298971652984619140625e1), SC_(-0.85687523720959234998720552344234982305671299898196e-2), SC_(-0.48857005677113196416359021785218151379203650021081e-2), 
      SC_(0.28e2), SC_(0.5e1), SC_(-0.846441447734832763671875e0), SC_(-0.56284923553466796875e1), SC_(0.3647923513126111922503115636055725933093205777732e0), SC_(0.48386747098235354960987684318477267981623334144679e-1), 
      SC_(0.28e2), SC_(0.5e1), SC_(0.4151194095611572265625e1), SC_(-0.5815281391143798828125e1), SC_(0.26726917143067893396495442494135622082707159949158e-2), SC_(-0.27633455488337920174174128039592444686107269780764e-2), 
      SC_(0.28e2), SC_(0.9e1), SC_(0.1393414020538330078125e1), SC_(-0.4903962612152099609375e1), SC_(-0.32465484455243118463225724415754601138616082359438e0), SC_(0.50185222751834862051129946904541428719603392752397e-1), 
      SC_(0.28e2), SC_(0.1e2), SC_(-0.84841859340667724609375e0), SC_(-0.27043387889862060546875e1), SC_(0.12909330609310526403894668405290308571894010613022e0), SC_(0.36511541159277651527045081673970587076715433222867e0), 
      SC_(0.28e2), SC_(0.12e2), SC_(-0.2621095180511474609375e1), SC_(0.357422637939453125e1), SC_(0.27830207480444508442103903815990998408888519620986e0), SC_(-0.53559344562374926298319778445421465060417361512259e0), 
      SC_(0.28e2), SC_(0.13e2), SC_(-0.14266557991504669189453125e0), SC_(-0.470821475982666015625e1), SC_(-0.88183209080443499816837351366071602837109179504688e-7), SC_(0.16234561983310332804334726913840256338435535503632e-5), 
      SC_(0.28e2), SC_(0.13e2), SC_(0.506378841400146484375e1), SC_(0.337982940673828125e1), SC_(-0.1865650122895414736250237161955013764378855133958e0), SC_(0.83104058496945432609840437913208892628585320296553e-2), 
      SC_(0.28e2), SC_(0.14e2), SC_(-0.5219646453857421875e1), SC_(0.32433712482452392578125e1), SC_(-0.53683080326167826661347790717962342153575534204683e-1), SC_(-0.36534000361326218712600869371457843178984446179199e0), 
      SC_(0.28e2), SC_(0.16e2), SC_(0.503000438213348388671875e0), SC_(-0.231458187103271484375e1), SC_(0.8160256822988137923717617864356537496559291179126e-1), SC_(0.64094222246065219890134215414118365176933409558335e-1), 
      SC_(0.28e2), SC_(0.16e2), SC_(0.3427127361297607421875e1), SC_(0.35153391361236572265625e1), SC_(0.88842414649858727724678507859023456976045310064479e-4), SC_(-0.27798045063355101148605200522196071346933288033418e-4), 
      SC_(0.28e2), SC_(0.18e2), SC_(-0.26192047595977783203125e1), SC_(0.152940261363983154296875e1), SC_(-0.2076220547467651797296012614447245899778479020637e-1), SC_(0.19152325659437762869857948324070336161019583882491e-1), 
      SC_(0.28e2), SC_(0.19e2), SC_(0.3145768642425537109375e1), SC_(-0.6064627170562744140625e0), SC_(-0.88341184376953282584893787413595035721549243557524e-41), SC_(-0.15174070660493520559219146747689439763583330303958e-40), 
      SC_(0.28e2), SC_(0.19e2), SC_(0.5450787067413330078125e1), SC_(-0.191129744052886962890625e1), SC_(0.10172020391842454645010387046398599344839775038625e0), SC_(0.5395643957632813756083582714606347011863207416976e0), 
      SC_(0.28e2), SC_(0.22e2), SC_(-0.13068177700042724609375e1), SC_(0.145541286468505859375e1), SC_(0.23314723486748828438576781341885063296772905905627e-2), SC_(0.16058731833356469601277859955322418946539873329667e-2), 
      SC_(0.28e2), SC_(0.25e2), SC_(0.138050591945648193359375e1), SC_(0.20941126346588134765625e1), SC_(-0.12846379713076890219934659144680944221241334472141e0), SC_(0.22617950598970200061848568141208860634676281592502e0), 
      SC_(0.28e2), SC_(0.25e2), SC_(0.37426455020904541015625e1), SC_(0.446419525146484375e1), SC_(-0.30193414476467530194579451177295867812762250722799e-5), SC_(0.38461599518589484146449693851194411585041267604652e-4), 
      SC_(0.28e2), SC_(0.26e2), SC_(0.338872015476226806640625e0), SC_(-0.2938283443450927734375e1), SC_(0.47180815469628669101312406831788890857752827012654e-11), SC_(-0.73020521348926074040478651522705948652200116908528e-11), 
      SC_(0.28e2), SC_(0.28e2), SC_(0.5292593479156494140625e1), SC_(0.5836107730865478515625e1), SC_(0.46521681564480569204591023639475657415682769495109e-2), SC_(0.22440121774846652185467755015421152029151599618688e-3), 
      SC_(0.29e2), SC_(0), SC_(-0.5304096698760986328125e1), SC_(0.28013269901275634765625e1), SC_(-0.34374558636242491840981443596475176397358553372639e0), SC_(0), 
      SC_(0.29e2), SC_(0.6e1), SC_(-0.96623599529266357421875e0), SC_(-0.160583972930908203125e1), SC_(-0.34554988311283977468421467624627937687834304566326e0), SC_(0.73745426424497457276975129325391083183363013350031e-1), 
      SC_(0.29e2), SC_(0.8e1), SC_(-0.4647654056549072265625e1), SC_(0.587067127227783203125e1), SC_(0.30930236229253840906868604496020677447343005601587e0), SC_(-0.49445352201839267573221621551803070753225218660487e-1), 
      SC_(0.29e2), SC_(0.8e1), SC_(0.392187595367431640625e0), SC_(-0.287519633769989013671875e0), SC_(-0.22783473767664553001722166505582548516999414563321e0), SC_(-0.25491514760415924822989178358055253661292656118935e0), 
      SC_(0.29e2), SC_(0.1e2), SC_(-0.166051280498504638671875e1), SC_(-0.5044215679168701171875e1), SC_(0.19634739869929818957613891900276548175011116302552e0), SC_(-0.35055041111834758499728357411289819921477862124714e-1), 
      SC_(0.29e2), SC_(0.11e2), SC_(-0.4498418331146240234375e1), SC_(0.123935830593109130859375e1), SC_(0.14690621666124024611580070133304967300815386557761e0), SC_(0.26622999350812294628786186427067031828600102198782e0), 
      SC_(0.29e2), SC_(0.12e2), SC_(-0.74578392505645751953125e0), SC_(0.1655825138092041015625e1), SC_(0.99888331464138590380937139151776111267389823372577e-1), SC_(0.16275738178735920210750975726264147081416847520487e0), 
      SC_(0.29e2), SC_(0.13e2), SC_(-0.529826259613037109375e1), SC_(-0.618491268157958984375e1), SC_(0.98979467435598604095409774985421677956362899621551e-1), SC_(0.3277921220729318025300220870512544670763508502924e0), 
      SC_(0.29e2), SC_(0.13e2), SC_(-0.3128500461578369140625e1), SC_(-0.37050945758819580078125e1), SC_(-0.58125775526763659448326852916865612752038485720042e-19), SC_(0.99556742336446969687933404146584340963719811016785e-19), 
      SC_(0.29e2), SC_(0.14e2), SC_(-0.2293616771697998046875e1), SC_(-0.4944765567779541015625e1), SC_(-0.26456752409113754642102156002114073206323731200161e0), SC_(0.29670242313018655704198158459070860453944419639195e-1), 
      SC_(0.29e2), SC_(0.24e2), SC_(-0.20265896320343017578125e1), SC_(-0.3549204349517822265625e1), SC_(0.38829064186143240079963069303110733448851686796105e0), SC_(-0.14522471521789769613757985193418678616393961928275e0), 
      SC_(0.29e2), SC_(0.26e2), SC_(-0.6074800968170166015625e1), SC_(-0.38170487880706787109375e1), SC_(0.49134464663501283579362404490172972856511176968503e-16), SC_(0.16889713007060117605648674492926732435423618839529e-15), 
      SC_(0.29e2), SC_(0.26e2), SC_(-0.4693541049957275390625e1), SC_(0.21117798984050750732421875e0), SC_(0.84636753168273078124026193887830210701304344868755e-1), SC_(-0.85857411297063483265530066555493102413552722402254e-1), 
      SC_(0.3e2), SC_(0.1e1), SC_(0.108653104305267333984375e1), SC_(-0.43433170318603515625e1), SC_(0.98908915427691374021854029902073080488614986744833e-1), SC_(-0.25571346682500308908732440427042813790112955761028e0), 
      SC_(0.3e2), SC_(0.4e1), SC_(0.472572624683380126953125e0), SC_(-0.4141473293304443359375e1), SC_(-0.15490927214237789860573453940991420883686046939352e-3), SC_(0.17918424051917089574886831374610565150993696722213e-3), 
      SC_(0.3e2), SC_(0.5e1), SC_(0.13224494457244873046875e1), SC_(0.3243536472320556640625e1), SC_(0.26365491798605679927313677444286415933345142724669e0), SC_(0.14738045644608160308680420470804357761454397482851e0), 
      SC_(0.3e2), SC_(0.5e1), SC_(0.15393459796905517578125e1), SC_(0.41063690185546875e1), SC_(0.28934839933299968852244268798704520786922646850272e-1), SC_(-0.25844571107395323915222897537162027108332006584997e0), 
      SC_(0.3e2), SC_(0.12e2), SC_(-0.5311216831207275390625e1), SC_(0.44351177215576171875e1), SC_(-0.23641395480393837093083525215186198584158911542983e0), SC_(0.44404587772637704032010827773777202965024463317766e-1), 
      SC_(0.3e2), SC_(0.12e2), SC_(0.293827056884765625e1), SC_(0.23315105438232421875e1), SC_(-0.12265538183565026657215522947660764910548872080846e-2), SC_(0.37432649161076190722582863270078347981029707060705e-3), 
      SC_(0.3e2), SC_(0.14e2), SC_(0.443767642974853515625e1), SC_(-0.3618727207183837890625e1), SC_(0.13416211019590894407587077090408767671949275644819e0), SC_(-0.56201434447065499982940764627223367392418609084618e-1), 
      SC_(0.3e2), SC_(0.17e2), SC_(-0.122919237613677978515625e1), SC_(0.294741058349609375e1), SC_(0.2710266860063696014647030831454921329441436090915e0), SC_(-0.43599814745099186350165299725161120139330177424029e-1), 
      SC_(0.3e2), SC_(0.17e2), SC_(0.466351985931396484375e1), SC_(0.149558103084564208984375e1), SC_(-0.31636708231385235084218926963010486936015783483521e0), SC_(-0.95144491774198646174163906099598653984767353757822e-1), 
      SC_(0.3e2), SC_(0.18e2), SC_(-0.30436723232269287109375e1), SC_(-0.4174770832061767578125e1), SC_(0.12643784992924183233372017293751865365024150662377e-12), SC_(0.32601401658620691910357150247267165864754583834782e-13), 
      SC_(0.3e2), SC_(0.2e2), SC_(-0.149106013774871826171875e1), SC_(0.533106327056884765625e1), SC_(0.94374993459508192098714618955183548094519223880307e-1), SC_(-0.18432664742629340915258888435711247976010709923588e-1), 
      SC_(0.3e2), SC_(0.2e2), SC_(0.2313419342041015625e1), SC_(0.428986644744873046875e1), SC_(-0.29318407317941253439456421046760337007834035136883e0), SC_(-0.43180987318052629517936366896354388606808306111249e0), 
      SC_(0.3e2), SC_(0.2e2), SC_(0.36214644908905029296875e1), SC_(0.6067486286163330078125e1), SC_(-0.13138782640381106925001979961496931082228340481569e-2), SC_(0.31214547947555042809850196174813718560611575919433e-2), 
      SC_(0.3e2), SC_(0.2e2), SC_(0.526058673858642578125e1), SC_(-0.419460964202880859375e1), SC_(0.22582511508808987293935165209714110995770925672756e0), SC_(0.30331458249938896042218753312621592377727002507949e0), 
      SC_(0.3e2), SC_(0.22e2), SC_(-0.60458240509033203125e1), SC_(-0.5353339672088623046875e1), SC_(-0.85930465999490298964029892818202201788221540684003e-11), SC_(0.23693444365551066509449536762109818344241577450133e-9), 
      SC_(0.3e2), SC_(0.23e2), SC_(0.726197540760040283203125e0), SC_(0.403766345977783203125e1), SC_(-0.12755301400432633854627948582649036572442590418343e-1), SC_(0.66583164428055150562962447740111911222958448004406e-1), 
      SC_(0.3e2), SC_(0.24e2), SC_(-0.25868046283721923828125e1), SC_(-0.227922725677490234375e1), SC_(-0.72119753571211453912771025379536109079711921094975e-4), SC_(0.2542298502060570309079242448277729880888534881731e-3), 
      SC_(0.3e2), SC_(0.28e2), SC_(0.22341783344745635986328125e0), SC_(0.25537784099578857421875e1), SC_(-0.95687897152591358569962065530998323869356081255145e-17), SC_(0.89291963429434019882895832664397638007407748168944e-17), 
      SC_(0.3e2), SC_(0.29e2), SC_(0.603563213348388671875e1), SC_(0.2597660064697265625e1), SC_(0.10250703048349278067860993003576285045796698426188e-16), SC_(-0.67837273874377012468166466639778833478711594798685e-18), 
      SC_(0.3e2), SC_(0.3e2), SC_(0.700423657894134521484375e0), SC_(-0.584097194671630859375e1), SC_(0.10225347297727285748147276144679087091036780392267e-5), SC_(0.86132191079023610794410642400064244383036224295423e-6), 
      SC_(0.31e2), SC_(0.1e1), SC_(0.928564608097076416015625e0), SC_(0.417735576629638671875e1), SC_(-0.35856471993436608867144962448511819760284009045171e-1), SC_(-0.60497017410155836932330444710434133998091026314078e-1), 
      SC_(0.31e2), SC_(0.4e1), SC_(-0.887741386890411376953125e0), SC_(-0.6742284297943115234375e0), SC_(0.20632124174114237674527171624409443912851954465212e0), SC_(0.98313956344915999174986124429304689389305827770677e-1), 
      SC_(0.31e2), SC_(0.6e1), SC_(0.574202632904052734375e1), SC_(0.8840157985687255859375e0), SC_(0.15014761214172592376774588930797627043755053007961e-1), SC_(-0.22342430241520771147086566449242736798618992453359e-1), 
      SC_(0.31e2), SC_(0.7e1), SC_(-0.26366097927093505859375e1), SC_(0.60937328338623046875e1), SC_(0.88100929919455699024943768244623121474006888309583e-1), SC_(-0.35292812879977250086898036419500987291149514768436e0), 
      SC_(0.31e2), SC_(0.7e1), SC_(0.5836645603179931640625e1), SC_(-0.5976138591766357421875e1), SC_(0.19773015637170180297598234705690105393055744540095e0), SC_(-0.30277002522631753679887090680190060645139097536884e0), 
      SC_(0.31e2), SC_(0.9e1), SC_(0.122509801387786865234375e1), SC_(-0.5586736202239990234375e1), SC_(-0.1835447283739527910995916592028911308510444396965e0), SC_(0.27796968823091213806899083435678729593065511355864e-2), 
      SC_(0.31e2), SC_(0.11e2), SC_(0.2281555652618408203125e1), SC_(-0.3464831411838531494140625e0), SC_(-0.76015958003905388816378493978324545073261884273619e-1), SC_(0.60189558647728381716256649564051005049859811088047e-1), 
      SC_(0.31e2), SC_(0.11e2), SC_(0.30240728855133056640625e1), SC_(0.364751160144805908203125e0), SC_(0.19007877531794893239833867085756272355433916433928e-4), SC_(0.22561167353088321464358503856127270569862042419864e-4), 
      SC_(0.31e2), SC_(0.15e2), SC_(0.43375396728515625e0), SC_(-0.49521503448486328125e1), SC_(-0.70571879121713793717386306046974511953543544128478e-1), SC_(-0.14431187238624056529651612550423943245255662753848e0), 
      SC_(0.31e2), SC_(0.15e2), SC_(0.5296014308929443359375e1), SC_(-0.95083713531494140625e0), SC_(0.47556336605805756159571160383412358532090715801204e-1), SC_(0.37727732638798349717419619252929853830563849819192e0), 
      SC_(0.31e2), SC_(0.16e2), SC_(0.754196941852569580078125e-1), SC_(0.32588040828704833984375e1), SC_(-0.22129354866106521104204765138927535620136724225795e-12), SC_(0.70392963582410131758551153918170650770375736041396e-12), 
      SC_(0.31e2), SC_(0.18e2), SC_(-0.59573972225189208984375e0), SC_(0.1748990535736083984375e1), SC_(0.34417602662724970168877896701132509066340952614395e0), SC_(0.22715164805922997821149208687693807263713770929382e-1), 
      SC_(0.31e2), SC_(0.2e2), SC_(-0.33932993412017822265625e1), SC_(0.193132722377777099609375e1), SC_(-0.56356320947342473851511443112692598635687060727182e-7), SC_(-0.75163276800677556476147633584861632899696159210293e-7), 
      SC_(0.31e2), SC_(0.21e2), SC_(0.6030786991119384765625e1), SC_(-0.25230128765106201171875e1), SC_(-0.13498810396910162090134252881631307336594753214304e-7), SC_(-0.6089904624285230873015003167598944182671966579842e-8), 
      SC_(0.31e2), SC_(0.23e2), SC_(-0.5045162200927734375e1), SC_(-0.4549957752227783203125e1), SC_(0.17188598027762318906496398169666579485097946256704e0), SC_(-0.25432990204876614368801654107373858183287092141351e0), 
      SC_(0.31e2), SC_(0.26e2), SC_(-0.326124477386474609375e1), SC_(-0.558091640472412109375e1), SC_(-0.12122240462108415172663806743757572570401894532422e-20), SC_(0.81264283011069600354257445218059504436818433612651e-21), 
      SC_(0.31e2), SC_(0.27e2), SC_(-0.2207580089569091796875e1), SC_(-0.176423919200897216796875e1), SC_(-0.11681787764663391959627013716270259778551463854622e0), SC_(0.65430297163720305249962671261535705948040912842563e-1), 
      SC_(0.31e2), SC_(0.27e2), SC_(0.3325610637664794921875e1), SC_(-0.529215872287750244140625e0), SC_(-0.81986339461444704131072732038440779644507649468355e-18), SC_(-0.536436196208583508887279168894720922285530130249e-17), 
      SC_(0.31e2), SC_(0.29e2), SC_(-0.21260488033294677734375e1), SC_(-0.3617063999176025390625e1), SC_(-0.24601271411846658246464210063697569222669417594421e-1), SC_(0.67711064411241211167026732009031006833426141744155e-1), 
      SC_(0.31e2), SC_(0.3e2), SC_(0.73286068439483642578125e0), SC_(0.65784461796283721923828125e-1), SC_(-0.94487608256439867034529038228650922819649862573855e-5), SC_(0.22178948686460061070866490389104853268567019025408e-4), 
      SC_(0.32e2), SC_(0), SC_(0.20807661116123199462890625e0), SC_(-0.4968012332916259765625e1), SC_(0.66298344664836888730906564539274631055366541342095e0), SC_(0), 
      SC_(0.32e2), SC_(0.2e1), SC_(-0.21638844013214111328125e1), SC_(-0.106696796417236328125e1), SC_(0.1730373585499837778959174314297306708773493756511e0), SC_(0.27408305067680561166146537720059053177935425786118e0), 
      SC_(0.32e2), SC_(0.2e1), SC_(-0.55312104523181915283203125e-1), SC_(0.22586028575897216796875e1), SC_(-0.13470871325174836931206542661564999567351283863348e0), SC_(-0.68137864605410005585866049296418931158030610598288e0), 
      SC_(0.32e2), SC_(0.2e1), SC_(0.583700954914093017578125e0), SC_(-0.26306140422821044921875e1), SC_(-0.18798579627145320272320328081177975023893948646504e0), SC_(-0.30741292998911942466794911069091516832135850261479e0), 
      SC_(0.32e2), SC_(0.3e1), SC_(-0.4228428363800048828125e1), SC_(0.13026702404022216796875e1), SC_(-0.12243694649079274631858229100552657599390134539447e-1), SC_(-0.11787525019271484573107500985123810109931588532403e-1), 
      SC_(0.32e2), SC_(0.3e1), SC_(0.498306751251220703125e1), SC_(0.5436382770538330078125e1), SC_(-0.16540897059115030171859712666542047676962096767732e0), SC_(-0.11345036003534882596646154596508932481909780901634e0), 
      SC_(0.32e2), SC_(0.4e1), SC_(-0.58237209320068359375e1), SC_(-0.3628082752227783203125e1), SC_(0.86078901831272428064191837205688710062259082154164e-1), SC_(0.21857640376476717078248483234444535372452049724628e0), 
      SC_(0.32e2), SC_(0.6e1), SC_(-0.401196765899658203125e1), SC_(0.568090617656707763671875e0), SC_(-0.34002714397528148300121722244505024953616293767765e0), SC_(-0.92990083105225573294865377146019481047624587912796e-1), 
      SC_(0.32e2), SC_(0.7e1), SC_(0.532406520843505859375e1), SC_(-0.458774089813232421875e1), SC_(0.13078729987539274708760014110228524034154847172216e0), SC_(-0.10977211710600889159192149001437128324287154964944e0), 
      SC_(0.32e2), SC_(0.1e2), SC_(-0.5482160091400146484375e1), SC_(0.4956043243408203125e1), SC_(0.23847303389160211087345366200999697249841756380708e-1), SC_(-0.2029305580166500753097395160160460571514400800365e-1), 
      SC_(0.32e2), SC_(0.11e2), SC_(-0.4877975940704345703125e1), SC_(-0.2188639163970947265625e1), SC_(0.15251141369148101078768720197443589036409281851311e0), SC_(0.27069004053143028430587769027179087821604416294607e0), 
      SC_(0.32e2), SC_(0.16e2), SC_(-0.113722121715545654296875e1), SC_(0.3124237060546875e1), SC_(0.31837895806810353833281101206368208313315354423414e0), SC_(-0.90755329400809358691070463890653118785195245845093e-1), 
      SC_(0.32e2), SC_(0.19e2), SC_(-0.5408166408538818359375e1), SC_(-0.6025125026702880859375e1), SC_(0.85155456270057723665669575832960967457597060014359e-1), SC_(-0.44098172375387438748618298920157495817981560575925e0), 
      SC_(0.32e2), SC_(0.2e2), SC_(0.5691125392913818359375e1), SC_(0.3702780246734619140625e1), SC_(0.33245985289150069105210127177798999622998108646666e-1), SC_(-0.14316476282533068534636754351884877495171531101195e0), 
      SC_(0.32e2), SC_(0.24e2), SC_(0.972564160823822021484375e0), SC_(-0.32377068996429443359375e1), SC_(-0.28185916132339390017243206695609352756821265839239e0), SC_(-0.31121199496397838396016529951689443317449664266775e0), 
      SC_(0.32e2), SC_(0.25e2), SC_(-0.50359554290771484375e1), SC_(-0.4353111743927001953125e1), SC_(-0.4781367583226849216630168603430725206713112725752e-1), SC_(-0.1008167405799027782331509877467511332697585292248e0), 
      SC_(0.32e2), SC_(0.25e2), SC_(0.2882596492767333984375e1), SC_(-0.40839481353759765625e1), SC_(0.47171108449629706646618445156309169154829662633038e-13), SC_(-0.15426148860991650127193778562440220393503927928497e-10), 
      SC_(0.32e2), SC_(0.25e2), SC_(0.569830989837646484375e1), SC_(0.2081862926483154296875e1), SC_(-0.21358219126146379037755730870891179414407721000697e-3), SC_(0.10006182997472336160963499928607568710188406974034e-2), 
      SC_(0.32e2), SC_(0.31e2), SC_(-0.47728710174560546875e1), SC_(-0.13419498503208160400390625e0), SC_(0.17184574657361548198477627647756338994710221518522e0), SC_(-0.27881847562946397601936836610840150784354405653775e0), 
      SC_(0.32e2), SC_(0.32e2), SC_(-0.4227705478668212890625e1), SC_(0.20169875621795654296875e1), SC_(-0.20065917919227948858373005166952369187742945080701e-2), SC_(0.14141530837330922160597003865134200637914586765046e-1), 
      SC_(0.33e2), SC_(0.2e1), SC_(-0.10280778408050537109375e1), SC_(-0.141691577434539794921875e1), SC_(-0.21199357173846927861721140231231265818161126743439e0), SC_(-0.67384412952686462902002371937140117905926739951661e-1), 
      SC_(0.33e2), SC_(0.2e1), SC_(0.31660518646240234375e1), SC_(0.787688791751861572265625e0), SC_(0.83828966680565351932168328367169458083111452155676e-3), SC_(-0.18298118953521029694312837066798829728000009448976e0), 
      SC_(0.33e2), SC_(0.3e1), SC_(-0.4496408939361572265625e1), SC_(-0.3676222264766693115234375e0), SC_(0.8778676115933738229214513638612855099604101209253e-1), SC_(-0.17370993939992492669197863127541840669829602569981e0), 
      SC_(0.33e2), SC_(0.3e1), SC_(0.5052531719207763671875e1), SC_(-0.30459156036376953125e1), SC_(0.10891764351810655565058983711643382330383084583511e0), SC_(0.32150572743612381036346830098927258093240505765618e-1), 
      SC_(0.33e2), SC_(0.7e1), SC_(0.22033364772796630859375e1), SC_(-0.991332709789276123046875e0), SC_(-0.65078932551511285239653440619719552424121247998126e-1), SC_(0.50107144042480366535275176403238050525103908606693e-1), 
      SC_(0.33e2), SC_(0.11e2), SC_(0.33593618869781494140625e1), SC_(0.801525056362152099609375e0), SC_(-0.19331012906111682628733926104032195676875292205561e-1), SC_(0.13453409021982401163248455038152669836236852959845e-1), 
      SC_(0.33e2), SC_(0.11e2), SC_(0.5271373748779296875e1), SC_(0.164856636524200439453125e1), SC_(-0.76189744315738311831420746763593292761815174567881e-1), SC_(0.66196085450301076004049363610755534745383550957475e-1), 
      SC_(0.33e2), SC_(0.12e2), SC_(-0.6052063465118408203125e1), SC_(0.70831857621669769287109375e-1), SC_(0.87666432557664212122835069239425792690058563707377e-2), SC_(0.99790004000008412448133243600221248292580960270107e-2), 
      SC_(0.33e2), SC_(0.13e2), SC_(-0.187066686153411865234375e1), SC_(-0.5476586818695068359375e1), SC_(0.16323322590296355006984330973714002298047552591084e0), SC_(0.2919632765818747886808075054035883027514958625827e0), 
      SC_(0.33e2), SC_(0.14e2), SC_(0.6282451152801513671875e1), SC_(-0.704167187213897705078125e0), SC_(-0.28264715727426954730240390130033997384913600198657e-37), SC_(0.13084870462628237297082358706020472224447204851218e-37), 
      SC_(0.33e2), SC_(0.15e2), SC_(0.429217052459716796875e1), SC_(0.5220873355865478515625e1), SC_(0.34663658839570367684920973218779144297265382881659e0), SC_(-0.79962812545695387926501798552405211936151318335177e-1), 
      SC_(0.33e2), SC_(0.16e2), SC_(-0.77481329441070556640625e0), SC_(-0.16290705204010009765625e1), SC_(-0.10857313604670246578131980278415622538736879035396e0), SC_(0.14631036245722678657366426789769020203067076071433e0), 
      SC_(0.33e2), SC_(0.17e2), SC_(-0.39697129726409912109375e1), SC_(0.893506467342376708984375e0), SC_(-0.42327819382014604870435782055652942153178405302822e-1), SC_(0.2414283096289504477817521242893263417602295779535e-1), 
      SC_(0.33e2), SC_(0.19e2), SC_(-0.4060759067535400390625e1), SC_(-0.603465747833251953125e1), SC_(-0.19335111727331654212434524796913528239767518465687e-3), SC_(0.20057031870730384770811394001766285555334118787843e-1), 
      SC_(0.33e2), SC_(0.19e2), SC_(0.3632605075836181640625e1), SC_(-0.125561869144439697265625e1), SC_(0.16606436767628517593082402186229100905795788666483e-1), SC_(0.54687790415583995321124918425096138535972202573216e-1), 
      SC_(0.33e2), SC_(0.21e2), SC_(0.6058349132537841796875e1), SC_(0.89253747463226318359375e0), SC_(0.65661919271919274660834187104787488584165856454498e-8), SC_(-0.70042097596150469255807440858988819548237459531012e-9), 
      SC_(0.33e2), SC_(0.25e2), SC_(0.178518903255462646484375e1), SC_(0.163600885868072509765625e1), SC_(0.10285838902352309449698368199635806926573134984729e-1), SC_(0.61290583254192849619309147980259868149640987587218e-3), 
      SC_(0.33e2), SC_(0.25e2), SC_(0.39727337360382080078125e1), SC_(-0.20406267642974853515625e1), SC_(0.24817825824443781586887155432178279748389272206498e0), SC_(-0.23128852631109200782059759358494316866754795288222e0), 
      SC_(0.33e2), SC_(0.27e2), SC_(-0.55289669036865234375e1), SC_(0.16090323925018310546875e1), SC_(-0.19374904506881111846630703710192247220468580836629e-1), SC_(0.11572386296762929201845051641664803052227979311569e-1), 
      SC_(0.33e2), SC_(0.29e2), SC_(-0.19202787876129150390625e1), SC_(0.27044403553009033203125e1), SC_(-0.36528717935641733540863033540170376656373584600122e0), SC_(0.40731253115425075582880994936585949230771316852815e-1), 
      SC_(0.33e2), SC_(0.29e2), SC_(-0.182119834423065185546875e1), SC_(0.4119784832000732421875e1), SC_(-0.28379244934656280866214380765083155949566246107236e0), SC_(-0.265375535348017689943232823805827261162124246222e-1), 
      SC_(0.33e2), SC_(0.29e2), SC_(0.1915756702423095703125e1), SC_(0.182224595546722412109375e1), SC_(0.29019140898839473027547321559129655992737941569612e0), SC_(-0.18272155461874450914250644537446209771725174793041e0), 
      SC_(0.33e2), SC_(0.29e2), SC_(0.4933666706085205078125e1), SC_(-0.137272417545318603515625e1), SC_(0.21439774977906306496796774311686224277178027213006e0), SC_(0.35840642564789112835440912112605173002719929566325e0), 
      SC_(0.33e2), SC_(0.29e2), SC_(0.5323255062103271484375e1), SC_(-0.3466163158416748046875e1), SC_(0.14809013294088358823162198182939843441477089914292e0), SC_(0.18117244800140409658540127036860536618878261958792e-2), 
      SC_(0.33e2), SC_(0.31e2), SC_(0.170477139949798583984375e1), SC_(-0.137854945659637451171875e1), SC_(-0.1977141308864077034293892252243671403797001727324e-1), SC_(-0.58963829533132044436078908352660614461994207146641e-1), 
      SC_(0.33e2), SC_(0.31e2), SC_(0.20581443309783935546875e1), SC_(0.39526233673095703125e1), SC_(0.14703061785490068036808594608634500040037117041804e0), SC_(0.13543221180469735067915161091800474057406870844807e-2), 
      SC_(0.34e2), SC_(0.1e1), SC_(-0.2188931941986083984375e1), SC_(-0.191715514659881591796875e1), SC_(0.74648429187024477561430282029766499552096205544695e-1), SC_(0.20683529203034600863507770317585540157270626781474e0), 
      SC_(0.34e2), SC_(0.2e1), SC_(-0.71949017047882080078125e0), SC_(-0.5441914081573486328125e1), SC_(0.22412955231582108996746639938127249053867311156486e-1), SC_(-0.19973476426760867358722786056037002132862660666356e0), 
      SC_(0.34e2), SC_(0.5e1), SC_(-0.121777820587158203125e1), SC_(0.61085662841796875e1), SC_(-0.10553903941424644179118832121057917709107689882198e0), SC_(0.12588654721669852277934862443869250658563060560821e0), 
      SC_(0.34e2), SC_(0.7e1), SC_(0.30894107818603515625e1), SC_(0.35562279224395751953125e1), SC_(0.18641041510024639502252334130105107209287395555361e-3), SC_(-0.45449004191754781407370168701778529300136575099457e-4), 
      SC_(0.34e2), SC_(0.8e1), SC_(-0.6011126041412353515625e1), SC_(0.5419887065887451171875e1), SC_(0.60994914441104821837759997789223220623267125077273e0), SC_(-0.43840214384266110255519390517303780761802145422775e0), 
      SC_(0.34e2), SC_(0.9e1), SC_(-0.62173640727996826171875e0), SC_(-0.14664161205291748046875e1), SC_(-0.12294641941962225696079801149613521538475085881115e0), SC_(0.89901125793120174279904411318392431036704861349601e-1), 
      SC_(0.34e2), SC_(0.1e2), SC_(0.3278270721435546875e1), SC_(-0.40134868621826171875e1), SC_(-0.13704591391677795281047775027000968317056208570957e-2), SC_(-0.11680613863702510563648914712059656500356295502456e-2), 
      SC_(0.34e2), SC_(0.11e2), SC_(-0.205713176727294921875e1), SC_(-0.2949050426483154296875e1), SC_(-0.21616286304576857177427534953488466838105391999285e-1), SC_(0.3548215866206954765658732155903069088884062317148e-1), 
      SC_(0.34e2), SC_(0.11e2), SC_(0.147377431392669677734375e1), SC_(-0.4987617969512939453125e1), SC_(0.11512174832480081763915981239777491773305624587235e-2), SC_(-0.10048055596871303011680340653458917357004876937073e-1), 
      SC_(0.34e2), SC_(0.12e2), SC_(-0.5183623790740966796875e1), SC_(-0.478307342529296875e1), SC_(0.19830504045557048270215072167674339387017285629336e0), SC_(-0.2249253534751446118481456151969598698150770681191e0), 
      SC_(0.34e2), SC_(0.13e2), SC_(-0.17067182064056396484375e0), SC_(0.16002833843231201171875e1), SC_(-0.69970950610382171636908927657545058386162497676311e-4), SC_(0.1735041450185279822280565167940069281542584419891e-3), 
      SC_(0.34e2), SC_(0.13e2), SC_(0.379619312286376953125e1), SC_(0.3765476226806640625e1), SC_(-0.56296816567933203625217695968330184425299752947632e-2), SC_(0.21464192912326494430844934287639334145161986998958e-1), 
      SC_(0.34e2), SC_(0.14e2), SC_(0.201837062835693359375e1), SC_(-0.2973775386810302734375e1), SC_(-0.30602319213657541561387676330539096853430197003561e-1), SC_(0.3101843541474430125775501368221380601692868249897e-1), 
      SC_(0.34e2), SC_(0.17e2), SC_(-0.572339153289794921875e1), SC_(0.37769315242767333984375e1), SC_(-0.11482449549795715541665138029012133310225512950648e0), SC_(-0.58193193669712556825407770368449154350883331795453e0), 
      SC_(0.34e2), SC_(0.17e2), SC_(-0.23615055084228515625e1), SC_(-0.15888440608978271484375e1), SC_(-0.81701010555781934871874201404533038019079117065051e-1), SC_(-0.25788207870721930877984579776283099772843234559003e0), 
      SC_(0.34e2), SC_(0.17e2), SC_(0.178838884830474853515625e1), SC_(-0.518894100189208984375e1), SC_(0.77860126506645035871033610549261042083199407374962e-1), SC_(-0.19665688045513046305140827759237637312114795583158e-1), 
      SC_(0.34e2), SC_(0.18e2), SC_(-0.34216616153717041015625e1), SC_(-0.4451731204986572265625e1), SC_(0.2018250124842600992070972826092525919583422015107e-5), SC_(0.98202528575873328904595294177587194802271010326078e-4), 
      SC_(0.34e2), SC_(0.22e2), SC_(0.5335441112518310546875e1), SC_(-0.48849849700927734375e1), SC_(-0.35457995819358863070775990515577215744194271828492e0), SC_(0.2726542090502517592749072144971434560486725387608e0), 
      SC_(0.34e2), SC_(0.25e2), SC_(-0.5717056751251220703125e1), SC_(-0.2651668071746826171875e1), SC_(0.23231054747886190818217635895909590845802850349194e-2), SC_(-0.76535888310941153967539156375933485514543623650535e-3), 
      SC_(0.34e2), SC_(0.27e2), SC_(-0.5267404079437255859375e1), SC_(-0.607725203037261962890625e0), SC_(0.40178772095461132746981289438498237079704488396183e0), SC_(-0.33884527410380240935777884395196342685193422622907e0), 
      SC_(0.34e2), SC_(0.27e2), SC_(0.56536662578582763671875e0), SC_(0.37764084339141845703125e0), SC_(0.14482030760668204445837408492449818262868607752451e-3), SC_(0.14085675470049277776015006423447607403857692588278e-3), 
      SC_(0.34e2), SC_(0.3e2), SC_(-0.5906295299530029296875e1), SC_(-0.96199953556060791015625e0), SC_(-0.34766719496984776597465210065708393620110992296361e-10), SC_(0.2305996270469727378901602626559999771539322611368e-10), 
      SC_(0.34e2), SC_(0.31e2), SC_(-0.28265569210052490234375e1), SC_(0.21103322505950927734375e1), SC_(0.19037921950282100528451185671424238253882106530834e-13), SC_(-0.1175481467000614047356892390731542939385721039979e-13), 
      SC_(0.35e2), SC_(0.3e1), SC_(-0.6175082683563232421875e1), SC_(0.552494335174560546875e1), SC_(0.64762661721897286914407043438944796290733340830337e0), SC_(0.76278587040835558544493433474647829686025098006925e0), 
      SC_(0.35e2), SC_(0.6e1), SC_(0.3778275012969970703125e1), SC_(0.4842569828033447265625e1), SC_(0.26069400829564138472332830963452099519571850583881e0), SC_(0.25845486508349986513227757891492984177186166771467e0), 
      SC_(0.35e2), SC_(0.9e1), SC_(-0.493931674957275390625e1), SC_(-0.76453101634979248046875e0), SC_(0.17611300450297471655861377670143539666985254732432e-1), SC_(-0.11986431777207887659385788646195950178871750130696e-1), 
      SC_(0.35e2), SC_(0.11e2), SC_(0.5599313259124755859375e1), SC_(-0.13019330501556396484375e1), SC_(0.39306541370272934098647438084027145948462323623321e-1), SC_(0.21109286765620662127686926497444274161829510098599e0), 
      SC_(0.35e2), SC_(0.13e2), SC_(-0.3546209812164306640625e1), SC_(-0.5493760585784912109375e1), SC_(0.41140800695038474583623391400282317112025844394376e0), SC_(0.45690144435133473719116479983271298258798212805798e0), 
      SC_(0.35e2), SC_(0.13e2), SC_(0.55216426849365234375e1), SC_(0.40094776153564453125e1), SC_(0.65650245913257757935984854111888614427215698375688e-1), SC_(-0.22248838661680016523461200549762726853057751155267e0), 
      SC_(0.35e2), SC_(0.16e2), SC_(-0.26905200481414794921875e1), SC_(0.2040550708770751953125e1), SC_(-0.11410042867695768603335761210976964148910739151645e0), SC_(-0.32471276367906056287942215778218085529932955432059e0), 
      SC_(0.35e2), SC_(0.16e2), SC_(0.5014043331146240234375e1), SC_(0.61833057403564453125e1), SC_(-0.92628609322787250637744218627217798387397258942743e-3), SC_(-0.33950401545537407458127438621038123686600693271351e-1), 
      SC_(0.35e2), SC_(0.19e2), SC_(-0.2948562145233154296875e1), SC_(0.23101842403411865234375e1), SC_(0.61054606689296446102355449253333377374709815786486e-7), SC_(-0.54357346336593357491525011939182468075349764344657e-8), 
      SC_(0.35e2), SC_(0.19e2), SC_(-0.182896327972412109375e1), SC_(0.48633632659912109375e1), SC_(-0.13891158994925192872562838520451890709693704690757e-1), SC_(-0.49597428243820487984069474178404450499221616673685e-1), 
      SC_(0.35e2), SC_(0.25e2), SC_(0.3565537929534912109375e1), SC_(0.2607357025146484375e1), SC_(-0.11510203219569123647879133930562022919644316425375e-4), SC_(0.11605485085172380895845985292226655593817805360139e-4), 
      SC_(0.35e2), SC_(0.26e2), SC_(-0.5752410888671875e1), SC_(-0.45506725311279296875e1), SC_(0.2147731130313168954969967501315098314949861144624e-3), SC_(0.38598875598314903959033484143427104468466924065902e-3), 
      SC_(0.35e2), SC_(0.27e2), SC_(0.23241953551769256591796875e0), SC_(0.608651447296142578125e1), SC_(-0.12145006444031333088222083595802041635330588416337e-12), SC_(-0.17839314516843793734566875676149759876096506462614e-12), 
      SC_(0.35e2), SC_(0.27e2), SC_(0.3353102207183837890625e1), SC_(0.644649028778076171875e0), SC_(0.23293397144205718343095219616719055681533534205889e-14), SC_(-0.18276846375932362442421251992692060819005093672218e-13), 
      SC_(0.35e2), SC_(0.28e2), SC_(-0.148924577236175537109375e1), SC_(-0.5757661342620849609375e1), SC_(0.21771116952108476216566724234477798671110879927765e0), SC_(-0.33411424655576977010169522968144926649093725138912e0), 
      SC_(0.35e2), SC_(0.32e2), SC_(-0.3214913845062255859375e1), SC_(-0.566165637969970703125e1), SC_(-0.38983003305026869249082783272384743339651875210725e-34), SC_(-0.66316242242111015091959302816507433257724152502068e-34), 
      SC_(0.35e2), SC_(0.32e2), SC_(-0.12234590053558349609375e1), SC_(0.613618755340576171875e1), SC_(-0.49823989819244344298672232477081032502243492034449e-2), SC_(0.58886216218274013551747326518985147414028389639693e0), 
      SC_(0.35e2), SC_(0.35e2), SC_(0.3947638034820556640625e1), SC_(0.2264188289642333984375e1), SC_(-0.61016549653640153707452484713311968722816165008185e-5), SC_(-0.52104135104164816670829307399702509954801233110894e-5), 
      SC_(0.36e2), SC_(0.1e1), SC_(0.21743738651275634765625e1), SC_(0.4273143768310546875e1), SC_(-0.48264438420531041154138719748558547250544006921034e-2), SC_(-0.1027211589826428954508318432836077772278057490027e-1), 
      SC_(0.36e2), SC_(0.3e1), SC_(0.105017936229705810546875e1), SC_(0.9703075885772705078125e0), SC_(0.28023414023822310580330273812051655850887744019713e-1), SC_(-0.65813012076094990648189571910583081697746235900808e-2), 
      SC_(0.36e2), SC_(0.4e1), SC_(-0.569321155548095703125e0), SC_(0.2670110225677490234375e1), SC_(-0.11803637756901604534884368018564903072556303568166e-1), SC_(-0.36207811251658199088821921427158991402743840081632e-1), 
      SC_(0.36e2), SC_(0.5e1), SC_(-0.93527507781982421875e0), SC_(-0.35470836162567138671875e1), SC_(0.12856779089854493417126264230632227872523760325072e0), SC_(0.26169223011336727467266527601280179200222323411493e0), 
      SC_(0.36e2), SC_(0.8e1), SC_(0.349933624267578125e0), SC_(-0.237740230560302734375e1), SC_(-0.2046411806384792179939632417947530204382228090946e0), SC_(0.35056962261399772756804027654658133759034166311288e-1), 
      SC_(0.36e2), SC_(0.8e1), SC_(0.6177388668060302734375e1), SC_(-0.18279759883880615234375e1), SC_(-0.33405446563805483282662924358124090764569138739511e-2), SC_(-0.63138605584201364702579666904100967104480109266963e-2), 
      SC_(0.36e2), SC_(0.1e2), SC_(0.37946469783782958984375e1), SC_(-0.52452945709228515625e1), SC_(0.24260398291328944288145139643428076348208156865878e0), SC_(0.34223122061161569086943772129172956133861724761331e0), 
      SC_(0.36e2), SC_(0.11e2), SC_(-0.4704163074493408203125e1), SC_(-0.34106485843658447265625e1), SC_(0.90540303783993150467870442159489450654975000095926e-1), SC_(0.16660607413992855229762074909459792717465675304504e-1), 
      SC_(0.36e2), SC_(0.12e2), SC_(0.35546753406524658203125e1), SC_(0.565371227264404296875e1), SC_(0.18316156423729799461879537118973337088638257769457e0), SC_(-0.59147203843269717362931073514970634642013456697092e0), 
      SC_(0.36e2), SC_(0.13e2), SC_(0.592201328277587890625e1), SC_(-0.32812511920928955078125e0), SC_(-0.19221546392698773279681789373377641644372404904744e0), SC_(0.40122771978321226012148696247896983764497883097323e0), 
      SC_(0.36e2), SC_(0.16e2), SC_(-0.1280763149261474609375e1), SC_(-0.616000652313232421875e1), SC_(0.13405693401015095495129388603285599750939697886452e0), SC_(-0.31701770527568262964964812962724629734835358749076e0), 
      SC_(0.36e2), SC_(0.19e2), SC_(-0.3404269695281982421875e1), SC_(0.12897899150848388671875e1), SC_(0.18532299339835815658653258883287556973422377603475e-4), SC_(-0.13419656731737411662155444076113775826744546206039e-4), 
      SC_(0.36e2), SC_(0.19e2), SC_(0.31481277942657470703125e1), SC_(0.282136058807373046875e1), SC_(0.21608541875911484482619839280377140498992072196971e-34), SC_(0.4352740835449175273786127546343860266602215450184e-35), 
      SC_(0.36e2), SC_(0.21e2), SC_(0.49584560394287109375e1), SC_(0.28413121700286865234375e1), SC_(0.30818809265046209013246504196838768892343556314636e0), SC_(-0.69985663287759070110991967057193552994228020833338e-2), 
      SC_(0.36e2), SC_(0.23e2), SC_(0.4612946033477783203125e1), SC_(-0.2902143955230712890625e1), SC_(0.82722576970874955167593382079510927154775020161443e-1), SC_(-0.81160248033739719362640536978430112983799454496176e-1), 
      SC_(0.36e2), SC_(0.25e2), SC_(0.28841459751129150390625e1), SC_(0.1758579313755035400390625e0), SC_(-0.14614810787689115820681723612053986560929040406321e-9), SC_(-0.447086040437218656153849669311193642383366747105e-9), 
      SC_(0.36e2), SC_(0.29e2), SC_(0.45498828887939453125e1), SC_(0.650843918323516845703125e0), SC_(-0.17588594232504250844313117597961469791234192935114e0), SC_(-0.43835821579972026957359669574633985853039026566328e-2), 
      SC_(0.36e2), SC_(0.3e2), SC_(-0.3695554256439208984375e1), SC_(0.34049112796783447265625e1), SC_(-0.49308687446922613354500651342874756115731960080751e-6), SC_(0.10811237988846967988204519015573780804355808552599e-4), 
      SC_(0.36e2), SC_(0.3e2), SC_(0.138416826725006103515625e1), SC_(0.485745334625244140625e1), SC_(0.11718975012366615190022181338923530348301139954051e0), SC_(0.31090930623855047709904198988043404809066829550887e0), 
      SC_(0.36e2), SC_(0.3e2), SC_(0.4312946319580078125e1), SC_(-0.665180265903472900390625e0), SC_(-0.10396188509121396049908483789764720268279105376038e-1), SC_(0.20725149598268798180289515654479767979338972915199e-1), 
      SC_(0.36e2), SC_(0.34e2), SC_(-0.532843017578125e1), SC_(0.25678074359893798828125e1), SC_(0.94419857832555556720572713140264451857907085225083e-2), SC_(-0.73149913789329850940684770701152447685718924379975e-2), 
      SC_(0.36e2), SC_(0.35e2), SC_(-0.5747106075286865234375e1), SC_(0.5534349918365478515625e1), SC_(-0.15666912588548910010152345853983031099529312521263e-9), SC_(0.29070787518477918567114071799623371683907764556947e-9), 
      SC_(0.36e2), SC_(0.36e2), SC_(0.27591998577117919921875e1), SC_(0.1727804660797119140625e1), SC_(0.23042699089344079321919140879800356618823276857639e-15), SC_(-0.16832035251153218659707294060847720285511352789236e-15), 
      SC_(0.37e2), SC_(0), SC_(-0.331193065643310546875e1), SC_(0.19625661373138427734375e1), SC_(-0.59040431719830321939497774067883911626646808828588e0), SC_(0), 
      SC_(0.37e2), SC_(0.5e1), SC_(-0.399324703216552734375e1), SC_(0.352965450286865234375e1), SC_(-0.34824082871969541568390181605736168436988461887844e-2), SC_(0.89914332727447868563791431523940325441115453093328e-2), 
      SC_(0.37e2), SC_(0.5e1), SC_(0.162010610103607177734375e1), SC_(-0.4640440464019775390625e1), SC_(-0.29167550643159516617737412802554637678361610162562e-1), SC_(0.77550793331245717502227360054182457195048698483259e-1), 
      SC_(0.37e2), SC_(0.7e1), SC_(0.3354236602783203125e1), SC_(0.4074541568756103515625e1), SC_(-0.75190283231218629189973893587809314388123277514717e0), SC_(-0.18995695410749039436316705939767864946092237530211e0), 
      SC_(0.37e2), SC_(0.11e2), SC_(-0.572818470001220703125e1), SC_(0.24856951236724853515625e1), SC_(0.19389074033000062456128524622674459404145802558031e0), SC_(-0.26090056891764454737868371132703309460299600035472e0), 
      SC_(0.37e2), SC_(0.12e2), SC_(0.28321716785430908203125e1), SC_(-0.202374267578125e1), SC_(-0.2445934666733770593107923893198055065145824587679e0), SC_(-0.27721271566316580609498532960417573178381989003755e0), 
      SC_(0.37e2), SC_(0.14e2), SC_(-0.3642417430877685546875e1), SC_(0.56937999725341796875e1), SC_(0.83486129949316133491012083764527839421749251725045e-1), SC_(0.1988962321613134897834313141634083269954155515755e0), 
      SC_(0.37e2), SC_(0.16e2), SC_(-0.38547928333282470703125e1), SC_(-0.37430069446563720703125e1), SC_(0.15340761411680551440173238784517334046739113737875e0), SC_(-0.30754143690986007512519102243784797183691712373023e-1), 
      SC_(0.37e2), SC_(0.17e2), SC_(0.20390284061431884765625e1), SC_(-0.1286319196224212646484375e0), SC_(-0.20477328143545082417694159720253569894977139994573e0), SC_(-0.28930670033553256197023336028833594936991509573978e0), 
      SC_(0.37e2), SC_(0.2e2), SC_(-0.5596852779388427734375e1), SC_(-0.6203143596649169921875e1), SC_(-0.94299689671346106785969757870295334716476145037523e-2), SC_(0.31384143819878936152644850799412133061608621063165e0), 
      SC_(0.37e2), SC_(0.2e2), SC_(0.864350855350494384765625e0), SC_(-0.5037988185882568359375e1), SC_(0.21597965622429421148211487520626925473680903448659e0), SC_(-0.50296622569603223756324097936621770129590028617271e-1), 
      SC_(0.37e2), SC_(0.21e2), SC_(0.172814190387725830078125e1), SC_(0.3424273967742919921875e1), SC_(0.55493596974124575942502676553571309353893240418355e-1), SC_(-0.20060612855328578086038712293043636418348929939069e-1), 
      SC_(0.37e2), SC_(0.21e2), SC_(0.4667064189910888671875e1), SC_(-0.137155973911285400390625e1), SC_(-0.48890074984140087476157302649977781549398866542541e-1), SC_(0.28541899575151135107058005274770446820132961524225e-1), 
      SC_(0.37e2), SC_(0.27e2), SC_(-0.2363231182098388671875e1), SC_(0.363593578338623046875e1), SC_(-0.20556150562252155823978466385454720509982773518548e0), SC_(-0.2037179864858758412786001161234072400070335421107e0), 
      SC_(0.37e2), SC_(0.27e2), SC_(0.507170963287353515625e1), SC_(0.4142421245574951171875e1), SC_(0.12313415582380836442824153204499733399085003409887e0), SC_(-0.37302491580564145738684158432021011241065982153338e0), 
      SC_(0.37e2), SC_(0.28e2), SC_(0.5235477924346923828125e1), SC_(0.15546662807464599609375e1), SC_(-0.16694263530629170561134745517964653708576187189061e0), SC_(0.80980691301778800832935373162679443306008601966239e-1), 
      SC_(0.37e2), SC_(0.3e2), SC_(0.23033859729766845703125e1), SC_(-0.4927413463592529296875e1), SC_(0.11606291542327291942834427890974526617435713058201e0), SC_(-0.1963028395454235833862299815422454069334022623e-1), 
      SC_(0.37e2), SC_(0.34e2), SC_(-0.4569547176361083984375e1), SC_(0.5106524944305419921875e1), SC_(-0.26597387589294145061485272410316220810284438620564e0), SC_(-0.29331934304289058673104777740185578517140955026007e0), 
      SC_(0.38e2), SC_(0), SC_(-0.385000514984130859375e1), SC_(0.32233941555023193359375e1), SC_(0.85663667457337634729884391053932869770705247192481e-1), SC_(0), 
      SC_(0.38e2), SC_(0.5e1), SC_(0.4186511516571044921875e1), SC_(0.11965868473052978515625e1), SC_(-0.30756705730263749730833975121531661231994235007456e0), SC_(0.95226256844637999906010538372845363253556415606187e-1), 
      SC_(0.38e2), SC_(0.7e1), SC_(0.2454925537109375e1), SC_(-0.85801708698272705078125e0), SC_(-0.37848386928946957960177361544061248751941332163498e0), SC_(-0.10763326668391069617527492664635709253989608914231e0), 
      SC_(0.38e2), SC_(0.8e1), SC_(0.6020914554595947265625e1), SC_(0.92850553989410400390625e0), SC_(0.32601151655610156404367383997413180224978696137718e0), SC_(0.71854137037188866141963414444072398211974755249061e0), 
      SC_(0.38e2), SC_(0.11e2), SC_(0.4212505340576171875e1), SC_(-0.25713951587677001953125e1), SC_(0.16138227713070033537990020974723366249742693010514e0), SC_(-0.17773529470076020399451154973983331221873830909747e-2), 
      SC_(0.38e2), SC_(0.16e2), SC_(0.22381556034088134765625e1), SC_(0.547928142547607421875e1), SC_(0.22164730040201844185792803397297021117475940375287e0), SC_(-0.6761547974912585244399809184220446964697574465315e-1), 
      SC_(0.38e2), SC_(0.2e2), SC_(-0.28559644222259521484375e1), SC_(-0.21309597492218017578125e1), SC_(0.13052715376145115399607816832066136813211772693062e-4), SC_(0.61939579537732113408829715545908845673183377991271e-4), 
      SC_(0.38e2), SC_(0.21e2), SC_(0.15013239383697509765625e1), SC_(0.24704010486602783203125e1), SC_(0.11493854322261367622012364225956290739607252419893e-1), SC_(-0.27257158202495689848334660990760226905858948937919e0), 
      SC_(0.38e2), SC_(0.22e2), SC_(-0.706580340862274169921875e0), SC_(-0.138223898410797119140625e1), SC_(0.27593095583474122258813493311826770616362715602336e0), SC_(0.43610672876685305964947721351249694159707301339709e0), 
      SC_(0.38e2), SC_(0.24e2), SC_(0.34469749927520751953125e1), SC_(0.31393585205078125e1), SC_(0.57443589774062363104280320554762850898607160281915e-6), SC_(-0.30830341415872819902304942817731497444592618356133e-7), 
      SC_(0.38e2), SC_(0.26e2), SC_(0.5370316982269287109375e1), SC_(0.828188419342041015625e0), SC_(0.25842854314014818263078202769470828624933272847314e-1), SC_(-0.12747522215101311306826743078548453686256816393693e-1), 
      SC_(0.38e2), SC_(0.29e2), SC_(-0.4715228557586669921875e1), SC_(-0.31311509609222412109375e1), SC_(0.26924451996433607030454428262435118228565965387604e-1), SC_(0.8411651685457611552185932083165511261217799065308e-2), 
      SC_(0.38e2), SC_(0.3e2), SC_(0.148707139492034912109375e1), SC_(0.3357749462127685546875e1), SC_(-0.17118569301682477227411290998670554828928357012174e0), SC_(-0.34971848497040761327630670681948633751793416047773e-1), 
      SC_(0.38e2), SC_(0.31e2), SC_(0.6252527713775634765625e1), SC_(0.19403975009918212890625e1), SC_(-0.27734703906140091407654303548501789219824738599088e-42), SC_(-0.13812428853645629227486800239185285435516576667286e-42), 
      SC_(0.38e2), SC_(0.32e2), SC_(-0.211925983428955078125e1), SC_(0.184068977832794189453125e1), SC_(-0.36540306401826445203586073983483893923353047129563e0), SC_(0.36744724409151777739983732825837984771450491081829e0), 
      SC_(0.38e2), SC_(0.34e2), SC_(0.177065169811248779296875e1), SC_(0.268385028839111328125e1), SC_(0.44489390978321896925312513090443818620132711811972e0), SC_(0.64839630736196134505315634619626437453616319400174e-1), 
      SC_(0.38e2), SC_(0.35e2), SC_(-0.108195507526397705078125e1), SC_(-0.494240093231201171875e1), SC_(-0.21063370417133738566738472865165525423012393225209e0), SC_(0.4191673049618808930269680220452215046716958074704e-1), 
      SC_(0.38e2), SC_(0.35e2), SC_(-0.501043498516082763671875e0), SC_(-0.180306494235992431640625e0), SC_(0.90609706910817486775327385725551557903183775703621e-9), SC_(-0.24962029457283237350210265045078497842567485138623e-10), 
      SC_(0.38e2), SC_(0.36e2), SC_(0.50760555267333984375e1), SC_(0.65673887729644775390625e0), SC_(0.3188581332146985668250825945764647498098480235838e-1), SC_(-0.39447980035197207817773108832361416199044211977205e0), 
      SC_(0.38e2), SC_(0.37e2), SC_(0.495677661895751953125e1), SC_(0.841379821300506591796875e0), SC_(0.49575524826641166367996162563399794544201410813859e0), SC_(-0.14517590970609161993208933474553530979186899216424e0), 
      SC_(0.39e2), SC_(0.1e1), SC_(-0.22189953327178955078125e1), SC_(-0.568559551239013671875e1), SC_(-0.26362352369126604619827073712298941471465705306636e0), SC_(-0.17942331459264444736582830183148441709749911009171e0), 
      SC_(0.39e2), SC_(0.3e1), SC_(0.2702335357666015625e1), SC_(-0.49971103668212890625e1), SC_(0.32947376425504896243460752647524994514906015574692e0), SC_(0.28701345716644405530332976547805814355020050920744e0), 
      SC_(0.39e2), SC_(0.7e1), SC_(0.5940549373626708984375e1), SC_(-0.6232646942138671875e1), SC_(-0.51656586279688044950711634036251354125533716728252e0), SC_(-0.19077040635494184638120206366558534298625300719421e0), 
      SC_(0.39e2), SC_(0.11e2), SC_(-0.338810634613037109375e1), SC_(0.4586989879608154296875e1), SC_(-0.23877153244768608999890067159152512877447099792542e0), SC_(-0.4626878054862662602734660652549887601766588421787e-1), 
      SC_(0.39e2), SC_(0.13e2), SC_(-0.248224544525146484375e1), SC_(0.24472157955169677734375e1), SC_(0.54941092645166904834920834727446255000680307548179e-1), SC_(0.23091471424958065001681061908432063952364425648914e-1), 
      SC_(0.39e2), SC_(0.15e2), SC_(-0.190022623538970947265625e1), SC_(0.74311459064483642578125e0), SC_(0.43464357338660042477118006495680152129360507616133e-1), SC_(-0.28537495656259039876978837909500642477003671348907e0), 
      SC_(0.39e2), SC_(0.15e2), SC_(0.6118773937225341796875e1), SC_(-0.27456552982330322265625e1), SC_(-0.30802787544450581315318751333233601636223571240946e-4), SC_(0.11039251492516581623768579071290124463674770612662e-4), 
      SC_(0.39e2), SC_(0.16e2), SC_(0.113862192630767822265625e1), SC_(0.402301251888275146484375e0), SC_(-0.69843082662666438469907379107724580187662162902624e-1), SC_(-0.10815552291147088835252669690754246626577926778838e-1), 
      SC_(0.39e2), SC_(0.18e2), SC_(0.30042703151702880859375e1), SC_(-0.4114825725555419921875e1), SC_(-0.20948815393434284963434815248781264780604118706442e-8), SC_(-0.85814057146474070445985001188784612705395387648924e-8), 
      SC_(0.39e2), SC_(0.19e2), SC_(-0.4547080516815185546875e1), SC_(0.4244960308074951171875e1), SC_(-0.14979119947863593888671163915967848470667139837599e0), SC_(0.24784312736335417217830276955636319347100852388625e0), 
      SC_(0.39e2), SC_(0.19e2), SC_(-0.179863739013671875e1), SC_(0.2398190200328826904296875e0), SC_(0.88771011876196951185099188821790923832267574397737e-3), SC_(0.56505603928521901211793499219351978008379345904375e-2), 
      SC_(0.39e2), SC_(0.21e2), SC_(0.2903470516204833984375e1), SC_(-0.102999699115753173828125e1), SC_(0.81005435097927983178305242439494753567303393829117e-6), SC_(0.3060279428421732671244180799889083089964584265582e-6), 
      SC_(0.39e2), SC_(0.22e2), SC_(-0.56102597713470458984375e0), SC_(0.15654294490814208984375e1), SC_(-0.26853168248495340627513459942203432757962017961318e0), SC_(0.31854049206691960868565297873557734721157679072492e-1), 
      SC_(0.39e2), SC_(0.26e2), SC_(0.189623260498046875e1), SC_(-0.5882033824920654296875e1), SC_(-0.24416704670322721774874359464017402558898849373876e-1), SC_(-0.38461895659007789994759209956968120490261875418424e-1), 
      SC_(0.39e2), SC_(0.29e2), SC_(-0.31472566127777099609375e1), SC_(-0.32558839321136474609375e1), SC_(-0.29782600311806713071438519559259850541305144000117e-59), SC_(0.51999467971643933528091252225423690752025659468939e-60), 
      SC_(0.39e2), SC_(0.33e2), SC_(-0.517082977294921875e1), SC_(-0.27457325458526611328125e1), SC_(0.44485772050549760148108071373952867240008433825619e0), SC_(0.24130428948443863212425471655875547270644914086933e0), 
      SC_(0.39e2), SC_(0.34e2), SC_(-0.795731604099273681640625e0), SC_(0.423138332366943359375e1), SC_(0.37298078383831255143216964283953070387994540231477e-2), SC_(-0.28132865355569288227291542068525502725794275466035e-2), 
      SC_(0.4e2), SC_(0.3e1), SC_(0.37776181697845458984375e1), SC_(-0.437015628814697265625e1), SC_(-0.44762897582083848054962033395906182795836231423733e-2), SC_(0.27082188219665115221843477268315210055663448216561e-2), 
      SC_(0.4e2), SC_(0.4e1), SC_(-0.257291126251220703125e1), SC_(-0.168192327022552490234375e1), SC_(-0.33452579380889814397592647665020592181468185457127e0), SC_(0.15933434358144601091537541781205856396916789174386e0), 
      SC_(0.4e2), SC_(0.7e1), SC_(0.59571781158447265625e1), SC_(0.108623218536376953125e1), SC_(-0.15066685304143155089501514444910373337242367259554e0), SC_(-0.58918330377945397082369473462595166743274962048925e0), 
      SC_(0.4e2), SC_(0.9e1), SC_(-0.21466524600982666015625e1), SC_(0.48274097442626953125e1), SC_(-0.19012849637414995253299495901029844216370474405966e0), SC_(0.11283691039569148528403234822003574114460332154869e0), 
      SC_(0.4e2), SC_(0.9e1), SC_(0.3700389385223388671875e1), SC_(-0.635310947895050048828125e0), SC_(0.3858473097149320852394248915156604119119565490555e0), SC_(0.24481208096959495860585691337182183042737517426572e0), 
      SC_(0.4e2), SC_(0.1e2), SC_(-0.454146480560302734375e1), SC_(-0.14596920013427734375e1), SC_(0.13183360317324389944322693050392606116191901939996e0), SC_(0.26625452629980127019969655041850113347162456402059e0), 
      SC_(0.4e2), SC_(0.1e2), SC_(0.37030851840972900390625e1), SC_(0.175278103351593017578125e1), SC_(-0.45170634323389672982410842609144643417527702181142e-1), SC_(0.17760568565726107759448606450180599968822314132773e0), 
      SC_(0.4e2), SC_(0.12e2), SC_(0.35668976306915283203125e1), SC_(-0.12689526081085205078125e1), SC_(0.98479452197270371861686544756821513595602498426226e-1), SC_(0.51336076438396321585068371219478921083311068650963e-1), 
      SC_(0.4e2), SC_(0.13e2), SC_(0.5966534137725830078125e1), SC_(-0.60297451019287109375e1), SC_(-0.40814888319587251224627559368729895906147542395101e0), SC_(-0.62992985899195241819838302151083705992979344250913e-1), 
      SC_(0.4e2), SC_(0.14e2), SC_(-0.121276605129241943359375e1), SC_(-0.2129637263715267181396484375e-1), SC_(-0.17622440466028082454444309119417984799272298340445e0), SC_(0.54155438110526668529476730456045528858751411912114e-1), 
      SC_(0.4e2), SC_(0.15e2), SC_(-0.190999209880828857421875e1), SC_(-0.10845546722412109375e1), SC_(0.44641709124084006993013389525322466495115256717402e-1), SC_(-0.28010293696016297798145039395962388242625468439447e-1), 
      SC_(0.4e2), SC_(0.15e2), SC_(0.38548543453216552734375e1), SC_(-0.469067287445068359375e1), SC_(0.93373632251474992991169593675039459740595983426086e-2), SC_(-0.27643839420475811736860157626921201409934132878769e-1), 
      SC_(0.4e2), SC_(0.16e2), SC_(-0.30429947376251220703125e1), SC_(-0.4699630260467529296875e1), SC_(0.39182691470049792887278401849472432789463723587197e-8), SC_(0.81117299585000965530489903892218563700098780701483e-9), 
      SC_(0.4e2), SC_(0.16e2), SC_(0.459347820281982421875e1), SC_(-0.5229199886322021484375e1), SC_(0.38401195774960842490415846405454674436193731539014e-1), SC_(0.87160512412409821485858623433906534663447952460687e-1), 
      SC_(0.4e2), SC_(0.19e2), SC_(0.4738133907318115234375e1), SC_(0.625856876373291015625e1), SC_(0.24074378534225175098659151322707561146989517045009e0), SC_(-0.12159818883173160520588469053028402457467987664732e0), 
      SC_(0.4e2), SC_(0.21e2), SC_(-0.375971221923828125e1), SC_(0.151146328449249267578125e1), SC_(0.57848721407149135967887535562592536133964666466945e0), SC_(0.19479271494721171058806180253330478563386263234169e0), 
      SC_(0.4e2), SC_(0.21e2), SC_(0.28800032138824462890625e1), SC_(-0.29098837375640869140625e1), SC_(-0.13310019478983451100130411530770127405799208547926e-5), SC_(0.86029115971033637431048736936310285542831587652986e-5), 
      SC_(0.4e2), SC_(0.23e2), SC_(-0.39055421352386474609375e1), SC_(0.13312530517578125e1), SC_(-0.9007081037290095635686600052829002177364004584175e-1), SC_(0.92205026580488481026551623548061073533619482443032e-1), 
      SC_(0.4e2), SC_(0.23e2), SC_(-0.157518100738525390625e1), SC_(-0.33773653507232666015625e1), SC_(0.33327344273553296806259811536248755782132403624042e-1), SC_(0.38743943892992262541511169590568513858360814004108e-1), 
      SC_(0.4e2), SC_(0.23e2), SC_(0.2200527667999267578125e1), SC_(0.2192636966705322265625e1), SC_(0.40233060264922782360971791600003937740009514216918e0), SC_(0.67062998179869328378273708657154818165734314674185e-1), 
      SC_(0.4e2), SC_(0.25e2), SC_(-0.2899014055728912353515625e0), SC_(-0.1307614147663116455078125e0), SC_(-0.13507709383015693590632361853520826606369848983956e-6), SC_(0.173083988959859126296403537718726138627706063577e-7), 
      SC_(0.4e2), SC_(0.25e2), SC_(0.27851517200469970703125e1), SC_(0.29652383327484130859375e1), SC_(0.38264840408146744282303594854313779422713995446482e-5), SC_(-0.12217018093513181920638660233049226584954316507899e-4), 
      SC_(0.4e2), SC_(0.33e2), SC_(-0.20672550201416015625e1), SC_(0.594336986541748046875e1), SC_(-0.1060389896749715128395881260544368034960110652837e0), SC_(-0.47792841908598828730176516794167651470716625984297e0), 
      SC_(0.4e2), SC_(0.33e2), SC_(0.5824893474578857421875e1), SC_(0.57718982696533203125e1), SC_(-0.11239575764667924426550709740834462169106457079581e-7), SC_(0.26124919737532424928559985927407204733369029083156e-7), 
      SC_(0.4e2), SC_(0.34e2), SC_(-0.56875209808349609375e1), SC_(0.47037041187286376953125e0), SC_(-0.8757634929310491949722035857147172673734280134627e-5), SC_(-0.25622622923765712457025973291203211731453605863522e-5), 
      SC_(0.4e2), SC_(0.34e2), SC_(-0.5098448276519775390625e1), SC_(-0.233850765228271484375e1), SC_(-0.27180808118053782911776373329934161771506524548913e-1), SC_(0.39614999267501463222578898064989094333737791338198e-1), 
      SC_(0.4e2), SC_(0.39e2), SC_(0.39100372791290283203125e1), SC_(0.4565982341766357421875e1), SC_(0.18180670109365057787842199567581333502107779612893e-5), SC_(-0.28157765632310697627215982196127424206233996382758e-5), 
      SC_(0.41e2), SC_(0.1e1), SC_(0.2786633968353271484375e1), SC_(0.57350695133209228515625e0), SC_(-0.44760371090909016993347029643895660736478199881072e0), SC_(-0.28911953189512459243804783868845499997749736745644e0), 
      SC_(0.41e2), SC_(0.3e1), SC_(0.21175868511199951171875e1), SC_(0.4694798290729522705078125e0), SC_(-0.44850660846618986970645476839099111847576684048019e-1), SC_(-0.27381589047694237083995300860556295039133973411612e0), 
      SC_(0.41e2), SC_(0.5e1), SC_(-0.5158113002777099609375e1), SC_(-0.2901681423187255859375e1), SC_(0.10745114844988161076944383880828165711389595466395e0), SC_(0.27601783958596812984550372881019015070706626570317e0), 
      SC_(0.41e2), SC_(0.8e1), SC_(-0.570272541046142578125e1), SC_(0.306122303009033203125e1), SC_(0.28526664316862824482952086071590174961255665459141e0), SC_(-0.21370755079689401572155170348121531461371386783466e0), 
      SC_(0.41e2), SC_(0.9e1), SC_(-0.513057994842529296875e1), SC_(0.2766685009002685546875e1), SC_(0.11628498538792599118341763242850424752655709073871e0), SC_(-0.27543539395364710561818402975346634066511532570006e-1), 
      SC_(0.41e2), SC_(0.9e1), SC_(0.7519805431365966796875e0), SC_(0.1057139873504638671875e1), SC_(0.24699705676628218421728374594781404036130119821091e-1), SC_(0.22160696377651964786951345214359466494054833553114e-2), 
      SC_(0.41e2), SC_(0.11e2), SC_(-0.3691407144069671630859375e0), SC_(-0.541163158416748046875e1), SC_(-0.19873479786691230812064098894402777997967510381447e0), SC_(-0.32543534928091777817681390635416762886531375120039e-1), 
      SC_(0.41e2), SC_(0.14e2), SC_(-0.26898710727691650390625e1), SC_(-0.1288261890411376953125e1), SC_(-0.14114439308501138699715615576476406213799579490405e0), SC_(-0.149425341158853137667723597754008887519361320998e0), 
      SC_(0.41e2), SC_(0.17e2), SC_(-0.4467624187469482421875e1), SC_(0.5521785259246826171875e1), SC_(0.31061432817444388590883580727247736893178861012404e0), SC_(-0.12313870468392041314710116774139076155788978765743e0), 
      SC_(0.41e2), SC_(0.17e2), SC_(0.6043213367462158203125e1), SC_(-0.104114472866058349609375e1), SC_(0.33163562259315332695135153347916529546350024527475e-3), SC_(0.74122870028555822986561272352259037698028732298604e-3), 
      SC_(0.41e2), SC_(0.19e2), SC_(-0.5394939899444580078125e1), SC_(0.503642749786376953125e1), SC_(0.41889697971732974586602635059611704564495625175026e-1), SC_(0.32949810789601385241026117965648403279944612283107e0), 
      SC_(0.41e2), SC_(0.19e2), SC_(0.29545609951019287109375e1), SC_(0.3774587154388427734375e1), SC_(0.67867621291278295915493482070888123912494296005881e-6), SC_(-0.40633453926854345331768951551807003641873314084801e-6), 
      SC_(0.41e2), SC_(0.2e2), SC_(0.171152722835540771484375e1), SC_(0.2340153217315673828125e1), SC_(-0.29906195201292177353286861304941487031700630881578e0), SC_(0.99380010597569928266886654548185101711035406388685e-1), 
      SC_(0.41e2), SC_(0.2e2), SC_(0.514093494415283203125e1), SC_(0.609187793731689453125e1), SC_(-0.77374343105202905250737530627478215930457399726053e-1), SC_(0.63154681222097794088938963676337781969606208036491e-1), 
      SC_(0.41e2), SC_(0.21e2), SC_(-0.35850913524627685546875e1), SC_(-0.83867251873016357421875e0), SC_(-0.2333563753155654210311316578086154477809308917333e-1), SC_(-0.67388121050409449597888592350313195316110946347159e-1), 
      SC_(0.41e2), SC_(0.21e2), SC_(0.4946534633636474609375e1), SC_(-0.48415355682373046875e1), SC_(-0.69919324560903728928353631917888297706507774695596e-1), SC_(0.15265117982428554944960361339090875253054623998399e0), 
      SC_(0.41e2), SC_(0.22e2), SC_(-0.172838771343231201171875e1), SC_(-0.422222423553466796875e1), SC_(-0.4977079638224638861157822152177625090816800241581e-1), SC_(-0.23129651896334090187109358139777580008076767016578e0), 
      SC_(0.41e2), SC_(0.22e2), SC_(0.591207981109619140625e1), SC_(0.10358831882476806640625e1), SC_(-0.14134038630395918678341776110548549572535458501209e-2), SC_(-0.14503001571812621064424380118541042963392414572942e-2), 
      SC_(0.41e2), SC_(0.23e2), SC_(0.27102906703948974609375e1), SC_(-0.4408702373504638671875e1), SC_(-0.55956984093246998580263217024611818175209323778085e-2), SC_(0.66218258555556140201125517574104315121373299514595e-2), 
      SC_(0.41e2), SC_(0.28e2), SC_(0.280195140838623046875e1), SC_(-0.601230621337890625e1), SC_(-0.23354137993052426950870473036093545878660021821853e-7), SC_(-0.84592909664490115819274721521067408417143014773123e-7), 
      SC_(0.41e2), SC_(0.29e2), SC_(-0.476459598541259765625e1), SC_(0.184486472606658935546875e1), SC_(0.78840929810301063790453573244334159608288847000681e-2), SC_(0.74331075339628723047208730083679155160072983392562e-3), 
      SC_(0.41e2), SC_(0.32e2), SC_(-0.24159405231475830078125e1), SC_(0.4049268245697021484375e1), SC_(0.16505668366641421775293001841157511391319219303939e-1), SC_(0.16046229725849754489105196553804398467711316257933e-1), 
      SC_(0.41e2), SC_(0.32e2), SC_(0.704719483852386474609375e0), SC_(-0.24672639369964599609375e1), SC_(-0.11987287913210018495639103128089366594250266494911e-1), SC_(0.52475693538344912206019782246067129283971818658146e-2), 
      SC_(0.41e2), SC_(0.35e2), SC_(-0.35141360759735107421875e0), SC_(-0.306959569454193115234375e0), SC_(-0.11978091867523295994625639273868749999740050953383e-12), SC_(0.46523715929069624312526174060689742902961770313435e-12), 
      SC_(0.41e2), SC_(0.35e2), SC_(0.3341947078704833984375e1), SC_(0.3522301197052001953125e1), SC_(-0.21593444102896830038920944859640869723121449308558e-20), SC_(-0.20459024208809578921889182191243802099549472746347e-20), 
      SC_(0.41e2), SC_(0.38e2), SC_(0.31292583942413330078125e1), SC_(0.5742122173309326171875e1), SC_(0.88236154445512265403701000652271970226796206435487e-71), SC_(0.62592299509180428918327187921131788623351582211663e-70), 
      SC_(0.42e2), SC_(0.1e1), SC_(0.54931964874267578125e1), SC_(0.30963861942291259765625e1), SC_(-0.37065447624222376527473480374628900361171446878783e0), SC_(0.16767400160509097473936715527611962301507922289622e-1), 
      SC_(0.42e2), SC_(0.2e1), SC_(-0.13086125850677490234375e1), SC_(0.37802193164825439453125e1), SC_(0.1265686306466798255955286308566526245012909283909e-1), SC_(0.41871959738118297810142522963337434319682768231143e-1), 
      SC_(0.42e2), SC_(0.8e1), SC_(0.96457326412200927734375e0), SC_(-0.196476018428802490234375e1), SC_(0.35383165719216546034992204921505950403246787970813e0), SC_(-0.3580263903523446698569749129509056899951516345304e-2), 
      SC_(0.42e2), SC_(0.12e2), SC_(0.183848476409912109375e1), SC_(-0.22926352024078369140625e1), SC_(-0.22102739071324446085117239461696799485802058889798e-1), SC_(-0.21121944928260335022194201425513909683551148751589e-1), 
      SC_(0.42e2), SC_(0.16e2), SC_(0.49776821136474609375e1), SC_(0.15619199275970458984375e1), SC_(0.18032612126454231728664840634674213894054526913705e0), SC_(-0.2578393685356509370899918428183645557608231166465e-1), 
      SC_(0.42e2), SC_(0.22e2), SC_(-0.45919589996337890625e1), SC_(-0.160456645488739013671875e1), SC_(0.84068343182306297121700818898402238377536650237956e-1), SC_(-0.77216809306544453423453034598135737820796542584815e-1), 
      SC_(0.42e2), SC_(0.22e2), SC_(0.755321443080902099609375e0), SC_(0.4825696468353271484375e1), SC_(-0.35393211696534831350114676301893436585408368600156e0), SC_(0.26840675840769681747595590373354025593899502516395e0), 
      SC_(0.42e2), SC_(0.26e2), SC_(0.5576095104217529296875e1), SC_(-0.24977228641510009765625e1), SC_(-0.30599874889718534775320919776907586054079009418347e0), SC_(-0.51263715540835924707617792550592179259559170412e0), 
      SC_(0.42e2), SC_(0.27e2), SC_(-0.6024259090423583984375e1), SC_(-0.671911537647247314453125e0), SC_(-0.86041972878090301523782074763452497660779624759101e-9), SC_(-0.73648548818155533768830319274246340585527530670346e-9), 
      SC_(0.42e2), SC_(0.36e2), SC_(0.38493900299072265625e1), SC_(0.28699934482574462890625e1), SC_(-0.36607793994528125608481004889296589657447432932742e-3), SC_(0.13478893781515524984918558255955818953206485523795e-3), 
      SC_(0.43e2), SC_(0.1e1), SC_(-0.160178196430206298828125e1), SC_(-0.27454612255096435546875e1), SC_(0.6502076902283828085178840580815731887693284873971e-1), SC_(0.27194322026461882480931005976894006261391499412988e-1), 
      SC_(0.43e2), SC_(0.1e1), SC_(0.193334352970123291015625e1), SC_(0.5253942012786865234375e1), SC_(-0.16940434235987969669001635678648910739145353594867e0), SC_(0.2816165094206977078525631322453265278177663991694e0), 
      SC_(0.43e2), SC_(0.3e1), SC_(0.5912111759185791015625e1), SC_(0.468163394927978515625e1), SC_(-0.45511375483571548105977295377757139727733506496886e-2), SC_(-0.49186703988235064739081523170471729426524162941611e-1), 
      SC_(0.43e2), SC_(0.3e1), SC_(0.5928637981414794921875e1), SC_(-0.5262205600738525390625e1), SC_(0.38950731275125627569610073982208858875030537244758e0), SC_(-0.3069945905235465706056740197390004578303326084831e-1), 
      SC_(0.43e2), SC_(0.7e1), SC_(-0.19417209923267364501953125e0), SC_(-0.437286090850830078125e1), SC_(0.61481308483532017364960216959900644401223523648576e0), SC_(0.64055424887581681583907268656839907438874913498591e0), 
      SC_(0.43e2), SC_(0.1e2), SC_(-0.434856128692626953125e1), SC_(-0.3684755802154541015625e1), SC_(-0.70165262585061217924626711140433043042893636426591e-1), SC_(-0.80122155565480983654024509998827275734106778173452e-1), 
      SC_(0.43e2), SC_(0.1e2), SC_(0.125106012821197509765625e1), SC_(0.39075133800506591796875e1), SC_(0.52485287082250021389344263214914764000512860730697e-1), SC_(0.26605086765995645869214589782985506592941048559677e0), 
      SC_(0.43e2), SC_(0.17e2), SC_(0.2097723484039306640625e1), SC_(-0.4791971683502197265625e1), SC_(-0.16377789599610764789344549419887127908311498854713e0), SC_(-0.36261301289582052796076088829087991025171845767032e-1), 
      SC_(0.43e2), SC_(0.18e2), SC_(0.54475421905517578125e1), SC_(0.600885105133056640625e1), SC_(-0.12227560598673887221889076301163576057498352219125e-1), SC_(-0.53270782480505198843576101246976970664315947760873e-1), 
      SC_(0.43e2), SC_(0.23e2), SC_(0.4663701355457305908203125e-1), SC_(-0.117210423946380615234375e1), SC_(0.10578477307021401427507619815264667072161756065346e-22), SC_(0.40604428233472254693938294111214999985360842365261e-22), 
      SC_(0.43e2), SC_(0.24e2), SC_(0.27731602191925048828125e1), SC_(0.4576013088226318359375e1), SC_(0.4827373378371254410267285017280371281507807161791e-3), SC_(-0.63813420099543301085234886590708611242752505956473e-4), 
      SC_(0.43e2), SC_(0.33e2), SC_(0.176919162273406982421875e1), SC_(-0.10424125194549560546875e1), SC_(-0.30291233043563300129849982877858513492570763782676e0), SC_(-0.48233244522652771503645402734518941816634117030754e-1), 
      SC_(0.43e2), SC_(0.4e2), SC_(-0.616541957855224609375e1), SC_(0.4386737346649169921875e1), SC_(0.131823146458441547633836798721374931293128945795e-34), SC_(-0.65261504313363083883479628490167668223107806653275e-35), 
      SC_(0.44e2), SC_(0.2e1), SC_(-0.210887813568115234375e1), SC_(0.2064402103424072265625e1), SC_(0.66284644235954233363632987433397538765544954096284e-1), SC_(0.10038503289391170703449082166849393783292273385062e0), 
      SC_(0.44e2), SC_(0.6e1), SC_(-0.270239543914794921875e1), SC_(0.447860622406005859375e1), SC_(0.60015102175321045819349123378786932514320713418143e-1), SC_(-0.35365149331466188300321960764228979860909536999347e0), 
      SC_(0.44e2), SC_(0.6e1), SC_(0.502216243743896484375e1), SC_(0.55176219940185546875e1), SC_(0.18020475570272501843944024820945189162755654831805e-1), SC_(-0.1507054439952946472559027093517248587458260454792e0), 
      SC_(0.44e2), SC_(0.9e1), SC_(-0.4739846706390380859375e1), SC_(-0.684512555599212646484375e0), SC_(0.29720600687942097545037255480053597233140974573527e0), SC_(0.36612766138080746022130980274923317786634100148313e-1), 
      SC_(0.44e2), SC_(0.17e2), SC_(0.61069583892822265625e1), SC_(-0.31832225322723388671875e1), SC_(-0.19724351561898231996746067351765415901455640516974e-4), SC_(0.16875190288492450432384106679901350046274343424895e-4), 
      SC_(0.44e2), SC_(0.18e2), SC_(0.732429981231689453125e0), SC_(-0.596606922149658203125e1), SC_(0.4311074733137189814083164592670565785920512707363e-2), SC_(-0.27943588251736749003644092959127989087169358190939e-2), 
      SC_(0.44e2), SC_(0.19e2), SC_(0.41352845728397369384765625e-2), SC_(0.4806464672088623046875e1), SC_(0.23816584139595749620260246926958614624230304798328e-36), SC_(0.52419335130613194463634161064992381220624244564069e-37), 
      SC_(0.44e2), SC_(0.19e2), SC_(0.443493366241455078125e1), SC_(0.497878170013427734375e1), SC_(0.31914540699308768023021802875001781051308182085836e0), SC_(0.1161619023058994035115426520831430848626638706681e0), 
      SC_(0.44e2), SC_(0.21e2), SC_(0.5022947788238525390625e1), SC_(0.30831587314605712890625e1), SC_(-0.50132037323238884797543797853839840278747889855096e-1), SC_(0.1400777440654766926502972696961782549165936261845e0), 
      SC_(0.44e2), SC_(0.22e2), SC_(-0.2321910381317138671875e1), SC_(-0.28238275051116943359375e1), SC_(0.30299881952384371248837650192933033966768509812876e0), SC_(0.25919949336834942177772319757362911533638697396495e0), 
      SC_(0.44e2), SC_(0.23e2), SC_(0.14365551471710205078125e1), SC_(0.51988544464111328125e1), SC_(0.31332072053015667363946949610174590747952655564775e0), SC_(0.61275838168345603293856987391767615654418702515799e-1), 
      SC_(0.44e2), SC_(0.25e2), SC_(-0.474674224853515625e1), SC_(-0.4412345409393310546875e1), SC_(-0.31324992129142435373839965159292587033308246958752e0), SC_(0.11537299148658286918994279887325675058499720187771e0), 
      SC_(0.44e2), SC_(0.28e2), SC_(-0.13963277339935302734375e1), SC_(0.451167011260986328125e1), SC_(0.27791086561301244532611159484631191650774060844459e0), SC_(0.21705253872615266329386024847936506238945025696093e0), 
      SC_(0.44e2), SC_(0.29e2), SC_(-0.1135275363922119140625e1), SC_(-0.2635244466364383697509765625e-1), SC_(-0.28422531146145117495535273336196996534923484107899e0), SC_(0.27243500407779479862891090435179662344000257040133e0), 
      SC_(0.44e2), SC_(0.29e2), SC_(0.410391139984130859375e1), SC_(0.551767635345458984375e1), SC_(-0.22556695838212962205131755486923853802156004357055e0), SC_(0.47750462951755744836798874918839062249400663018501e-1), 
      SC_(0.44e2), SC_(0.32e2), SC_(0.27227523326873779296875e1), SC_(-0.23255970478057861328125e1), SC_(0.225159297318814868776636915494200155274959184538e-6), SC_(0.33506402055328666863189722097476659664932692422277e-6), 
      SC_(0.44e2), SC_(0.32e2), SC_(0.35741660594940185546875e1), SC_(-0.20553843975067138671875e1), SC_(-0.95208843267735130259986009117365664915838276829943e-6), SC_(-0.19413308574328131999815650494587412826930220403174e-6), 
      SC_(0.44e2), SC_(0.39e2), SC_(-0.5015091419219970703125e1), SC_(-0.36986305713653564453125e1), SC_(0.65673589762762509196254689824127314259238994729293e-1), SC_(0.17940456940288493861690019949592356205897933668166e-1), 
      SC_(0.45e2), SC_(0), SC_(0.939174830913543701171875e0), SC_(0.5369831562042236328125e1), SC_(-0.15933733183488475302574634162534414155663773104725e0), SC_(0), 
      SC_(0.45e2), SC_(0.2e1), SC_(-0.130913650989532470703125e1), SC_(-0.354610443115234375e1), SC_(0.13921098187224773570610176981394499039542145613822e0), SC_(-0.14594925796703871477805511474081865541632485211103e0), 
      SC_(0.45e2), SC_(0.3e1), SC_(-0.604929065704345703125e1), SC_(-0.20665225982666015625e1), SC_(-0.49911729921863373943368450136926638789712925224419e0), SC_(-0.41832488452007977388497358200789629193628922907864e-1), 
      SC_(0.45e2), SC_(0.3e1), SC_(-0.552333736419677734375e1), SC_(0.3132267475128173828125e1), SC_(-0.23816772167653511501207331843608268271957639051909e0), SC_(0.66646082580896887544342405123693997582447332336862e-2), 
      SC_(0.45e2), SC_(0.3e1), SC_(-0.15620987415313720703125e1), SC_(-0.50837457180023193359375e0), SC_(-0.13428904810115399322775375248291552956333652314016e-1), SC_(0.29382086096676203381597203219739487357219947180009e0), 
      SC_(0.45e2), SC_(0.5e1), SC_(0.16549806296825408935546875e0), SC_(-0.6136397838592529296875e1), SC_(-0.56271021513870705900836394291962825302725244127426e0), SC_(-0.50758335850164506390927543089742197802394050752957e0), 
      SC_(0.45e2), SC_(0.7e1), SC_(-0.5060004711151123046875e1), SC_(0.193110167980194091796875e0), SC_(-0.71540994144235865560077645766823944384967816471795e-1), SC_(-0.32139382088905621629202225810076786761143583265731e0), 
      SC_(0.45e2), SC_(0.7e1), SC_(0.5014622211456298828125e0), SC_(-0.587950992584228515625e1), SC_(0.3839338150104470247569276470374314485915123284344e0), SC_(-0.12547208174733428227188968181934135699287480959684e0), 
      SC_(0.45e2), SC_(0.12e2), SC_(-0.2188745021820068359375e1), SC_(-0.77272093296051025390625e0), SC_(0.34555666780913094925074329525267632969391312273423e0), SC_(0.52977729970812527589078040905728687761822956075162e-1), 
      SC_(0.45e2), SC_(0.13e2), SC_(0.5684658527374267578125e1), SC_(-0.422357845306396484375e1), SC_(0.27266783223837613881540476320835810520139733921365e-1), SC_(-0.38149831577034554443304936206080974741507979649135e0), 
      SC_(0.45e2), SC_(0.16e2), SC_(0.197958719730377197265625e1), SC_(-0.619251430034637451171875e0), SC_(-0.30556748124355038731954280799339438065140265556109e0), SC_(0.16034416664717506435272134602067848575693271965245e0), 
      SC_(0.45e2), SC_(0.18e2), SC_(-0.12556350231170654296875e1), SC_(-0.7369987964630126953125e0), SC_(-0.13973745905530426028905597788108699577861590107185e0), SC_(0.11760556394033085108159337642936562688995826763498e0), 
      SC_(0.45e2), SC_(0.2e2), SC_(-0.7813746929168701171875e0), SC_(0.27677395343780517578125e1), SC_(-0.39849218351007578506841407237493608495069770578433e-1), SC_(0.10066877387056751526933226791286739608366615374509e0), 
      SC_(0.45e2), SC_(0.22e2), SC_(-0.6202817440032958984375e1), SC_(0.395440673828125e1), SC_(0.2745769977511131751544732895346113708784179864521e-15), SC_(-0.39864741899734083739809198194152374756235766569503e-15), 
      SC_(0.45e2), SC_(0.23e2), SC_(-0.10876858234405517578125e1), SC_(-0.54758465290069580078125e0), SC_(-0.36813456165008714961923702579403331542009744543449e0), SC_(0.10338610805549694712336773945006870484644272308057e-1), 
      SC_(0.45e2), SC_(0.27e2), SC_(-0.22089176177978515625e1), SC_(-0.535065555572509765625e1), SC_(0.41141480172194981846690667274473042845038773638111e0), SC_(0.18757887746647837784832607273188838756300856275546e-1), 
      SC_(0.45e2), SC_(0.3e2), SC_(0.2447994232177734375e1), SC_(-0.1720281124114990234375e1), SC_(-0.63262997119417630609121090707517619542963845112263e-1), SC_(0.27283653856555771378568400091562423346179839955125e0), 
      SC_(0.45e2), SC_(0.32e2), SC_(-0.550032520294189453125e1), SC_(-0.197652399539947509765625e1), SC_(0.37914490460800950722564369649799928337346055286563e0), SC_(-0.16791460754886262593803128496604866549198193900205e0), 
      SC_(0.45e2), SC_(0.33e2), SC_(-0.20435826778411865234375e1), SC_(0.77811157703399658203125e0), SC_(0.77645390567356909989093657298781394838446159128476e-2), SC_(0.47065976737942973470312981088025304876207764952942e-2), 
      SC_(0.45e2), SC_(0.34e2), SC_(-0.435846805572509765625e1), SC_(-0.4595039844512939453125e1), SC_(-0.23173174951494724049335139235217704962545643146909e0), SC_(-0.26287348321367285049632415964845518701217296430745e0), 
      SC_(0.45e2), SC_(0.34e2), SC_(0.177516520023345947265625e1), SC_(0.137764739990234375e1), SC_(0.59761588654541651921538993283902141182837198683092e-1), SC_(-0.17435916863343648549723487454804073917582879348239e-1), 
      SC_(0.45e2), SC_(0.34e2), SC_(0.3879002094268798828125e1), SC_(0.27753543853759765625e1), SC_(-0.59667989412747151036847414005580139704727606438127e-1), SC_(-0.68480632370701762469979880941171986559613724866762e-2), 
      SC_(0.45e2), SC_(0.4e2), SC_(-0.2200931549072265625e1), SC_(0.5044522762298583984375e1), SC_(-0.37751879505890675204290416319324203430339866034527e-1), SC_(-0.33042938405518148395974728408099392183896536464139e-1), 
      SC_(0.45e2), SC_(0.4e2), SC_(-0.85712230205535888671875e0), SC_(0.27941138744354248046875e1), SC_(0.15126082014514309105699573435928708984110455017974e-2), SC_(-0.62346115144458295296539248693593197512548415960439e-2), 
      SC_(0.45e2), SC_(0.4e2), SC_(0.2686634540557861328125e1), SC_(-0.77928817272186279296875e0), SC_(-0.13149478049059040821589095143716566492527139660456e-10), SC_(-0.32792807833371932672386100174246835119468974214531e-11), 
      SC_(0.46e2), SC_(0.6e1), SC_(-0.432638645172119140625e1), SC_(-0.38857147693634033203125e1), SC_(-0.40016334930735413522008285324026775292932027877037e-1), SC_(0.15826311122866724066507068410824769374050643856726e0), 
      SC_(0.46e2), SC_(0.9e1), SC_(-0.480351352691650390625e1), SC_(-0.4442025661468505859375e1), SC_(-0.17804425547632560305083458901376629753558029308276e0), SC_(-0.20784592455207982712353861524396387343566007564129e0), 
      SC_(0.46e2), SC_(0.9e1), SC_(0.19425664842128753662109375e0), SC_(0.235065460205078125e1), SC_(0.38952883997601874903417652597285085753047471617813e0), SC_(-0.43044586433592812110060425497489734963473376324051e0), 
      SC_(0.46e2), SC_(0.11e2), SC_(0.1100307941436767578125e1), SC_(-0.879623353481292724609375e0), SC_(-0.23481723667983642303785004561261788720018270887495e0), SC_(0.60228627945927417244808749030695729373020587528789e-1), 
      SC_(0.46e2), SC_(0.12e2), SC_(0.3864775180816650390625e1), SC_(0.4004157543182373046875e1), SC_(0.24428263805252340563167127045447834294287218158908e0), SC_(0.32483329495887636777189975350710117091884719267287e0), 
      SC_(0.46e2), SC_(0.15e2), SC_(0.4853572845458984375e1), SC_(-0.1043331623077392578125e1), SC_(-0.23302525543734963918261234649372184763674980748449e-1), SC_(-0.13528050372225311322128559869543308439796322737887e-2), 
      SC_(0.46e2), SC_(0.24e2), SC_(-0.2910006999969482421875e1), SC_(0.117321979999542236328125e1), SC_(-0.16388352843277053045356822643126635895481895595764e-6), SC_(0.19272097241945999466564643840876007968713615827811e-7), 
      SC_(0.46e2), SC_(0.24e2), SC_(0.30920257568359375e1), SC_(0.41045475006103515625e1), SC_(-0.17141793730524635244619658001858906829425946738015e-22), SC_(-0.353932157629508870861527650447703335456641711151e-22), 
      SC_(0.46e2), SC_(0.27e2), SC_(-0.30337450504302978515625e1), SC_(-0.26822617053985595703125e1), SC_(0.22182505919358879453411450836404708327950722163022e-17), SC_(-0.36808156453037151724744300957184672127236705649958e-18), 
      SC_(0.46e2), SC_(0.28e2), SC_(-0.132531630992889404296875e1), SC_(0.546580791473388671875e1), SC_(-0.21329378814290365449612692361118580219648092391161e0), SC_(0.26626936572354782734997372022985821694671870975775e0), 
      SC_(0.46e2), SC_(0.28e2), SC_(-0.1029656827449798583984375e0), SC_(0.5967599391937255859375e1), SC_(-0.37880142937699879641874135818635870094007889448655e-19), SC_(-0.25273663696314938327515532061787690717970261018698e-19), 
      SC_(0.46e2), SC_(0.28e2), SC_(0.482559390366077423095703125e-1), SC_(-0.5518924236297607421875e1), SC_(-0.26315848561574888067768081465300364071961272401734e-28), SC_(0.17690086300756944612204623673726731224135866889251e-28), 
      SC_(0.46e2), SC_(0.28e2), SC_(0.573732852935791015625e1), SC_(0.672823250293731689453125e0), SC_(0.49351179412072949336683976023897526718169335572202e-1), SC_(-0.51844893265478561854065841006330149592977061759561e-3), 
      SC_(0.46e2), SC_(0.31e2), SC_(-0.6200977802276611328125e1), SC_(0.487247467041015625e1), SC_(-0.10395707481778370618550774477780737547027453922993e-25), SC_(-0.26574212928785201709352578354806008627623144348818e-26), 
      SC_(0.46e2), SC_(0.31e2), SC_(0.2640482425689697265625e1), SC_(0.4013978481292724609375e1), SC_(0.18993053959502150052468986600791304906563873585754e-3), SC_(-0.53620432352494314091893553128144469715606258596804e-3), 
      SC_(0.46e2), SC_(0.32e2), SC_(-0.54709758758544921875e1), SC_(0.3057758808135986328125e1), SC_(-0.53766561950689769965804154140988619898087315513611e0), SC_(-0.26565598059831519737826054076822541229399481610759e0), 
      SC_(0.46e2), SC_(0.32e2), SC_(-0.3191898345947265625e1), SC_(0.595924472808837890625e1), SC_(-0.44145496629530935095307947744856711840542556073239e-34), SC_(0.60613432894613823636685675140616588075400465754263e-34), 
      SC_(0.46e2), SC_(0.33e2), SC_(0.16479690074920654296875e1), SC_(0.443247222900390625e1), SC_(-0.40907775367135866917702573996177698848809877084062e-1), SC_(0.2155824296611070354716993857852359428103292430576e0), 
      SC_(0.46e2), SC_(0.38e2), SC_(0.89018189907073974609375e0), SC_(0.36493904590606689453125e1), SC_(0.13889767421801824676794829473709208617257672078469e0), SC_(0.66541168648123245559255467416199141677120092677324e-1), 
      SC_(0.47e2), SC_(0.3e1), SC_(-0.4007724761962890625e1), SC_(0.150865638256072998046875e1), SC_(-0.26767145533992176767497559163509049956344958420219e-1), SC_(-0.14191811357002032840541828034175393201300045603129e0), 
      SC_(0.47e2), SC_(0.4e1), SC_(0.2455342769622802734375e1), SC_(-0.99948275089263916015625e0), SC_(0.2174308680625884328795523329330743970260614863717e0), SC_(-0.25069567276564714314225605282895819077172700433603e0), 
      SC_(0.47e2), SC_(0.6e1), SC_(0.29439375400543212890625e1), SC_(0.5179188251495361328125e0), SC_(0.356948479346197013224774682397014388555120380011e0), SC_(-0.12169409707676878334735987022772795685926883013465e-1), 
      SC_(0.47e2), SC_(0.8e1), SC_(-0.575384318828582763671875e0), SC_(0.1000965595245361328125e1), SC_(0.52609764735493880386658178470886011732259841641417e-1), SC_(-0.33949223818788971610750151642163418359887123654498e0), 
      SC_(0.47e2), SC_(0.11e2), SC_(0.7798192501068115234375e0), SC_(-0.7041451930999755859375e0), SC_(-0.56653310111911531477233240689992111230625108233036e-2), SC_(0.52065832061739333971520273981969883254825594657534e-1), 
      SC_(0.47e2), SC_(0.12e2), SC_(0.4662929534912109375e1), SC_(-0.9241869449615478515625e0), SC_(0.23362894693871191987918828430964470190930593496574e-1), SC_(0.24604723434869110858598425017491701426924638144305e0), 
      SC_(0.47e2), SC_(0.12e2), SC_(0.559471797943115234375e1), SC_(0.2798630237579345703125e1), SC_(0.17033489008554011818661187796298714500018186073295e0), SC_(-0.250673941390055873246229086782342877123592075417e0), 
      SC_(0.47e2), SC_(0.16e2), SC_(0.2135078907012939453125e0), SC_(0.17677328586578369140625e1), SC_(-0.40270055436638473531410355130447754148130521624792e-2), SC_(-0.37822169118264880418889481540869124483351373905041e-4), 
      SC_(0.47e2), SC_(0.2e2), SC_(-0.195895731449127197265625e1), SC_(-0.579391777515411376953125e0), SC_(-0.15577860999005695928154075733762613389761234158943e0), SC_(-0.23152551164929220445481581901016524977854444194532e0), 
      SC_(0.47e2), SC_(0.21e2), SC_(0.4007311165332794189453125e0), SC_(0.47393741607666015625e1), SC_(-0.70272896583053034791238962988375990671208121812288e-1), SC_(0.11043869498561021486738079932321951805943232163813e0), 
      SC_(0.47e2), SC_(0.22e2), SC_(-0.24021832942962646484375e1), SC_(-0.17589018344879150390625e1), SC_(-0.22524795870491574224537613981959148215876594881665e0), SC_(0.34829144959822154881414680836189838260621088876932e0), 
      SC_(0.47e2), SC_(0.23e2), SC_(-0.6144268035888671875e1), SC_(-0.19239718914031982421875e1), SC_(-0.21428418065072641195187189772881405126431473733192e-10), SC_(0.59087250125232030799036036471778804738471950937741e-11), 
      SC_(0.47e2), SC_(0.24e2), SC_(-0.90589809417724609375e0), SC_(-0.69550454616546630859375e0), SC_(0.21621145388913791954852453820974859105758383446149e0), SC_(-0.325269227515941384150753099077386791354732112632e0), 
      SC_(0.47e2), SC_(0.28e2), SC_(-0.4909250736236572265625e1), SC_(-0.34989111423492431640625e1), SC_(0.2849042481648421063594526222235567477585168996532e0), SC_(-0.18671717508379687462424778809383789120058232562727e0), 
      SC_(0.47e2), SC_(0.31e2), SC_(0.731376349925994873046875e0), SC_(0.25832922458648681640625e1), SC_(0.14558311977380004242663313719763696307600681918104e-1), SC_(0.50973041759102896592485887663785873189653213696073e0), 
      SC_(0.47e2), SC_(0.31e2), SC_(0.4225698947906494140625e1), SC_(0.448341846466064453125e1), SC_(-0.10048142070645931863483498239705078295501286342258e0), SC_(-0.94720792669270806839081551900740318275224474965324e-1), 
      SC_(0.47e2), SC_(0.33e2), SC_(-0.23726341724395751953125e1), SC_(0.346272182464599609375e1), SC_(0.15886769869597684035077430317752989569837414157117e0), SC_(0.37753328887917336010699798430583391320850404839209e0), 
      SC_(0.47e2), SC_(0.36e2), SC_(0.345058917999267578125e1), SC_(0.24347667694091796875e1), SC_(-0.42764431337120844123235375883123149895117279758459e-12), SC_(0.13839773517362302854143994286869291829733243112091e-12), 
      SC_(0.47e2), SC_(0.37e2), SC_(0.2493927001953125e1), SC_(-0.4316608428955078125e1), SC_(0.66667168495166953309758312008417545833856092128204e-3), SC_(0.37003730562098288570362491190035224799197658320599e-3), 
      SC_(0.48e2), SC_(0.2e1), SC_(-0.2035869121551513671875e1), SC_(-0.6225636005401611328125e1), SC_(0.28606894490141744647813319476199313844842342813869e0), SC_(0.33072309108214894083517702632450561761016797624373e-1), 
      SC_(0.48e2), SC_(0.5e1), SC_(0.13228361606597900390625e1), SC_(0.14751684665679931640625e1), SC_(-0.84852408402337008554120048209601235452611537689521e-1), SC_(-0.16372931389555959806105883386148626432700901477429e0), 
      SC_(0.48e2), SC_(0.8e1), SC_(-0.61489925384521484375e1), SC_(-0.557976818084716796875e1), SC_(0.19079773202103238064509095581513541982710490971462e0), SC_(-0.14681385693827482231520169778980942919825638751309e0), 
      SC_(0.48e2), SC_(0.9e1), SC_(0.1855456829071044921875e1), SC_(-0.34094126224517822265625e1), SC_(-0.20465278494968209294999961968701797552184796734969e0), SC_(-0.18359488295947017699172291314906035468217255253267e0), 
      SC_(0.48e2), SC_(0.11e2), SC_(-0.510445415973663330078125e0), SC_(-0.2179370403289794921875e1), SC_(-0.17415801107756946800231879780099729296579201750249e0), SC_(-0.39946809289135814220017962080684064709296251216702e0), 
      SC_(0.48e2), SC_(0.12e2), SC_(0.5127735137939453125e1), SC_(0.147180497646331787109375e1), SC_(0.10235270561549462717073795224019921669009190057754e0), SC_(-0.25411603142079242733272237982972076450193559196436e0), 
      SC_(0.48e2), SC_(0.13e2), SC_(-0.28512251377105712890625e1), SC_(0.21358762681484222412109375e0), SC_(0.65082793160341590914926316444150324051891586307335e0), SC_(-0.24866103078135174972315060854694095694134464474465e0), 
      SC_(0.48e2), SC_(0.15e2), SC_(0.21509382724761962890625e1), SC_(0.505238056182861328125e1), SC_(0.33153682677233458889683871883764794291900552041288e0), SC_(0.13530604504841517586204066208483785803300406806222e0), 
      SC_(0.48e2), SC_(0.17e2), SC_(-0.410233306884765625e1), SC_(-0.5055477142333984375e1), SC_(0.120658610881024129421142111496549042350283006718e0), SC_(-0.24934508488272542971829338925578466799768762724609e0), 
      SC_(0.48e2), SC_(0.18e2), SC_(0.419954395294189453125e1), SC_(-0.31286038458347320556640625e-1), SC_(0.18229465107186350461724966401750299694404393980909e0), SC_(-0.11509073643647539446369783158526832981463008146529e0), 
      SC_(0.48e2), SC_(0.19e2), SC_(0.33512248992919921875e1), SC_(0.5698537349700927734375e1), SC_(-0.11430916047691646574027070138178816779368218597795e-4), SC_(-0.10096469757450613482659522651534357791031593710281e-3), 
      SC_(0.48e2), SC_(0.2e2), SC_(-0.4913626194000244140625e1), SC_(0.4570525646209716796875e1), SC_(0.27544694591170425084361640327912372332575356920479e0), SC_(0.86513078636045023383894712247218808351168016037179e-1), 
      SC_(0.48e2), SC_(0.22e2), SC_(-0.35437946319580078125e1), SC_(-0.14283583164215087890625e1), SC_(0.92521800679569304410458632278427028786030152854651e-1), SC_(-0.73615833685271087989994719034708442687869544183798e-3), 
      SC_(0.48e2), SC_(0.24e2), SC_(0.2529537379741668701171875e0), SC_(-0.13951661586761474609375e1), SC_(-0.14461558442027612635993431382924805648986580565293e-5), SC_(-0.26644654773805667856532999455349036511597661939098e-5), 
      SC_(0.48e2), SC_(0.25e2), SC_(-0.5302140712738037109375e1), SC_(0.534227657318115234375e1), SC_(0.14567724220048959327288429307006198049897616049705e-1), SC_(-0.37118356905088388538181275498694280409563892893147e0), 
      SC_(0.48e2), SC_(0.26e2), SC_(0.4788922786712646484375e1), SC_(0.114234256744384765625e1), SC_(-0.49889909138094330244956751684356082959364552066594e-1), SC_(-0.34351914682484557095802003482605269948574737582585e0), 
      SC_(0.48e2), SC_(0.29e2), SC_(-0.155845987796783447265625e1), SC_(0.265560741536319255828857421875e-2), SC_(-0.16358032708366624805995699759082827770270765931603e0), SC_(-0.12622713495579813089501286854682899269376306838204e-1), 
      SC_(0.48e2), SC_(0.31e2), SC_(-0.814608156681060791015625e0), SC_(-0.5973989009857177734375e1), SC_(-0.21849236027340450931517916914197181334381665924407e0), SC_(-0.35329064201860941281957627439495576583081752554927e-1), 
      SC_(0.48e2), SC_(0.34e2), SC_(0.5690162181854248046875e1), SC_(-0.4747711181640625e1), SC_(-0.14208000946756588475345650324158728024525891044283e-2), SC_(0.36648708355068107608507564157213823609107549413423e-2), 
      SC_(0.48e2), SC_(0.36e2), SC_(-0.606925201416015625e1), SC_(-0.6036619663238525390625e1), SC_(-0.33060032760649252071566767946067882261145163749527e-17), SC_(0.20197241068338690816933400483260997588417796049136e-17), 
      SC_(0.48e2), SC_(0.36e2), SC_(-0.557515811920166015625e1), SC_(0.549843120574951171875e1), SC_(-0.29793042772484214996215596790395794084288963000676e-1), SC_(-0.69091218291545995969013380580434842461096487036142e-3), 
      SC_(0.48e2), SC_(0.37e2), SC_(-0.4484233856201171875e1), SC_(-0.586126422882080078125e1), SC_(0.28783210566723256763209668589242474045102053584988e0), SC_(-0.27973722891666817142600363847230369142196912070032e-1), 
      SC_(0.49e2), SC_(0.4e1), SC_(0.7450397014617919921875e0), SC_(-0.486802196502685546875e1), SC_(0.43523446367954232471457024383074543728337571811041e-1), SC_(-0.31238445205075929681258187766528850038918026320874e-1), 
      SC_(0.49e2), SC_(0.5e1), SC_(-0.705654084682464599609375e0), SC_(0.36159880161285400390625e1), SC_(0.33812266273696200694321547558772118159278050274115e-1), SC_(-0.32761490529250158683739840580938438700363222937706e-1), 
      SC_(0.49e2), SC_(0.6e1), SC_(0.4099590480327606201171875e0), SC_(-0.148899996280670166015625e1), SC_(0.33872549952379279074817297974186583810635403131808e-1), SC_(0.18101089014763158990806574103071386037200021990488e-1), 
      SC_(0.49e2), SC_(0.6e1), SC_(0.288681316375732421875e1), SC_(0.555331707000732421875e1), SC_(-0.17299631476757984574148560709032937173460259126009e0), SC_(0.49987182677495761333169759620280021625021164232635e0), 
      SC_(0.49e2), SC_(0.8e1), SC_(-0.28113791942596435546875e1), SC_(0.4268764019012451171875e1), SC_(0.11234284818582161154493446715155148494092582868555e0), SC_(-0.4848176775276798667653033304055062110686751478506e-1), 
      SC_(0.49e2), SC_(0.8e1), SC_(-0.175365102291107177734375e1), SC_(0.3699061870574951171875e0), SC_(0.150510223757467945212888241106383078890968767236e0), SC_(-0.27752777621993241253038961455135547546359775538701e-1), 
      SC_(0.49e2), SC_(0.1e2), SC_(-0.623242966830730438232421875e-1), SC_(0.99178183078765869140625e0), SC_(-0.39129153600073467169496931061202903620397035718226e-4), SC_(-0.21024087848986552498673205313374207046750995885514e-4), 
      SC_(0.49e2), SC_(0.11e2), SC_(0.4610438823699951171875e1), SC_(0.516170978546142578125e1), SC_(-0.64931321841066713098308595750847102912382779925862e-1), SC_(-0.15212818549984179656962126137889372220056261241257e-1), 
      SC_(0.49e2), SC_(0.12e2), SC_(-0.492767429351806640625e1), SC_(0.5237930774688720703125e1), SC_(-0.25815646423352702571250699074506009315207777917256e0), SC_(-0.60203250835447592212607712693653576640800332594405e-2), 
      SC_(0.49e2), SC_(0.12e2), SC_(-0.285912036895751953125e1), SC_(0.203067779541015625e1), SC_(-0.58309335353629437699137207747030784181611219363777e0), SC_(0.55933823022969032857356665544019317581369057604275e0), 
      SC_(0.49e2), SC_(0.21e2), SC_(0.213364541530609130859375e0), SC_(0.3487752437591552734375e1), SC_(0.68979677728313700400977850242007578301598557836144e-5), SC_(0.10423031489346059064213401632074682208378658096143e-4), 
      SC_(0.49e2), SC_(0.24e2), SC_(-0.5363933563232421875e1), SC_(-0.13800899982452392578125e1), SC_(-0.39624366668844441499649851882221871259293339848909e-1), SC_(-0.29077551093957529339300484162110207541478366743715e0), 
      SC_(0.49e2), SC_(0.24e2), SC_(0.113704526424407958984375e1), SC_(-0.524048984050750732421875e0), SC_(-0.95716020864868532424772271176706645369949424860348e-1), SC_(0.10342521283811512447413822494381438186657088095508e-2), 
      SC_(0.49e2), SC_(0.26e2), SC_(0.195927083492279052734375e1), SC_(0.2748439788818359375e1), SC_(0.11971762382480258608379673285431990043583083168738e0), SC_(-0.12257642890929780276867696344794516000179864725662e0), 
      SC_(0.49e2), SC_(0.27e2), SC_(0.49123775959014892578125e0), SC_(0.2262770175933837890625e1), SC_(0.10204568382238142188564702604070162264838835105016e-1), SC_(0.60809845254720905762068213640063158711493179195797e-1), 
      SC_(0.49e2), SC_(0.28e2), SC_(-0.26242389678955078125e1), SC_(0.551108074188232421875e1), SC_(0.62995535686340908516656601005584507927420828344839e-1), SC_(0.24594729609877561046325340633244478848156201312828e-1), 
      SC_(0.49e2), SC_(0.29e2), SC_(-0.30029771327972412109375e1), SC_(-0.2872400760650634765625e1), SC_(-0.55339515369306716058956107221780747493058274670244e-17), SC_(-0.11662133768710831442193525927180620131415498665886e-15), 
      SC_(0.49e2), SC_(0.3e2), SC_(0.611942386627197265625e1), SC_(-0.63407027721405029296875e0), SC_(0.1394293153272931999882487586325865494180618327615e-14), SC_(-0.24300519585643234499387785103683410462334687962488e-15), 
      SC_(0.49e2), SC_(0.35e2), SC_(-0.166894090175628662109375e1), SC_(0.4225218296051025390625e1), SC_(-0.35508021992434406559798366674327649256336649541254e0), SC_(-0.82310724679645695220583934477252032989621192496738e-1), 
      SC_(0.49e2), SC_(0.36e2), SC_(-0.32497041225433349609375e1), SC_(0.107579600811004638671875e1), SC_(-0.17013596752796213880005913256594710378533147240406e-27), SC_(-0.28302568795764666512713804293802636201022080165826e-27), 
      SC_(0.49e2), SC_(0.37e2), SC_(-0.5017117023468017578125e1), SC_(0.383155155181884765625e1), SC_(-0.35232624098397971030888657233932783396857095781041e0), SC_(-0.14719428675619986819270542639579914303323853912089e0), 
      SC_(0.49e2), SC_(0.37e2), SC_(-0.23628532886505126953125e1), SC_(-0.123920929431915283203125e1), SC_(-0.40342907812326051474768377766202705403179945762591e-1), SC_(-0.13151134923462644400467105161114547636592907143886e0), 
      SC_(0.49e2), SC_(0.38e2), SC_(0.33035366535186767578125e1), SC_(0.2936229705810546875e1), SC_(-0.14617119042429598121920579635742118107020065282388e-24), SC_(0.29099331615315387488356539500057397404411535737234e-23), 
      SC_(0.49e2), SC_(0.4e2), SC_(0.4189170360565185546875e1), SC_(-0.5219272136688232421875e1), SC_(-0.71881448396381481201576224141351106542999167239121e-1), SC_(0.49216549050921898631651418491099543778321238775524e0)
   };
#undef SC_

