#include "maemo_orientation.h"

#include <QtDBus>

#include <mce/mode-names.h>
#include <mce/dbus-names.h>

MaemoOrientation::MaemoOrientation(QObject *parent):
	QObject(parent),
	portrait(false)
{
	QDBusConnection::systemBus().call(QDBusMessage::createMethodCall(MCE_SERVICE, MCE_REQUEST_PATH, MCE_REQUEST_IF, MCE_ACCELEROMETER_ENABLE_REQ));
	QDBusConnection::systemBus().connect("", MCE_SIGNAL_PATH, MCE_SIGNAL_IF, MCE_DEVICE_ORIENTATION_SIG, this, SLOT(orientationUpdate(QString, QString, QString, int, int, int)));
}


MaemoOrientation::~MaemoOrientation()
{
	 QDBusConnection::systemBus().disconnect("", MCE_SIGNAL_PATH, MCE_SIGNAL_IF, MCE_DEVICE_ORIENTATION_SIG, this, SLOT(orientationUpdate(QString,QString,QString, int, int, int)));
	QDBusConnection::systemBus().call(QDBusMessage::createMethodCall(MCE_SERVICE, MCE_REQUEST_PATH, MCE_REQUEST_IF, MCE_ACCELEROMETER_DISABLE_REQ));
}


void MaemoOrientation::orientationUpdate(const QString &rotation, const QString &/*stand*/, const QString &/*face*/, int /*x*/, int /*y*/, int /*z*/) {
	if(portrait and rotation=="landscape") {
		portrait = false;
		emit orientationChanged(portrait);
	} else if(!portrait and rotation=="portrait") {
		portrait = true;
		emit orientationChanged(portrait);
	}
}

