#ifndef GPSPOSITION_H
#define GPSPOSITION_H

#include <qmobilityglobal.h>
#include <qgeopositioninfosource.h>
#include <qgeosatelliteinfosource.h>
#include <qnmeapositioninfosource.h>
#include <qgeopositioninfo.h>
#include <qnetworkconfigmanager.h>
#include <qnetworksession.h>

QTM_USE_NAMESPACE

class GPSPosition : public QObject
{
    Q_OBJECT
public:
    static GPSPosition& getInstance();
    qreal getLatitude() const;
    qreal getLongitude() const;
    QGeoCoordinate getCoordinate() const;
    void setTolerance(qreal newTolerance);

signals:
    void movedTolerance();

public slots:
    void requestUpdate();

private slots:
    void onPositionUpdated(QGeoPositionInfo);

private:
    GPSPosition(QObject *parent = 0);
    QGeoPositionInfoSource * location;
    QGeoCoordinate coordinate;
    QGeoCoordinate lastEmitted;
    qreal tolerance;
};

#endif // GPSPOSITION_H
