/*
 * StationDetail.cpp
 *
 *  Created on: Nov 3, 2010
 *      Author: Thomas Schwery
 */

#include "StationDetail.h"

StationDetail::StationDetail(Station * station, QWidget *parent)
    : QWidget(parent)
{
#ifdef  Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    setWindowFlags(windowFlags() | Qt::Window);
    setWindowTitle("BiciMobile - " + station->getName());

    QVBoxLayout * layout = new QVBoxLayout(this);

    layout->addLayout(station->getLayout());

    layout->addStretch();

    MapWidget * map = new MapWidget(station->getCoordinate(), GPSPosition::getInstance().getCoordinate(), this);

    QHBoxLayout * mapLayout = new QHBoxLayout();
    mapLayout->addStretch();
    mapLayout->addWidget(map);
    mapLayout->addStretch();

    layout->addLayout(mapLayout);
}

StationDetail::~StationDetail() {
    // TODO Auto-generated destructor stub
}
