/*
 * StationsState.cpp
 *
 *  Created on: Nov 3, 2010
 *      Author: Thomas Schwery
 */

#include "StationsState.h"

StationsState::StationsState() {
    stations = new QMap<QString, Station*>();
    sortType = numerical;
}

StationsState::~StationsState() {
    QMap<QString, Station*>::iterator i;
    for (i=stations->begin(); i!=stations->end(); ++i) {
        delete (*i);
    }
    delete stations;
}

void StationsState::setSortType(StationSorting sorting) {
    sortType = sorting;
}

void StationsState::setSortType(QString sorting) {
    if (sorting == "name") {
        sortType = alpha_name;
    } else if (sorting == "network") {
        sortType = alpha_network;
    } else if (sorting == "numeric") {
        sortType = numerical;
    } else {
        sortType = distance_user;
    }
}

QMap<QString, Station*> * StationsState::getStationMap() {
    return stations;
}

QList<Station*> * StationsState::getStationList() {
    QList<Station*> * stationsList = new QList<Station*>(stations->values());
    if (sortType == distance_user) qSort(stationsList->begin(), stationsList->end(), compareDistance);
    if (sortType == alpha_name) qSort(stationsList->begin(), stationsList->end(), compareName);
    if (sortType == alpha_network) qSort(stationsList->begin(), stationsList->end(), compareNetwork);
    if (sortType == numerical) qSort(stationsList->begin(), stationsList->end(), compareNumber);
    return stationsList;
}


void StationsState::setStations(QMap<QString, Station*>* updatedStations) {
    QMap<QString, Station*>::iterator i;
    for (i=stations->begin(); i!=stations->end(); ++i) {
        delete (*i);
    }
    delete stations;
    stations = updatedStations;
}

bool StationsState::compareDistance(Station *& s1, Station *& s2) {
    QGeoCoordinate s1Coordinates(s1->getLatitude(), s1->getLongitude());
    QGeoCoordinate s2Coordinates(s2->getLatitude(), s2->getLongitude());
    QGeoCoordinate userCoordinates(GPSPosition::getInstance().getLatitude(), GPSPosition::getInstance().getLongitude());
    return (s1Coordinates.distanceTo(userCoordinates)) < (s2Coordinates.distanceTo(userCoordinates));
}

bool StationsState::compareName(Station *& s1, Station *& s2) {
    QString code1 = s1->getName().split(" ").at(1);
    QString code2 = s2->getName().split(" ").at(1);
    return code1 < code2;
}

bool StationsState::compareNetwork(Station *& s1, Station *& s2) {
    QString code1 = s1->getNetwork();
    QString code2 = s2->getNetwork();
    if (code1 == code2) {
        return compareNumber(s1, s2);
    }
    return code1 < code2;
}

bool StationsState::compareNumber(Station*& s1, Station*& s2) {
    int code1 = s1->getName().split(" ").at(0).toInt();
    int code2 = s2->getName().split(" ").at(0).toInt();
    return code1 < code2;
}
