/*
 * StationDetail.cpp
 *
 *  Created on: Nov 3, 2010
 *      Author: Thomas Schwery
 */

#include "StationDetail.h"

StationDetail::StationDetail(Station * station, QWidget *parent)
    : QWidget(parent)
{
#ifdef  Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    setWindowFlags(windowFlags() | Qt::Window);
    setWindowTitle("BiciMobile - " + station->getName());

    QVBoxLayout * layout = new QVBoxLayout(this);

    layout->addLayout(station->getLayout());

    //QScrollArea * scroll = new QScrollArea(this);
    MapWidget * map = new MapWidget(station->getCoordinate(), GPSPosition::getInstance().getCoordinate(), this);

    //scroll->setWidget(map);
    //scroll->ensureVisible(map->geometry().width()/2, map->geometry().width()/2);
    //layout->addWidget(scroll);
    layout->addWidget(map);

    //setLayout(layout);
}

StationDetail::~StationDetail() {
    // TODO Auto-generated destructor stub
}
