/*
 * Station.cpp
 *
 *  Created on: Nov 3, 2010
 *      Author: Thomas Schwery
 */

#include "Station.h"

Station::Station(QString name, QString network, float gpsX, float gpsY, int freeBikes, int freeStations) {
    this->name = name;
    this->network = network;
    this->xPosition = gpsX;
    this->yPosition = gpsY;
    this->freeBikes = freeBikes;
    this->freeStations = freeStations;
}

Station::~Station() {
    // TODO Auto-generated destructor stub
}

QPushButton * Station::getButton() {
    QPushButton *cb = new QPushButton(QString(""));

    QString infoText = "";
    infoText += "(" + network + ")";
    infoText += "Bikes:";
    infoText += QString("%1").arg(freeBikes);
    infoText += ", Stations:";
    infoText += QString("%1").arg(freeStations);

    QLabel * label = new QLabel(infoText);
    QLabel * label2 = new QLabel(name);

    QHBoxLayout * layout = new QHBoxLayout(cb);

    layout->addWidget(label);
    layout->addWidget(label2);

    cb->setLayout(layout);

#ifndef Q_WS_MAEMO_5
    cb->adjustSize();
#endif

    return cb;
}

qreal Station::getLatitude() const {
    return qreal(xPosition);
}

qreal Station::getLongitude() const {
    return qreal(yPosition);
}

QGeoCoordinate Station::getCoordinate() const {
    return QGeoCoordinate(xPosition, yPosition);
}

QLayout * Station::getLayout() {
    QVBoxLayout * vbox = new QVBoxLayout();

    QString label = "Station name: ";
    label += name;
    QLabel * labelName = new QLabel(label);

    QString label2 = "Station network: ";
    label2 += network;
    QLabel * labelNetwork = new QLabel(label2);

    QString label3 = "Available bikes: ";
    label3 += QString("%1").arg(freeBikes);
    QLabel * labelBikes = new QLabel(label3);

    QString label4 = "Available stations: ";
    label4 += QString("%1").arg(freeStations);
    QLabel * labelStations = new QLabel(label4);

    vbox->addWidget(labelName);
    vbox->addWidget(labelNetwork);
    vbox->addWidget(labelBikes);
    vbox->addWidget(labelStations);

    vbox->addStretch(1000);

    return vbox;
}

QString Station::getName() const {
    return name;
}

QString Station::getNetwork() const {
    return network;
}

int Station::getFreeBikes() const {
    return freeBikes;
}

int Station::getFreeStations() const {
    return freeStations;
}

QTextStream &operator<<(QTextStream &out, const Station &station) {
    out << station.getName() << "(" << station.getNetwork() << ") - Bikes:" << station.getFreeBikes() << ", Stations:" << station.getFreeStations();
    return out;
}
