{$include valkyrie.inc}
unit vwadfile;
{$H+}
interface
uses vdata,vnode, vstream, vgzstream, vutil;

type TDataElement = class(TVObject)
       constructor Init; virtual; abstract;
       constructor Load(WAD : TInputInterfaceStream); virtual; abstract;
       procedure Parse(ISt : TTextInputStream); virtual; abstract;
       procedure Write(WAD : TOutputInterfaceStream); virtual; abstract;
     end;

type TDataContainer = class(TVObjArray)
       DataType : Class of TDataElement;
       procedure Read(WAD : TInputInterfaceStream);
       procedure WriteAll(WAD : TOutputInterfaceStream; IDNum : Byte);
     end;

type

{ TData }

TData = class(TVObjArray)
       procedure LoadWAD(const Filename : string);
       procedure Parse(const Filename : string);
       private
       procedure Parse(ISt : TTextInputStream);
       procedure Read(WAD : TInputInterfaceStream);
       procedure Write(WAD : TOutputInterfaceStream);
     end;
     
implementation

uses SysUtils;

{ TData }

procedure TData.LoadWAD(const Filename : string);
var WAD : TGZFileInputStream;
begin
  WAD := TGZFileInputStream.Open(FileName);
  Read(WAD);
  WAD.Close;
end;

procedure TData.Parse(const Filename : string);
var ISt : TTextInputStream;
begin
  ISt := TTextInputStream.Open(FileName);
  Parse(ISt);
  ISt.Close;
end;

procedure TData.Parse(ISt : TTextInputStream);
var str, cmd, par : string;
    cnt : Byte;
begin
  repeat
    str := Trim(ISt.ReadString);
    
    if str[1]    = '#' then Continue;
    if length(str) < 2 then Continue;

    cmd := UpCase(Parameter(str,1,':'));
    par := Parameter(str,2,':');
  until False;
end;

procedure TData.Read(WAD : TInputInterfaceStream);
var TypeByte : Byte;
begin
  TypeByte := WAD.ReadByte;
  while TypeByte <> 0 do
  begin
    if Objects[TypeByte] <> nil then
      TDataContainer(Objects[TypeByte]).Read(WAD)
    else CritError('Unknown/unregistered DataType #'+IntToStr(TypeByte)+'!');
    TypeByte := WAD.ReadByte;
  end;
end;

procedure TData.Write(WAD : TOutputInterfaceStream);
var Counter : Word;
begin
  for Counter := 1 to MaxSize do
    if Objects[Counter] <> nil then
      TDataContainer(Objects[Counter]).WriteAll(WAD,Counter);
  WAD.WriteByte(0);
end;

{ TDataContainer }

procedure TDataContainer.Read(WAD : TInputInterfaceStream);
var OID : Word;
begin
  OID := WAD.ReadWord;
  if Objects[OID] = nil then
    Objects[OID] := DataType.Load(WAD)
  else CritError('Trying to redefine ID#'+IntToStr(OID)+'!');
end;

procedure TDataContainer.WriteAll(WAD : TOutputInterfaceStream; IDNum : Byte);
var Counter : Word;
begin
  for Counter := 1 to MaxSize do
    if Objects[Counter] <> nil then
    begin
      WAD.WriteByte(IDNum);
      WAD.WriteWord(Counter);
      TDataElement(Objects[Counter]).Write(WAD);
    end;
end;

end.

