// @abstract(Valkyrie Simple Roguelike Skeleton -- Map Unit)
// @author(Kornel Kisielewicz <kisiel@fulbrightweb.org>)
// @lastmod(Jan 23, 2006)
//
// This is the map unit. It introduces map data, and the map handling TNode -
// TMap. It also defines the method to draw the map.
//
// This piece of code I release to the PUBLIC DOMAIN.

{$INCLUDE valkyrie.inc}
unit srmap;
interface
uses vnode, voutput, srentity;

// The MapTile -- a definition of the Cell types.
type TMapTile = record
                  Picture  : Char;
                  Color    : Byte;
                  Passable : Boolean;
                  Name     : string[20];
                end;

// Tile Data
const MapTiles : array[0..1] of TMapTile = (
            ( Picture : '.'; Color : LightGray; Passable : True;  Name : 'floor';),
            ( Picture : '#'; Color : DarkGray;  Passable : False; Name : 'wall'; )
            );
            
// For accessing the MapTiles array
const TILEFLOOR = 0;
      TILEWALL  = 1;

// Wether the player has said "Quit".
var Finished : Boolean = False;

// A MapCell -- each point of the map has such a record
type TMapCell = record
                  Tile    : Byte;    // The Tile that is on the cell (index of
                                     // MapTiles array)
                  Entity  : TEntity; // The entity that is on the cell (or nil
                                     // if none).
                end;

// Our map class.
type TMap = class(TNode)
              // A map (2D array) of cells
              Cells : array[1..80,1..20] of TMapCell;
              constructor Init;
              procedure Draw;
            end;


implementation

constructor TMap.Init;
var x,y : byte;
begin
  inherited Create;                     // MANDATORY inherited initialization
  for x := 1 to 80 do
    for y := 1 to 20 do               // for each cell of the map
    begin
      Cells[x,y].Tile   := TILEFLOOR; // set it to floor...
      Cells[x,y].Entity := nil;       // ... on which no one stands.
    end;

  for x := 1 to 80 do                 // Now...
  begin
    Cells[x,1].Tile  := TILEWALL;     // Draw the Northern wall
    Cells[x,20].Tile := TILEWALL;     // Draw the Southern wall
  end;

  for y := 2 to 19 do                 // And...
  begin
    Cells[1,y].Tile  := TILEWALL;     // Draw the Western wall
    Cells[80,y].Tile := TILEWALL;     // Draw the Eastern wall
  end;
end;

procedure TMap.Draw;
var x,y : byte;
begin
  for x := 1 to 80 do
    for y := 1 to 20 do               // For each cell of the map
      with Cells[x,y] do              // Look at the Cell
        if Entity <> nil              // If it is a entity
          then Output.DrawChar(x,y,Entity.Color,Entity.Picture)
                                      // Draw the entity
          
          else Output.DrawChar(x,y,MapTiles[Tile].Color,MapTiles[Tile].Picture);
                                      // Draw the underlying Tile.
end;
end.
