// @abstract(Valkyrie Simple Roguelike Skeleton -- Main Unit)
// @author(Kornel Kisielewicz <kisiel@fulbrightweb.org>)
// @lastmod(Jan 23, 2006)
//
// This is the main unit. It has the main game system, and the root to all
// the program's nodes -- TGame.
//
// This piece of code I release to the PUBLIC DOMAIN.

{$INCLUDE valkyrie.inc}
unit srmain;
interface
uses vsystems, vsystem, vinput, voutput, vtinput, vtoutput, srmap, srplayer;

// The main Game class. It is the root of all TNode classes in our game. Holds
// shortcuts (pointers) to the Map and Player object.
type TGame = class(TSystem)
               // Pointer to the current map
               Map    : TMap;
               // Pointer to player
               Player : TPlayer;
               constructor Init;  overload;
               procedure   Run;
               destructor  Done;  overload;
             end;

// TGame singleton
var Game : TGame = nil;

implementation

constructor TGame.Init;
begin
  inherited Create;                           // MANDATORY inherited initialization
  Systems.Add(Input ,TTextModeInput.Create);  // Initialization of the input system
  Systems.Add(Output,TTextModeOutput.Create); // Initialization of the output system
  //Output.EnableColor;                       // Enabling '@'-escaped colours
  Map := TMap.Create;                         // Initialization of the map
  Add(Map);                                 // Adding Map to Game (Map is now it's child)
  Player := TPlayer.Create;                   // Player initialization
  Map.Add(Player);                          // Adding player to map.
  Player.Move(3,3);                         // MANDATORY moving the player to a
                                            // valid location
end;

procedure TGame.Run;
begin
  repeat             // Repeat
    Player.Action;   // Query the action from the player
  until Finished;    // Until player has pressed ESC
end;


destructor  TGame.Done;
begin
  inherited Destroy;    // MANDATORY iherited Deinitialization
end;

end.

