// @abstract(Valkyrie Simple Roguelike Skeleton - Entity Unit)
// @author(Kornel Kisielewicz <kisiel@fulbrightweb.org>)
// @lastmod(Jan 23, 2006)
//
// This is the entity unit. It introduces TEntity -- a base class for both the
// player and enemies.
//
// This piece of code I release to the PUBLIC DOMAIN.

{$include valkyrie.inc}
unit srentity;
interface
uses vnode, voutput;

// Our base abstract Entity class
type TEntity = class(TNode)
       protected
       // The position of the entity on the map
       xpos,ypos : Byte;
       public
       constructor Init;
       procedure Action; virtual; abstract;
       procedure Move(targetx,targety : Byte);
       property X : Byte read xpos;
       property Y : Byte read ypos;
       // It's ASCII picture
       Picture : char;
       // It's color
       Color   : byte;
     end;

implementation
uses srmap;

constructor TEntity.Init;
begin
  inherited Create;   // MANDATORY initialization
  xpos := 1;        // Settin the x, y to invalid, so we must redefine them
  ypos := 1;
  color := Green;   // Setting the color...
  picture := '@';   // .. and picture (ain't I pretty? ^_^)
end;

procedure TEntity.Move(targetx,targety : Byte);
begin
  with TMap(Parent) do
  begin
    Cells[xpos,ypos].Entity := nil;      // remove from the old position
    xpos := targetx;                     // set new...
    ypos := targety;                     // .. coordinates
    Cells[xpos,ypos].Entity := Self;     // place on new position.
  end;
end;

end.
