{$include valkyrie.inc}
unit doomdata;
interface
uses SysUtils, vutil,vstream,vwadfile,vdata;

const NAMELENGTH  = 24;
      IDLENGTH    = 12;
      MAXITEMARGS = 14;
      
type TItemArgs = array[1..MAXITEMARGS] of Byte;

type

{ TRaceData }

TRaceData = class(TDataElement)
       Name, mname : string[NAMELENGTH];
       id          : string[IDLENGTH];
       picture     : Char;
       color       : Byte;
       ST,DX       : Byte;
       HPMax       : Byte;
       Speed       : Byte;
       ExpVal      : Word;
       BasLev      : Byte;
       MaxLev      : Byte;
       Weapon      : Byte;
       Group       : Byte;
       NWep        : Byte;
       Armor       : Byte;
       Flags       : TFlags;
       constructor Init; override;
       constructor Load(WAD : TInputInterfaceStream); override;
       procedure Parse(ISt : TTextInputStream); override;
       procedure Write(WAD : TOutputInterfaceStream); override;
     end;

type

{ TItemData }

TItemData  = class(TDataElement)
       Name   : string[NAMELENGTH];
       id     : string[IDLENGTH];
       IType  : Char;
       Rarity : Byte;
       Args   : TItemArgs;
       Lev    : Byte;
       Color  : byte;
       constructor Init; override;
       constructor Load(WAD : TInputInterfaceStream); override;
       procedure Parse(ISt : TTextInputStream); override;
       procedure Write(WAD : TOutputInterfaceStream); override;
     end;


type

{ TStringData }

TStringData = class(TDataElement)
       Data : TStrArray;
       constructor Init; override;
       constructor Load(WAD : TInputInterfaceStream); override;
       procedure Parse(ISt : TTextInputStream); override;
       procedure Write(WAD : TOutputInterfaceStream); override;
       destructor Done;
     end;

type TDoomData = class(TData)
       constructor Init;
     end;
     
const DATA_RACES = 1;
      DATA_ITEMS = 2;
      DATA_STRINGS = 3;


implementation

{ TRace }

constructor TRaceData.Init;
begin
  name    := 'error';
  mname   := 'error';
  id      := 'error';
  picture := 'E';
  color   := 7;
  ST      := 10;
  DX      := 10;
  HPMax   := 10;
  Speed   := 100;
  ExpVal  := 0;
  BasLev  := 0;
  MaxLev  := 20;
  Weapon  := 0;
  Group   := 0;
  NWep    := 0;
  Armor   := 0;
  Flags   := [];
end;

constructor TRaceData.Load(WAD : TInputInterfaceStream);
begin
  name    := WAD.ReadString;
  mname   := WAD.ReadString;
  id      := WAD.ReadString;
  picture := WAD.ReadChar;
  color   := WAD.ReadByte;
  ST      := WAD.ReadByte;
  DX      := WAD.ReadByte;
  HPMax   := WAD.ReadByte;
  Speed   := WAD.ReadByte;
  ExpVal  := WAD.ReadWord;
  BasLev  := WAD.ReadByte;
  MaxLev  := WAD.ReadByte;
  Weapon  := WAD.ReadByte;
  Group   := WAD.ReadByte;
  NWep    := WAD.ReadByte;
  Armor   := WAD.ReadByte;
  Flags   := WAD.ReadFlags;
end;

procedure TRaceData.Parse(ISt : TTextInputStream);
var str, cmd, par : string;
    cnt : byte;
begin
  repeat
    str := Trim(ISt.ReadString);
    if str[1]    = '#' then Continue;
    if length(str) < 2 then Continue;
    
    cmd := UpCase(Parameter(str,1,':'));
    par := Parameter(str,2,':');

    if cmd = 'END' then Break;

         if cmd = 'NAME'    then name := par
    else if cmd = 'MNAME'   then mname := par
    else if cmd = 'ID'      then id := par
    else if cmd = 'PICTURE' then picture := par[1]
    else if cmd = 'COLOR'   then color := StrToInt(par)
    else if cmd = 'ST'      then ST      := StrToInt(par)
    else if cmd = 'DX'      then DX      := StrToInt(par)
    else if cmd = 'HPMAX'   then HPMax   := StrToInt(par)
    else if cmd = 'SPEED'   then Speed   := StrToInt(par)
    else if cmd = 'EXPVAL'  then ExpVal  := StrToInt(par)
    else if cmd = 'BASLEV'  then BasLev  := StrToInt(par)
    else if cmd = 'MAXLEV'  then MaxLev  := StrToInt(par)
    else if cmd = 'WEAPON'  then Weapon  := StrToInt(par)
    else if cmd = 'GROUP'   then Group   := StrToInt(par)
    else if cmd = 'NWEP'    then NWep    := StrToInt(par)
    else if cmd = 'ARMOR'   then Armor   := StrToInt(par)
    else if cmd = 'FLAGS'   then
    begin
      cnt := 1;
      repeat
        Include(Flags,StrToInt(par));
        inc(cnt);
        par := Parameter(str,1+cnt,':');
      until par = '';
    end
    else CritError('Unknown command in '+ISt.getName+' on line '+IntToStr(ISt.getLine)+'!');

  until cmd = 'END'
end;

procedure TRaceData.Write(WAD : TOutputInterfaceStream);
begin
  WAD.WriteString(name);
  WAD.WriteString(mname);
  WAD.WriteString(id);
  WAD.WriteChar(picture);
  WAD.WriteByte(color);
  WAD.WriteByte(ST);
  WAD.WriteByte(DX);
  WAD.WriteByte(HPMax);
  WAD.WriteByte(Speed);
  WAD.WriteWord(ExpVal);
  WAD.WriteByte(BasLev);
  WAD.WriteByte(MaxLev);
  WAD.WriteByte(Weapon);
  WAD.WriteByte(Group);
  WAD.WriteByte(NWep);
  WAD.WriteByte(Armor);
  WAD.WriteFlags(Flags);
end;

{ TDoomData }

constructor TDoomData.Init;
begin
  inherited Create;
  Objects[DATA_RACES] := TDataContainer.Create;
  TDataContainer(Objects[DATA_RACES]).DataType := TRaceData;
  Objects[DATA_ITEMS] := TDataContainer.Create;
  TDataContainer(Objects[DATA_ITEMS]).DataType := TItemData;
  Objects[DATA_STRINGS] := TDataContainer.Create;
  TDataContainer(Objects[DATA_STRINGS]).DataType := TStringData;

end;

{ TItemData }

constructor TItemData.Init;
var Counter : byte;
begin
  Name   := 'error';
  id     := 'error';
  IType  := 'X';
  for Counter := 1 to MAXITEMARGS do Args[Rarity] := 0;
  Rarity := 1;
  Lev    := 0;
  Color  := 7;
end;

constructor TItemData.Load(WAD : TInputInterfaceStream);
begin
  Name   := WAD.ReadString;
  id     := WAD.ReadString;
  IType  := WAD.ReadChar;
  Rarity := WAD.ReadByte;
  WAD.Read(SizeOf(Args),@Args);
  Lev    := WAD.ReadByte;
  Color  := WAD.Readbyte;
end;

procedure TItemData.Parse(ISt : TTextInputStream);
var str, cmd, par : string;
    cnt : Byte;
begin
  repeat
    str := Trim(ISt.ReadString);
    if str[1]    = '#' then Continue;
    if length(str) < 2 then Continue;

    cmd := UpCase(Parameter(str,1,':'));
    par := Parameter(str,2,':');

    if cmd = 'END' then Break;

         if cmd = 'NAME'    then name := par
    else if cmd = 'ID'      then id := par
    else if cmd = 'ITYPE'   then itype := par[1]
    else if cmd = 'RARITY'  then rarity  := StrToInt(par)
    else if cmd = 'COLOR'   then color   := StrToInt(par)
    else if cmd = 'LEV'     then lev     := StrToInt(par)
    else if cmd = 'ARGS'    then
    begin
      cnt := 1;
      repeat
        Args[cnt] := StrToInt(par);
        inc(cnt);
        par := Parameter(str,1+cnt,':');
      until par = '';
    end
    else CritError('Unknown command in '+ISt.getName+' on line '+IntToStr(ISt.getLine)+'!');

  until cmd = 'END'
end;

procedure TItemData.Write(WAD : TOutputInterfaceStream);
begin
  WAD.WriteString(Name);
  WAD.WriteString(id);
  WAD.WriteChar(IType);
  WAD.WriteByte(Rarity);
  WAD.Write(SizeOf(Args),@Args);
  WAD.WriteByte(Lev);
  WAD.WriteByte(Color);
end;

constructor TStringData.Init;
begin
  Data := TStrArray.Create(10);
end;

constructor TStringData.Load(WAD : TInputInterfaceStream);
begin
  Data := TStrArray.Create(10);
  Data.Read(WAD);
end;

procedure TStringData.Parse(ISt : TTextInputStream);
var str : string;
    cnt : DWord;
begin
  cnt := 0;
  repeat
    str := Trim(ISt.ReadString);
    if str[1]    = '#' then Continue;
    if length(str) < 2 then Continue;
    if length(str) = 3 then if UpCase(str) = 'END' then Break;
    Inc(cnt);
    Data[cnt] := str;
  until False;
end;

procedure TStringData.Write(WAD : TOutputInterfaceStream);
begin
  Data.Write(WAD);
end;

destructor TStringData.Done;
begin
  Data.Destroy;
end;

end.

