{$include valkyrie.inc}
program dsf;
uses SysUtils, vsystems,vsystem,vnode,voutput,vtoutput,vinput,vtinput,vtextut;

const MaxWeapons = 9;

const WeaponNames : array[1..MaxWeapons] of string =
      ('Fist','Pistol','Shotgun','Chansaw','Chain gun','Super Shotgun','Rocket Launcher','Plasma Gun','BFG9000');
      WeaponDamage : array[1..MaxWeapons] of Byte = (1,1,2,2,3,3,4,4,5);
      StanceNames  : array[1..3] of String = ('Driven','Purifier','Survivor');
      Actions      :

type

{ TPlayer }

TPlayer = class(TNode)
    Name      : AnsiString;
    Weapons   : array[1..MaxWeapons] of Boolean;
    OHealth   : Integer;
    OTimeLeft : Integer;
    OBodyCount: Integer;
    Health    : Integer;
    TimeLeft  : Integer;
    BodyCount : Integer;
    Stance    : Byte;
    constructor Create; override;
  end;

{ TGame }

TGame = class(TSystem)
  Player   : TPlayer;
  Room     : Byte;
  Level    : Byte;
  Keys     : Byte;
  RoomType : Byte;
  constructor Create;
  procedure DrawStatus;
  procedure Run;
end;

{ TGame }

constructor TGame.Create;
begin
  inherited Create;
  TEXTUIBOLDCOLOR           := Yellow;
  TEXTUINORMALCOLOR         := LightRed;
  Player := TPlayer.Create;
  Add(Player);
  Room   := 0;
  Level  := 0;
  Keys   := 0;
end;

procedure TGame.DrawRoom;
function RoomDesc : string;
  case RoomType of
    1 : Exit('Open area with monsters. @/Choose your Action!');
    2 : Exit('Corridor with monsters. @/Choose your Action!');
    3 : Exit('Room with monsters. @/Choose your Action!');
    4 : Exit('Hazard/puzzle area: Stuck! @/Choose your Action!');
    5 : Exit('Room with monsters and window. @/If you choose to exit through the window, @/you can choose the next room from two rolls.@/Choose your Action!');
    6 : Exit('Horrific scene of demons torturing humans. @/Too many enemies!');
    7 : Exit('Secret chamber opens!');
    8 : Exit('A Teleporter sends you into room with monsters. @/Choose your Action!');
    9 : Exit('Exit found! You move to next Level!');
  end;
begin
  Output.DrawString(3,3 ,YELLOW,RoomDesc);
  
end;

procedure TGame.DrawStatus;
function WeaponStr : string;
var c : Byte;
begin
  WeaponStr := '';
  for c := 1 to MaxWeapons do
    if Player.Weapons[c] then WeaponStr += '@y'+IntToStr(c)
                         else WeaponStr += '@d'+IntToStr(c);
end;
begin
  Output.DrawString(53,1 ,RED,'| ');
  Output.DrawString(53,2 ,RED,'| Name      : @y@1',[Player.Name]);
  Output.DrawString(53,3 ,RED,'| ');
  Output.DrawString(53,4 ,RED,'| Health    : @y@1',[Player.Health]);
  Output.DrawString(53,5 ,RED,'| Time Left : @y@1',[Player.TimeLeft]);
  Output.DrawString(53,6 ,RED,'| Bodycount : @y@1',[Player.Bodycount]);
  Output.DrawString(53,7 ,RED,'| ');
  Output.DrawString(53,8 ,RED,'| Stance    : @y@1',[StanceNames[Player.Stance]]);
  Output.DrawString(53,9 ,RED,'|                 ');
  Output.DrawString(53,10,RED,'| Weapons   : @1',[WeaponStr]);
  Output.DrawString(53,11,RED,'|                 ');
  Output.DrawString(53,12,RED,'| Keys      : @1',[Keys]);
  Output.DrawString(53,13,RED,'| Level     : @1',[Level]);
  Output.DrawString(53,14,RED,'| Room      : @1',[Room]);
  Output.DrawString(53,15,RED,'|                 ');
  Output.DrawString(53,16,RED,'\-------------------------');
  Output.Update;
end;

procedure TGame.Run;
begin


end;

{ TPlayer }

constructor TPlayer.Create;
  function NumberField(x,y,Max : byte) : Byte;
  var TEMP,RES : String;
  begin
    TEMP := TEXTUIEDITCHARS;
    TEXTUIEDITCHARS := '0123456789';
    repeat
      RES := TextInputField(x,y,3);
      if RES = '' then RES := '1';
      NumberField := StrToInt(RES);
    until (NumberField <= Max) and (NumberField > 0);
    TEXTUIEDITCHARS := TEMP;
  end;
var Points,Cnt : Byte;
begin
  inherited Create;
  Output.DrawString(2,21,RED,'-------------------------------------------------------------------------------');
  Output.DrawString(4,22,YELLOW,'Enter the name for your marine');
  Output.DrawString(3,3,RED,'Name      : ');
  Output.Update;
  Name := TextInputField(15,3,20);
  if Name = '' then Name := 'Sandy';
  Output.DrawString(4,22,YELLOW,'Allocate 12 points between @<Health@>, @<Time Left@> and @<Bodycount@>.');
  Output.DrawString(4,23,YELLOW,'Allocate at least one point to each.');
  Points := 12;
  
  Output.DrawString(4,24,YELLOW,IntToStr(Points)+' points left.   ');
  Output.DrawString(3,5,RED,'Health    : ');
  Health := NumberField(15,5,Points-2);
  Points -= Health;

  Output.DrawString(4,24,YELLOW,IntToStr(Points)+' points left.   ');
  Output.DrawString(3,6,RED,'Time Left : ');
  TimeLeft := NumberField(15,6,Points-1);
  Points -= TimeLeft;

  Output.DrawString(4,24,YELLOW,IntToStr(Points)+' points left.   ');
  Output.DrawString(3,7,RED,'Bodycount : ');
  Bodycount := NumberField(15,7,Points);
  Points -= BodyCount;

  Output.DrawString(3,9,RED,'Stance    : ');
  Output.MoveCursor(15,9);
  Output.DrawString(4,22,YELLOW,'Choose a stance - @<1@> : Driven (keep high Time Left),          @/@<2@> : Purifier (keep high Bodycount), @<3@> : Survivor (keep high Health)');
  Output.DrawString(4,24,YELLOW,'                  ');
  Output.Update;

  Stance := Input.GetKey([Ord('1')..Ord('3')]) - Ord('1') + 1;;
  Output.DrawString(15,9,YELLOW,StanceNames[Stance]);

  Output.Update;
  
  OHealth   := Health;
  OTimeLeft := TimeLeft;
  OBodyCount:= BodyCount;

  for Cnt := 1 to MaxWeapons do Weapons[Cnt] := True;
end;
  
var Game : TGame;

begin
  Systems.Add(Output,TTextModeOutput.Create);
  Systems.Add(Input,TTextModeInput.Create);
  Systems.Add(Game,TGame.Create);
  Game.Run;
end.

