{$include valkyrie.inc}
program consoletest;

{$H+}

uses
  Classes, SysUtils, vnode, vutil, voutput, vsystem, vsystems,
  vinput, vtinput, vtoutput, vtextut, vlua, lua, lauxlib
  { add your units here }, vconsole;

var ValkLua : TLua;

{ TConsoleWindow }

type TTextConsoleWindow = class(TConsoleWindow)
  // Initialization
  constructor Create(nBufferSize : Word = 1000; const nOptions : TFlags32 = []); override;
  // Draws the messages to screen.
  procedure Draw; override;
  // Reads the input
  function ReadInput : string; override;
  // Saves the screen
  procedure SaveScreen; override;
  // Restores the screen
  procedure RestoreScreen; override;
  // deinitialization
  destructor Destroy; override;
  private
  ScreenDump : TScreenDump;
  SavedX     : Word;
end;

function TTextConsoleWindow.ReadInput : string;
const SizeY = 10;
      PX = 3;
      PY = SizeY + 3;
var Key : byte;
    Str : string;
    CI  : Word;
    procedure Refresh;
    begin
      Output.ClearRect(PX,PY,PX+Width-1,PY);
      Output.PrintString(PX,PY,White,Str);
      Output.Update;
      Output.MoveCursor(PX+Length(Str),PY);
    end;

begin
  Output.ShowCursor;
  Str := '';
  CI := 0;
  Refresh;
  repeat
    Key := Input.GetKey;
    case Key of
      VKEY_UP   : if CI < CBufferSize+1 then begin Inc(CI); Str := GetCommand(CI); end;
      VKEY_DOWN : if CI > 1 then begin Dec(CI); Str := GetCommand(CI); end
                  else begin CI := 0; Str := ''; end;
      VKEY_BackSpace : if Length(Str) > 0 then
                         Delete(Str,Length(Str),1);
      VKEY_Enter : Key := VKEY_Escape;
      else if Pos(chr(key),TEXTUIEDITCHARS) <> 0 then
        if Length(Str) < Width-1 then
          Str := Str+chr(key);
    end;
    if Key = VKEY_F1 then Exit(Str);
    Refresh;
  until Key = VKEY_Escape;

  if Trim(Str) <> '' then Commands[CPosition] := Str;
  Inc(CPosition);
  if CPosition = CBufferSize then CPosition := 0;

  Exit(Str);
end;

procedure TTextConsoleWindow.SaveScreen;
begin
  if Output.inheritsFrom(TTextModeOutput) then
    TTextModeOutput(Output).CatchScreenDump(ScreenDump);
end;

procedure TTextConsoleWindow.RestoreScreen;
begin
  if Output.inheritsFrom(TTextModeOutput) then
    TTextModeOutput(Output).DrawScreenDump(ScreenDump);
end;

destructor TTextConsoleWindow.Destroy;
begin
  FreeMem(ScreenDump);
  inherited Destroy;
end;

constructor TTextConsoleWindow.Create(nBufferSize : Word;
  const nOptions : TFlags32);
begin
  inherited Create(nBufferSize, nOptions);
  GetMem(ScreenDump,ScreenSize*SizeOf(Word));
end;

procedure TTextConsoleWindow.Draw;
const SizeY = 10;
      PosX = 3;
      PosY = 2;
var cy : Word;
begin
  Output.ClearRect(PosX,PosY,PosX+Width-1,PosY+SizeY-1);
  for cy := 1 to SizeY do
    Output.DrawString(PosX,PosY+SizeY-cy,DarkGray,Get(cy));
end;


type

{ TLuaConsole }

TLuaConsole = class(TConsole)
  procedure Command(cmd : Ansistring); override;
end;

{ TLuaConsole }

procedure TLuaConsole.Command(cmd : Ansistring);
var Error : AnsiString;
begin
  cmd := Trim(cmd);
  if lua_dostring(ValkLua.LuaState,PChar(cmd)) <> 0 then
  begin
    Error := lua_tostring(ValkLua.LuaState,0);
    Print('@RError : '+Error);
    lua_pop(ValkLua.LuaState,1);
  end;
end;

var Console : TConsole;
    X,Y : Byte;

function LuaStr(L: Plua_State; stackNum : byte) : string;
begin
  if lua_isstring(L,stackNum) or lua_isnumber(L,stackNum) then
  begin
    LuaStr := lua_tostring(L, stackNum);
    //Delete(LuaStr,Length(LuaStr),1);
  end else Exit('');
end;


function lua_consoleprint(L: Plua_State): Integer; cdecl;
var n,i : byte;
begin
  n := lua_gettop(L);
  if n <> 0 then
  for i := 1 to n do
    Console.Print('@C'+LuaStr(L,i));
  Result := 0;
end;

begin
  Systems.Add(Output,TTextModeOutput.Create);
  Systems.Add(Input,TTextModeInput.Create);
  Systems.Add(Console,TLuaConsole.Create(TTextConsoleWindow.Create));
  ValkLua := TLua.Create;
  ValkLua.Register('print',@lua_consoleprint);
  Input.RegisterOverrideKey(VKEY_F1,Console);
  for x := 1 to 80 do for y := 1 to 25 do Output.DrawChar(x,y,Blue,'x');
  Output.Update;
  repeat
    x := Input.GetKey;
    Output.DrawString(2,25,LightBlue,' Key : '+PadSpace(Input.VCodeToString(x),60));
    Output.Update;
  until x = VKEY_ESCAPE;
  ValkLua.Destroy;
end.

