// @abstract(TextMode Toolkit for Valkyrie)
// @author(Kornel Kisielewicz <kisiel@fulbrightweb.org>)
// @created(Oct 14, 2006)
// @lastmod(Oct 14, 2006)
//
// TextMode utilities for Valkyrie. Placeholder for GUI functions until a
// text GUI is developed. Most of the code here is from a very old incarnation
// of the Valkyrie library, so it's neither nice, nor effective.
//
//  @html <div class="license">
//  This library is free software; you can redistribute it and/or modify it
//  under the terms of the GNU Library General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or (at your
//  option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT
//  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
//  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Library General Public License
//  for more details.
//
//  You should have received a copy of the GNU Library General Public License
//  along with this library; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//  @html </div>
{$INCLUDE valkyrie.inc}
unit vtextut;
interface
uses classes, vutil, vinput, vconsole, vrltools, voutput, vtextui, vui;

const TEXTUIBOLDCOLOR           : Byte   = White;
      TEXTUINORMALCOLOR         : Byte   = LightGray;
      TEXTUIINACTIVEBOLDCOLOR   : Byte   = Red;
      TEXTUIINACTIVENORMALCOLOR : Byte   = DarkGray;
      TEXTUIEDITCHARS     : string = '1234567890qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM!#$%^&*()_+-=[]{}\|;:''"<>,./?`~ ';
      TEXTUIVIEWERLINES          = 2048;

const MENU_ESCAPEALLOWED   = 1;
      MENU_BROWSEINACTIVE  = 2;


// TextMode version of the TMessages class from Roguelike Tools.
type TTextModeMessages = class(TMessages)
    // Creates a new message system. Pos and Size are used to place the Messages
    // on the textmode screen. BufferSize determines how many messages will be
    // stored by the system.
    constructor Create(nPosX, nPosY, nSizeX, nSizeY : Word; nBufferSize : Word = 1000; const nOptions : TFlags32 = []; const nMoreText : string = '@B[more]');
    // Prints a TTextViewer screen with recent messages.
    procedure ShowRecent;
  end;

// specialization for TTextMenu
type TTextMenuCallback = procedure(choice : Byte) of object;

// A text UI menu.
type TTextMenu = class(TUIMenu)
    // Initialize the menu at position xp,yp, with optionaly : a initial choice,
    // a callback to be run at each change and wether Escape can be pressed.
    constructor Create(x,y : byte; TerminationKeys : TKeyFilter = [VKEY_ENTER,VKEY_ESCAPE]; cback : TTextMenuCallback = nil; BrowseInactive : Boolean = False; initial : byte = 1); overload;
    protected
    procedure Update; override;
  end;

// A text UI input line.
type TTextInputLine = class(TTextUIInputLine)
    // Initialize the menu at position xp,yp, with optionaly : a initial choice,
    // a callback to be run at each change and wether Escape can be pressed.
    constructor Create(x,y,maxlen : byte);
    protected
    procedure Update; override;
  end;


//
type TTextViewer = class(TTextUIFullViewer)
    constructor Create(newTitle : AnsiString; noBars : Boolean = False);
    protected
    procedure Update; override;
  end;
  
type TTextConsoleWindow = class(TConsoleWindow)
  // Initialization
  constructor Create(nBufferSize : Word = 1000; const nOptions : TFlags32 = []); override;
  // Draws the messages to screen.
  procedure Draw; override;
  // Reads the input
  function ReadInput : string; override;
  // Saves the screen
  procedure SaveScreen; override;
  // Restores the screen
  procedure RestoreScreen; override;
  // deinitialization
  destructor Destroy; override;
  private
  ScreenDump : TScreenDump;
end;

// Creates and runs a text input field.
function TextInputField(px, py, len : Byte) : string;
function ExtendedTextInputField(px, py, len : Byte; var Str : string;
  BreakKeys : TKeyFilter = []) : Byte;

implementation
uses vtoutput, vds, sysutils, math;

constructor TTextModeMessages.Create(nPosX, nPosY, nSizeX, nSizeY: Word; nBufferSize: Word; const nOptions: TFlags32;
  const nMoreText: string);
begin
  inherited Create(TTextUIMessages, nPosX, nPosY, nSizeX, nSizeY, nBufferSize, nOptions, nMoreText);
end;

procedure TTextModeMessages.ShowRecent;
var View  : TTextViewer;
    Arr   : TStringArray;
    Cnt   : DWord;
begin
  Arr  := TStringArray.Create;
  for Cnt := Min(2000-1,Messages.Size) downto 0 do
     if Get(Cnt) <> '' then
       Arr.Push(Get(Cnt));
  View := TTextViewer.Create('Past messages viewer');
  View.SetArray( Arr );
  View.Recent;
  View.Run;

  FreeAndNil(Arr);
  FreeAndNil(View);
end;

{ TTextMenu }

constructor TTextMenu.Create(x, y: byte; TerminationKeys: TKeyFilter;
  cback: TTextMenuCallback; BrowseInactive: Boolean; initial: byte);
begin
  inherited Create(nil,TerminationKeys,cback,BrowseInactive,initial);
  Dimensions := NewRectXY(x,y,x-1,y-1);
end;

procedure TTextMenu.Update;
begin
  Draw;
  inherited Update;
end;

function TextInputField(px, py, len: Byte): string;
var InputLine : TTextInputLine;
begin
  InputLine := TTextInputLine.Create(px,py,len);
  InputLine.Run([VKEY_ENTER,VKEY_ESCAPE]);
  TextInputField := InputLine.Return;
  FreeAndNil(InputLine);
end;

function ExtendedTextInputField(px, py, len : Byte; var Str : string;
  BreakKeys : TKeyFilter = []) : Byte;
var InputLine : TTextInputLine;
begin
  InputLine := TTextInputLine.Create(px,py,len);
  InputLine.SetLine(Str);
  ExtendedTextInputField := InputLine.Run(BreakKeys);
  Str := InputLine.Return;
  FreeAndNil(InputLine);
end;

function TTextConsoleWindow.ReadInput : string;
var InputLine : TTextInputLine;
const SizeY = 10;
      PX = 3;
      PY = SizeY + 3;
var Key : Byte;
    CI  : Word;
begin
  InputLine := TTextInputLine.Create(px,py,74);
  CI := 0;
  repeat
    Key := InputLine.Run([VKEY_ENTER,VKEY_F1,VKEY_UP,VKEY_DOWN]);
    ReadInput := InputLine.Return;
    case Key of
      VKEY_UP     : if CI < CBufferSize+1 then begin Inc(CI); InputLine.SetLine(GetCommand(CI)); end;
      VKEY_DOWN   : if CI > 1 then begin Dec(CI); InputLine.SetLine(GetCommand(CI)); end
                    else begin CI := 0; InputLine.SetLine(''); end;
//      VKEY_Escape : begin CI := 0; ReadInput := ''; end;
    end;
  until (Key = VKEY_Enter) or (Key = VKEY_F1);
  FreeAndNil(InputLine);

  if Key = VKEY_F1 then Exit('');
  if Trim(ReadInput) <> '' then
  begin
    Commands[CPosition] := ReadInput;
    Inc(CPosition);
  end;
  if CPosition = CBufferSize then CPosition := 0;

end;

procedure TTextConsoleWindow.SaveScreen;
begin
  if Output.inheritsFrom(TTextModeOutput) then
    TTextModeOutput(Output).CatchScreenDump(ScreenDump);
end;

procedure TTextConsoleWindow.RestoreScreen;
begin
  if Output.inheritsFrom(TTextModeOutput) then
    TTextModeOutput(Output).DrawScreenDump(ScreenDump);
end;

destructor TTextConsoleWindow.Destroy;
begin
  FreeMem(ScreenDump);
  inherited Destroy;
end;

constructor TTextConsoleWindow.Create(nBufferSize : Word;
  const nOptions : TFlags32);
begin
  inherited Create(nBufferSize, nOptions);
  GetMem(ScreenDump,ScreenSize*SizeOf(Word));
end;

procedure TTextConsoleWindow.Draw;
const SizeY = 10;
      PosX = 3;
      PosY = 2;
var cy : Word;
begin
  Output.ClearRect(PosX,PosY,PosX+Width-1,PosY+SizeY-1);
  for cy := 1 to SizeY do
    Output.DrawString(PosX,PosY+SizeY-cy,DarkGray,Get(cy));
end;

{ TTextInputLine }

constructor TTextInputLine.Create(x, y,maxlen: byte);
begin
  inherited Create(nil,maxlen);
  Dimensions := NewRectXY(x,y,x+maxlen,y);
end;

procedure TTextInputLine.Update;
begin
  Draw;
  inherited Update;
end;

{ TTextViewer }

constructor TTextViewer.Create(newTitle: AnsiString; noBars : Boolean = False);
begin
  inherited Create(nil,noBars,newTitle);
end;

procedure TTextViewer.Update;
begin
  Draw;
  inherited Update;
end;

end.

