unit vsdlsurface;
{$include valkyrie.inc}
interface

uses Classes, vsdl, vutil, vnode, SDL, GL, GLU;

type

{ TSurface }

TSurface = class(TVObject)
  SDLSurface : PSDL_Surface;
  SDLRect    : TSDL_Rect;
  GLTexture  : GLuint;
  GLWidth    : GLFloat;
  GLHeight   : GLFloat;
  constructor Create(nwidth,nheight : Word; Alpha : Boolean = False);
  constructor Create(FileName : Ansistring; Alpha : Boolean = False);
  procedure RenderGL(Blended : Boolean = False);
  procedure SetColorKey(r,g,b : Byte);
  procedure DrawGL(x,y : DWord);
  procedure DrawGL;
  procedure Fill(color : TColor);
  procedure BlitSDLSurface(source : PSDL_Surface; x,y : Byte);
  procedure Blit(x, y : Byte);
  destructor Destroy; override;
end;

implementation

uses SDL_Image;

{ TSurface }

constructor TSurface.Create(nwidth,nheight : Word; Alpha : Boolean = False);
begin
  inherited Create;
  with SDL_GetVideoSurface^ do
    Self.SDLSurface := SDL_CreateRGBSurface(flags,nwidth,nheight,
//      ValkyrieSDL.BPP,format^.RMask,format^.GMask,format^.BMask,format^.AMask);
      32,format^.RMask,format^.GMask,format^.BMask,format^.AMask);
  if Alpha then SDLSurface := SDL_DisplayFormatAlpha(SDLSurface);
  SDLRect.x := 0;
  SDLRect.y := 0;
  SDLRect.w := nwidth;
  SDLRect.h := nheight;
  GLTexture := 0;
end;

constructor TSurface.Create(FileName : Ansistring; Alpha : Boolean = False);
begin
  inherited Create;
  SDLSurface := IMG_Load(PChar(Filename));
  SDLRect.x := 0;
  SDLRect.y := 0;
  SDLRect.w := SDLSurface^.w;
  SDLRect.h := SDLSurface^.h;
  GLTexture := 0;
  if Alpha then SDL_SetAlpha(SDLSurface, SDL_SRCALPHA, 0);
end;

procedure TSurface.RenderGL(Blended : Boolean = False);
var w, h    : Integer;
    image   : PSDL_Surface;
    area    : SDL_Rect;
    saved_flags : Uint32;
    saved_alpha : Uint8;
  function power_of_two(input : Integer) : Integer;
  begin
    power_of_two := 1;
    while power_of_two < input do power_of_two *= 2;
  end;
begin
  Log('RenderGL!');
  if GLTexture <> 0 then begin Log('Reredndering!'); glDeleteTextures(1,@GLTexture); end;
  // Use the surface width and height expanded to powers of 2
  w := power_of_two(SDLSurface^.w);
  h := power_of_two(SDLSurface^.h);
  GLWidth  := SDLSurface^.w / w;
  GLHeight := SDLSurface^.h / h;

  image := SDL_CreateRGBSurface( SDL_SWSURFACE, w, h, 32,
//#if SDL_BYTEORDER == SDL_LIL_ENDIAN /* OpenGL RGBA masks */
            $000000FF,
            $0000FF00,
            $00FF0000,
            $FF000000
{#else
            $FF000000,
            $00FF0000,
            $0000FF00,
            $000000FF
#endif}
  );

  if image = nil then
  begin
    Log('RenderGL: SDL_CreateRGBSurface returned nil!');
    Exit;
  end;

  //* Save the alpha blending attributes */
  saved_flags := SDLSurface^.flags and (SDL_SRCALPHA or SDL_RLEACCELOK);
  saved_alpha := SDLSurface^.format^.alpha;
  if (saved_flags and SDL_SRCALPHA) = SDL_SRCALPHA then
    SDL_SetAlpha(SDLSurface, 0, 0);

  //* Copy the surface into the GL texture image */
  area.x := 0;
  area.y := 0;
  area.w := SDLSurface^.w;
  area.h := SDLSurface^.h;
  SDL_BlitSurface(SDLSurface, @area, image, @area);

  //* Restore the alpha blending attributes */
  if (saved_flags and SDL_SRCALPHA) = SDL_SRCALPHA then
    SDL_SetAlpha(SDLSurface, saved_flags, saved_alpha);

  //* Create an OpenGL texture for the image */

  glGenTextures(1, @GLTexture);
  glBindTexture(GL_TEXTURE_2D, GLTexture);
  if Blended then
  begin
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
  end
  else
  begin
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
  end;
  glTexImage2D   (GL_TEXTURE_2D, 0, GL_RGBA, w, h, 0, GL_RGBA,
                  GL_UNSIGNED_BYTE, image^.pixels);

  SDL_FreeSurface(image); //* No longer needed */

end;

procedure TSurface.SetColorKey(r, g, b : Byte);
begin
  SDL_SetColorKey(SDLSurface,SDL_SRCCOLORKEY or SDL_RLEACCEL,SDL_MapRGB(SDLSurface^.format, r,g,b));
end;

procedure TSurface.DrawGL(x, y : DWord);
begin
  glBindTexture(GL_TEXTURE_2D, GLTexture);
  glBegin(GL_QUADS);
  glTexCoord2f(0,       0);        glVertex2i(x,                 y);
  glTexCoord2f(0,       GLHeight); glVertex2i(x,                 y+SDLSurface^.h);
  glTexCoord2f(GLWidth, GLHeight); glVertex2i(x+SDLSurface^.w, y+SDLSurface^.h);
  glTexCoord2f(GLWidth, 0);        glVertex2i(x+SDLSurface^.w, y);
  glEnd();
end;

procedure TSurface.DrawGL;
begin
  glBindTexture(GL_TEXTURE_2D, GLTexture);
  glBegin(GL_QUADS);
  glTexCoord2f(0,       0);        glVertex2i(0,0);
  glTexCoord2f(0,       GLHeight); glVertex2i(0,SDLSurface^.h);
  glTexCoord2f(GLWidth, GLHeight); glVertex2i(SDLSurface^.w, SDLSurface^.h);
  glTexCoord2f(GLWidth, 0);        glVertex2i(SDLSurface^.w, 0);
  glEnd();
end;

procedure TSurface.Fill(Color : TColor);
begin
  if SDL_FillRect( SDLSurface,@SDLRect,Color.RGBA ) = -1 then Log('Fill error!');
end;

procedure TSurface.BlitSDLSurface(source : PSDL_Surface; x, y : Byte);
var dest : TSDL_Rect;
begin
  dest.w := Source^.w;
  dest.h := Source^.h;
  dest.x := x;
  dest.y := y;
 // SDL_FillRect(SDLSurface, @dest, $FFFFFFFF);
  SDL_BlitSurface(source, nil, SDLSurface, @dest);
end;

procedure TSurface.Blit(x, y : Byte);
var dest : TSDL_Rect;
begin
  dest.w := SDLSurface^.w;
  dest.h := SDLSurface^.h;
  dest.x := x;
  dest.y := y;
 // SDL_FillRect(SDLSurface, @dest, $FFFFFFFF);
  SDL_BlitSurface(SDLSurface, nil, SDL_GetVideoSurface, @dest);
end;

destructor TSurface.Destroy;
begin
  if (GLTexture <> 0) and (not VALKYRIESHUTDOWN) then
    glDeleteTextures(1,@GLTexture);
  SDL_FreeSurface(SDLSurface);
  inherited Destroy;
end;



end.

