{$INCLUDE valkyrie.inc}
unit vgui;

{$H+}

interface

uses Classes, SysUtils, vutil, vui, gl;

type TGUITWindow = class(TUIWindow)
  procedure Draw; override;
end;

type TGUIWindow = class(TGUITWindow)
  procedure Draw; override;
end;

type TGUILabel = class(TUILabel)
  procedure Draw; override;
end;

type

{ TGUIDarkLabel }

TGUIDarkLabel = class(TUILabel)
  procedure Draw; override;
end;


type TGUISeparator = class(TUISeparator)
  procedure Draw; override;
end;

type TGUIViewer = class(TUIViewer)
  constructor Create(newParent : TUIElement; newTitle : Ansistring);
  procedure Draw; override;
end;

type TGUIFullViewer = class(TUIFullViewer)
  constructor Create(newParent : TUIElement; newTitle : Ansistring);
  procedure Draw; override;
end;

implementation
uses vgloutput, voutput, vtextui;

type TGUIStringListArea = TTextUIStringListArea;

{ TGUIWindow }

procedure TGUITWindow.Draw;
var AD,TR : TRect;
begin
  if not Visible then Exit; // and don't draw children!
  AD := AbsoluteDimensions;

  glDisable( GL_TEXTURE_2D );
  glBegin(GL_QUADS);
    glColor4f(0.0,0.0,0.0,0.9);
    GLOutput.Quad(AD);
  glEnd();
  glBegin(GL_LINES);
    glColor4ubv(@GLColorsPacked[Style^.FrameColor]);
    GLOutput.Frame(AD);
  glEnd();

  if Title <> '' then
  begin
    glBegin(GL_QUADS);
      glColor4f(0.0,0.0,0.0,1.0);
      TR := GLOutput.TranslateRect(NewRectWH(AD.X1+AD.w div 2-Length(Title) div 2-1,AD.Y1,Length(Title)+2,2));
      TR.y1-= GLOutput.GylphHeight div 2 ;
      TR.y2-= (GLOutput.GylphHeight) div 2;
      glVertex2i(TR.x1, TR.y1);
      glVertex2i(TR.x1, TR.y2);
      glVertex2i(TR.x2, TR.y2);
      glVertex2i(TR.x2, TR.y1);
    glEnd();
    Output.CenterDrawString(AD.X1+AD.w div 2-1,AD.Y1,Style^.TitleColor,' '+Title+' ');
  end;
  
  glEnable( GL_TEXTURE_2D );

  inherited Draw;
end;

{ TGUISeparator }

procedure TGUISeparator.Draw;
var AD : TRect;
begin
  inherited Draw;
  AD := AbsoluteDimensions;
  glDisable( GL_TEXTURE_2D );
  glBegin(GL_LINES);
    glColor4ubv(@GLColorsPacked[Style^.FrameColor]);
  if Horizontal
    then GLOutput.Line(AD.x1-1-LengthBonus, AD.y1+Position-1, AD.x2+1+LengthBonus, AD.y1+Position-1)
    else GLOutput.Line(AD.x1+Position-1, AD.y1-1-LengthBonus, AD.x1+Position-1, AD.y2+1+LengthBonus);
  glEnd();
  glEnable( GL_TEXTURE_2D );
end;

{ TGUIViewer }

constructor TGUIViewer.Create(newParent: TUIElement; newTitle: Ansistring);
begin
  inherited Create(newParent, newTitle);
  StringArea := TGUIStringListArea.Create(Self);
  StringArea.Dimensions.y1 += 2;
  StringArea.Dimensions.y2 -= 2;
end;

procedure TGUIViewer.Draw;
var AD    : TRect;
    last  : DWord;
begin
  AD := getAbsoluteDimensions;
  GLOutput.UpdateChars;
  GLOutput.Clear;
  AD.x1-= 1;
  AD.y1-= 1;
  AD.x2+= 1;
  AD.y2+= 1;

  glDisable( GL_TEXTURE_2D );
  glBegin(GL_QUADS);
    glColor4f(0.1,0.1,0.1,0.9);
    GLOutput.Quad(AD);
  glEnd();
  glBegin(GL_LINES);
    glColor4ubv(@GLColorsPacked[Style^.FrameColor]);
    GLOutput.Line(AD.x1,AD.y1+2,AD.x2,AD.y1+2);
    GLOutput.Line(AD.x1,AD.y2-2,AD.x2,AD.y2-2);
  glEnd();
  glEnable( GL_TEXTURE_2D );


  last := TextLines;
  Output.DrawString(AD.x1+3,AD.y1+1,Style^.TitleColor,Title);
  Output.DrawString(AD.x1+3,AD.y2-1,Style^.MainColor,'Use arrows to scroll, PgUp, PgDown. Escape or Enter exits.');
  if last > 0 then Output.LeftDrawString(AD.x2-10,AD.y1+1,Style^.MainColor,FloatToStrF((StringArea.Position/last*100),ffFixed,0,0)+'%');

  inherited Draw;
end;


{ TGUITWindow }

procedure TGUIWindow.Draw;
begin
  if not Visible then Exit; // and don't draw children!
  GLOutput.UpdateChars;
  GLOutput.Clear;
  inherited Draw;
end;

{ TGUIFullViewer }

constructor TGUIFullViewer.Create(newParent: TUIElement; newTitle: Ansistring);
begin
  inherited Create(newParent, newTitle);
  Dimensions.x1 += 1;
  Dimensions.x2 -= 1;
  StringArea := TGUIStringListArea.Create(Self);
  StringArea.Dimensions.y1 += 2;
  StringArea.Dimensions.y2 -= 2;
  SetText(StringList);
end;

procedure TGUIFullViewer.Draw;
var AD,TR : TRect;
    last  : DWord;
begin
  AD := getAbsoluteDimensions;
  TR := AD;
  TR.x1 -= 2; TR.x2 += 2;
  TR.y1 -= 2; TR.y2 += 2;
  GLOutput.UpdateChars;
  GLOutput.Clear;

  glDisable( GL_TEXTURE_2D );
  glBegin(GL_QUADS);
    glColor4f(0.1,0.1,0.1,0.9);
    GLOutput.Quad(TR);
  glEnd();
  glBegin(GL_LINES);
    glColor4ubv(@GLColorsPacked[Style^.FrameColor]);
    GLOutput.Line(TR.x1,AD.y1+1,TR.x2,AD.y1+1);
    GLOutput.Line(TR.x1,AD.y2-1,TR.x2,AD.y2-1);
  glEnd();
  glEnable( GL_TEXTURE_2D );


  last := TextLines;
  Output.DrawString(AD.x1+2,AD.y1,Style^.TitleColor,Title);
  Output.DrawString(AD.x1+2,AD.y2,Style^.MainColor,'Use arrows to scroll, PgUp, PgDown. Escape or Enter exits.');
  if last > 0 then Output.LeftDrawString(AD.x2-10,AD.y1,Style^.MainColor,FloatToStrF((StringArea.Position/last*100),ffFixed,0,0)+'%');

  inherited Draw;
end;

{ TGUILabel }

procedure TGUILabel.Draw;
var AD : TRect;
begin
  AD := getAbsoluteDimensions;
  GLOutput.UpdateChars;
  GLOutput.Clear;

  glDisable( GL_TEXTURE_2D );
  glBegin(GL_QUADS);
    glColor4f(1.0,0.1,0.1,0.9);
    GLOutput.Quad(AD);
  glEnd();
  glEnable( GL_TEXTURE_2D );

  if LineBreak then
    Output.DrawString(AD.X1,AD.Y1,Style^.MainColor,Text,Dimensions.GetWidth+1)
  else
    Output.DrawString(AD.X1,AD.Y1,Style^.MainColor,Text);
  inherited Draw;
end;

{ TGUIDarkLabel }

procedure TGUIDarkLabel.Draw;
var AD, TR : TRect;
begin
  if Text = '' then Exit;
  AD := getAbsoluteDimensions;
  GLOutput.UpdateChars;
  GLOutput.Clear;

  glDisable( GL_TEXTURE_2D );
  glBegin(GL_QUADS);
    glColor4f(0.0,0.0,0.0,1.0);
    TR := GLOutput.TranslateRect(NewRectWH(AD.X1-1,AD.Y1,GLOutput.Length(Text)+2,2));
    TR.y1-= GLOutput.GylphHeight div 2 ;
    TR.y2-= (GLOutput.GylphHeight) div 2;
    glVertex2i(TR.x1, TR.y1);
    glVertex2i(TR.x1, TR.y2);
    glVertex2i(TR.x2, TR.y2);
    glVertex2i(TR.x2, TR.y1);
  glEnd();
  glEnable( GL_TEXTURE_2D );

  if LineBreak then
    Output.DrawString(AD.X1,AD.Y1,Style^.MainColor,Text,Dimensions.GetWidth+1)
  else
    Output.DrawString(AD.X1,AD.Y1,Style^.MainColor,Text);
  inherited Draw;
end;

end.

