#include <dbus/dbus.h>
#include <libosso.h>

osso_context_t* osso;

void maemo_init()
{
	osso = osso_initialize("bermudasyndrome", "1.0", FALSE, NULL);
}

void show_notification(const char* text)
{
	DBusConnection* session_bus = (DBusConnection*)osso_get_dbus_connection(osso);
	DBusMessageIter args;
	DBusMessage*msg = dbus_message_new_method_call("org.freedesktop.Notifications", 
												   "/org/freedesktop/Notifications",
												   "org.freedesktop.Notifications", 
												   "SystemNoteInfoprint");
	if (msg) { 
		dbus_message_iter_init_append(msg, &args);
		if (dbus_message_iter_append_basic(&args, DBUS_TYPE_STRING, &text)) {
			dbus_connection_send(session_bus, msg, NULL);
			dbus_connection_flush(session_bus);
		}
		dbus_message_unref(msg);
	}
}
