#include "pmonitor.h"
#include "ui_pmonitor.h"

#include <QtCore/QCoreApplication>
#include <QShortcut>

Pmonitor::Pmonitor(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::Pmonitor)
{
    ui->setupUi(this);

    //Set Window
    this->setWindowTitle(tr("VGA"));
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    this->setWindowFlags(Qt::Window);

    //Set A Image
    imgSceneA = new QGraphicsScene(ui->imgA);
    QGraphicsPixmapItem *itemA;
    QPixmap mImgA("/opt/bander/images/vga-pinout.jpg");
    ui->imgA->setScene(imgSceneA);
    mImgA = mImgA.scaled(QSize(440, 440), Qt::KeepAspectRatio);
    itemA = new QGraphicsPixmapItem(mImgA);
    imgSceneA->addItem(itemA);

    // For Connecting Keyboard Buttons
          connectSignals();

}

Pmonitor::~Pmonitor()
{
    delete ui;
}

// Keyboard Button Signals - remember to include QShortcut
void Pmonitor::connectSignals()
{
     connect(new QShortcut(QKeySequence(Qt::Key_Backspace), this), SIGNAL(activated()), this, SLOT(close()));
}
