#ifndef OHMS_H
#define OHMS_H

#include <QDialog>

namespace Ui {
    class Ohms;
}

class Ohms : public QDialog
{
    Q_OBJECT

public:
    explicit Ohms(QWidget *parent = 0);
    ~Ohms();

private slots:

    // For Connecting Keyboard buttons
    void connectSignals();

    void on_comboUnit1_currentIndexChanged(int index);
    void on_comboUnit2_currentIndexChanged(int index);

    void on_spinValue1_valueChanged(double d);
    void on_spinValue2_valueChanged(double d);

    void on_comboMultiplier1_currentIndexChanged(int index);
    void on_comboMultiplier2_currentIndexChanged(int index);

private:
    void recalculate();

    // There are two combo boxes to select units.
    // The first combo allows to select any of the four units:
    // Voltage (V), Current (I), Power (P) or Resistance (R).
    // The second combo allows to select any unit except for
    // the unit selected by the first combo.
    // The result is 12 different combinations as per enum Units.
    // The combination is expressed as ((3 * unit1) + unit2).
    enum Units
    {
        UNIT_VI = 0,    // Voltage, Current
        UNIT_VP = 1,    // Voltage, Power
        UNIT_VR = 2,    // Voltage, Resistance

        UNIT_IV = 3,    // Current, Voltage
        UNIT_IP = 4,    // Current, Power
        UNIT_IR = 5,    // Current, Resistance

        UNIT_PV = 6,    // Power, Voltage
        UNIT_PI = 7,    // Power, Current
        UNIT_PR = 8,    // Power, Resistance

        UNIT_RV = 9,    // Resistance, Voltage
        UNIT_RI = 10,   // Resistance, Current
        UNIT_RP = 11    // Resistance, Power
    };

    Ui::Ohms *ui;
};

#endif // OHMS_H
