/*
babyphone - A baby monitor application on the Nokia N900.
    Copyright (C) 2010  Roman Morawek <maemo@morawek.at>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef USERNOTIFIER_H
#define USERNOTIFIER_H

#include <QObject>
#include <QTimer>
#include "settings.h"


// forward class declaration
class QDBusMessage;


/*!
  UserNotifier handles the whole notification interface to the parents phone, 
  which includes the voice call setup and rejecting of incoming calls.
  
  UserNotifier receives incoming notification requests and establishes a phone
  call then. This is done by the normal phone applicaton in Maemo using the DBus
  interface. The class monitors the call status and drops it after specific 
  timeouts. As the call is ended or aborted, it emits a notifyFinished signal
  such that the calling class can continue its work (i.e. the audio monitoring).
  
  This class is the only platform dependant component of the application. It 
  uses the DBus interface with specific messages as needed by Maemo 5. Since
  this DBus interface is only unofficially documented it may be subject to 
  change in future releases, e.g. in MaeGo.
*/
class UserNotifier : public QObject
{
    Q_OBJECT
public:
    explicit UserNotifier(Settings *settings, QObject *parent = 0);
    ~UserNotifier();

    bool Notify();

private:
    bool dropIncomingCall() const;
    bool takeIncomingCall();
    bool notifySMS(const QString droppedPhoneNumber) const;


signals:
    /*!
      This signal gets emited as the notification process is finished.
      This is the case when the call is dropped by the parents or by the
      application after specific timeouts.
      Every successful notification request (check return value!) will
      result in a notifyFinished signal.
      This signal is also emited when an incoming taken call is terminated.
    */
    void notifyFinished();


private slots:
    void callSetupTimer();
    void callEstablished(const QDBusMessage&);
    void receiveCall(const QDBusMessage&);
    void callStatusUpdate(const QDBusMessage&);


private:
    //! reference to global application settings
    Settings* const itsSettings;
    //! timeout to abort outgoing voice calls
    QTimer *itsCallTimer;
    //! initially active phone profile
    QString itsInitialProfile;
    //! indicates whether a call is active
    bool itsCallPending;
};

#endif // USERNOTIFIER_H
