#!/bin/sh

case "$1" in
	'-i' | '--install')
		# backing up
		mv /usr/share/pixmaps/noor.png /usr/share/pixmaps/noor.png.orig
		mv /usr/share/pixmaps/app-search-widget.png /usr/share/pixmaps/app-search-widget.png.orig
		mv /usr/share/pixmaps/quicklaunch-search.png /usr/share/pixmaps/quicklaunch-search.png.orig
		# copy the replacement icons
		cp /usr/share/icons/awoken-icon-theme/extras/noor-2.png /usr/share/pixmaps/noor.png
		cp /usr/share/icons/awoken-icon-theme/extras/app-search-widget.png /usr/share/pixmaps/app-search-widget.png
		cp /usr/share/icons/awoken-icon-theme/extras/quicklaunch-search.png /usr/share/pixmaps/quicklaunch-search.png
		echo "Replacing the pixmaps icons are done. Restart and the new icons should be shown"
	;;
	'-u' | '--uninstall')
		# remove the replacement icons
		rm /usr/share/pixmaps/noor.png
		rm /usr/share/pixmaps/app-search-widget.png
		rm /usr/share/pixmaps/quicklaunch-search.png
		# restore the original icons
		mv /usr/share/pixmaps/noor.png.orig /usr/share/pixmaps/noor.png
		mv /usr/share/pixmaps/app-search-widget.png.orig /usr/share/pixmaps/app-search-widget.png
		mv /usr/share/pixmaps/quicklaunch-search.png.orig /usr/share/pixmaps/quicklaunch-search.png
		echo "Restoring the original pixmaps icons are done. Restart and the old icons should be shown"
	;;
esac


