#include "mainwindow.h"
#include "ui_mainwindow.h"

#include <QMessageBox>

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    connect(ui->actionHelp, SIGNAL(triggered()), this, SLOT(showHelp()));
    connect(ui->actionAbout, SIGNAL(triggered()), this, SLOT(showAbout()));
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::showHelp()
{
    QString helpText;

    helpText.append("<h2>AutoConnect "+tr("Hilfe") +"</h2>");
    helpText.append("<p>"+ tr("Bietet zustzliche Suchintervalle fr den automatischen Verbindungsaufbau zum Internet.")+"<br/>");
    helpText.append(tr("Zur Nutzung von AutoConnect sollte ein Datentarif vorhanden sein, da ansonsten erhebliche Mehrkosten entstehen knnen.")+"<br/>");
    QMessageBox::about(this, tr("Hilfe"),
                       helpText);
}

void MainWindow::showAbout()
{
    QString about;
    about.append("<h2>AutoConnect</h2>");
    about.append(tr("Entwickelt in Qt %1<br/>").arg(QString(QT_VERSION_STR)));
    about.append(tr("Copyright") + " 2010 - MeeGo.de<br/><br/> Code: &lt;DuKe@meego.de&gt; <br/> Code: &lt;Xarthas@meego.de&gt; <br/> Gui: &lt;NightShift79@meego.de&gt;<br/><br/>");
    about.append(tr("Besucht <a href=http://meego.de>http://meego.de</a> um feedback zu geben und ber Bugs zu berichten. Danke.</p>"));

    QMessageBox::about(this, tr("ber AutoConnect"),
                       about);
}



void MainWindow::on_pushButton_clicked()
{
    QString question;
    question.append("Soll das Intervall auf 2 Minuten gesetzt werden?");

    QMessageBox::StandardButton reply;
    reply = QMessageBox::question(this, tr("AutoConnect:"),
                                    question,
                                    QMessageBox::Yes | QMessageBox::No | QMessageBox::Cancel);
    if (reply == QMessageBox::Yes)
        system("gconftool -s -t int /system/osso/connectivity/network_type/search_interval 120");
    else if (reply == QMessageBox::No)
        ;
    else
        ;
}

void MainWindow::on_pushButton_2_clicked()
{
    QString question;
    question.append("Soll das Intervall auf 5 Minuten gesetzt werden?");

    QMessageBox::StandardButton reply;
    reply = QMessageBox::question(this, tr("AutoConnect:"),
                                    question,
                                    QMessageBox::Yes | QMessageBox::No | QMessageBox::Cancel);
    if (reply == QMessageBox::Yes)
        system("gconftool -s -t int /system/osso/connectivity/network_type/search_interval 300");
    else if (reply == QMessageBox::No)
        ;
    else
        ;
}

void MainWindow::on_pushButton_14_clicked()
{
    QString question;
    question.append("Soll das Intervall auf 10 Minuten gesetzt werden?");

    QMessageBox::StandardButton reply;
    reply = QMessageBox::question(this, tr("AutoConnect:"),
                                    question,
                                    QMessageBox::Yes | QMessageBox::No | QMessageBox::Cancel);
    if (reply == QMessageBox::Yes)
        system("gconftool -s -t int /system/osso/connectivity/network_type/search_interval 600");
    else if (reply == QMessageBox::No)
        ;
    else
        ;
}

void MainWindow::on_pushButton_16_clicked()
{
    QString question;
    question.append("Soll das Intervall auf 15 Minuten gesetzt werden?");

    QMessageBox::StandardButton reply;
    reply = QMessageBox::question(this, tr("AutoConnect:"),
                                    question,
                                    QMessageBox::Yes | QMessageBox::No | QMessageBox::Cancel);
    if (reply == QMessageBox::Yes)
        system("gconftool -s -t int /system/osso/connectivity/network_type/search_interval 900");
    else if (reply == QMessageBox::No)
        ;
    else
        ;
}


void MainWindow::on_pushButton_15_clicked()
{
    QString question;
    question.append("Soll das Intervall auf 20 Minuten gesetzt werden?");

    QMessageBox::StandardButton reply;
    reply = QMessageBox::question(this, tr("AutoConnect:"),
                                    question,
                                    QMessageBox::Yes | QMessageBox::No | QMessageBox::Cancel);
    if (reply == QMessageBox::Yes)
        system("gconftool -s -t int /system/osso/connectivity/network_type/search_interval 1200");
    else if (reply == QMessageBox::No)
        ;
    else
        ;
}

void MainWindow::on_pushButton_17_clicked()
{
    QString question;
    question.append("Soll das Intervall auf 25 Minuten gesetzt werden?");

    QMessageBox::StandardButton reply;
    reply = QMessageBox::question(this, tr("AutoConnect:"),
                                    question,
                                    QMessageBox::Yes | QMessageBox::No | QMessageBox::Cancel);
    if (reply == QMessageBox::Yes)
        system("gconftool -s -t int /system/osso/connectivity/network_type/search_interval 1500");
    else if (reply == QMessageBox::No)
        ;
    else
        ;
}

void MainWindow::on_pushButton_18_clicked()
{
    QString question;
    question.append("Soll das Intervall auf 30 Minuten gesetzt werden?");

    QMessageBox::StandardButton reply;
    reply = QMessageBox::question(this, tr("AutoConnect:"),
                                    question,
                                    QMessageBox::Yes | QMessageBox::No | QMessageBox::Cancel);
    if (reply == QMessageBox::Yes)
        system("gconftool -s -t int /system/osso/connectivity/network_type/search_interval 1800");
    else if (reply == QMessageBox::No)
        ;
    else
        ;
}

void MainWindow::on_pushButton_19_clicked()
{
    QString question;
    question.append("Soll das Intervall auf 35 Minuten gesetzt werden?");

    QMessageBox::StandardButton reply;
    reply = QMessageBox::question(this, tr("AutoConnect:"),
                                    question,
                                    QMessageBox::Yes | QMessageBox::No | QMessageBox::Cancel);
    if (reply == QMessageBox::Yes)
        system("gconftool -s -t int /system/osso/connectivity/network_type/search_interval 2100");
    else if (reply == QMessageBox::No)
        ;
    else
        ;
}

void MainWindow::on_pushButton_20_clicked()
{
    QString question;
    question.append("Soll das Intervall auf 40 Minuten gesetzt werden?");

    QMessageBox::StandardButton reply;
    reply = QMessageBox::question(this, tr("AutoConnect:"),
                                    question,
                                    QMessageBox::Yes | QMessageBox::No | QMessageBox::Cancel);
    if (reply == QMessageBox::Yes)
        system("gconftool -s -t int /system/osso/connectivity/network_type/search_interval 2400");
    else if (reply == QMessageBox::No)
        ;
    else
        ;
}

void MainWindow::on_pushButton_21_clicked()
{
    QString question;
    question.append("Soll das Intervall auf 45 Minuten gesetzt werden?");

    QMessageBox::StandardButton reply;
    reply = QMessageBox::question(this, tr("AutoConnect:"),
                                    question,
                                    QMessageBox::Yes | QMessageBox::No | QMessageBox::Cancel);
    if (reply == QMessageBox::Yes)
        system("gconftool -s -t int /system/osso/connectivity/network_type/search_interval 2700");
    else if (reply == QMessageBox::No)
        ;
    else
        ;
}

void MainWindow::on_pushButton_22_clicked()
{
    QString question;
    question.append("Soll das Intervall auf 50 Minuten gesetzt werden?");

    QMessageBox::StandardButton reply;
    reply = QMessageBox::question(this, tr("AutoConnect:"),
                                    question,
                                    QMessageBox::Yes | QMessageBox::No | QMessageBox::Cancel);
    if (reply == QMessageBox::Yes)
        system("gconftool -s -t int /system/osso/connectivity/network_type/search_interval 3000");
    else if (reply == QMessageBox::No)
        ;
    else
        ;
}

void MainWindow::on_pushButton_23_clicked()
{
    QString question;
    question.append("Soll das Intervall auf 55 Minuten gesetzt werden?");

    QMessageBox::StandardButton reply;
    reply = QMessageBox::question(this, tr("AutoConnect:"),
                                    question,
                                    QMessageBox::Yes | QMessageBox::No | QMessageBox::Cancel);
    if (reply == QMessageBox::Yes)
        system("gconftool -s -t int /system/osso/connectivity/network_type/search_interval 3300");
    else if (reply == QMessageBox::No)
        ;
    else
        ;
}

void MainWindow::on_pushButton_8_clicked()
{
    QString question;
    question.append("Soll das Intervall auf eine Stunden gesetzt werden?");

    QMessageBox::StandardButton reply;
    reply = QMessageBox::question(this, tr("AutoConnect:"),
                                    question,
                                    QMessageBox::Yes | QMessageBox::No | QMessageBox::Cancel);
    if (reply == QMessageBox::Yes)
        system("gconftool -s -t int /system/osso/connectivity/network_type/search_interval 3600");
    else if (reply == QMessageBox::No)
        ;
    else
        ;
}

void MainWindow::on_pushButton_3_clicked()
{
    QString question;
    question.append("Soll das Intervall auf 2 Stunden gesetzt werden?");

    QMessageBox::StandardButton reply;
    reply = QMessageBox::question(this, tr("AutoConnect:"),
                                    question,
                                    QMessageBox::Yes | QMessageBox::No | QMessageBox::Cancel);
    if (reply == QMessageBox::Yes)
        system("gconftool -s -t int /system/osso/connectivity/network_type/search_interval 7200");
    else if (reply == QMessageBox::No)
        ;
    else
        ;
}

void MainWindow::on_pushButton_5_clicked()
{
    QString question;
    question.append("Soll das Intervall auf 3 Stunden gesetzt werden?");

    QMessageBox::StandardButton reply;
    reply = QMessageBox::question(this, tr("AutoConnect:"),
                                    question,
                                    QMessageBox::Yes | QMessageBox::No | QMessageBox::Cancel);
    if (reply == QMessageBox::Yes)
        system("gconftool -s -t int /system/osso/connectivity/network_type/search_interval 10800");
    else if (reply == QMessageBox::No)
        ;
    else
        ;
}

void MainWindow::on_pushButton_4_clicked()
{
    QString question;
    question.append("Soll das Intervall auf 4 Stunden gesetzt werden?");

    QMessageBox::StandardButton reply;
    reply = QMessageBox::question(this, tr("AutoConnect:"),
                                    question,
                                    QMessageBox::Yes | QMessageBox::No | QMessageBox::Cancel);
    if (reply == QMessageBox::Yes)
        system("gconftool -s -t int /system/osso/connectivity/network_type/search_interval 14400");
    else if (reply == QMessageBox::No)
        ;
    else
        ;
}

void MainWindow::on_pushButton_6_clicked()
{
    QString question;
    question.append("Soll das Intervall auf 5 Stunden gesetzt werden?");

    QMessageBox::StandardButton reply;
    reply = QMessageBox::question(this, tr("AutoConnect:"),
                                    question,
                                    QMessageBox::Yes | QMessageBox::No | QMessageBox::Cancel);
    if (reply == QMessageBox::Yes)
        system("gconftool -s -t int /system/osso/connectivity/network_type/search_interval 18000");
    else if (reply == QMessageBox::No)
        ;
    else
        ;
}

void MainWindow::on_pushButton_9_clicked()
{
    QString question;
    question.append("Soll das Intervall auf 6 Stunden gesetzt werden?");

    QMessageBox::StandardButton reply;
    reply = QMessageBox::question(this, tr("AutoConnect:"),
                                    question,
                                    QMessageBox::Yes | QMessageBox::No | QMessageBox::Cancel);
    if (reply == QMessageBox::Yes)
        system("gconftool -s -t int /system/osso/connectivity/network_type/search_interval 21600");
    else if (reply == QMessageBox::No)
        ;
    else
        ;
}

void MainWindow::on_pushButton_10_clicked()
{
    QString question;
    question.append("Soll das Intervall auf 7 Stunden gesetzt werden?");

    QMessageBox::StandardButton reply;
    reply = QMessageBox::question(this, tr("AutoConnect:"),
                                    question,
                                    QMessageBox::Yes | QMessageBox::No | QMessageBox::Cancel);
    if (reply == QMessageBox::Yes)
        system("gconftool -s -t int /system/osso/connectivity/network_type/search_interval 25200");
    else if (reply == QMessageBox::No)
        ;
    else
        ;
}

void MainWindow::on_pushButton_11_clicked()
{
    QString question;
    question.append("Soll das Intervall auf 8 Stunden gesetzt werden?");

    QMessageBox::StandardButton reply;
    reply = QMessageBox::question(this, tr("AutoConnect:"),
                                    question,
                                    QMessageBox::Yes | QMessageBox::No | QMessageBox::Cancel);
    if (reply == QMessageBox::Yes)
        system("gconftool -s -t int /system/osso/connectivity/network_type/search_interval 28800");
    else if (reply == QMessageBox::No)
        ;
    else
        ;
}

void MainWindow::on_pushButton_12_clicked()
{
    QString question;
    question.append("Soll das Intervall auf 9 Stunden gesetzt werden?");

    QMessageBox::StandardButton reply;
    reply = QMessageBox::question(this, tr("AutoConnect:"),
                                    question,
                                    QMessageBox::Yes | QMessageBox::No | QMessageBox::Cancel);
    if (reply == QMessageBox::Yes)
        system("gconftool -s -t int /system/osso/connectivity/network_type/search_interval 32400");
    else if (reply == QMessageBox::No)
        ;
    else
        ;
}

void MainWindow::on_pushButton_13_clicked()
{
    QString question;
    question.append("Soll das Intervall auf 10 Stunden gesetzt werden?");

    QMessageBox::StandardButton reply;
    reply = QMessageBox::question(this, tr("AutoConnect:"),
                                    question,
                                    QMessageBox::Yes | QMessageBox::No | QMessageBox::Cancel);
    if (reply == QMessageBox::Yes)
        system("gconftool -s -t int /system/osso/connectivity/network_type/search_interval 36000");
    else if (reply == QMessageBox::No)
        ;
    else
        ;
}

void MainWindow::on_pushButton_7_clicked()
{
    QString question;
    question.append("Soll das Intervall auf 0 gesetzt werden?");
    question.append("In diesem Fall wird nie eine Verbindung aufgebaut.");

    QMessageBox::StandardButton reply;
    reply = QMessageBox::question(this, tr("AutoConnect:"),
                                    question,
                                    QMessageBox::Yes | QMessageBox::No | QMessageBox::Cancel);
    if (reply == QMessageBox::Yes)
        system("gconftool -s -t int /system/osso/connectivity/network_type/search_interval 0");
    else if (reply == QMessageBox::No)
        ;
    else
        ;
}

