#include "xmlparser.h"
#include <QDomDocument>

XMLParser::XMLParser(QObject *parent) :
    QObject(parent)
{

}

QList<QString> XMLParser::parseSearchTitles(QNetworkReply *reply)
{
    if (!searchTitles.isEmpty())
        searchTitles.clear();
    doc.setContent(reply->readAll());
    rootElement = doc.documentElement();
    QDomNode n = rootElement.firstChild();
    while(!n.isNull()) {
        QDomElement e = n.toElement(); // try to convert the node to an element.
        if(!e.isNull()) {
            if (e.tagName() == "Section")
            {
                QDomNode child = e.firstChild();
                while (!child.isNull())
                {
                    QDomElement tag = child.toElement();
                    if (!tag.isNull())
                    {
                        if (tag.tagName() == "Item")
                        {
                            QDomNode text = tag.firstChild();
                            while (!text.isNull())
                            {
                                QDomElement a = text.toElement();
                                if (!a.isNull())
                                {
                                    if (a.tagName() == "Text")
                                    {
                                        searchTitles.append(a.text());
                                    }
                                }
                                text = text.nextSibling();
                            }
                        }
                    }
                    child = child.nextSibling();
                }
            }
        }
        n = n.nextSibling();
    }
    return searchTitles;
}

QMap<QString, QStringList> XMLParser::parseArticleContent(QNetworkReply *reply)
{
    doc.setContent(reply->readAll());
    rootElement = doc.documentElement();
    QMap<QString, QStringList> article;
    QDomNode n = rootElement.firstChild();
    QString articleContent;
    QStringList links;
    while(!n.isNull())
    {
        QDomElement e = n.toElement(); // try to convert the node to an element.
        if(!e.isNull())
        {
            QDomNode child = e.firstChild();
            while (!child.isNull())
            {
                QDomElement tag = child.toElement();
                if (!tag.isNull())
                {
                    if (tag.tagName() == "text")
                    {
                        articleContent = tag.text();
                    }
                    if (tag.tagName() == "links")
                    {
                        QDomNode link = tag.firstChild();
                        while (!link.isNull())
                        {
                            QDomElement linkElement = link.toElement();
                            if (!linkElement.isNull())
                            {
                                links.append(linkElement.text());
                            }
                            link = link.nextSibling();
                        }
                    }
                }
                child = child.nextSibling();
            }

        }
        n = n.nextSibling();
    }

    article.insert(articleContent, links);
    return article;
}
