#ifndef NETWORK_H
#define NETWORK_H

#include <QObject>
#include <QNetworkAccessManager>
#include <QUrl>
#include <QNetworkReply>
#include <QFile>
#include <datahandler.h>



class Network : public QObject
{
    Q_OBJECT
public:
    Network();
    ~Network();
    void startRequest(QUrl url);
    void searchKeyWord(QString key);
    void retrieveArticle(QString title, bool infile = false, bool forplaylist = false);
    void fileSaved(QString title);

private slots:
    void httpFinished();
    void httpReadyRead();
    void parseWikiText(QString title, QString article);

private:
    QUrl url;
    QNetworkAccessManager qnam;
    QNetworkReply *reply;
    QFile *file;
    int httpGetId;
    bool httpRequestAborted;
    DataHandler *dataHandler;
    int mode;
    bool onlySaveArticle;
    QString article;

signals:
    void searchTitlesReceived(QList<QString> titles);
    void articleContentReceived(QString title, QString content);
    void playlistArticleSaved(QString title);
    void downloadProgress(qint64 received, qint64 total);

};

#endif // NETWORK_H
