#include "player.h"
#include "ui_player.h"
#include <QFile>
#include <QDesktopServices>
#include <QDebug>


Player::Player(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::Player)
{
    ui->setupUi(this);
    reload = false;
    playing = false;
    audio = new Audio();
    articleLoaded = false;

    connect(audio,SIGNAL(finished()), this, SLOT(playingFinished()));
    connect(audio, SIGNAL(wavCreated()), this, SLOT(wavCreated()));
}

Player::~Player()
{
    delete ui;
}

void Player::openArticle(QString itemName, QString text, bool playlist)
{
    path = QDesktopServices::storageLocation(QDesktopServices::DocumentsLocation) + itemName.toLower().normalized(QString::NormalizationForm_D)+".txt";

    QStringList links;
    QFile *articleLinks = new QFile(QDesktopServices::storageLocation(QDesktopServices::DocumentsLocation) +  itemName.toLower().normalized(QString::NormalizationForm_D)+".dat");
    if (articleLinks->open(QIODevice::ReadOnly))
    {
        QDataStream out(articleLinks);   // we will serialize the data into the file
        out >> links;
        articleLinks->close();
    }

    linkWidget = new LinkList(links, this);
    linkWidget->hide();
    connect(linkWidget, SIGNAL(linkClicked(QListWidgetItem*)), this, SLOT(linkListWidget_itemClicked(QListWidgetItem*)));

    if (!reload)
    {

        if (itemName.contains("_"))
            itemName.replace("_", " ");

        QListWidgetItem *item = new QListWidgetItem(itemName);

        ui->playListWidget->insertItem(ui->playListWidget->count(), item);

        if (ui->playListWidget->count() > 1)
            ui->playListWidget->setCurrentRow(ui->playListWidget->count()-1);

    }
    else
    {

        reload = false;
    }


    ui->articleBrowser->setText(text);
    bool audioExists = QFile(QDesktopServices::storageLocation(QDesktopServices::DocumentsLocation) +  itemName.toLower().normalized(QString::NormalizationForm_D)+".wav").exists();

    if (!playlist || !audioExists)
        audio->createWav(path);
    if (audioExists)
        audio->setAudio(QDesktopServices::storageLocation(QDesktopServices::DocumentsLocation) +  itemName.toLower().normalized(QString::NormalizationForm_D)+".wav");

    articleLoaded = true;

}

void Player::clearCurrentArticles()
{
    ui->playListWidget->clear();
    ui->articleBrowser->clear();
}

void Player::clear()
{
    ui->playListWidget->clear();
    ui->articleBrowser->clear();
}

void Player::linkListWidget_itemClicked(QListWidgetItem *item)
{
    this->openArticleFromLink(item);
}

void Player::on_backwardButton_clicked()
{
    if (this->ui->playListWidget->currentRow() >= 1 && ui->playListWidget->count() != 0)
    {
        reload = true;
        this->ui->playListWidget->item(this->ui->playListWidget->currentRow())->setSelected(false);
        this->ui->playListWidget->setCurrentRow(this->ui->playListWidget->currentRow()-1,QItemSelectionModel::Select);
        this->openArticleFromLink(ui->playListWidget->currentItem());
    }

}

void Player::on_forwardButton_clicked()
{
    if (ui->playListWidget->count() > 1 && this->ui->playListWidget->currentRow() < this->ui->playListWidget->count() && ui->playListWidget->count() != 0)
    {
        reload = true;
        this->ui->playListWidget->item(this->ui->playListWidget->currentRow())->setSelected(false);
        this->ui->playListWidget->setCurrentRow(this->ui->playListWidget->currentRow()+1,QItemSelectionModel::Select);
        this->openArticleFromLink(ui->playListWidget->currentItem());
    }

}

void Player::setPlaylistFocus()
{
    reload = true;
    this->ui->playListWidget->setCurrentRow(1, QItemSelectionModel::Select);

    this->openArticleFromLink(ui->playListWidget->item(this->ui->playListWidget->currentRow()));
   // audio->createWav(this->ui->playListWidget->currentItem()->text());
}

void Player::on_playListWidget_itemClicked(QListWidgetItem *item)
{
    reload = true;
    this->ui->playListWidget->setCurrentItem(item);
    this->openArticleFromLink(item);
}

void Player::on_linksButton_clicked()
{
    if (this->articleLoaded)
        linkWidget->show();
}

void Player::on_playPauseButton_clicked()
{
    if (articleLoaded)
    {
        if (!playing)
        {
            audio->play();
            playing = true;
            this->ui->playPauseButton->setIcon(QIcon(":/images/Icon_pause.png"));
        }
        else
        {
            audio->pause();
            playing = false;
            this->ui->playPauseButton->setIcon(QIcon(":/images/Icon_play.png"));
        }
    }

}

void Player::playingFinished()
{
    playing = false;
}

void Player::wavCreated()
{
    this->audioCreated();
}
