#ifndef ARTICLELIST_H
#define ARTICLELIST_H

#include <QWidget>
#include <QListWidgetItem>
#include <QTableWidgetItem>

namespace Ui {
    class ArticleList;
}

class ArticleList : public QWidget
{
    Q_OBJECT

public:
    explicit ArticleList(QWidget *parent = 0);
    void openSplashScreen(QStringList titles);
    void fillTable(QList<QString> searchTitles, QString keyword);
    ~ArticleList();

private slots:
    //void on_articleListWidget_itemClicked(QListWidgetItem *item);

    void on_tableWidget_cellClicked(int row, int column);

    void on_searchButton_clicked();

    void addToPlaylist(QString playlist, QString item);

    void on_searchLineEdit_returnPressed();

signals:
    void articleSelected(QTableWidgetItem *item);
    void addToPlaylistClicked();
    void newSearch(QString searchWord);
    void articleToPlaylist(QString playlist, QString item);


private:
    Ui::ArticleList *ui;
    QString selectedArticle;
};

#endif // ARTICLELIST_H
