#include "audio.h"
#include <stdlib.h>
#include <QProcess>
#include <QSound>
#include <QDebug>
#include <QFile>
#include <QDesktopServices>
#include <phonon/MediaObject>
#include <phonon/MediaSource>

Audio::Audio(QObject *parent) :
    QObject(parent)
{


}

void Audio::createWav(QString filename)
{


    QString audio = filename;
    audio.chop(3);
    audio.append("wav");
    audioFile = new QFile(audio);
    if (!audioFile->open(QIODevice::ReadWrite))
        qDebug()<<"cannot write to file";
    else
    {
        QString program = "flite"; //espeak
        QStringList arguments;

        arguments << "-voice" << "awb" << "-f" << filename << "-o" << audio; //arguments << "-f" << filename << "-s" << "110" << "-v " << "en/en-rp" << -w << audio;
        qDebug()<<arguments;
        QProcess *myProcess = new QProcess();

        file = audio;

        myProcess->start(program, arguments);
        myProcess->waitForFinished();

        music = Phonon::createPlayer(Phonon::MusicCategory,
                                      Phonon::MediaSource(audioFile->fileName()));


        connect(music, SIGNAL(finished()), this, SLOT(audioFinished()));

        audioFile->close();
    }

}

void Audio::audioFinished()
{
    this->finished();
}

void Audio::play()
{

    music->play();
}

void Audio::pause()
{
    music->pause();
}

