#include "playlist.h"
#include "ui_playlist.h"
#include <QMap>

Playlist::Playlist(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::Playlist)
{
    ui->setupUi(this);
    playlistlist = new Playlists();
    this->updateList();
    ui->treeWidget->setColumnCount(1);



}

Playlist::~Playlist()
{
    delete ui;
}

void Playlist::on_treeWidget_itemClicked(QTreeWidgetItem *item, int column)
{
    if (item->childCount() == 0)
        this->articleSelected(item, column);

    else
        this->playlistSelected(item->takeChildren(), column);

    this->hide();
}

QStringList Playlist::getPlaylists()
{
    return playlistlist->getPlaylistTitles();
}

void Playlist::addToPlaylist(QString playlist, QString article)
{
    playlistlist->addNewItemToPlaylist(playlist, article);
    this->updateList();
}

void Playlist::updateList()
{
    this->ui->treeWidget->clear();
    QList<QTreeWidgetItem *> items;
    foreach(QString title, this->playlistlist->getPlaylistTitles())
    {
        QTreeWidgetItem *item = new QTreeWidgetItem(QStringList(title));
        QList<QTreeWidgetItem*> children;
        foreach (QString article, this->playlistlist->getPlaylistContent(title))
            children.append(new QTreeWidgetItem(QStringList(article)));
        item->addChildren(children);
        items.append(item);
       // item->set
        //this->ui->treeWidget->addTopLevelItem(item);
    }
    this->ui->treeWidget->insertTopLevelItems(0, items);
}

