#include "mainwindow.h"
#include "ui_mainwindow.h"

#include <QtCore/QCoreApplication>
#include <QDesktopServices>
#ifdef Q_WS_MAEMO5
#include <QtMaemo5/QMaemo5InformationBox>
#endif

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent), ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    articleList = new ArticleList(this);
    articleList->hide();
    playlist = new Playlist(this);
    playlist->hide();
    player = new Player(this);
    player->hide();
    options = new Options(this);
    options->hide();
    network = new Network();

    message = new QProgressDialog("", "Cancel", 0, -1, this);

    connect(articleList, SIGNAL(articleSelected(QTableWidgetItem*)), this, SLOT(article_selected(QTableWidgetItem*)));
    connect(playlist, SIGNAL(articleSelected(QTreeWidgetItem*, int)), this, SLOT(playlist_item_selected(QTreeWidgetItem*, int)));
    connect(options, SIGNAL(closeButtonClicked()), this, SLOT(close()));
    connect(articleList, SIGNAL(addToPlaylistClicked()), this, SLOT(addToPlaylistClicked()));
    connect(playlist, SIGNAL(playlistSelected(QList<QTreeWidgetItem*>,int)), this, SLOT(playlist_selected(QList<QTreeWidgetItem*>,int)));
    connect(options, SIGNAL(clearCurrentClicked()), player, SLOT(clear()));
    connect(network, SIGNAL(searchTitlesReceived(QList<QString>)), this, SLOT(openArticleList(QList<QString>)));
    connect(articleList, SIGNAL(newSearch(QString)), this, SLOT(newSearch(QString)));
    connect(network, SIGNAL(articleContentReceived(QString,QString)), this, SLOT(openArticleInPlayer(QString,QString)));
    connect(articleList, SIGNAL(articleToPlaylist(QString,QString)), this, SLOT(addToPlaylist(QString,QString)));
    connect(network, SIGNAL(playlistArticleSaved()), message, SLOT(hide()));
    connect(player, SIGNAL(openArticleFromLink(QListWidgetItem*)), this, SLOT(openArticleFromLink(QListWidgetItem*)));
   // connect(network, SIGNAL(downloadProgress(qint64,qint64)), this, SLOT(updateProgressBar(qint64,qint64)));
}

MainWindow::~MainWindow()
{
    network->deleteLater();
    delete ui;
}

void MainWindow::setOrientation(ScreenOrientation orientation)
{
#if defined(Q_OS_SYMBIAN)
    // If the version of Qt on the device is < 4.7.2, that attribute won't work
    if (orientation != ScreenOrientationAuto) {
        const QStringList v = QString::fromAscii(qVersion()).split(QLatin1Char('.'));
        if (v.count() == 3 && (v.at(0).toInt() << 16 | v.at(1).toInt() << 8 | v.at(2).toInt()) < 0x040702) {
            qWarning("Screen orientation locking only supported with Qt 4.7.2 and above");
            return;
        }
    }((articleContentReceived(QString), this, SLOT(openArticleInPlayer(QString)));)ar)
#endif // Q_OS_SYMBIAN

    Qt::WidgetAttribute attribute;
    switch (orientation) {
#if QT_VERSION < 0x040702
    // Qt < 4.7.2 does not yet have the Qt::WA_*Orientation attributes
    case ScreenOrientationLockPortrait:
        attribute = static_cast<Qt::WidgetAttribute>(128);
        break;
    case ScreenOrientationLockLandscape:
        attribute = static_cast<Qt::WidgetAttribute>(129);
        break;
    default:
    case ScreenOrientationAuto:
        attribute = static_cast<Qt::WidgetAttribute>(130);
        break;
#else // QT_VERSION < 0x040702
    case ScreenOrientationLockPortrait:
        attribute = Qt::WA_LockPortraitOrientation;
        break;
    case ScreenOrientationLockLandscape:
        attribute = Qt::WA_LockLandscapeOrientation;
        break;
    default:
    case ScreenOrientationAuto:
        attribute = Qt::WA_AutoOrientation;
        break;
#endif // QT_VERSION < 0x040702
    };
    setAttribute(attribute, true);
}
void MainWindow::showExpanded()
{
#ifdef Q_OS_SYMBIAN
    showFullScreen();
#elif defined(Q_WS_MAEMO_5)
    showMaximized();
#else
    show();
#endif
}

void MainWindow::on_searchButton_clicked()
{


   /* if (articleList->isVisible())
        articleList->hide();
    else
    {
        articleList->show();
    }
    if (playlist->isVisible())
        playlist->hide();
    else if (player->isVisible())
        player->hide();
    if (options->isVisible())
        options->hide();*/
    if (this->ui->searchLineEdit->text().isEmpty())
    {
        #ifdef Q_WS_MAEMO5
        QMaemo5InformationBox::information(this, "Please enter search word first",
                                                    QMaemo5InformationBox::DefaultTimeout);
        #endif
    }
    else
    {
        message->setLabelText("Searching");
        message->show();
        network->searchKeyWord(this->ui->searchLineEdit->text());
        this->searchWord = this->ui->searchLineEdit->text();
    }
}

void MainWindow::on_mainWindowButton_clicked()
{
    if (!articleList->isVisible())
        articleList->show();
    if (playlist->isVisible())
        playlist->hide();
    else if (player->isVisible())
        player->hide();
    if (options->isVisible())
        options->hide();
}

void MainWindow::on_playlistsButton_clicked()
{
    if (playlist->isVisible())
        playlist->hide();
    else
        playlist->show();
    if (articleList->isVisible())
        articleList->hide();
    else if (player->isVisible())
        player->hide();
    if (options->isVisible())
        options->hide();
}
void MainWindow::on_playerButton_clicked()
{
    if (player->isVisible())
        player->hide();
    else
        player->show();
    if (articleList->isVisible())
        articleList->hide();
    else if (playlist->isVisible())
        playlist->hide();
    if (options->isVisible())
        options->hide();
}

void MainWindow::article_selected(QTableWidgetItem *item)
{
    message->setLabelText("Loading " + item->text());
    message->show();
    bool existsAlready = QFile(QDesktopServices::storageLocation(QDesktopServices::DocumentsLocation) +  item->text().toLower().normalized(QString::NormalizationForm_D).replace(" ", "_")+".txt").exists();
    network->retrieveArticle(item->text(), existsAlready);
}

void MainWindow::openArticleFromLink(QListWidgetItem *item)
{
    if (player->isVisible())
        player->hide();
    message->setLabelText("Loading " + item->text());
    message->show();
    bool existsAlready = QFile(QDesktopServices::storageLocation(QDesktopServices::DocumentsLocation) +  item->text().toLower().normalized(QString::NormalizationForm_D).replace(" ", "_")+".txt").exists();
    network->retrieveArticle(item->text(), existsAlready);
}

void MainWindow::playlist_item_selected(QTreeWidgetItem *item, int column)
{
    message->setLabelText("Opening " + item->text(column));
    message->show();
    bool existsAlready = QFile(QDesktopServices::storageLocation(QDesktopServices::DocumentsLocation) +  item->text(column).toLower().normalized(QString::NormalizationForm_D).replace(" ", "_")+".txt").exists();
    network->retrieveArticle(item->text(column), existsAlready);
}

void MainWindow::on_optionsButton_clicked()
{
    if (options->isVisible())
        options->hide();
    else
        options->show();
}

void MainWindow::addToPlaylistClicked()
{
    QStringList list = playlist->getPlaylists();

    articleList->openSplashScreen(list);
}

void MainWindow::playlist_selected(QList<QTreeWidgetItem *> items, int column)
{
    player->clearCurrentArticles();
    QTreeWidgetItem *item;
    foreach (item, items)
    {
        bool existsAlready = QFile(QDesktopServices::storageLocation(QDesktopServices::DocumentsLocation) +  item->text(column).toLower().normalized(QString::NormalizationForm_D).replace(" ", "_")+".txt").exists();
        network->retrieveArticle(item->text(column), existsAlready);
    }
    player->setPlaylistFocus();
}

void MainWindow::openArticleList(QList<QString> searchTitles)
{
    articleList->fillTable(searchTitles, this->searchWord);
    if (!articleList->isVisible())
        articleList->show();
    message->hide();
}

void MainWindow::newSearch(QString keyword)
{
    this->searchWord = keyword;
    network->searchKeyWord(keyword);
}

void MainWindow::openArticleInPlayer(QString title, QString article)
{
     player->openArticle(title, article);
     player->show();

     message->hide();
}

void MainWindow::addToPlaylist(QString playlistname, QString item)
{
    message->setLabelText("Saving");
    message->setParent(articleList);
    message->show();
    network->retrieveArticle(item, false, true);
    playlist->addToPlaylist(playlistname, item);
    network->fileSaved(item);
}

/*void MainWindow::updateProgressBar(qint64 bytesReceived, qint64 bytesTotal)
{/*
    this->message->setMinimum(0);
    this->message->setMaximum(bytesTotal);
    this->message->setValue(bytesReceived);
    qDebug()<<"min" << this->message->minimum();
    qDebug()<<" max" <<this->message->maximum();
    qDebug()<<"rec" << bytesReceived;
    qDebug()<<"tot" << bytesTotal;



}*/
