#ifndef PLAYLIST_H
#define PLAYLIST_H

#include <QWidget>
#include <QTreeWidgetItem>
#include <playlists.h>

namespace Ui {
    class Playlist;
}

class Playlist : public QWidget
{
    Q_OBJECT

public:
    explicit Playlist(QWidget *parent = 0);
    QStringList getPlaylists();
    void addToPlaylist(QString playlist, QString article);
    ~Playlist();

private slots:
    void on_treeWidget_itemClicked(QTreeWidgetItem *item, int column);

signals:
    void articleSelected(QTreeWidgetItem *item, int column);
    void playlistSelected(QList<QTreeWidgetItem *> items, int column);

private:
    Ui::Playlist *ui;
    QMap<QString, QString> *titles;
    Playlists *playlistlist;
    void updateList();
};

#endif // PLAYLIST_H
