#ifndef PLAYER_H
#define PLAYER_H

#include <QWidget>
#include <QListWidgetItem>
#include <linklist.h>
#include <audio.h>


namespace Ui {
    class Player;
}

class Player : public QWidget
{
    Q_OBJECT

public:
    explicit Player(QWidget *parent = 0);
    void openArticle(QString itemTitle, QString text);
    void clearCurrentArticles();
    void setPlaylistFocus();
    ~Player();

private slots:
    void clear();

    void linkListWidget_itemClicked(QListWidgetItem *item);

    void on_backwardButton_clicked();

    void on_forwardButton_clicked();

//    void on_playListWidget_itemSelectionChanged();

//    void on_playListWidget_itemActivated(QListWidgetItem *item);

//    void on_playListWidget_currentItemChanged(QListWidgetItem *current, QListWidgetItem *previous);

    void on_playListWidget_itemClicked(QListWidgetItem *item);

    void on_linksButton_clicked();

    void on_playPauseButton_clicked();

    void playingFinished();

signals:
    void openArticleFromLink(QListWidgetItem *item);

private:
    Ui::Player *ui;
    bool reload;
    LinkList *linkWidget;
    QString path;
    bool playing;
    Audio *audio;

};

#endif // PLAYER_H
