#include "datahandler.h"
#include <QDesktopServices>
#define SEARCH 1
#define ARTICLE 2
#define PARSE 3

DataHandler::DataHandler(QObject *parent) :
    QObject(parent)
{
    parser = new XMLParser();
    articleParser = new ArticleParser();
    savedFiles = new QList<QString>();
    allLoadedFiles = new QList<QString>();
}

DataHandler::~DataHandler()
{

}

void DataHandler::dataReceived(QNetworkReply *reply, int mode)
{
    if (mode == SEARCH)
        searchTitles = parser->parseSearchTitles(reply);
    else if (mode == ARTICLE)
    {
        articleContent = parser->parseArticleContent(reply);
        this->saveArticleToFile(articleContent);
    }
}

QList<QString> DataHandler::getSearchTitles()
{
    return this->searchTitles;
}

QMap<QString, QStringList> DataHandler::getArticleContent()
{
    return this->articleContent;
}

void DataHandler::setCurrentArticle(QString articleName)
{
    this->currentArticleTitle = articleName;
}

void DataHandler::saveArticleToFile(QMap<QString, QStringList> content)
{
    article = new QFile(currentArticleTitle.toLower().normalized(QString::NormalizationForm_D)+".txt");
    articleLinks = new QFile(currentArticleTitle.toLower().normalized(QString::NormalizationForm_D)+".dat");
    if (!article->open(QIODevice::WriteOnly))
        qDebug()<<"file error";
    else
    {
        QString articleText = articleParser->parseArticleContent(content.keys().at(0));
        QTextStream articleContent(article);
        articleContent << articleText;
        article->close();
    }
    if (articleLinks->open(QIODevice::WriteOnly))
    {
        QDataStream out(articleLinks);   // we will serialize the data into the file
        out << content.value(content.keys().at(0));
        articleLinks->close();
    }
    articleLinkList = content.value(content.keys().at(0));
    allLoadedFiles->append(currentArticleTitle);
    qDebug()<<"articleSaved";
}

QString DataHandler::getArticleFromFile()
{

    QString line;
    QFile file(currentArticleTitle.toLower().normalized(QString::NormalizationForm_D)+".txt");
    if (!file.open(QIODevice::ReadOnly | QIODevice::Text))
        return "";

    QTextStream in(&file);
    while (!in.atEnd())
    {
        line.append(in.readLine());
    }

    //line = articleParser->parseArticleContent(line);



    return line;
}

QString DataHandler::getCurrentArticleTitle()
{
    return this->currentArticleTitle;
}

void DataHandler::addFileToSaved(QString title)
{
    this->savedFiles->append(title);
}

void DataHandler::removeFiles()
{
    for(int i = 0; i<allLoadedFiles->count(); i++)
    {
        if (!savedFiles->contains(allLoadedFiles->at(i)))
        {
            QFile textFile(allLoadedFiles->at(i).toLower().normalized(QString::NormalizationForm_D)+".txt");
            textFile.remove();
            QFile datFile(allLoadedFiles->at(i).toLower().normalized(QString::NormalizationForm_D)+".dat");
            datFile.remove();
            QFile soundFile(allLoadedFiles->at(i).toLower().normalized(QString::NormalizationForm_D)+".wav");
            soundFile.remove();
        }
    }
}
